/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.team.internal.core.TeamPlugin;

public class CopyFileAreaUtil {
    public static Collection<IShare> getNestedShares(IShareable shareable) throws FileSystemException {
        return CopyFileAreaUtil.getNestedShares(shareable, shareable.getLocalPath());
    }

    public static Collection<IShare> getNestedShares(IShareable shareable, IRelativeLocation relativeLocation) throws FileSystemException {
        AbstractLock lock = CFALockUtil.createAndLockForReading(shareable.getSandbox().getRoot(), true, (IProgressMonitor)new NullProgressMonitor());
        if (lock == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            CopyFileArea cfa = (CopyFileArea)ICopyFileAreaManager.instance.getExistingCopyFileArea(shareable.getSandbox().getRoot());
            ArrayList<IShare> result = new ArrayList<IShare>();
            for (IRelativeLocation relative : cfa.allSharePaths(relativeLocation)) {
                Share share = cfa.getShare(relative);
                if (share == null) continue;
                result.add(share);
            }
            ArrayList<IShare> arrayList = result;
            return arrayList;
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static boolean isNestedShare(IShareable shareable) throws FileSystemException {
        IRelativeLocation shareableLocation = shareable.getLocalPath();
        AbstractLock lock = CFALockUtil.createAndLockForReading(shareable.getSandbox().getRoot(), true, (IProgressMonitor)new NullProgressMonitor());
        if (lock == null) {
            return false;
        }
        try {
            CopyFileArea cfa = (CopyFileArea)ICopyFileAreaManager.instance.getExistingCopyFileArea(shareable.getSandbox().getRoot());
            IRelativeLocation[] allSharePaths = cfa.allSharePaths();
            Arrays.sort(allSharePaths, new Comparator<IRelativeLocation>(){

                @Override
                public int compare(IRelativeLocation location1, IRelativeLocation location2) {
                    return location1.toString().compareTo(location2.toString());
                }
            });
            IRelativeLocation previous = null;
            boolean isNested = false;
            IRelativeLocation[] iRelativeLocationArray = allSharePaths;
            int n = allSharePaths.length;
            int n2 = 0;
            while (n2 < n) {
                IRelativeLocation location = iRelativeLocationArray[n2];
                if (previous == null) {
                    previous = location;
                } else if (previous.isPrefixOf(location)) {
                    isNested = true;
                } else {
                    previous = location;
                    isNested = false;
                }
                if (location.equals(shareableLocation)) {
                    boolean bl = isNested;
                    return bl;
                }
                ++n2;
            }
            return false;
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private static void traceIfEnabled(Log traceLog, String message) {
        if (traceLog != null && traceLog.isTraceEnabled()) {
            traceLog.trace((Object)message);
        }
    }

    public static InverseFileItemInfo getItemInfo(ILocation cfaRoot, IVersionableHandle item, IComponentHandle component, IContextHandle connectionHandle, Log traceLog, IProgressMonitor monitor) throws FileSystemException {
        CopyFileAreaUtil.traceIfEnabled(traceLog, "CopyFileAreaUtil#getItemInfo: Start.");
        if (cfaRoot == null || item == null || component == null || connectionHandle == null) {
            CopyFileAreaUtil.traceIfEnabled(traceLog, "CopyFileAreaUtil#getItemInfo: Some of the required arguments were null, hence we throw an exception.");
            throw new IllegalArgumentException("Errors occurred while fetching the versionable information from the metadata");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.lockExistingForRead(cfaRoot, (IProgressMonitor)progress.newChild(50));
        if (lock == null) {
            CopyFileAreaUtil.traceIfEnabled(traceLog, "CopyFileAreaUtil#getItemInfo: Not able to get a read lock on the sandbox, hence we throw an exception.");
            throw new FileSystemException("Errors occurred while fetching the versionable information from the metadata");
        }
        try {
            ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
            CopyFileAreaUtil.traceIfEnabled(traceLog, NLS.bind((String)"CopyFileAreaUtil#getItemInfo: Fetching the InverseFileItemInfo for versionable with itemId: \"{0}\", in component with itemId: \"{1}\", in workspace context with itemId: \"{2}\", at sandbox location: \"{3}\".", (Object[])new String[]{item.getItemId().getUuidValue(), component.getItemId().getUuidValue(), connectionHandle.getItemId().getUuidValue(), cfa.getRoot().toString()}, (Object[])new Object[0]));
            InverseFileItemInfo inverseFileItemInfo = cfa.getItemInfo(item, component, connectionHandle, false);
            return inverseFileItemInfo;
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(50));
            CopyFileAreaUtil.traceIfEnabled(traceLog, "CopyFileAreaUtil#getItemInfo: End.");
        }
    }

    public static void updateWorkspaceComponentStateToUnknown(ILocation cfaRoot, Collection<LoadedConfigurationDescriptor> loadedComponentConfigurations, Log traceLog, IProgressMonitor monitor) throws FileSystemException {
        CopyFileAreaUtil.traceIfEnabled(traceLog, "CopyFileAreaUtil#updateWorkspaceComponentStateToUnknown: Start.");
        if (cfaRoot == null || loadedComponentConfigurations == null) {
            CopyFileAreaUtil.traceIfEnabled(traceLog, "CopyFileAreaUtil#updateWorkspaceComponentStateToUnknown: Some of the required arguments were null, hence we throw an exception.");
            throw new IllegalArgumentException(Messages.CopyFileAreaUtil_ErrorUpdatingWorkspaceComponentStateInMetadata);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.createAndLockForReading(cfaRoot, true, (IProgressMonitor)progress.newChild(10));
        if (lock == null) {
            CopyFileAreaUtil.traceIfEnabled(traceLog, "CopyFileAreaUtil#updateWorkspaceComponentStateToUnknown: Not able to get a read lock on the sandbox, hence we throw an exception.");
            throw new FileSystemException(Messages.CopyFileAreaUtil_ErrorUpdatingWorkspaceComponentStateInMetadata);
        }
        try {
            SubMonitor updateProgress = progress.newChild(80);
            updateProgress.setWorkRemaining(loadedComponentConfigurations.size());
            ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
            for (LoadedConfigurationDescriptor configDescriptor : loadedComponentConfigurations) {
                CopyFileAreaUtil.traceIfEnabled(traceLog, NLS.bind((String)"CopyFileAreaUtil#updateWorkspaceComponentStateToUnknown: Updating the workspace component state for component: \"{0}\", with workspace context: \"{1}\", at sandbox location: \"{2}\", to UNKNOWN.", (Object[])new String[]{configDescriptor.componentName, configDescriptor.connectionName, cfa.getRoot().toString()}, (Object[])new Object[0]));
                cfa.updateWorkspaceComponentState(-1L, false, configDescriptor, (IProgressMonitor)updateProgress.newChild(1));
            }
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(10));
        }
        CopyFileAreaUtil.traceIfEnabled(traceLog, "CopyFileAreaUtil#updateWorkspaceComponentStateToUnknown: End.");
    }

    public static void updateWorkspaceComponentState(ILocation cfaRoot, long workspaceComponentState, boolean overwriteWithAfterStateIfBeforeStateIsUnknown, LoadedConfigurationDescriptor loadedComponentConfiguration, Log traceLog, IProgressMonitor monitor) throws FileSystemException {
        CopyFileAreaUtil.traceIfEnabled(traceLog, "CopyFileAreaUtil#updateWorkspaceComponentState: Start.");
        if (cfaRoot == null || loadedComponentConfiguration == null) {
            CopyFileAreaUtil.traceIfEnabled(traceLog, "CopyFileAreaUtil#updateWorkspaceComponentState: Some of the required arguments were null, hence we throw an exception.");
            throw new IllegalArgumentException(Messages.CopyFileAreaUtil_ErrorUpdatingWorkspaceComponentStateInMetadata);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.createAndLockForReading(cfaRoot, true, (IProgressMonitor)progress.newChild(10));
        if (lock == null) {
            CopyFileAreaUtil.traceIfEnabled(traceLog, "CopyFileAreaUtil#updateWorkspaceComponentState: Not able to get a read lock on the sandbox, hence we throw an exception.");
            throw new FileSystemException(Messages.CopyFileAreaUtil_ErrorUpdatingWorkspaceComponentStateInMetadata);
        }
        try {
            ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
            CopyFileAreaUtil.traceIfEnabled(traceLog, NLS.bind((String)"CopyFileAreaUtil#updateWorkspaceComponentState: Updating the workspace component state for component: \"{0}\", with workspace context: \"{1}\", at sandbox location: \"{2}\", to: \"{3}\".", (Object[])new String[]{loadedComponentConfiguration.componentName, loadedComponentConfiguration.connectionName, cfaRoot.toString(), String.valueOf(workspaceComponentState)}, (Object[])new Object[0]));
            cfa.updateWorkspaceComponentState(workspaceComponentState, overwriteWithAfterStateIfBeforeStateIsUnknown, loadedComponentConfiguration, (IProgressMonitor)progress.newChild(80));
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(10));
        }
        CopyFileAreaUtil.traceIfEnabled(traceLog, "CopyFileAreaUtil#updateWorkspaceComponentState: End.");
    }

    public static Collection<LoadedConfigurationDescriptor> getFilteredLoadedConfigurationForComponents(UUID workspaceItemId, Collection<UUID> componentItemIds, Collection<LoadedConfigurationDescriptor> loadedComponentConfigurations) {
        if (workspaceItemId == null || componentItemIds == null || loadedComponentConfigurations == null) {
            throw new IllegalArgumentException(Messages.SharingManager_ErrorFetchingConfiguration);
        }
        ArrayList<LoadedConfigurationDescriptor> filteredComponentConfigurations = new ArrayList<LoadedConfigurationDescriptor>();
        for (UUID componentItemId : componentItemIds) {
            LoadedConfigurationDescriptor configDescriptor = CopyFileAreaUtil.getFilteredLoadedConfigurationForComponent(workspaceItemId, componentItemId, loadedComponentConfigurations);
            if (configDescriptor == null) continue;
            filteredComponentConfigurations.add(configDescriptor);
        }
        return filteredComponentConfigurations;
    }

    public static LoadedConfigurationDescriptor getFilteredLoadedConfigurationForComponent(UUID workspaceItemId, UUID componentItemId, Collection<LoadedConfigurationDescriptor> loadedComponentConfigurations) {
        if (workspaceItemId == null || componentItemId == null || loadedComponentConfigurations == null) {
            throw new IllegalArgumentException(Messages.SharingManager_ErrorFetchingConfiguration);
        }
        LoadedConfigurationDescriptor loadedComponentConfiguration = null;
        for (LoadedConfigurationDescriptor configDescriptor : loadedComponentConfigurations) {
            if (!workspaceItemId.equals((Object)configDescriptor.connectionHandle.getItemId()) || !configDescriptor.getComponentHandle().getItemId().equals((Object)componentItemId)) continue;
            loadedComponentConfiguration = configDescriptor;
            break;
        }
        return loadedComponentConfiguration;
    }

    public static boolean isNestedShare(ILocation root, IRelativeLocation shareableLocation) throws FileSystemException {
        AbstractLock lock = CFALockUtil.createAndLockForReading(root, true, (IProgressMonitor)new NullProgressMonitor());
        if (lock == null) {
            return false;
        }
        try {
            CopyFileArea cfa = (CopyFileArea)ICopyFileAreaManager.instance.getExistingCopyFileArea(root);
            IRelativeLocation[] allSharePaths = cfa.allSharePaths();
            Arrays.sort(allSharePaths, new Comparator<IRelativeLocation>(){

                @Override
                public int compare(IRelativeLocation location1, IRelativeLocation location2) {
                    return location1.toString().compareTo(location2.toString());
                }
            });
            IRelativeLocation previous = null;
            boolean isNested = false;
            IRelativeLocation[] iRelativeLocationArray = allSharePaths;
            int n = allSharePaths.length;
            int n2 = 0;
            while (n2 < n) {
                IRelativeLocation location = iRelativeLocationArray[n2];
                if (previous == null) {
                    previous = location;
                } else if (previous.isPrefixOf(location)) {
                    isNested = true;
                } else {
                    previous = location;
                    isNested = false;
                }
                if (location.equals(shareableLocation)) {
                    boolean bl = isNested;
                    return bl;
                }
                ++n2;
            }
            return false;
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static boolean hasNestedShareRoots(IShareable shareable) throws FileSystemException {
        return CopyFileAreaUtil.getNestedShares(shareable).size() > 1;
    }

    public static boolean hasNestedShareRoots(IShareable[] shareables) throws FileSystemException {
        IShareable[] iShareableArray = shareables;
        int n = shareables.length;
        int n2 = 0;
        while (n2 < n) {
            IShareable shareable = iShareableArray[n2];
            if (CopyFileAreaUtil.hasNestedShareRoots(shareable)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isShareRoot(IRelativeLocation location, ILocation cfaRoot, IProgressMonitor monitor) throws FileSystemException {
        IShare share = SharingManager.getInstance().getShare(cfaRoot, location, monitor);
        return share != null && location.equals(share.getPath());
    }

    public static boolean isShareRoot(IResource resource, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        try {
            if (resource.getProject() != null && resource.getProject().isOpen() && resource.getPersistentProperty(TeamPlugin.PROVIDER_PROP_KEY) != null) {
                return true;
            }
        }
        catch (CoreException e) {
            throw new FileSystemException(e);
        }
        IShareable shareable = (IShareable)resource.getAdapter(IShareable.class);
        if (shareable == null) {
            return false;
        }
        return CopyFileAreaUtil.isShareRoot(shareable.getLocalPath(), shareable.getSandbox().getRoot(), (IProgressMonitor)progress);
    }
}

