/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IRemoteVisitor;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.IVisitor;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataProperties;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.StringWrapper;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.BatchingLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFAReadLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ComponentLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaEvent;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ILockParticipant;
import com.ibm.team.filesystem.client.internal.copyfileareas.MultiLock;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.internal.IConfigurationDescriptor;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class CopyFileAreaStore {
    protected final ISharingMetadata metadata;
    protected final ILocation path;
    protected final ListenerList listeners;
    protected final ReentrantLock sharingInfoLock;
    protected final CFAReadLock rlock;
    private final Log traceLog;

    protected CopyFileAreaStore(ILocation path, ISharingMetadata metadataStore) {
        Assert.isNotNull((Object)path);
        Assert.isNotNull((Object)metadataStore);
        this.path = path;
        this.metadata = metadataStore;
        this.listeners = new ListenerList();
        this.sharingInfoLock = new ReentrantLock();
        this.rlock = new CFAReadLock(path);
        Log log = LoggingHelper.getLog(CopyFileAreaStore.class);
        this.traceLog = log != null && log.isTraceEnabled() ? log : null;
    }

    private void traceIfEnabled(String message) {
        if (this.traceLog != null && this.traceLog.isTraceEnabled()) {
            this.traceLog.trace((Object)message);
        }
    }

    public void addListener(ICopyFileAreaListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(ICopyFileAreaListener listener) {
        this.listeners.remove((Object)listener);
    }

    public ReentrantLock getSharingLock() {
        return this.sharingInfoLock;
    }

    protected void assertReadLocked() {
        Assert.isTrue((boolean)CopyFileAreaManager.instance.batchingLock.isLocked(this.rlock));
        Assert.isTrue((this == CopyFileAreaManager.instance.getExistingCopyFileArea(this.getRoot()) ? 1 : 0) != 0);
    }

    public boolean isLocked(IComponentHandle component, IContextHandle connection) {
        return CopyFileAreaManager.instance.batchingLock.isLocked(new ComponentLock(this.getRoot(), connection, component));
    }

    public AbstractLock lock(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) {
        return CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connection, component), monitor);
    }

    public AbstractLock lock(IRelativeLocation shareablePath, IProgressMonitor monitor) throws FileSystemException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        RuleDescriptorPair pair = this.beginBatching(shareablePath, (IProgressMonitor)progress.newChild(99));
        if (pair.desc == null) {
            CopyFileAreaStore.endBatching(pair.rule, (IProgressMonitor)progress.newChild(1));
            return null;
        }
        return pair.rule;
    }

    public void release(AbstractLock rule, IProgressMonitor monitor) throws FileSystemException {
        CopyFileAreaManager.instance.batchingLock.release(rule, monitor);
    }

    private void updateParentInfoForChange(FileItemInfo newInfo, FileItemInfo oldInfo, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemException {
        if (oldInfo != null && !oldInfo.getVersionableHandle().sameItemId((IItemHandle)newInfo.getVersionableHandle())) {
            throw new IllegalArgumentException("Infos must be for the same versionable");
        }
        if (this.metadata.getPathForShareRoot(newInfo.getVersionableHandle(), component, connection) == null) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            if (oldInfo != null && oldInfo.getParent() != null && oldInfo.getParent().sameItemId((IItemHandle)newInfo.getParent()) && !oldInfo.getName().equals(newInfo.getName())) {
                this.updateParentInfoForRename(oldInfo, newInfo, component, connection, (IProgressMonitor)progress.newChild(2));
            } else {
                if (oldInfo != null && oldInfo.getParent() != null && !oldInfo.getParent().sameItemId((IItemHandle)newInfo.getParent())) {
                    this.updateParentInfoForRemoval(oldInfo, component, connection, (IProgressMonitor)progress.newChild(1));
                }
                if (!(newInfo.getParent() == null || oldInfo != null && newInfo.getParent().sameItemId((IItemHandle)oldInfo.getParent()))) {
                    InverseFileItemInfo oldParentInverseInfo = this.metadata.getFileItemInfo((IVersionableHandle)newInfo.getParent(), component, connection);
                    if (oldParentInverseInfo == null) {
                        this.metadata.setCorrupt(true, "Unexpected null parent", null);
                        throw new RuntimeException("Detected metadata corruption");
                    }
                    InverseFileItemInfo newParentInverseInfo = oldParentInverseInfo.addRemoteChild(newInfo.getName(), newInfo.getVersionableHandle());
                    this.metadata.setFileItemInfo((IVersionableHandle)newInfo.getParent(), component, connection, newParentInverseInfo, (IProgressMonitor)progress.newChild(1));
                }
            }
        }
    }

    private void updateParentInfoForRename(FileItemInfo oldInfo, FileItemInfo newInfo, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemException {
        InverseFileItemInfo oldParentInverseInfo = this.metadata.getFileItemInfo((IVersionableHandle)newInfo.getParent(), component, connection);
        IVersionableHandle oldChild = oldParentInverseInfo.getRemoteChild(oldInfo.getName());
        if (oldChild == null) {
            throw new FileSystemException(NLS.bind((String)Messages.CopyFileAreaStore_0, (Object)newInfo.getName()));
        }
        LinkedHashMap<String, IVersionableHandle> children = new LinkedHashMap<String, IVersionableHandle>(oldParentInverseInfo.getRemoteChildren());
        if (oldInfo.getVersionableHandle().sameItemId((IItemHandle)oldChild)) {
            children.remove(oldInfo.getName());
        }
        children.put(newInfo.getName(), newInfo.getVersionableHandle());
        InverseFileItemInfo newParentInverseInfo = oldParentInverseInfo.withRemoteChildren(children);
        this.metadata.setFileItemInfo((IVersionableHandle)newInfo.getParent(), component, connection, newParentInverseInfo, monitor);
    }

    private void updateParentInfoForRemoval(FileItemInfo oldInfo, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemException {
        if (oldInfo.getParent() != null) {
            InverseFileItemInfo oldParentInverseInfo = this.metadata.getFileItemInfo((IVersionableHandle)oldInfo.getParent(), component, connection);
            if (oldParentInverseInfo == null) {
                return;
            }
            IVersionableHandle child = oldParentInverseInfo.getRemoteChild(oldInfo.getName());
            if (child == null) {
                throw new FileSystemException(NLS.bind((String)Messages.CopyFileAreaStore_0, (Object)oldInfo.getName()));
            }
            if (!oldInfo.getVersionableHandle().sameItemId((IItemHandle)child)) {
                return;
            }
            InverseFileItemInfo newParentInverseInfo = oldParentInverseInfo.removeRemoteChild(oldInfo.getName());
            this.metadata.setFileItemInfo((IVersionableHandle)oldInfo.getParent(), component, connection, newParentInverseInfo, monitor);
        }
    }

    private void updateLocalParent(IRelativeLocation path, IFolderHandle newParent, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemException {
        Map<StringWrapper, FileItemInfo> childMap = this.metadata.getChildInfos(path);
        for (FileItemInfo i : childMap.values()) {
            InverseFileItemInfo oldInfo = this.metadata.getFileItemInfo(i.getVersionableHandle(), component, connection);
            if (oldInfo == null || oldInfo.getLocalName() == null) continue;
            InverseFileItemInfo newInfo = oldInfo.withLocalParent(newParent);
            this.metadata.setFileItemInfo(newInfo.getVersionableHandle(), component, connection, newInfo, monitor);
        }
    }

    protected FileItemInfo setItemInfo(IRelativeLocation shareablePath, FileItemInfo info, ICopyFileArea.PropertyUpdate updateType, MetadataProperties updateProperties, IProgressMonitor monitor) throws FileSystemException {
        FileItemInfo fileItemInfo;
        SubMonitor progress;
        block24: {
            Assert.isNotNull((Object)info);
            this.assertReadLocked();
            AbstractLock rule = null;
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
            try {
                FileItemInfo existing;
                IFolderHandle parent;
                RuleDescriptorPair pair = this.beginBatching(shareablePath, (IProgressMonitor)progress.newChild(1));
                ISharingDescriptor desc = pair.desc;
                if (desc == null) {
                    throw new FileSystemException(NLS.bind((String)"Internal error: The path {0} is not within a share", (Object)shareablePath.toString()));
                }
                rule = pair.rule;
                InverseFileItemInfo oldInfo = this.metadata.getFileItemInfo(info.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle());
                if (info.getVersionableHandle().sameItemId((IItemHandle)desc.getRootVersionable())) {
                    parent = info.getParent();
                    if (oldInfo != null && !oldInfo.getVersionableHandle().sameItemId((IItemHandle)info.getVersionableHandle())) {
                        throw new FileSystemException("Internal error: Share root must be at root of share");
                    }
                } else {
                    FileItemInfo parentInfo = this.metadata.getFileItemInfo(shareablePath.getParent());
                    if (parentInfo == null) {
                        throw new FileSystemException(NLS.bind((String)"Internal error: Parent info missing for path {0}", (Object)shareablePath.toString()));
                    }
                    parent = (IFolderHandle)parentInfo.getVersionableHandle();
                    if (!(oldInfo == null || oldInfo.getLocalParent() == null || parent != null && parent.sameItemId((IItemHandle)oldInfo.getLocalParent()))) {
                        throw new FileSystemException(NLS.bind((String)Messages.CopyFileAreaStore_3, (Object)shareablePath.toString(), (Object)this.getLocalPathInternal(oldInfo, desc.getComponent(), desc.getConnectionHandle())));
                    }
                }
                String name = shareablePath.getName();
                if (this.isCaseSensitive()) {
                    existing = this.metadata.setFileItemInfo(shareablePath, info);
                } else {
                    existing = this.metadata.setFileItemInfo(shareablePath, null);
                    this.metadata.setFileItemInfo(shareablePath, info);
                }
                if (existing != null && !info.getVersionableHandle().sameItemId((IItemHandle)existing.getVersionableHandle())) {
                    if (existing.getVersionableHandle().sameItemId((IItemHandle)desc.getRootVersionable())) {
                        throw new FileSystemException("Internal error: Cannot change share root item id this way");
                    }
                    if (existing.getVersionableHandle() instanceof IFolderHandle) {
                        this.updateLocalParent(shareablePath, (IFolderHandle)info.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle(), (IProgressMonitor)progress.newChild(1));
                    }
                    if (existing.getVersionableHandle().hasStateId()) {
                        InverseFileItemInfo existingInverse = this.metadata.getFileItemInfo(existing.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle());
                        existingInverse = new InverseFileItemInfo(existingInverse.getVersionableHandle(), false, -1L, existingInverse.getParent(), existingInverse.getName(), existingInverse.isLoadedWithAnotherName(), existingInverse.getRemoteChildren(), null, null, existingInverse.getHash(), existingInverse.getContentLength(), existingInverse.getOriginalLineDelimiter(), existingInverse.getLineDelimiter(), existingInverse.getOriginalContentType(), existingInverse.getContentType(), existingInverse.getStoredPredecessorHintHash(), existingInverse.getStoredSize(), existingInverse.getStoredEncoding(), existingInverse.getStoredHash(), existingInverse.getStoredNumLineDelimiters(), existingInverse.isOriginalExecutable(), existingInverse.isOriginalExecutable(), existingInverse.isOriginalDirectoryLink(), existingInverse.isOriginalDirectoryLink(), existingInverse.getOriginalProperties(), existingInverse.getRemovedProperties(), existingInverse.getChangedProperties(), existingInverse.getExternalLinks(), existingInverse.getOriginalExternalLinks());
                        this.metadata.setFileItemInfo(existing.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle(), existingInverse, (IProgressMonitor)progress.newChild(1));
                    } else {
                        this.metadata.setFileItemInfo(existing.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle(), null, (IProgressMonitor)progress.newChild(1));
                    }
                }
                this.updateParentInfoForChange(info, oldInfo, desc.getComponent(), desc.getConnectionHandle(), (IProgressMonitor)progress.newChild(1));
                Map<String, Object> children = info.isFolder() ? (oldInfo != null ? oldInfo.getRemoteChildren() : Collections.EMPTY_MAP) : Collections.EMPTY_MAP;
                Map<String, String> originalProperties = Collections.EMPTY_MAP;
                Map<String, String> changedProperties = Collections.EMPTY_MAP;
                Set<String> removedProperties = Collections.EMPTY_SET;
                switch (updateType) {
                    case PRESERVE: {
                        if (oldInfo == null) break;
                        originalProperties = oldInfo.getOriginalProperties();
                        changedProperties = oldInfo.getChangedProperties();
                        removedProperties = oldInfo.getRemovedProperties();
                        break;
                    }
                    case CANCEL_CHANGES: {
                        if (oldInfo == null) break;
                        originalProperties = oldInfo.getOriginalProperties();
                        break;
                    }
                    case REPLACE: {
                        originalProperties = updateProperties.getOriginalProperties();
                        changedProperties = updateProperties.getChangedProperties();
                        removedProperties = updateProperties.getRemovedProperties();
                        break;
                    }
                    case REPLACE_DELTA: {
                        if (oldInfo != null) {
                            originalProperties = oldInfo.getOriginalProperties();
                        }
                        MetadataProperties properties = new MetadataProperties(originalProperties, updateProperties.getCurrentProperties());
                        changedProperties = properties.getChangedProperties();
                        removedProperties = properties.getRemovedProperties();
                        break;
                    }
                    case REPLACE_ORIGINAL: {
                        originalProperties = updateProperties.getOriginalProperties();
                        if (oldInfo == null || oldInfo.getChangedProperties().isEmpty() || oldInfo.getRemovedProperties().isEmpty()) break;
                        MetadataProperties oldProperties = new MetadataProperties(oldInfo.getOriginalProperties(), oldInfo.getChangedProperties(), oldInfo.getRemovedProperties());
                        MetadataProperties properties = new MetadataProperties(updateProperties.getOriginalProperties(), oldProperties);
                        changedProperties = properties.getChangedProperties();
                        removedProperties = properties.getRemovedProperties();
                    }
                }
                InverseFileItemInfo newInfo = new InverseFileItemInfo(info.getVersionableHandle(), info.isContentChanged(), info.getLastContentChangeCheckStamp(), info.getParent(), info.getName(), info.isLoadedWithAnotherName(), children, parent, name, info.getHash(), info.getContentLength(), info.getOriginalLineDelimiter(), info.getLineDelimiter(), info.getOriginalContentType(), info.getContentType(), info.getStoredPredecessorHintHash(), info.getStoredSize(), info.getStoredEncoding(), info.getStoredHash(), info.getStoredNumLineDelimiters(), info.isExecutable(), info.isOriginalExecutable(), info.isDirectoryLink(), info.isOriginalDirectoryLink(), originalProperties, removedProperties, changedProperties, info.getExternalLinks(), info.getOriginalExternalLinks());
                this.metadata.setFileItemInfo(info.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle(), newInfo, (IProgressMonitor)progress.newChild(1));
                fileItemInfo = existing;
                if (rule == null) break block24;
            }
            catch (Throwable throwable) {
                if (rule != null) {
                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                progress.done();
                throw throwable;
            }
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return fileItemInfo;
    }

    protected FileItemInfo setItemInfo(IVersionableHandle item, IComponentHandle component, IContextHandle connection, FileItemInfo info, ICopyFileArea.PropertyUpdate updateType, MetadataProperties updateProperties, IProgressMonitor monitor) throws FileSystemException {
        InverseFileItemInfo inverseFileItemInfo;
        SubMonitor progress;
        block14: {
            this.assertReadLocked();
            AbstractLock rule = null;
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                IFolderHandle localParent;
                String localName;
                rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connection, component), (IProgressMonitor)progress.newChild(1));
                InverseFileItemInfo oldInfo = this.metadata.getFileItemInfo(item, component, connection);
                this.updateParentInfoForChange(info, oldInfo, component, connection, (IProgressMonitor)progress.newChild(1));
                Map<String, IVersionableHandle> children = info.isFolder() && oldInfo != null ? oldInfo.getRemoteChildren() : Collections.EMPTY_MAP;
                IRelativeLocation localPath = this.getLocalPathInternal(oldInfo, component, connection);
                if (localPath != null) {
                    this.metadata.setFileItemInfo(localPath, info);
                }
                if (oldInfo != null) {
                    localName = oldInfo.getLocalName();
                    localParent = oldInfo.getLocalParent();
                } else {
                    localName = null;
                    localParent = null;
                }
                Map<String, String> originalProperties = Collections.EMPTY_MAP;
                Map<String, String> changedProperties = Collections.EMPTY_MAP;
                Set<String> removedProperties = Collections.EMPTY_SET;
                switch (updateType) {
                    case PRESERVE: {
                        if (oldInfo == null) break;
                        originalProperties = oldInfo.getOriginalProperties();
                        changedProperties = oldInfo.getChangedProperties();
                        removedProperties = oldInfo.getRemovedProperties();
                        break;
                    }
                    case CANCEL_CHANGES: {
                        if (oldInfo == null) break;
                        originalProperties = oldInfo.getOriginalProperties();
                        break;
                    }
                    case REPLACE: {
                        originalProperties = updateProperties.getOriginalProperties();
                        changedProperties = updateProperties.getChangedProperties();
                        removedProperties = updateProperties.getRemovedProperties();
                        break;
                    }
                    case REPLACE_DELTA: {
                        if (oldInfo != null) {
                            originalProperties = oldInfo.getOriginalProperties();
                        }
                        MetadataProperties properties = new MetadataProperties(originalProperties, updateProperties.getCurrentProperties());
                        changedProperties = properties.getChangedProperties();
                        removedProperties = properties.getRemovedProperties();
                        break;
                    }
                    case REPLACE_ORIGINAL: {
                        originalProperties = updateProperties.getOriginalProperties();
                        if (oldInfo == null || oldInfo.getChangedProperties().isEmpty() || oldInfo.getRemovedProperties().isEmpty()) break;
                        MetadataProperties oldProperties = new MetadataProperties(oldInfo.getOriginalProperties(), oldInfo.getChangedProperties(), oldInfo.getRemovedProperties());
                        MetadataProperties properties = new MetadataProperties(updateProperties.getOriginalProperties(), oldProperties);
                        changedProperties = properties.getChangedProperties();
                        removedProperties = properties.getRemovedProperties();
                    }
                }
                InverseFileItemInfo newInfo = new InverseFileItemInfo(info.getVersionableHandle(), info.isContentChanged(), info.getLastContentChangeCheckStamp(), info.getParent(), info.getName(), info.isLoadedWithAnotherName(), children, localParent, localName, info.getHash(), info.getContentLength(), info.getOriginalLineDelimiter(), info.getLineDelimiter(), info.getOriginalContentType(), info.getContentType(), info.getStoredPredecessorHintHash(), info.getStoredSize(), info.getStoredEncoding(), info.getStoredHash(), info.getStoredNumLineDelimiters(), info.isExecutable(), info.isOriginalExecutable(), info.isDirectoryLink(), info.isOriginalDirectoryLink(), originalProperties, removedProperties, changedProperties, info.getExternalLinks(), info.getOriginalExternalLinks());
                this.metadata.setFileItemInfo(item, component, connection, newInfo, (IProgressMonitor)progress.newChild(1));
                progress.worked(96);
                inverseFileItemInfo = oldInfo;
                if (rule == null) break block14;
            }
            catch (Throwable throwable) {
                if (rule != null) {
                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                progress.done();
                throw throwable;
            }
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return inverseFileItemInfo;
    }

    public Map<StringWrapper, FileItemInfo> getChildInfos(IRelativeLocation shareablePath, IProgressMonitor monitor) throws FileSystemException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Map<StringWrapper, FileItemInfo> result = this.metadata.getChildInfos(shareablePath);
        progress.done();
        return result;
    }

    public UUID getRemoteAncestor(Set<UUID> potentialAncestors, IVersionableHandle item, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemException {
        UUID uUID;
        SubMonitor progress;
        block15: {
            InverseFileItemInfo info;
            AbstractLock rule;
            block13: {
                block14: {
                    block11: {
                        block12: {
                            block9: {
                                UUID uUID2;
                                block10: {
                                    block7: {
                                        block8: {
                                            this.assertReadLocked();
                                            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                                            rule = null;
                                            try {
                                                if (!potentialAncestors.isEmpty()) break block7;
                                                if (rule == null) break block8;
                                            }
                                            catch (Throwable throwable) {
                                                if (rule != null) {
                                                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                                                }
                                                progress.done();
                                                throw throwable;
                                            }
                                            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                                        }
                                        progress.done();
                                        return null;
                                    }
                                    if (!potentialAncestors.contains(item.getItemId())) break block9;
                                    uUID2 = item.getItemId();
                                    if (rule == null) break block10;
                                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                                }
                                progress.done();
                                return uUID2;
                            }
                            rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connection, component), (IProgressMonitor)progress.newChild(1));
                            info = this.metadata.getFileItemInfo(item, component, connection);
                            if (info != null && info.getVersionableHandle().hasStateId()) break block11;
                            if (rule == null) break block12;
                            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                        }
                        progress.done();
                        return null;
                    }
                    IRelativeLocation rootPath = this.metadata.getPathForShareRoot(info.getVersionableHandle(), component, connection);
                    if (rootPath == null) break block13;
                    if (rule == null) break block14;
                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                progress.done();
                return null;
            }
            uUID = this.getRemoteAncestorInternal_rec(potentialAncestors, (IVersionableHandle)info.getParent(), component, connection);
            if (rule == null) break block15;
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return uUID;
    }

    private UUID getRemoteAncestorInternal(Set<UUID> potentialAncestors, IVersionableHandle item, IComponentHandle component, IContextHandle connection) throws FileSystemException {
        if (potentialAncestors.isEmpty()) {
            return null;
        }
        if (potentialAncestors.contains(item.getItemId())) {
            return item.getItemId();
        }
        InverseFileItemInfo info = this.metadata.getFileItemInfo(item, component, connection);
        if (info == null) {
            return null;
        }
        IRelativeLocation rootPath = this.metadata.getPathForShareRoot(info.getVersionableHandle(), component, connection);
        if (rootPath != null) {
            return null;
        }
        if (info.getName() == null) {
            return null;
        }
        return this.getRemoteAncestorInternal_rec(potentialAncestors, (IVersionableHandle)info.getParent(), component, connection);
    }

    private UUID getRemoteAncestorInternal_rec(Set<UUID> potentialAncestors, IVersionableHandle item, IComponentHandle component, IContextHandle connection) throws FileSystemException {
        while (!potentialAncestors.contains(item.getItemId())) {
            IRelativeLocation rootPath = this.metadata.getPathForShareRoot(item, component, connection);
            if (rootPath != null) {
                return null;
            }
            InverseFileItemInfo info = this.metadata.getFileItemInfo(item, component, connection);
            if (info == null) {
                throw new IllegalStateException(NLS.bind((String)Messages.CopyFileAreaStore_6, (Object)item));
            }
            if (info.getName() == null) {
                throw new IllegalStateException(NLS.bind((String)Messages.CopyFileAreaStore_7, (Object)info.getVersionableHandle()));
            }
            item = info.getParent();
        }
        return item.getItemId();
    }

    public IRelativeLocation getRemotePathFor(IRelativeLocation shareablePath, IProgressMonitor monitor) throws FileSystemException {
        IRelativeLocation iRelativeLocation;
        SubMonitor progress;
        block12: {
            FileItemInfo info;
            ISharingDescriptor desc;
            AbstractLock rule;
            block8: {
                IRelativeLocation iRelativeLocation2;
                block11: {
                    IRelativeLocation rootPath;
                    block9: {
                        IRelativeLocation iRelativeLocation3;
                        block10: {
                            block6: {
                                block7: {
                                    this.assertReadLocked();
                                    rule = null;
                                    progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                                    try {
                                        RuleDescriptorPair pair = this.beginBatching(shareablePath, (IProgressMonitor)progress.newChild(1));
                                        desc = pair.desc;
                                        rule = pair.rule;
                                        info = this.metadata.getFileItemInfo(shareablePath);
                                        if (info != null && info.getVersionableHandle().hasStateId()) break block6;
                                        if (rule == null) break block7;
                                    }
                                    catch (Throwable throwable) {
                                        if (rule != null) {
                                            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                                        }
                                        progress.done();
                                        throw throwable;
                                    }
                                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                                }
                                progress.done();
                                return null;
                            }
                            rootPath = this.metadata.getPathForShareRoot(info.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle());
                            if (rootPath == null) break block8;
                            if (info.getName() == null || info.getName().equals(rootPath.getName())) break block9;
                            iRelativeLocation3 = rootPath.getParent().append(info.getName());
                            if (rule == null) break block10;
                            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                        }
                        progress.done();
                        return iRelativeLocation3;
                    }
                    iRelativeLocation2 = rootPath;
                    if (rule == null) break block11;
                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                progress.done();
                return iRelativeLocation2;
            }
            iRelativeLocation = this.getRemotePathInternal((IVersionableHandle)info.getParent(), desc.getComponent(), desc.getConnectionHandle()).append(info.getName());
            if (rule == null) break block12;
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return iRelativeLocation;
    }

    public IRelativeLocation getRemotePathFor(IVersionableHandle item, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemException {
        IRelativeLocation iRelativeLocation;
        SubMonitor progress;
        block12: {
            InverseFileItemInfo info;
            AbstractLock rule;
            block8: {
                IRelativeLocation iRelativeLocation2;
                block11: {
                    IRelativeLocation rootPath;
                    block9: {
                        IRelativeLocation iRelativeLocation3;
                        block10: {
                            block6: {
                                block7: {
                                    this.assertReadLocked();
                                    rule = null;
                                    progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                                    try {
                                        rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connection, component), (IProgressMonitor)progress.newChild(1));
                                        info = this.metadata.getFileItemInfo(item, component, connection);
                                        if (info != null && info.getVersionableHandle().hasStateId()) break block6;
                                        if (rule == null) break block7;
                                    }
                                    catch (Throwable throwable) {
                                        if (rule != null) {
                                            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                                        }
                                        progress.done();
                                        throw throwable;
                                    }
                                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                                }
                                progress.done();
                                return null;
                            }
                            rootPath = this.metadata.getPathForShareRoot(info.getVersionableHandle(), component, connection);
                            if (rootPath == null) break block8;
                            if (info.getName() == null || info.getName().equals(rootPath.getName())) break block9;
                            iRelativeLocation3 = rootPath.getParent().append(info.getName());
                            if (rule == null) break block10;
                            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                        }
                        progress.done();
                        return iRelativeLocation3;
                    }
                    iRelativeLocation2 = rootPath;
                    if (rule == null) break block11;
                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                progress.done();
                return iRelativeLocation2;
            }
            iRelativeLocation = this.getRemotePathInternal((IVersionableHandle)info.getParent(), component, connection).append(info.getName());
            if (rule == null) break block12;
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return iRelativeLocation;
    }

    private IRelativeLocation getRemotePathInternal(IVersionableHandle item, IComponentHandle component, IContextHandle connection) throws FileSystemException {
        InverseFileItemInfo info = this.metadata.getFileItemInfo(item, component, connection);
        if (info == null || !info.getVersionableHandle().hasStateId()) {
            return null;
        }
        IRelativeLocation rootPath = this.metadata.getPathForShareRoot(item, component, connection);
        if (rootPath != null) {
            if (info.getName() != null && !info.getName().equals(rootPath.getName())) {
                return rootPath.getParent().append(info.getName());
            }
            return rootPath;
        }
        return this.getRemotePathInternal_rec(info, component, connection);
    }

    private IRelativeLocation getRemotePathInternal_rec(FileItemInfo info, IComponentHandle component, IContextHandle connection) throws FileSystemException {
        ArrayList<String> segments = null;
        boolean pathlen = false;
        while (true) {
            String name;
            IRelativeLocation rootPath;
            if ((rootPath = this.metadata.getPathForShareRoot(info.getVersionableHandle(), component, connection)) != null) {
                if (info.getName() != null && !info.getName().equals(rootPath.getName())) {
                    if (segments == null) {
                        return new RelativeLocation(info.getName());
                    }
                    rootPath = rootPath.getParent();
                    name = info.getName();
                    segments.add(name);
                } else if (segments == null) {
                    return new RelativeLocation(rootPath.getName());
                }
                int max = segments.size() - 1;
                if (max == 0) {
                    return new RelativeLocation((String)segments.get(0));
                }
                String[] remotePath = new String[segments.size()];
                int j = 0;
                int i = max;
                while (i >= 0) {
                    remotePath[j] = (String)segments.get(i);
                    ++j;
                    --i;
                }
                return new RelativeLocation(remotePath);
            }
            name = info.getName();
            if (name == null) {
                throw new IllegalStateException(NLS.bind((String)Messages.CopyFileAreaStore_8, (Object)info.getVersionableHandle()));
            }
            if (segments == null) {
                segments = new ArrayList<String>();
            }
            segments.add(name);
            info = this.metadata.getFileItemInfo((IVersionableHandle)info.getParent(), component, connection);
        }
    }

    public List<IRelativeLocation> getLocalPathFor(List<IVersionableHandle> items, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemException {
        ArrayList<IRelativeLocation> arrayList;
        SubMonitor progress;
        block4: {
            this.assertReadLocked();
            AbstractLock rule = null;
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connection, component), (IProgressMonitor)progress.newChild(1));
                ArrayList<IRelativeLocation> result = new ArrayList<IRelativeLocation>(items.size());
                SubMonitor subProgress = progress.newChild(98);
                subProgress.setWorkRemaining(items.size());
                for (IVersionableHandle item : items) {
                    result.add(this.getLocalPathInternal(item, component, connection));
                    subProgress.worked(1);
                }
                subProgress.done();
                arrayList = result;
                if (rule == null) break block4;
            }
            catch (Throwable throwable) {
                if (rule != null) {
                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                progress.done();
                throw throwable;
            }
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return arrayList;
    }

    public IRelativeLocation getLocalPathFor(IVersionableHandle item, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemException {
        IRelativeLocation iRelativeLocation;
        SubMonitor progress;
        block3: {
            this.assertReadLocked();
            AbstractLock rule = null;
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connection, component), (IProgressMonitor)progress.newChild(1));
                iRelativeLocation = this.getLocalPathInternal(item, component, connection);
                if (rule == null) break block3;
            }
            catch (Throwable throwable) {
                if (rule != null) {
                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                progress.done();
                throw throwable;
            }
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return iRelativeLocation;
    }

    private IRelativeLocation getLocalPathInternal(IVersionableHandle item, IComponentHandle component, IContextHandle connection) throws FileSystemException {
        InverseFileItemInfo info = this.metadata.getFileItemInfo(item, component, connection);
        return this.getLocalPathInternal(info, component, connection);
    }

    private IRelativeLocation getLocalPathInternal(InverseFileItemInfo info, IComponentHandle component, IContextHandle connection) throws FileSystemException {
        if (info == null) {
            return null;
        }
        IRelativeLocation rootPath = this.metadata.getPathForShareRoot(info.getVersionableHandle(), component, connection);
        if (rootPath != null) {
            return rootPath;
        }
        if (info.getLocalName() == null) {
            return null;
        }
        return this.getLocalPathInternal_rec(info, component, connection);
    }

    private IRelativeLocation getLocalPathInternal_rec(InverseFileItemInfo info, IComponentHandle component, IContextHandle connection) throws FileSystemException {
        ArrayList<String> segments = new ArrayList<String>();
        while (true) {
            segments.add(info.getLocalName());
            InverseFileItemInfo parentInfo = this.metadata.getFileItemInfo((IVersionableHandle)info.getLocalParent(), component, connection);
            if (parentInfo == null) {
                IRelativeLocation knownLocalPath = this.appendChildToParentSegmentsToPath(RelativeLocation.EMPTY_LOCATION, segments);
                String message = info.getLocalParent() == null ? "The parent of item {0} is missing. Local segments resolved before missing item encountered: {1}." : "The parent info for item {0} is missing. Local segments resolved before missing item encountered: {1}.";
                IllegalStateException e = new IllegalStateException(NLS.bind((String)message, (Object[])new Object[]{this.getPrintableDescription(info.getName(), info.getVersionableHandle(), component, connection), knownLocalPath}));
                e.fillInStackTrace();
                this.metadata.setCorrupt(true, e.getMessage(), e);
                throw e;
            }
            IRelativeLocation rootPath = this.metadata.getPathForShareRoot(parentInfo.getVersionableHandle(), component, connection);
            if (rootPath != null) {
                return this.appendChildToParentSegmentsToPath(rootPath, segments);
            }
            if (parentInfo.getLocalName() == null) {
                IRelativeLocation knownLocalPath = this.appendChildToParentSegmentsToPath(RelativeLocation.EMPTY_LOCATION, segments);
                IllegalStateException e = new IllegalStateException(NLS.bind((String)"Local Path for {0} does not resolve. Local segments resolved before missing item encountered: {1}.", (Object[])new Object[]{this.getPrintableDescription(parentInfo.getName(), parentInfo.getVersionableHandle(), component, connection), knownLocalPath}));
                e.fillInStackTrace();
                this.metadata.setCorrupt(true, e.getMessage(), e);
                throw e;
            }
            info = parentInfo;
        }
    }

    private String getPrintableDescription(String name, IVersionableHandle versionableHandle, IComponentHandle component, IContextHandle context) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(versionableHandle.getItemType().getName());
        if (name != null) {
            buffer.append(" named '");
            buffer.append(name);
            buffer.append("'");
        }
        buffer.append(" with item id: ");
        buffer.append(versionableHandle.getItemId().getUuidValue());
        if (versionableHandle.getStateId() != null) {
            buffer.append(" state id: ");
            buffer.append(versionableHandle.getStateId().getUuidValue());
        }
        buffer.append(" context id: ");
        buffer.append(context.getItemId().getUuidValue());
        buffer.append(" component id: ");
        buffer.append(component.getItemId().getUuidValue());
        return buffer.toString();
    }

    private IRelativeLocation appendChildToParentSegmentsToPath(IRelativeLocation rootPath, List<String> segments) {
        int i = segments.size() - 1;
        while (i >= 0) {
            rootPath = rootPath.append(segments.get(i));
            --i;
        }
        return rootPath;
    }

    public InverseFileItemInfo getItemInfo(IVersionableHandle handle, IComponentHandle component, IContextHandle connection, boolean mustBePresent) {
        this.assertReadLocked();
        try {
            InverseFileItemInfo info = this.metadata.getFileItemInfo(handle, component, connection);
            if (mustBePresent && info == null) {
                IllegalStateException e = new IllegalStateException(NLS.bind((String)Messages.CopyFileAreaStore_1, (Object)handle.getItemId().toString()));
                this.metadata.setCorrupt(true, e.toString(), e);
                throw e;
            }
            return info;
        }
        catch (FileSystemException e) {
            if (mustBePresent) {
                throw new IllegalStateException((Throwable)((Object)e));
            }
            LoggingHelper.log("com.ibm.team.filesystem.client", e);
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public FileItemInfo getDeletedItem(IFolderHandle handle, String name, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) {
        block18: {
            SubMonitor progress;
            AbstractLock rule;
            block15: {
                InverseFileItemInfo inverseFileItemInfo;
                block16: {
                    IVersionableHandle h;
                    this.assertReadLocked();
                    rule = null;
                    progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connection, component), (IProgressMonitor)progress.newChild(1));
                    InverseFileItemInfo info = this.metadata.getFileItemInfo((IVersionableHandle)handle, component, connection);
                    if (info == null || (h = info.getRemoteChildren().get(name)) == null) break block15;
                    info = this.metadata.getFileItemInfo(h, component, connection);
                    if (info == null) {
                        IllegalStateException e = new IllegalStateException(NLS.bind((String)"The state recorded for item named ''{0}'' is inconsistent", (Object)name));
                        e.fillInStackTrace();
                        this.metadata.setCorrupt(true, e.getMessage(), e);
                        throw e;
                    }
                    if (info.getLocalName() != null) break block15;
                    inverseFileItemInfo = info;
                    if (rule == null) break block16;
                    try {
                        CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                    }
                    catch (FileSystemException e) {
                        LoggingHelper.log("com.ibm.team.filesystem.client", e);
                    }
                }
                progress.done();
                return inverseFileItemInfo;
                catch (FileSystemException e) {
                    block17: {
                        try {
                            LoggingHelper.log("com.ibm.team.filesystem.client", e);
                            if (rule == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rule != null) {
                                try {
                                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                                }
                                catch (FileSystemException e2) {
                                    LoggingHelper.log("com.ibm.team.filesystem.client", e2);
                                }
                            }
                            progress.done();
                            throw throwable;
                        }
                        try {
                            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                        }
                        catch (FileSystemException e3) {
                            LoggingHelper.log("com.ibm.team.filesystem.client", e3);
                        }
                    }
                    progress.done();
                    break block18;
                }
            }
            if (rule != null) {
                try {
                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                catch (FileSystemException e) {
                    LoggingHelper.log("com.ibm.team.filesystem.client", e);
                }
            }
            progress.done();
        }
        return null;
    }

    public Collection<IRelativeLocation> getLocalItemPaths(IVersionableHandle handle, IProgressMonitor monitor) throws FileSystemException {
        AbstractLock rule;
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Collection<ISharingMetadata.IConnectionComponent> locations = this.metadata.getLocations(handle);
        block8: while (true) {
            progress.setWorkRemaining(100);
            if (locations.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            AbstractLock[] rules = new AbstractLock[locations.size()];
            int idx = 0;
            for (ISharingMetadata.IConnectionComponent c : locations) {
                rules[idx++] = new ComponentLock(this.getRoot(), c.getConnection(), c.getComponent());
            }
            AbstractLock schedRule = MultiLock.combine(rules);
            rule = CopyFileAreaStore.beginBatching(schedRule, (IProgressMonitor)progress.newChild(1));
            boolean success = false;
            try {
                Collection<ISharingMetadata.IConnectionComponent> newLocations = this.metadata.getLocations(handle);
                if (newLocations.size() != locations.size()) {
                    locations = newLocations;
                    continue;
                }
                HashSet<ISharingMetadata.IConnectionComponent> old = new HashSet<ISharingMetadata.IConnectionComponent>(locations);
                locations = newLocations;
                for (ISharingMetadata.IConnectionComponent c : newLocations) {
                    if (!old.contains(c)) continue block8;
                }
                success = true;
            }
            finally {
                if (success) continue;
                CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                continue;
            }
            break;
        }
        try {
            SubMonitor subProgress = progress.newChild(98);
            subProgress.setWorkRemaining(locations.size());
            ArrayList<IRelativeLocation> paths = new ArrayList<IRelativeLocation>(locations.size());
            for (ISharingMetadata.IConnectionComponent c : locations) {
                IRelativeLocation path = this.getLocalPathInternal(handle, c.getComponent(), c.getConnection());
                if (path != null) {
                    paths.add(path);
                }
                subProgress.worked(1);
            }
            subProgress.done();
            ArrayList<IRelativeLocation> arrayList = paths;
            return arrayList;
        }
        finally {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    public Collection<IRelativeLocation> getLocalItemPaths(IVersionableHandle handle, IContextHandle connection, IProgressMonitor monitor) throws FileSystemException {
        AbstractLock rule;
        int numResults;
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Collection<ISharingMetadata.IConnectionComponent> locations = this.metadata.getLocations(handle);
        block8: while (true) {
            progress.setWorkRemaining(100);
            AbstractLock[] rules = new AbstractLock[locations.size()];
            numResults = 0;
            for (ISharingMetadata.IConnectionComponent c : locations) {
                if (!c.getConnection().sameItemId((IItemHandle)connection)) continue;
                rules[numResults++] = new ComponentLock(this.getRoot(), c.getConnection(), c.getComponent());
            }
            if (numResults == 0) {
                return Collections.EMPTY_LIST;
            }
            AbstractLock schedRule = MultiLock.combine(rules);
            rule = CopyFileAreaStore.beginBatching(schedRule, (IProgressMonitor)progress.newChild(1));
            boolean success = false;
            try {
                HashSet<ISharingMetadata.IConnectionComponent> old = new HashSet<ISharingMetadata.IConnectionComponent>(numResults * 4 / 3);
                for (ISharingMetadata.IConnectionComponent c : locations) {
                    if (!c.getConnection().sameItemId((IItemHandle)connection)) continue;
                    old.add(c);
                }
                locations = this.metadata.getLocations(handle);
                numResults = 0;
                for (ISharingMetadata.IConnectionComponent c : locations) {
                    if (!c.getConnection().sameItemId((IItemHandle)connection)) continue;
                    if (!old.contains(c)) continue block8;
                    ++numResults;
                }
                if (numResults != old.size()) continue;
                success = true;
            }
            finally {
                if (success) continue;
                CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                continue;
            }
            break;
        }
        try {
            SubMonitor subProgress = progress.newChild(98);
            subProgress.setWorkRemaining(numResults);
            ArrayList<IRelativeLocation> paths = new ArrayList<IRelativeLocation>(numResults);
            for (ISharingMetadata.IConnectionComponent c : locations) {
                if (!c.getConnection().sameItemId((IItemHandle)connection)) continue;
                IRelativeLocation path = this.getLocalPathInternal(handle, c.getComponent(), c.getConnection());
                if (path != null) {
                    paths.add(path);
                }
                subProgress.worked(1);
            }
            subProgress.done();
            ArrayList<IRelativeLocation> arrayList = paths;
            return arrayList;
        }
        finally {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    public Collection<IRelativeLocation> getLocalItemPaths(IVersionableHandle handle, IComponentHandle component, IProgressMonitor monitor) throws FileSystemException {
        AbstractLock rule;
        int numResults;
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Collection<ISharingMetadata.IConnectionComponent> locations = this.metadata.getLocations(handle);
        block8: while (true) {
            progress.setWorkRemaining(100);
            AbstractLock[] rules = new AbstractLock[locations.size()];
            numResults = 0;
            for (ISharingMetadata.IConnectionComponent c : locations) {
                if (!c.getComponent().sameItemId((IItemHandle)component)) continue;
                rules[numResults++] = new ComponentLock(this.getRoot(), c.getConnection(), c.getComponent());
            }
            if (numResults == 0) {
                return Collections.EMPTY_LIST;
            }
            AbstractLock schedRule = MultiLock.combine(rules);
            rule = CopyFileAreaStore.beginBatching(schedRule, (IProgressMonitor)progress.newChild(1));
            boolean success = false;
            try {
                HashSet<ISharingMetadata.IConnectionComponent> old = new HashSet<ISharingMetadata.IConnectionComponent>(numResults * 4 / 3);
                for (ISharingMetadata.IConnectionComponent c : locations) {
                    if (!c.getComponent().sameItemId((IItemHandle)component)) continue;
                    old.add(c);
                }
                locations = this.metadata.getLocations(handle);
                numResults = 0;
                for (ISharingMetadata.IConnectionComponent c : locations) {
                    if (!c.getComponent().sameItemId((IItemHandle)component)) continue;
                    if (!old.contains(c)) continue block8;
                    ++numResults;
                }
                if (numResults != old.size()) continue;
                success = true;
            }
            finally {
                if (success) continue;
                CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                continue;
            }
            break;
        }
        try {
            SubMonitor subProgress = progress.newChild(98);
            subProgress.setWorkRemaining(numResults);
            ArrayList<IRelativeLocation> paths = new ArrayList<IRelativeLocation>(numResults);
            for (ISharingMetadata.IConnectionComponent c : locations) {
                if (!c.getComponent().sameItemId((IItemHandle)component)) continue;
                IRelativeLocation path = this.getLocalPathInternal(handle, c.getComponent(), c.getConnection());
                if (path != null) {
                    paths.add(path);
                }
                subProgress.worked(1);
            }
            subProgress.done();
            ArrayList<IRelativeLocation> arrayList = paths;
            return arrayList;
        }
        finally {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    public FileItemInfo getItemInfo(IRelativeLocation path) {
        this.assertReadLocked();
        try {
            return this.metadata.getFileItemInfo(path);
        }
        catch (FileSystemException e) {
            LoggingHelper.log("com.ibm.team.filesystem.client", e);
            return null;
        }
    }

    public void moveSharingInfo(final IRelativeLocation sourcePath, final IRelativeLocation destinationPath, IProgressMonitor monitor) throws FileSystemException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final ISharingDescriptor[] oldInfo = new ISharingDescriptor[1];
        final FileSystemException[] exception = new FileSystemException[1];
        AbstractLock rule = null;
        try {
            rule = CopyFileAreaStore.beginBatchingWithLock(null, new ILockParticipant(){

                @Override
                public AbstractLock locking(AbstractLock rule) {
                    CopyFileAreaStore.this.sharingInfoLock.lock();
                    try {
                        IRelativeLocation conflicting = CopyFileAreaStore.this.metadata.findConflictingShare(destinationPath);
                        if (conflicting != null && (sourcePath.equals(destinationPath) || !conflicting.getCanonicalForm(CopyFileAreaStore.this.isCaseSensitive(), true).equals(sourcePath.getCanonicalForm(CopyFileAreaStore.this.isCaseSensitive(), true)))) {
                            throw new IllegalArgumentException("Cannot move share from " + sourcePath + " to " + destinationPath + " because destination conflicts with existing share " + conflicting);
                        }
                        oldInfo[0] = CopyFileAreaStore.this.metadata.getSharingDescriptor(sourcePath);
                        if (oldInfo[0] != null) {
                            ComponentLock lock = new ComponentLock(CopyFileAreaStore.this.getRoot(), oldInfo[0].getConnectionHandle(), oldInfo[0].getComponent());
                            return lock;
                        }
                        throw new FileSystemException(NLS.bind((String)Messages.CopyFileAreaStore_11, (Object)sourcePath));
                    }
                    catch (FileSystemException e) {
                        exception[0] = e;
                        return null;
                    }
                }

                @Override
                public void waiting() {
                    CopyFileAreaStore.this.sharingInfoLock.unlock();
                }
            }, (IProgressMonitor)progress.newChild(1));
            if (exception[0] != null) {
                throw exception[0];
            }
            InverseFileItemInfo oldFiInfo = this.metadata.getFileItemInfo(oldInfo[0].getRootVersionable(), oldInfo[0].getComponent(), oldInfo[0].getConnectionHandle());
            if (oldFiInfo != null) {
                this.metadata.setFileItemInfo(oldFiInfo.getVersionableHandle(), oldInfo[0].getComponent(), oldInfo[0].getConnectionHandle(), oldFiInfo.withLocalName(destinationPath.getName()), (IProgressMonitor)progress.newChild(1));
                this.metadata.moveFileItemInfo(sourcePath, destinationPath);
            }
            progress.worked(50);
            ArrayList<Triple> toProcess = new ArrayList<Triple>();
            class Triple {
                IRelativeLocation source;
                IRelativeLocation destination;
                ISharingDescriptor descriptor;

                Triple(IRelativeLocation source, IRelativeLocation destination, ISharingDescriptor descriptor) {
                    this.source = source;
                    this.destination = destination;
                    this.descriptor = descriptor;
                }
            }
            toProcess.add(new Triple(sourcePath, destinationPath, oldInfo[0]));
            Map<IRelativeLocation, ISharingDescriptor> allDesc = this.metadata.getSharingDescriptors();
            for (IRelativeLocation loc : allDesc.keySet()) {
                if (sourcePath.equals(loc) || !sourcePath.isPrefixOf(loc)) continue;
                ISharingDescriptor desc = allDesc.get(loc);
                IRelativeLocation newPath = destinationPath.append(loc.removeFirstSegments(sourcePath.segmentCount()));
                toProcess.add(new Triple(loc, newPath, desc));
            }
            for (Triple trip : toProcess) {
                this.metadata.setSharingDescriptor(trip.source, null, (IProgressMonitor)progress.newChild(24));
                CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(trip.descriptor.getRootVersionable(), this, trip.source, 2));
                this.metadata.setSharingDescriptor(trip.destination, trip.descriptor, (IProgressMonitor)progress.newChild(24));
                CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(trip.descriptor.getRootVersionable(), this, trip.destination, 1));
            }
        }
        catch (Throwable throwable) {
            this.sharingInfoLock.unlock();
            if (rule != null) {
                CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
            throw throwable;
        }
        this.sharingInfoLock.unlock();
        if (rule != null) {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
    }

    public void setSharingInfo(IRelativeLocation path, final ISharingDescriptor info, IProgressMonitor monitor) throws FileSystemException {
        this.assertReadLocked();
        final IRelativeLocation sharePath = path;
        Assert.isNotNull((Object)info);
        AbstractLock rule = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final ISharingDescriptor[] oldInfo = new ISharingDescriptor[1];
        final FileSystemException[] exception = new FileSystemException[1];
        try {
            rule = CopyFileAreaStore.beginBatchingWithLock(null, new ILockParticipant(){

                @Override
                public AbstractLock locking(AbstractLock rule) {
                    CopyFileAreaStore.this.sharingInfoLock.lock();
                    try {
                        oldInfo[0] = CopyFileAreaStore.this.metadata.getSharingDescriptor(sharePath);
                        if (oldInfo[0] != null) {
                            rule = MultiLock.combine(new ComponentLock(CopyFileAreaStore.this.getRoot(), info.getConnectionHandle(), info.getComponent()), new ComponentLock(CopyFileAreaStore.this.getRoot(), oldInfo[0].getConnectionHandle(), oldInfo[0].getComponent()));
                        } else {
                            IRelativeLocation conflicting = CopyFileAreaStore.this.metadata.findConflictingShare(sharePath);
                            if (conflicting != null) {
                                throw new IllegalArgumentException("Cannot share " + sharePath + " because it conflicts with " + conflicting);
                            }
                            rule = new ComponentLock(CopyFileAreaStore.this.getRoot(), info.getConnectionHandle(), info.getComponent());
                        }
                        return rule;
                    }
                    catch (FileSystemException e) {
                        exception[0] = e;
                        return null;
                    }
                }

                @Override
                public void waiting() {
                    CopyFileAreaStore.this.sharingInfoLock.unlock();
                }
            }, (IProgressMonitor)progress.newChild(1));
            if (exception[0] != null) {
                throw exception[0];
            }
            if (oldInfo[0] == null) {
                if (this.getFileItemInfo(info) != null) {
                    throw new FileSystemException(NLS.bind((String)Messages.CopyFileAreaStore_12, (Object[])new Object[]{sharePath, info.getRootVersionable().getItemId().getUuidValue(), info.getConnectionName(), info.getComponentName()}));
                }
                Collection<IRelativeLocation> allSharePaths = this.allSharePaths(sharePath);
                if (allSharePaths.isEmpty()) {
                    this.metadata.deleteFileItemInfo(sharePath, (IProgressMonitor)progress.newChild(70));
                }
            } else if (!(oldInfo[0].getComponent().sameItemId((IItemHandle)info.getComponent()) && oldInfo[0].getConnectionHandle().sameItemId((IItemHandle)info.getConnectionHandle()) && oldInfo[0].getRootVersionable().sameItemId((IItemHandle)info.getRootVersionable()))) {
                if (this.getFileItemInfo(info) != null) {
                    throw new FileSystemException(NLS.bind((String)Messages.CopyFileAreaStore_12, (Object[])new Object[]{sharePath, info.getRootVersionable().getItemId().getUuidValue(), info.getConnectionName(), info.getComponentName()}));
                }
                if (!oldInfo[0].getRootVersionable().sameItemId((IItemHandle)info.getRootVersionable())) {
                    CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(oldInfo[0].getRootVersionable(), this, sharePath, 2));
                }
                IRelativeLocation oldSharePath = this.metadata.getPathForShareRoot(oldInfo[0].getRootVersionable(), oldInfo[0].getComponent(), oldInfo[0].getConnectionHandle());
                if (info.getRootVersionable() instanceof IFolderHandle) {
                    if (oldInfo[0].getRootVersionable() instanceof IFolderHandle) {
                        this.moveShareRootToWC(oldSharePath, oldInfo[0], sharePath, info, (IProgressMonitor)progress.newChild(70));
                    } else {
                        this.deleteTreeInfoInternal(oldSharePath, oldInfo[0], progress.newChild(70));
                    }
                } else if (info.getRootVersionable().sameItemId((IItemHandle)oldInfo[0].getRootVersionable())) {
                    InverseFileItemInfo oldRootInfo = this.metadata.getFileItemInfo(info.getRootVersionable(), oldInfo[0].getComponent(), oldInfo[0].getConnectionHandle());
                    this.deleteTreeInfoInternal(oldSharePath, oldInfo[0], progress.newChild(69));
                    InverseFileItemInfo newRootInfo = oldRootInfo.withLocalName(sharePath.getName());
                    this.metadata.setFileItemInfo(sharePath, newRootInfo);
                    this.metadata.setFileItemInfo(info.getRootVersionable(), info.getComponent(), info.getConnectionHandle(), newRootInfo, (IProgressMonitor)progress.newChild(1));
                } else {
                    this.deleteTreeInfoInternal(oldSharePath, oldInfo[0], progress.newChild(70));
                }
            } else {
                progress.setWorkRemaining(29);
            }
            this.metadata.setSharingDescriptor(sharePath, info, (IProgressMonitor)progress.newChild(14));
            if (!(oldInfo[0] == null || oldInfo[0].getComponent().sameItemId((IItemHandle)info.getComponent()) && oldInfo[0].getConnectionHandle().sameItemId((IItemHandle)info.getConnectionHandle()))) {
                progress.setWorkRemaining(16);
                if (!this.metadata.hasShares(oldInfo[0].getComponent(), oldInfo[0].getConnectionHandle(), (IProgressMonitor)progress.newChild(1))) {
                    LocalChangeManager.getInstance().clearPendingChanges(oldInfo[0].getConnectionHandle(), oldInfo[0].getComponent(), this.getRoot());
                }
            }
            LoadedConfigurationDescriptor descriptor = this.getLoadedConfigurationDescriptor(info, (IProgressMonitor)progress.newChild(4));
            if (descriptor.workspaceComponentState == -1L) {
                this.traceIfEnabled(NLS.bind((String)"CopyFileAreaStore#setSharingInfo: Updating the workspace component state for component: \"{0}\", with workspace context: \"{1}\", at sandbox location: \"{2}\", to UNKNOWN.", (Object[])new String[]{info.getComponentName(), info.getConnectionName(), this.metadata.getRoot().toString()}));
            } else {
                this.traceIfEnabled(NLS.bind((String)"CopyFileAreaStore#setSharingInfo: Updating the workspace component state for component: \"{0}\", with workspace context: \"{1}\", at sandbox location: \"{2}\", to: \"{3}\".", (Object[])new String[]{info.getComponentName(), info.getConnectionName(), this.metadata.getRoot().toString(), String.valueOf(descriptor.workspaceComponentState)}));
            }
            boolean alreadyLoaded = this.metadata.componentLoaded(descriptor, (IProgressMonitor)progress.newChild(10)) != null;
            CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(info.getRootVersionable(), this, sharePath, 1));
            if (!alreadyLoaded) {
                CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(null, this, null, 7));
            }
        }
        catch (Throwable throwable) {
            this.sharingInfoLock.unlock();
            if (rule != null) {
                CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
            throw throwable;
        }
        this.sharingInfoLock.unlock();
        if (rule != null) {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
    }

    private LoadedConfigurationDescriptor getLoadedConfigurationDescriptor(ISharingDescriptor info, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        long workspaceComponentState = -1L;
        Collection<LoadedConfigurationDescriptor> descriptors = this.metadata.allLoadedComponents((IProgressMonitor)progress.newChild(100));
        for (LoadedConfigurationDescriptor descriptor : descriptors) {
            if (!descriptor.connectionHandle.getItemId().equals((Object)info.getConnectionHandle().getItemId()) || !descriptor.getComponentHandle().getItemId().equals((Object)info.getComponent().getItemId())) continue;
            workspaceComponentState = descriptor.workspaceComponentState;
            break;
        }
        return new LoadedConfigurationDescriptor(info.getRepositoryId(), info.getConnectionHandle(), info.getConnectionName(), info.getComponent(), info.getComponentName(), workspaceComponentState);
    }

    protected void deleteTreeInfoInternal(IRelativeLocation oldSharePath, ISharingDescriptor oldInfo, SubMonitor progress) throws FileSystemException {
        progress.setWorkRemaining(100);
        if (!this.deleteTreeInfoInternal(oldSharePath, oldInfo.getComponent(), oldInfo.getConnectionHandle(), true, (IProgressMonitor)progress.newChild(70)) && this.metadata.getFileItemInfo(oldInfo.getRootVersionable(), oldInfo.getComponent(), oldInfo.getConnectionHandle()) != null) {
            ArrayList<FileSystemException> exceptions = new ArrayList<FileSystemException>();
            this.deleteInverseTreeInfo(oldInfo.getRootVersionable(), oldInfo.getConnectionHandle(), oldInfo.getComponent(), exceptions, (IProgressMonitor)progress.newChild(30));
            this.handleExceptions(exceptions, Messages.CopyFileAreaStore_19);
        }
    }

    private InverseFileItemInfo getFileItemInfo(ISharingDescriptor info) throws FileSystemException {
        return this.metadata.getFileItemInfo(info.getRootVersionable(), info.getComponent(), info.getConnectionHandle());
    }

    private void moveShareRootToWC(IRelativeLocation oldSharePath, ISharingDescriptor oldInfo, IRelativeLocation newSharePath, ISharingDescriptor newInfo, IProgressMonitor monitor) throws FileSystemException {
        try {
            this.internalMoveShareRootToWC(oldSharePath, oldInfo, newSharePath, newInfo, monitor);
        }
        catch (Throwable e) {
            StringBuffer message = new StringBuffer();
            message.append("Unexpected error during share reconciliation.");
            message.append(" Old share path ");
            message.append(oldSharePath.toString());
            message.append(" from ");
            this.appendSharingDescriptor(message, oldInfo);
            message.append(" New share path ");
            message.append(newSharePath.toString());
            message.append(" from ");
            this.appendSharingDescriptor(message, newInfo);
            throw new FileSystemException(message.toString(), e);
        }
    }

    private void appendSharingDescriptor(StringBuffer message, ISharingDescriptor sharingDescriptor) {
        message.append("workspace ");
        message.append(sharingDescriptor.getConnectionName());
        message.append(" (");
        message.append(sharingDescriptor.getConnectionHandle().getItemId().getUuidValue());
        message.append(") ");
        message.append("component ");
        message.append(sharingDescriptor.getComponentName());
        message.append(" (");
        message.append(sharingDescriptor.getComponent().getItemId().getUuidValue());
        message.append(") ");
        message.append("versionable ");
        message.append(sharingDescriptor.getRootVersionable().getItemId().getUuidValue());
        if (!sharingDescriptor.getReloadRoot().sameItemId((IItemHandle)sharingDescriptor.getRootVersionable())) {
            message.append(" (");
            message.append(sharingDescriptor.getReloadRoot().getItemId().getUuidValue());
            message.append(")");
        }
    }

    private void internalMoveShareRootToWC(IRelativeLocation oldSharePath, ISharingDescriptor oldInfo, IRelativeLocation newSharePath, ISharingDescriptor newInfo, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean foundNewRootInRemoteSubtree = false;
        InverseFileItemInfo oldRootInfo = null;
        if (this.sameWorkspaceComponent(oldInfo, newInfo)) {
            foundNewRootInRemoteSubtree = this.getRemoteAncestorInternal(Collections.singleton(oldInfo.getRootVersionable().getItemId()), newInfo.getRootVersionable(), oldInfo.getComponent(), oldInfo.getConnectionHandle()) != null;
            oldRootInfo = this.metadata.getFileItemInfo(oldInfo.getRootVersionable(), oldInfo.getComponent(), oldInfo.getConnectionHandle());
            progress.setWorkRemaining(10);
        } else {
            this.removeLocalInfoFromInverseMetadata(oldSharePath, oldInfo.getComponent(), oldInfo.getConnectionHandle(), progress.newChild(25));
            this.assignNewUUIDsToRemoteSharesWithNoLocal(oldInfo.getRootVersionable(), oldInfo.getComponent(), oldInfo.getConnectionHandle(), progress.newChild(20));
            foundNewRootInRemoteSubtree = this.moveInverseMetadataForShareRootToNewWC(oldInfo, newInfo, progress.newChild(20));
            oldRootInfo = this.fixLocalItemInverseMetadataForShareRootToNewWC(oldSharePath, oldInfo, newInfo, progress.newChild(25));
        }
        if (oldRootInfo == null) {
            ((ICopyFileArea)((Object)this)).forget(oldInfo.getConnectionHandle(), oldInfo.getComponent(), oldInfo.getRootVersionable(), (IProgressMonitor)progress.newChild(1));
        } else if (!oldRootInfo.getVersionableHandle().sameItemId((IItemHandle)newInfo.getRootVersionable())) {
            this.handeLocalMoveWithRemoteVersionableChange(oldSharePath, oldInfo, oldRootInfo, newSharePath, newInfo, foundNewRootInRemoteSubtree, progress);
        }
        if (!oldSharePath.equals(newSharePath)) {
            this.metadata.moveFileItemInfo(oldSharePath, newSharePath);
        }
        progress.done();
    }

    private void handeLocalMoveWithRemoteVersionableChange(IRelativeLocation oldSharePath, ISharingDescriptor oldInfo, InverseFileItemInfo oldRootInfo, IRelativeLocation newSharePath, ISharingDescriptor newInfo, boolean foundNewRootInRemoteSubtree, SubMonitor progress) throws FileSystemException {
        IFolderHandle localParent;
        String localName;
        IRelativeLocation pathToNewRootInOldComponent;
        InverseFileItemInfo newRootInfo;
        if (!oldInfo.getRootVersionable().sameItemId((IItemHandle)newInfo.getRootVersionable())) {
            newRootInfo = this.metadata.getFileItemInfo(newInfo.getRootVersionable(), oldInfo.getComponent(), oldInfo.getConnectionHandle());
            pathToNewRootInOldComponent = this.getLocalPathInternal(newRootInfo, oldInfo.getComponent(), oldInfo.getConnectionHandle());
        } else {
            newRootInfo = null;
            pathToNewRootInOldComponent = null;
        }
        HashMap<UUID, InverseFileItemInfo> itemInfos = new HashMap<UUID, InverseFileItemInfo>();
        itemInfos.put(oldRootInfo.getVersionableHandle().getItemId(), oldRootInfo);
        if (newRootInfo != null) {
            newRootInfo = this.getFileItemInfo(newInfo);
        }
        if (newRootInfo != null) {
            localName = newRootInfo.getLocalName();
            localParent = newRootInfo.getLocalParent();
        } else {
            localName = null;
            localParent = null;
        }
        if (foundNewRootInRemoteSubtree) {
            itemInfos.put(newRootInfo.getVersionableHandle().getItemId(), newRootInfo);
            InverseFileItemInfo parentInfo = this.getFileItemInfo((IVersionableHandle)newRootInfo.getParent(), newInfo.getComponent(), newInfo.getConnectionHandle(), itemInfos);
            parentInfo = parentInfo.removeRemoteChild(newRootInfo.getName());
            itemInfos.put(parentInfo.getVersionableHandle().getItemId(), parentInfo);
        } else {
            newRootInfo = new InverseFileItemInfo((IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(newInfo.getRootVersionable().getItemId(), UUID.generate()), null, null, true, Collections.EMPTY_MAP, null, newSharePath.getName(), Collections.EMPTY_MAP, Collections.EMPTY_SET, Collections.EMPTY_MAP);
            itemInfos.put(newRootInfo.getVersionableHandle().getItemId(), newRootInfo);
        }
        oldRootInfo = this.getFileItemInfo(oldRootInfo.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), itemInfos);
        if (oldRootInfo.getVersionableHandle().hasStateId()) {
            HashMap<String, IVersionableHandle> children = new HashMap<String, IVersionableHandle>(newRootInfo.getRemoteChildren());
            String name = newSharePath.getName();
            int i = 0;
            while (children.containsKey(name)) {
                name = String.valueOf(newSharePath.getName()) + Integer.toString(i);
                ++i;
            }
            children.put(name, oldRootInfo.getVersionableHandle());
            IVersionableHandle newRootHandle = newRootInfo.getVersionableHandle().hasStateId() ? newRootInfo.getVersionableHandle() : (IVersionableHandle)newRootInfo.getVersionableHandle().getItemType().createItemHandle(newRootInfo.getVersionableHandle().getItemId(), UUID.generate());
            newRootInfo = new InverseFileItemInfo(newRootHandle, newRootInfo.isContentChanged(), newRootInfo.getLastContentChangeCheckStamp(), null, null, true, Collections.unmodifiableMap(children), newRootInfo.getLocalParent(), newRootInfo.getLocalName(), newRootInfo.getHash(), newRootInfo.getContentLength(), newRootInfo.getOriginalLineDelimiter(), newRootInfo.getLineDelimiter(), newRootInfo.getOriginalContentType(), newRootInfo.getContentType(), newRootInfo.getStoredPredecessorHintHash(), newRootInfo.getStoredSize(), newRootInfo.getStoredEncoding(), newRootInfo.getStoredHash(), newRootInfo.getStoredNumLineDelimiters(), newRootInfo.isExecutable(), newRootInfo.isOriginalExecutable(), newRootInfo.isDirectoryLink(), newRootInfo.isOriginalDirectoryLink(), newRootInfo.getOriginalProperties(), newRootInfo.getRemovedProperties(), newRootInfo.getChangedProperties(), newRootInfo.getExternalLinks(), newRootInfo.getOriginalExternalLinks());
            itemInfos.put(newRootInfo.getVersionableHandle().getItemId(), newRootInfo);
            oldRootInfo = new InverseFileItemInfo(oldRootInfo.getVersionableHandle(), oldRootInfo.isContentChanged(), oldRootInfo.getLastContentChangeCheckStamp(), (IFolderHandle)newInfo.getRootVersionable(), name, oldRootInfo.isLoadedWithAnotherName(), oldRootInfo.getRemoteChildren(), localParent, localName, oldRootInfo.getHash(), oldRootInfo.getContentLength(), oldRootInfo.getOriginalLineDelimiter(), oldRootInfo.getLineDelimiter(), oldRootInfo.getOriginalContentType(), oldRootInfo.getContentType(), oldRootInfo.getStoredPredecessorHintHash(), oldRootInfo.getStoredSize(), oldRootInfo.getStoredEncoding(), oldRootInfo.getStoredHash(), oldRootInfo.getStoredNumLineDelimiters(), oldRootInfo.isExecutable(), oldRootInfo.isOriginalExecutable(), oldRootInfo.isDirectoryLink(), oldRootInfo.isOriginalDirectoryLink(), oldRootInfo.getOriginalProperties(), oldRootInfo.getRemovedProperties(), oldRootInfo.getChangedProperties(), oldRootInfo.getExternalLinks(), oldRootInfo.getOriginalExternalLinks());
            itemInfos.put(oldRootInfo.getVersionableHandle().getItemId(), oldRootInfo);
        }
        this.metadata.setFileItemInfo(oldSharePath, newRootInfo);
        if (pathToNewRootInOldComponent != null && oldSharePath.isPrefixOf(pathToNewRootInOldComponent)) {
            this.metadata.setFileItemInfo(pathToNewRootInOldComponent, oldRootInfo);
        }
        this.adjustChildrenToNewParent(oldSharePath, (IFolderHandle)newInfo.getRootVersionable(), newInfo.getComponent(), newInfo.getConnectionHandle(), itemInfos, (IProgressMonitor)progress.newChild(5));
        if (pathToNewRootInOldComponent != null && oldSharePath.isPrefixOf(pathToNewRootInOldComponent)) {
            this.adjustChildrenToNewParent(pathToNewRootInOldComponent, (IFolderHandle)oldRootInfo.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), itemInfos, (IProgressMonitor)progress.newChild(4));
        }
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress.newChild(1), (int)itemInfos.values().size());
        for (InverseFileItemInfo info : itemInfos.values()) {
            this.metadata.setFileItemInfo(info.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), info, (IProgressMonitor)subProgress.newChild(1));
        }
    }

    private boolean sameWorkspaceComponent(ISharingDescriptor oldInfo, ISharingDescriptor newInfo) {
        return oldInfo.getComponent().sameItemId((IItemHandle)newInfo.getComponent()) && oldInfo.getConnectionHandle().sameItemId((IItemHandle)newInfo.getConnectionHandle());
    }

    private void removeLocalInfoFromInverseMetadata(IRelativeLocation oldSharePath, final IComponentHandle component, final IContextHandle connection, SubMonitor progress) throws FileSystemException {
        final ArrayList<FileSystemException> exceptions = new ArrayList<FileSystemException>();
        this.metadata.accept(new IVisitor(){

            @Override
            public boolean visit(IRelativeLocation path, FileItemInfo entry, IProgressMonitor monitor) {
                try {
                    if (entry.getVersionableHandle().hasStateId()) {
                        InverseFileItemInfo inverse = CopyFileAreaStore.this.metadata.getFileItemInfo(entry.getVersionableHandle(), component, connection);
                        CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), component, connection, inverse.asLocalDeletion(), monitor);
                    }
                }
                catch (FileSystemException e) {
                    exceptions.add(e);
                }
                return true;
            }
        }, oldSharePath, Integer.MAX_VALUE, true, (IProgressMonitor)progress);
        this.handleExceptions(exceptions, Messages.CopyFileAreaStore_21);
    }

    private void assignNewUUIDsToRemoteSharesWithNoLocal(IVersionableHandle root, final IComponentHandle component, final IContextHandle connection, SubMonitor progress) throws FileSystemException {
        final ArrayList<FileSystemException> exceptions = new ArrayList<FileSystemException>();
        this.metadata.accept(new IRemoteVisitor(){

            @Override
            public boolean visit(InverseFileItemInfo entry, IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                try {
                    if (entry.getLocalName() != null && entry.getVersionableHandle().hasStateId()) {
                        IRelativeLocation localPath = CopyFileAreaStore.this.getLocalPathInternal(entry, component, connection);
                        InverseFileItemInfo newItemInfo = entry.withNewUUID();
                        CopyFileAreaStore.this.metadata.setFileItemInfo(localPath, newItemInfo);
                        CopyFileAreaStore.this.metadata.setFileItemInfo(newItemInfo.getVersionableHandle(), component, connection, newItemInfo, (IProgressMonitor)progress.newChild(1));
                        if (entry.getVersionableHandle() instanceof IFolderHandle) {
                            CopyFileAreaStore.this.updateLocalParent(localPath, (IFolderHandle)newItemInfo.getVersionableHandle(), component, connection, (IProgressMonitor)progress.newChild(1));
                        }
                    }
                }
                catch (FileSystemException e) {
                    exceptions.add(e);
                }
                progress.done();
                return true;
            }
        }, root, component, connection, Integer.MAX_VALUE, true, (IProgressMonitor)progress);
        this.handleExceptions(exceptions, Messages.CopyFileAreaStore_22);
    }

    private boolean moveInverseMetadataForShareRootToNewWC(final ISharingDescriptor oldInfo, final ISharingDescriptor newInfo, SubMonitor progress) throws FileSystemException {
        final ArrayList<FileSystemException> exceptions = new ArrayList<FileSystemException>();
        final boolean[] foundNewRootInRemoteSubtree = new boolean[1];
        this.metadata.accept(new IRemoteVisitor(){

            @Override
            public boolean visit(InverseFileItemInfo entry, IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
                try {
                    IVersionableHandle versionableHandle = entry.getVersionableHandle();
                    CopyFileAreaStore.this.metadata.setFileItemInfo(versionableHandle, oldInfo.getComponent(), oldInfo.getConnectionHandle(), null, (IProgressMonitor)progress.newChild(1));
                    boolean isNewRoot = versionableHandle.sameItemId((IItemHandle)newInfo.getRootVersionable());
                    if (isNewRoot) {
                        foundNewRootInRemoteSubtree[0] = true;
                    }
                    InverseFileItemInfo newFI = entry.forMoveToNewWC(entry.getParent(), entry.getName());
                    InverseFileItemInfo oldFI = CopyFileAreaStore.this.metadata.setFileItemInfo(versionableHandle, newInfo.getComponent(), newInfo.getConnectionHandle(), newFI, (IProgressMonitor)progress.newChild(1));
                    if (oldFI == null) {
                        if (!versionableHandle.sameItemId((IItemHandle)oldInfo.getRootVersionable())) {
                            InverseFileItemInfo parentFI = CopyFileAreaStore.this.metadata.getFileItemInfo((IVersionableHandle)entry.getParent(), newInfo.getComponent(), newInfo.getConnectionHandle());
                            String name = entry.getName();
                            if (parentFI.getRemoteChildren().containsKey(name)) {
                                int cnt = 0;
                                do {
                                    name = String.valueOf(entry.getName()) + Integer.toString(cnt);
                                    ++cnt;
                                } while (parentFI.getRemoteChildren().containsKey(name));
                                newFI = entry.forMoveToNewWC(entry.getParent(), name);
                                CopyFileAreaStore.this.metadata.setFileItemInfo(versionableHandle, newInfo.getComponent(), newInfo.getConnectionHandle(), newFI, (IProgressMonitor)progress.newChild(1));
                            }
                            parentFI = parentFI.addRemoteChild(name, versionableHandle);
                            CopyFileAreaStore.this.metadata.setFileItemInfo(parentFI.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), parentFI, (IProgressMonitor)progress.newChild(1));
                        }
                    } else {
                        CopyFileAreaStore.this.metadata.setFileItemInfo(versionableHandle, newInfo.getComponent(), newInfo.getConnectionHandle(), oldFI, (IProgressMonitor)progress.newChild(4));
                    }
                }
                catch (FileSystemException e) {
                    exceptions.add(e);
                }
                progress.done();
                return true;
            }
        }, oldInfo.getRootVersionable(), oldInfo.getComponent(), oldInfo.getConnectionHandle(), Integer.MAX_VALUE, true, (IProgressMonitor)progress);
        this.handleExceptions(exceptions, Messages.CopyFileAreaStore_14);
        return foundNewRootInRemoteSubtree[0];
    }

    private InverseFileItemInfo fixLocalItemInverseMetadataForShareRootToNewWC(IRelativeLocation oldSharePath, final ISharingDescriptor oldInfo, final ISharingDescriptor newInfo, SubMonitor progress) throws FileSystemException {
        final ArrayList<FileSystemException> exceptions = new ArrayList<FileSystemException>();
        final InverseFileItemInfo[] oldRootInfo = new InverseFileItemInfo[1];
        this.metadata.accept(new IVisitor(){

            @Override
            public boolean visit(IRelativeLocation path, FileItemInfo entry, IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                try {
                    if (!entry.getVersionableHandle().hasStateId()) {
                        CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), oldInfo.getComponent(), oldInfo.getConnectionHandle(), null, (IProgressMonitor)progress.newChild(1));
                    }
                    InverseFileItemInfo inverse = CopyFileAreaStore.this.metadata.getFileItemInfo(entry.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle());
                    String localName = path.getName();
                    if (inverse == null) {
                        FileItemInfo parentInfo = CopyFileAreaStore.this.metadata.getFileItemInfo(path.getParent());
                        inverse = entry.createInverseFileItemInfoForLocalItem((IFolderHandle)parentInfo.getVersionableHandle(), path.getName());
                        CopyFileAreaStore.this.metadata.setFileItemInfo(inverse.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), inverse, (IProgressMonitor)progress.newChild(1));
                    } else if (inverse.getLocalName() != null || CopyFileAreaStore.this.metadata.getPathForShareRoot(inverse.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle()) != null) {
                        IVersionableHandle h = (IVersionableHandle)entry.getVersionableHandle().getItemType().createItemHandle(UUID.generate(), null);
                        if (entry.getVersionableHandle().sameItemId((IItemHandle)oldInfo.getRootVersionable())) {
                            inverse = new InverseFileItemInfo((IFolderHandle)h, null, null, false, Collections.EMPTY_MAP, null, localName, Collections.EMPTY_MAP, Collections.EMPTY_SET, MetadataProperties.getCurrentProperties(inverse.getOriginalProperties(), inverse.getChangedProperties(), inverse.getRemovedProperties()));
                            CopyFileAreaStore.this.metadata.setFileItemInfo(path, inverse);
                            CopyFileAreaStore.this.metadata.setFileItemInfo(inverse.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), inverse, (IProgressMonitor)progress.newChild(1));
                            oldRootInfo[0] = inverse;
                        } else {
                            FileItemInfo parentInfo = CopyFileAreaStore.this.metadata.getFileItemInfo(path.getParent());
                            inverse = new InverseFileItemInfo(h, false, -1L, null, null, false, Collections.EMPTY_MAP, (IFolderHandle)parentInfo.getVersionableHandle(), localName, null, -1L, null, entry.getLineDelimiter(), null, entry.getContentType(), null, -1L, null, null, -1L, entry.isExecutable(), false, entry.isDirectoryLink(), false, Collections.EMPTY_MAP, Collections.EMPTY_SET, MetadataProperties.getCurrentProperties(inverse.getOriginalProperties(), inverse.getChangedProperties(), inverse.getRemovedProperties()), entry.getExternalLinks(), null);
                            CopyFileAreaStore.this.metadata.setFileItemInfo(path, inverse);
                            CopyFileAreaStore.this.metadata.setFileItemInfo(inverse.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), inverse, (IProgressMonitor)progress.newChild(1));
                        }
                    } else if (!entry.getVersionableHandle().sameItemId((IItemHandle)oldInfo.getRootVersionable())) {
                        boolean modified;
                        long timeStamp;
                        FileItemInfo parentInfo = CopyFileAreaStore.this.metadata.getFileItemInfo(path.getParent());
                        if (inverse.isFolder()) {
                            timeStamp = -1L;
                            modified = false;
                        } else if (entry.getContentLength() == inverse.getContentLength() && inverse.getHash().equals((Object)entry.getHash())) {
                            timeStamp = entry.getLastContentChangeCheckStamp();
                            modified = entry.isContentChanged();
                        } else {
                            timeStamp = -1L;
                            modified = true;
                        }
                        inverse = inverse.updateLocalInfo(entry, modified, timeStamp, (IFolderHandle)parentInfo.getVersionableHandle(), localName);
                        CopyFileAreaStore.this.metadata.setFileItemInfo(path, inverse);
                        CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), inverse, (IProgressMonitor)progress.newChild(1));
                    } else {
                        IFolderHandle parent = inverse.getParent();
                        if (parent != null && CopyFileAreaStore.this.metadata.getFileItemInfo((IVersionableHandle)parent, newInfo.getComponent(), newInfo.getConnectionHandle()) != null) {
                            parent = null;
                        }
                        inverse = new InverseFileItemInfo((IFolderHandle)inverse.getVersionableHandle(), inverse.getParent(), inverse.getName(), inverse.isLoadedWithAnotherName(), inverse.getRemoteChildren(), parent, localName, inverse.getOriginalProperties(), inverse.getRemovedProperties(), inverse.getChangedProperties());
                        CopyFileAreaStore.this.metadata.setFileItemInfo(path, inverse);
                        CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), inverse, (IProgressMonitor)progress.newChild(1));
                        oldRootInfo[0] = inverse;
                    }
                }
                catch (FileSystemException e) {
                    exceptions.add(e);
                }
                progress.done();
                return true;
            }
        }, oldSharePath, Integer.MAX_VALUE, true, (IProgressMonitor)progress);
        this.handleExceptions(exceptions, Messages.CopyFileAreaStore_15);
        return oldRootInfo[0];
    }

    private void adjustChildrenToNewParent(IRelativeLocation parentPath, IFolderHandle newParent, IComponentHandle component, IContextHandle connection, Map<UUID, InverseFileItemInfo> cache, IProgressMonitor monitor) throws FileSystemException {
        Map<StringWrapper, FileItemInfo> childMap = this.metadata.getChildInfos(parentPath);
        for (FileItemInfo entry : childMap.values()) {
            InverseFileItemInfo newInfo = this.getFileItemInfo(entry.getVersionableHandle(), component, connection, cache);
            cache.put(newInfo.getVersionableHandle().getItemId(), newInfo.withLocalParent(newParent));
        }
    }

    private InverseFileItemInfo getFileItemInfo(IVersionableHandle item, IComponentHandle component, IContextHandle connection, Map<UUID, InverseFileItemInfo> cache) throws FileSystemException {
        InverseFileItemInfo result = cache.get(item.getItemId());
        if (result != null) {
            return result;
        }
        result = this.metadata.getFileItemInfo(item, component, connection);
        if (result == null) {
            return null;
        }
        cache.put(item.getItemId(), result);
        return result;
    }

    public ISharingDescriptor getSharingInfo(IRelativeLocation sharePath) {
        this.assertReadLocked();
        try {
            return this.metadata.getSharingDescriptor(sharePath);
        }
        catch (FileSystemException e) {
            LoggingHelper.log("com.ibm.team.filesystem.client", e);
            return null;
        }
    }

    public ISharingDescriptor findSharingDescriptor(IRelativeLocation shareablePath) throws FileSystemException {
        this.assertReadLocked();
        return this.internalFindSharingDescriptor(shareablePath);
    }

    private ISharingDescriptor internalFindSharingDescriptor(IRelativeLocation shareablePath) throws FileSystemException {
        return this.metadata.findSharingDescriptor(shareablePath);
    }

    public boolean isShareRoot(IVersionableHandle item, IComponentHandle component, IContextHandle connection) throws FileSystemException {
        this.assertReadLocked();
        return this.metadata.getPathForShareRoot(item, component, connection) != null;
    }

    public void removeSharingInfo(IRelativeLocation sharePath, IProgressMonitor monitor) throws FileSystemException {
        block6: {
            this.assertReadLocked();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            RuleDescriptorPair pair = this.beginBatching(sharePath, (IProgressMonitor)progress.newChild(1));
            try {
                ISharingDescriptor info = pair.desc;
                if (info != null) {
                    if (this.metadata.setSharingDescriptor(sharePath, null, (IProgressMonitor)progress.newChild(49)) == null) {
                        throw new IllegalArgumentException(sharePath + " is not a share root");
                    }
                    CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(info.getRootVersionable(), this, sharePath, 2));
                    if (!this.metadata.hasShares(info.getComponent(), info.getConnectionHandle(), (IProgressMonitor)progress.newChild(44))) {
                        LocalChangeManager.getInstance().clearPendingChanges(info.getConnectionHandle(), info.getComponent(), this.getRoot());
                        this.componentUnloaded(info.getComponent(), info.getConnectionHandle(), (IProgressMonitor)progress.newChild(5));
                    }
                    break block6;
                }
                throw new IllegalArgumentException(sharePath + " is not shared");
            }
            finally {
                CopyFileAreaStore.endBatching(pair.rule, (IProgressMonitor)progress.newChild(1));
                progress.done();
            }
        }
    }

    public void removeSharingInfo(IContextHandle connectionHandle, IComponentHandle component, IVersionableHandle item, IProgressMonitor monitor) throws FileSystemException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connectionHandle, component), (IProgressMonitor)progress.newChild(1));
        try {
            IRelativeLocation sharePath = this.metadata.getPathForShareRoot(item, component, connectionHandle);
            if (sharePath != null) {
                this.metadata.setSharingDescriptor(sharePath, null, (IProgressMonitor)progress.newChild(49));
                CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(item, this, sharePath, 2));
                if (!this.metadata.hasShares(component, connectionHandle, (IProgressMonitor)progress.newChild(44))) {
                    LocalChangeManager.getInstance().clearPendingChanges(connectionHandle, component, this.getRoot());
                    this.componentUnloaded(component, connectionHandle, (IProgressMonitor)progress.newChild(5));
                }
            } else {
                progress.setWorkRemaining(1);
            }
        }
        finally {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    protected RuleDescriptorPair beginBatching(IRelativeLocation shareablePath, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        RuleDescriptorPair result = new RuleDescriptorPair();
        ISharingDescriptor desc = this.internalFindSharingDescriptor(shareablePath);
        while (true) {
            progress.setWorkRemaining(100);
            result.desc = desc;
            if (desc == null) {
                result.rule = CopyFileAreaStore.beginBatching(BatchingLock.NULL_SCHEDULING_RULE, null);
                progress.done();
                return result;
            }
            result.rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), desc.getConnectionHandle(), desc.getComponent()), (IProgressMonitor)progress.newChild(50));
            boolean success = false;
            try {
                desc = this.internalFindSharingDescriptor(shareablePath);
                if (desc == null || !desc.getComponent().sameItemId((IItemHandle)result.desc.getComponent()) || !desc.getConnectionHandle().sameItemId((IItemHandle)result.desc.getConnectionHandle())) continue;
                progress.done();
                success = true;
                RuleDescriptorPair ruleDescriptorPair = result;
                return ruleDescriptorPair;
            }
            finally {
                if (success) continue;
                CopyFileAreaStore.endBatching(result.rule, (IProgressMonitor)progress.newChild(1));
                continue;
            }
            break;
        }
    }

    private RuleDescriptorPairForMove beginBatching(IRelativeLocation sourcePath, IRelativeLocation destinationPath, SubMonitor progress) throws FileSystemException {
        RuleDescriptorPairForMove desc = new RuleDescriptorPairForMove();
        while (true) {
            progress.setWorkRemaining(100);
            desc.beginBatching(this.getRoot(), this.internalFindSharingDescriptor(sourcePath), this.internalFindSharingDescriptor(destinationPath), progress.newChild(50));
            boolean success = false;
            try {
                if (!desc.descriptorsInSameComponent(this.internalFindSharingDescriptor(sourcePath), this.internalFindSharingDescriptor(destinationPath))) continue;
                progress.done();
                success = true;
                RuleDescriptorPairForMove ruleDescriptorPairForMove = desc;
                return ruleDescriptorPairForMove;
            }
            finally {
                if (success) continue;
                desc.endBatching(progress.newChild(1));
                continue;
            }
            break;
        }
    }

    public static AbstractLock beginBatching(AbstractLock resourceRule, IProgressMonitor monitor) {
        CopyFileAreaManager instance = CopyFileAreaManager.instance;
        return instance.batchingLock.acquire(resourceRule, instance, BatchingLock.NULL_LOCK_PARTICIPANT, true, monitor);
    }

    public static AbstractLock beginBatchingWithLock(AbstractLock resourceRule, ILockParticipant participant, IProgressMonitor monitor) {
        CopyFileAreaManager instance = CopyFileAreaManager.instance;
        return instance.batchingLock.acquire(resourceRule, instance, participant, true, monitor);
    }

    public static AbstractLock beginBatchingNoWait(AbstractLock resourceRule) {
        CopyFileAreaManager instance = CopyFileAreaManager.instance;
        return instance.batchingLock.acquire(resourceRule, instance, BatchingLock.NULL_LOCK_PARTICIPANT, false, null);
    }

    public static void endBatching(AbstractLock rule, IProgressMonitor monitor) throws FileSystemException {
        CopyFileAreaManager.instance.batchingLock.release(rule, monitor);
    }

    public boolean isConnectionShared(IContextHandle connection) throws FileSystemException {
        this.assertReadLocked();
        return this.internalIsConnectionShared(connection);
    }

    boolean internalIsConnectionShared(IContextHandle connection) throws FileSystemException {
        for (ISharingDescriptor descriptor : this.metadata.getSharingDescriptors().values()) {
            if (!descriptor.getConnectionHandle().sameItemId((IItemHandle)connection)) continue;
            return true;
        }
        return false;
    }

    public void accept(IRemoteVisitor metadataVisitor, IVersionableHandle item, IComponentHandle component, IContextHandle connection, AbstractLock rule, int depth, IProgressMonitor monitor) throws FileSystemException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (rule != null) {
                rule = CopyFileAreaStore.beginBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            this.metadata.accept(metadataVisitor, item, component, connection, depth, rule != null, (IProgressMonitor)progress.newChild(98));
        }
        finally {
            if (rule != null) {
                CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
        }
    }

    public void accept(IVisitor metadataVisitor, IRelativeLocation shareablePath, boolean mutable, int depth, IProgressMonitor monitor) throws FileSystemException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            this.metadata.accept(metadataVisitor, shareablePath, depth, mutable, (IProgressMonitor)progress.newChild(98));
        }
        finally {
            progress.done();
        }
    }

    public IRelativeLocation[] allSharePaths() throws FileSystemException {
        this.assertReadLocked();
        return this.metadata.allShares();
    }

    public Collection<IRelativeLocation> allSharePaths(IRelativeLocation parent) throws FileSystemException {
        this.assertReadLocked();
        return this.metadata.allShares(parent);
    }

    public boolean deleteTreeInfo(IRelativeLocation shareablePath, boolean removeRemoteInfo, IProgressMonitor monitor) throws FileSystemException {
        boolean bl;
        SubMonitor progress;
        block5: {
            this.assertReadLocked();
            AbstractLock rule = null;
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                IContextHandle connection;
                IComponentHandle component;
                RuleDescriptorPair pair = this.beginBatching(shareablePath, (IProgressMonitor)progress.newChild(1));
                ISharingDescriptor desc = pair.desc;
                rule = pair.rule;
                if (desc != null) {
                    component = desc.getComponent();
                    connection = desc.getConnectionHandle();
                } else {
                    component = null;
                    connection = null;
                }
                bl = this.deleteTreeInfoInternal(shareablePath, component, connection, removeRemoteInfo, (IProgressMonitor)progress.newChild(98));
                if (rule == null) break block5;
            }
            catch (Throwable throwable) {
                if (rule != null) {
                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                progress.done();
                throw throwable;
            }
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return bl;
    }

    public void deleteTreeInfo(IVersionableHandle item, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemException {
        InverseFileItemInfo info;
        SubMonitor progress;
        AbstractLock rule;
        block9: {
            block10: {
                this.assertReadLocked();
                rule = null;
                progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connection, component), (IProgressMonitor)progress.newChild(1));
                info = this.metadata.getFileItemInfo(item, component, connection);
                if (info != null) break block9;
                if (rule == null) break block10;
                CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
            return;
        }
        try {
            if (info.getParent() != null && this.metadata.getPathForShareRoot(info.getVersionableHandle(), component, connection) == null) {
                this.updateParentInfoForRemoval(info, component, connection, (IProgressMonitor)progress.newChild(1));
            }
            ArrayList<IVersionableHandle> toDelete = new ArrayList<IVersionableHandle>();
            toDelete.add(item);
            do {
                FileItemInfo fileInfo;
                IVersionableHandle itemToDelete;
                IRelativeLocation localPath;
                if ((localPath = this.getLocalPathInternal(info = this.metadata.setFileItemInfo(itemToDelete = (IVersionableHandle)toDelete.remove(toDelete.size() - 1), component, connection, null, (IProgressMonitor)progress.newChild(1)), component, connection)) != null && (fileInfo = this.getItemInfo(localPath)) != null) {
                    InverseFileItemInfo newInfo = new InverseFileItemInfo((IVersionableHandle)info.getVersionableHandle().getItemType().createItemHandle(UUID.generate(), null), false, -1L, null, null, false, Collections.EMPTY_MAP, info.getLocalParent(), info.getLocalName(), null, -1L, null, info.getLineDelimiter(), null, info.getContentType(), null, -1L, null, null, -1L, info.isExecutable(), false, info.isDirectoryLink(), false, Collections.EMPTY_MAP, Collections.EMPTY_SET, MetadataProperties.getCurrentProperties(info.getOriginalProperties(), info.getChangedProperties(), info.getRemovedProperties()), info.getExternalLinks(), null);
                    this.metadata.setFileItemInfo(newInfo.getVersionableHandle(), component, connection, newInfo, (IProgressMonitor)progress.newChild(1));
                    this.metadata.setFileItemInfo(localPath, newInfo);
                    if (info.isFolder()) {
                        this.updateLocalParent(localPath, (IFolderHandle)newInfo.getVersionableHandle(), component, connection, (IProgressMonitor)progress.newChild(1));
                    }
                }
                toDelete.addAll(info.getRemoteChildren().values());
            } while (!toDelete.isEmpty());
        }
        catch (Throwable throwable) {
            if (rule != null) {
                CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
            throw throwable;
        }
        if (rule != null) {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
    }

    private boolean deleteTreeInfoInternal(final IRelativeLocation startingPath, final IComponentHandle component, final IContextHandle connection, boolean removeRemoteInfo, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final ArrayList<FileSystemException> exceptions = new ArrayList<FileSystemException>();
        final IVersionableHandle[] root = new IVersionableHandle[1];
        final boolean[] changed = new boolean[1];
        this.metadata.accept(new IVisitor(){

            @Override
            public boolean visit(IRelativeLocation path, FileItemInfo entry, IProgressMonitor monitor) {
                if (path.equals(startingPath)) {
                    root[0] = entry.getVersionableHandle();
                }
                if (component != null) {
                    try {
                        InverseFileItemInfo info = CopyFileAreaStore.this.metadata.getFileItemInfo(entry.getVersionableHandle(), component, connection);
                        if (info == null) {
                            LoggingHelper.log(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)"Inverse metadata is missing for path {0}", (Object)path.toString())));
                        } else {
                            if (info.getVersionableHandle().hasStateId() != entry.getVersionableHandle().hasStateId() || info.getVersionableHandle().hasStateId() && !info.getVersionableHandle().sameStateId((IItemHandle)entry.getVersionableHandle())) {
                                throw new IllegalStateException(NLS.bind((String)Messages.CopyFileAreaStore_18, (Object)path));
                            }
                            if (info.getVersionableHandle().hasStateId()) {
                                InverseFileItemInfo newInfo = new InverseFileItemInfo(info.getVersionableHandle(), false, -1L, info.getParent(), info.getName(), info.isLoadedWithAnotherName(), info.getRemoteChildren(), null, null, info.getHash(), info.getContentLength(), info.getOriginalLineDelimiter(), info.getLineDelimiter(), info.getOriginalContentType(), info.getContentType(), info.getStoredPredecessorHintHash(), info.getStoredSize(), info.getStoredEncoding(), info.getStoredHash(), info.getStoredNumLineDelimiters(), info.isOriginalExecutable(), info.isOriginalExecutable(), info.isOriginalDirectoryLink(), info.isOriginalDirectoryLink(), info.getOriginalProperties(), info.getRemovedProperties(), info.getChangedProperties(), info.getExternalLinks(), info.getOriginalExternalLinks());
                                CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), component, connection, newInfo, monitor);
                            } else {
                                CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), component, connection, null, monitor);
                            }
                            changed[0] = true;
                        }
                    }
                    catch (FileSystemException e) {
                        exceptions.add(e);
                    }
                }
                return true;
            }
        }, startingPath, Integer.MAX_VALUE, true, (IProgressMonitor)progress.newChild(33));
        if (component != null && removeRemoteInfo && root[0] != null && root[0].hasStateId()) {
            changed[0] = changed[0] | this.deleteInverseTreeInfo(root[0], connection, component, exceptions, (IProgressMonitor)progress.newChild(34));
        } else {
            progress.setWorkRemaining(33);
        }
        this.metadata.deleteFileItemInfo(startingPath, (IProgressMonitor)progress.newChild(33));
        this.handleExceptions(exceptions, Messages.CopyFileAreaStore_19);
        return changed[0];
    }

    protected boolean deleteInverseTreeInfo(final IVersionableHandle root, final IContextHandle connection, final IComponentHandle component, final List<FileSystemException> exceptions, IProgressMonitor monitor) throws FileSystemException {
        final boolean[] changed = new boolean[1];
        this.metadata.accept(new IRemoteVisitor(){

            @Override
            public boolean visit(InverseFileItemInfo entry, IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
                try {
                    if (entry.getVersionableHandle().sameItemId((IItemHandle)root) && entry.getParent() != null && CopyFileAreaStore.this.metadata.getPathForShareRoot(entry.getVersionableHandle(), component, connection) == null) {
                        CopyFileAreaStore.this.updateParentInfoForRemoval(entry, component, connection, (IProgressMonitor)progress.newChild(1));
                    }
                    if (entry.getLocalName() != null) {
                        InverseFileItemInfo newInfo = new InverseFileItemInfo((IVersionableHandle)entry.getVersionableHandle().getItemType().createItemHandle(UUID.generate(), null), false, -1L, null, null, false, Collections.EMPTY_MAP, entry.getLocalParent(), entry.getLocalName(), null, -1L, null, entry.getLineDelimiter(), null, entry.getContentType(), null, -1L, null, null, -1L, entry.isExecutable(), false, entry.isDirectoryLink(), false, Collections.EMPTY_MAP, Collections.EMPTY_SET, MetadataProperties.getCurrentProperties(entry.getOriginalProperties(), entry.getChangedProperties(), entry.getRemovedProperties()), entry.getExternalLinks(), null);
                        IRelativeLocation localPath = CopyFileAreaStore.this.getLocalPathInternal(entry, component, connection);
                        if (entry.getVersionableHandle() instanceof IFolderHandle) {
                            CopyFileAreaStore.this.updateLocalParent(localPath, (IFolderHandle)newInfo.getVersionableHandle(), component, connection, (IProgressMonitor)progress.newChild(1));
                        }
                        CopyFileAreaStore.this.metadata.setFileItemInfo(localPath, newInfo);
                        CopyFileAreaStore.this.metadata.setFileItemInfo(newInfo.getVersionableHandle(), component, connection, newInfo, (IProgressMonitor)progress.newChild(1));
                    }
                    CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), component, connection, null, (IProgressMonitor)progress.newChild(1));
                    changed[0] = true;
                }
                catch (FileSystemException e) {
                    exceptions.add(e);
                }
                progress.done();
                return true;
            }
        }, root, component, connection, Integer.MAX_VALUE, true, monitor);
        return changed[0];
    }

    public void moveTreeInfo(IRelativeLocation sourcePath, IRelativeLocation destinationPath, boolean remoteMove, IProgressMonitor monitor) throws FileSystemException {
        this.assertReadLocked();
        RuleDescriptorPairForMove pair = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            pair = this.beginBatching(sourcePath, destinationPath, progress.newChild(1));
            ISharingDescriptor sourceDesc = pair.sourceDesc;
            ISharingDescriptor destDesc = pair.destDesc;
            if (destDesc == null) {
                throw new AssertionFailedException(NLS.bind((String)"No sharing descriptor found for path ''{0}''", (Object)destinationPath.toString()));
            }
            FileItemInfo destInfo = this.metadata.getFileItemInfo(destinationPath);
            if (destInfo != null && !sourcePath.sameLocation(destinationPath, this.metadata.isCaseSensitive())) {
                this.deleteTreeInfoInternal(destinationPath, sourceDesc.getComponent(), sourceDesc.getConnectionHandle(), false, (IProgressMonitor)progress.newChild(1));
            }
            if (this.sameWorkspaceComponent(sourceDesc, destDesc)) {
                this.moveSubtree(sourcePath, sourceDesc, destinationPath, remoteMove, (IProgressMonitor)progress.newChild(97));
            } else {
                this.moveSubtreeToWC(sourcePath, sourceDesc, destinationPath, destDesc, progress.newChild(97));
            }
        }
        finally {
            if (pair != null) {
                pair.endBatching(progress.newChild(1));
            }
            progress.done();
        }
    }

    private void moveSubtreeToWC(IRelativeLocation sourcePath, ISharingDescriptor sourceDesc, IRelativeLocation destinationPath, ISharingDescriptor destDesc, SubMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        FileItemInfo sourceFileItemInfo = this.metadata.getFileItemInfo(sourcePath);
        if (sourceFileItemInfo == null) {
            throw new AssertionFailedException("File item info expected but not found at source path " + sourcePath.toString());
        }
        IVersionableHandle sourceVersionable = sourceFileItemInfo.getVersionableHandle();
        FileItemInfo destFileItemInfo = this.metadata.getFileItemInfo(destinationPath);
        if (destFileItemInfo != null) {
            throw new AssertionFailedException("File item info found but not expected at destination path " + destinationPath.toString());
        }
        FileItemInfo destinationParentInfo = this.metadata.getFileItemInfo(destinationPath.getParent());
        if (destinationParentInfo == null) {
            throw new AssertionFailedException("File item info not found but expected for parent of destination path " + destinationPath.toString());
        }
        this.removeLocalInfoFromInverseMetadata(sourcePath, sourceDesc.getComponent(), sourceDesc.getConnectionHandle(), progress.newChild(25));
        this.assignNewUUIDsToRemoteSharesWithNoLocal(sourceVersionable, sourceDesc.getComponent(), sourceDesc.getConnectionHandle(), progress.newChild(20));
        this.moveInverseMetadataToNewWC(sourceVersionable, sourceDesc, (IFolderHandle)destinationParentInfo.getVersionableHandle(), destinationPath.getName(), destDesc, progress.newChild(20));
        InverseFileItemInfo sourceParentInfo = this.metadata.getFileItemInfo((IVersionableHandle)sourceFileItemInfo.getParent(), sourceDesc.getComponent(), sourceDesc.getConnectionHandle());
        this.metadata.setFileItemInfo((IVersionableHandle)sourceFileItemInfo.getParent(), sourceDesc.getComponent(), sourceDesc.getConnectionHandle(), sourceParentInfo.removeRemoteChild(sourcePath.getName()), (IProgressMonitor)progress.newChild(10));
        this.fixInverseMetadataForLocalItems(sourcePath, sourceDesc, (IFolderHandle)destinationParentInfo.getVersionableHandle(), destDesc, destinationPath.getName(), progress.newChild(25));
        if (!sourcePath.equals(destinationPath)) {
            this.metadata.moveFileItemInfo(sourcePath, destinationPath);
        }
        progress.done();
    }

    private void moveInverseMetadataToNewWC(final IVersionableHandle sourceRoot, final ISharingDescriptor sourceDesc, final IFolderHandle destinationParent, final String destinationName, final ISharingDescriptor destinationDesc, SubMonitor progress) throws FileSystemException {
        final ArrayList<FileSystemException> exceptions = new ArrayList<FileSystemException>();
        this.metadata.accept(new IRemoteVisitor(){

            @Override
            public boolean visit(InverseFileItemInfo entry, IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
                try {
                    String name;
                    IFolderHandle parentVersionable;
                    IVersionableHandle versionableHandle = entry.getVersionableHandle();
                    CopyFileAreaStore.this.metadata.setFileItemInfo(versionableHandle, sourceDesc.getComponent(), sourceDesc.getConnectionHandle(), null, (IProgressMonitor)progress.newChild(1));
                    if (sourceRoot.sameItemId((IItemHandle)entry.getVersionableHandle())) {
                        parentVersionable = destinationParent;
                        name = destinationName;
                    } else {
                        parentVersionable = entry.getParent();
                        name = entry.getName();
                    }
                    InverseFileItemInfo newFI = entry.forMoveToNewWC(parentVersionable, name);
                    InverseFileItemInfo oldFI = CopyFileAreaStore.this.metadata.setFileItemInfo(versionableHandle, destinationDesc.getComponent(), destinationDesc.getConnectionHandle(), newFI, (IProgressMonitor)progress.newChild(1));
                    if (oldFI == null) {
                        InverseFileItemInfo parentFI = CopyFileAreaStore.this.metadata.getFileItemInfo((IVersionableHandle)parentVersionable, destinationDesc.getComponent(), destinationDesc.getConnectionHandle());
                        if (parentFI.getRemoteChildren().containsKey(name)) {
                            int cnt = 0;
                            do {
                                name = String.valueOf(entry.getName()) + Integer.toString(cnt);
                                ++cnt;
                            } while (parentFI.getRemoteChildren().containsKey(name));
                            newFI = entry.forMoveToNewWC(parentVersionable, name);
                            CopyFileAreaStore.this.metadata.setFileItemInfo(versionableHandle, destinationDesc.getComponent(), destinationDesc.getConnectionHandle(), newFI, (IProgressMonitor)progress.newChild(1));
                        }
                        parentFI = parentFI.addRemoteChild(name, versionableHandle);
                        CopyFileAreaStore.this.metadata.setFileItemInfo(parentFI.getVersionableHandle(), destinationDesc.getComponent(), destinationDesc.getConnectionHandle(), parentFI, (IProgressMonitor)progress.newChild(1));
                    } else {
                        CopyFileAreaStore.this.metadata.setFileItemInfo(versionableHandle, destinationDesc.getComponent(), destinationDesc.getConnectionHandle(), oldFI, (IProgressMonitor)progress.newChild(2));
                    }
                }
                catch (FileSystemException e) {
                    exceptions.add(e);
                }
                progress.done();
                return true;
            }
        }, sourceRoot, sourceDesc.getComponent(), sourceDesc.getConnectionHandle(), Integer.MAX_VALUE, true, (IProgressMonitor)progress);
        this.handleExceptions(exceptions, Messages.CopyFileAreaStore_14);
    }

    private void fixInverseMetadataForLocalItems(final IRelativeLocation sourcePath, final ISharingDescriptor sourceDesc, final IFolderHandle destinationParent, final ISharingDescriptor destinationDesc, final String destinationName, SubMonitor progress) throws FileSystemException {
        final ArrayList<FileSystemException> exceptions = new ArrayList<FileSystemException>();
        this.metadata.accept(new IVisitor(){

            @Override
            public boolean visit(IRelativeLocation path, FileItemInfo entry, IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                try {
                    String name;
                    IFolderHandle parentHandle;
                    if (!entry.getVersionableHandle().hasStateId()) {
                        CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), sourceDesc.getComponent(), sourceDesc.getConnectionHandle(), null, (IProgressMonitor)progress.newChild(1));
                    }
                    InverseFileItemInfo inverse = CopyFileAreaStore.this.metadata.getFileItemInfo(entry.getVersionableHandle(), destinationDesc.getComponent(), destinationDesc.getConnectionHandle());
                    if (path.equals(sourcePath)) {
                        parentHandle = destinationParent;
                        name = destinationName;
                    } else {
                        FileItemInfo parentInfo = CopyFileAreaStore.this.metadata.getFileItemInfo(path.getParent());
                        parentHandle = (IFolderHandle)parentInfo.getVersionableHandle();
                        name = path.getName();
                    }
                    if (inverse == null) {
                        inverse = entry.createInverseFileItemInfoForLocalItem(parentHandle, name);
                        CopyFileAreaStore.this.metadata.setFileItemInfo(inverse.getVersionableHandle(), destinationDesc.getComponent(), destinationDesc.getConnectionHandle(), inverse, (IProgressMonitor)progress.newChild(1));
                    } else {
                        boolean modified;
                        long timeStamp;
                        if (inverse.isFolder()) {
                            timeStamp = -1L;
                            modified = false;
                        } else if (entry.getContentLength() == inverse.getContentLength() && inverse.getHash().equals((Object)entry.getHash())) {
                            timeStamp = entry.getLastContentChangeCheckStamp();
                            modified = entry.isContentChanged();
                        } else {
                            timeStamp = -1L;
                            modified = true;
                        }
                        inverse = inverse.updateLocalInfo(entry, modified, timeStamp, parentHandle, name);
                        CopyFileAreaStore.this.metadata.setFileItemInfo(path, inverse);
                        CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), destinationDesc.getComponent(), destinationDesc.getConnectionHandle(), inverse, (IProgressMonitor)progress.newChild(1));
                    }
                }
                catch (FileSystemException e) {
                    exceptions.add(e);
                }
                progress.done();
                return true;
            }
        }, sourcePath, Integer.MAX_VALUE, true, (IProgressMonitor)progress);
        this.handleExceptions(exceptions, Messages.CopyFileAreaStore_15);
    }

    private void moveSubtree(IRelativeLocation sourcePath, ISharingDescriptor sourceDesc, IRelativeLocation destinationPath, boolean remoteMove, IProgressMonitor monitor) throws FileSystemException {
        FileItemInfo info = this.metadata.getFileItemInfo(sourcePath);
        if (info != null) {
            String remoteName;
            IFolderHandle remoteParent;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            Assert.isTrue((!info.getVersionableHandle().sameItemId((IItemHandle)sourceDesc.getRootVersionable()) ? 1 : 0) != 0);
            FileItemInfo parentInfo = this.metadata.getFileItemInfo(destinationPath.getParent());
            IFolderHandle parent = (IFolderHandle)parentInfo.getVersionableHandle();
            String name = destinationPath.getName();
            if (remoteMove) {
                remoteParent = parent;
                remoteName = name;
            } else {
                remoteParent = info.getParent();
                remoteName = info.getName();
            }
            InverseFileItemInfo oldInverseInfo = this.metadata.getFileItemInfo(info.getVersionableHandle(), sourceDesc.getComponent(), sourceDesc.getConnectionHandle());
            InverseFileItemInfo newInfo = new InverseFileItemInfo(info.getVersionableHandle(), info.isContentChanged(), info.getLastContentChangeCheckStamp(), remoteParent, remoteName, info.isLoadedWithAnotherName(), oldInverseInfo.getRemoteChildren(), parent, name, info.getHash(), info.getContentLength(), info.getOriginalLineDelimiter(), info.getLineDelimiter(), info.getOriginalContentType(), info.getContentType(), info.getStoredPredecessorHintHash(), info.getStoredSize(), info.getStoredEncoding(), info.getStoredHash(), info.getStoredNumLineDelimiters(), info.isExecutable(), info.isOriginalExecutable(), info.isDirectoryLink(), info.isOriginalDirectoryLink(), oldInverseInfo.getOriginalProperties(), oldInverseInfo.getRemovedProperties(), oldInverseInfo.getChangedProperties(), info.getExternalLinks(), info.getOriginalExternalLinks());
            this.updateParentInfoForChange(newInfo, info, sourceDesc.getComponent(), sourceDesc.getConnectionHandle(), (IProgressMonitor)progress.newChild(1));
            this.metadata.setFileItemInfo(info.getVersionableHandle(), sourceDesc.getComponent(), sourceDesc.getConnectionHandle(), newInfo, (IProgressMonitor)progress.newChild(1));
            if (remoteMove) {
                this.metadata.setFileItemInfo(sourcePath, newInfo);
            }
        }
        this.metadata.moveFileItemInfo(sourcePath, destinationPath);
    }

    public ISharingMetadata internalGetMetadata() {
        return this.metadata;
    }

    public void close() throws FileSystemException {
        CopyFileAreaManager.instance.deregister(this.getRoot(), false, null);
    }

    void release(boolean eraseMetadata) throws FileSystemException {
        try {
            this.metadata.release(eraseMetadata);
        }
        finally {
            LocalChangeManager.getInstance().clearPendingChanges(this.getRoot());
        }
    }

    public void sync() throws FileSystemException {
        this.assertReadLocked();
        this.metadata.close();
    }

    public ILocation getRoot() {
        return this.path;
    }

    public boolean isCaseSensitive() {
        return this.metadata.isCaseSensitive();
    }

    public void setConfigurationState(IContextHandle connectionHandle, IComponentHandle component, ISyncTime beforeConfigurationState, ISyncTime configurationState, IProgressMonitor monitor) throws FileSystemException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connectionHandle, component), (IProgressMonitor)progress.newChild(1));
        try {
            Map<IRelativeLocation, ISharingDescriptor> sharingDescriptors = this.metadata.getSharingDescriptors(component, connectionHandle);
            SubMonitor subProgress = progress.newChild(98);
            subProgress.setWorkRemaining(sharingDescriptors.size());
            for (Map.Entry<IRelativeLocation, ISharingDescriptor> entry : sharingDescriptors.entrySet()) {
                ISharingDescriptor descriptor = entry.getValue();
                IRelativeLocation sharePath = entry.getKey();
                this.updateConfigurationState(sharePath, descriptor, beforeConfigurationState, configurationState, subProgress);
            }
            subProgress.done();
        }
        finally {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    private void updateConfigurationState(IRelativeLocation sharePath, ISharingDescriptor sharingDescriptor, ISyncTime beforeConfigurationState, ISyncTime configurationState, SubMonitor subProgress) throws FileSystemException {
        SharingDescriptor descriptor = (SharingDescriptor)sharingDescriptor;
        if (beforeConfigurationState == null || beforeConfigurationState.equals(descriptor.getConfigurationState())) {
            SharingDescriptor newDescriptor = new SharingDescriptor(descriptor, configurationState);
            this.metadata.setSharingDescriptor(sharePath, newDescriptor, (IProgressMonitor)subProgress.newChild(1));
            CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(newDescriptor.getRootVersionable(), this, sharePath, 6));
        } else if (configurationState.equals(descriptor.getConfigurationState())) {
            subProgress.worked(1);
        } else if (descriptor.isUnknownState()) {
            SharingDescriptor newDescriptor = new SharingDescriptor(descriptor, ISyncTime.TIME_NONE);
            this.metadata.setSharingDescriptor(sharePath, newDescriptor, (IProgressMonitor)subProgress.newChild(1));
            CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(newDescriptor.getRootVersionable(), this, sharePath, 6));
        }
    }

    public void setConfigurationState(IContextHandle connectionHandle, IComponentHandle component, IVersionableHandle shareRootItem, ISyncTime configurationState, IProgressMonitor monitor) throws FileSystemException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connectionHandle, component), (IProgressMonitor)progress.newChild(1));
        try {
            SharingDescriptor descriptor;
            IRelativeLocation sharePath = this.getLocalPathInternal(shareRootItem, component, connectionHandle);
            if (sharePath != null && (descriptor = (SharingDescriptor)this.metadata.getSharingDescriptor(sharePath)) != null && !configurationState.equals(descriptor.getConfigurationState())) {
                SharingDescriptor newDescriptor = new SharingDescriptor(descriptor, configurationState);
                this.metadata.setSharingDescriptor(sharePath, newDescriptor, (IProgressMonitor)progress.newChild(98));
                CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(newDescriptor.getRootVersionable(), this, sharePath, 6));
            }
            progress.setWorkRemaining(1);
        }
        finally {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    public void setConfigurationState(IContextHandle connectionHandle, IComponentHandle component, IRelativeLocation sharePath, ISyncTime beforeConfigurationState, ISyncTime configurationState, IProgressMonitor monitor) throws FileSystemException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connectionHandle, component), (IProgressMonitor)progress.newChild(1));
        try {
            ISharingDescriptor descriptor = this.metadata.getSharingDescriptor(sharePath);
            if (descriptor != null && descriptor.getComponent().sameItemId((IItemHandle)component) && descriptor.getConnectionHandle().sameItemId((IItemHandle)connectionHandle)) {
                this.updateConfigurationState(sharePath, descriptor, beforeConfigurationState, configurationState, progress.newChild(98));
            }
            progress.setWorkRemaining(1);
        }
        finally {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    public void setConfigurationState(IContextHandle connectionHandle, IComponentHandle component, IRelativeLocation sharePath, ISyncTime configurationState, IProgressMonitor monitor) throws FileSystemException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connectionHandle, component), (IProgressMonitor)progress.newChild(1));
        try {
            SharingDescriptor descriptor = (SharingDescriptor)this.metadata.getSharingDescriptor(sharePath);
            if (descriptor != null && descriptor.getComponent().sameItemId((IItemHandle)component) && descriptor.getConnectionHandle().sameItemId((IItemHandle)connectionHandle) && !configurationState.equals(descriptor.getConfigurationState())) {
                SharingDescriptor newDescriptor = new SharingDescriptor(descriptor, configurationState);
                this.metadata.setSharingDescriptor(sharePath, newDescriptor, (IProgressMonitor)progress.newChild(98));
                CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(newDescriptor.getRootVersionable(), this, sharePath, 6));
            }
            progress.setWorkRemaining(1);
        }
        finally {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    public void setUnknownConfigurationState(IContextHandle connectionHandle, IComponentHandle component, IRelativeLocation sharePath, IProgressMonitor monitor) throws FileSystemException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connectionHandle, component), (IProgressMonitor)progress.newChild(1));
        try {
            SharingDescriptor descriptor = (SharingDescriptor)this.metadata.getSharingDescriptor(sharePath);
            if (descriptor != null && descriptor.getComponent().sameItemId((IItemHandle)component) && descriptor.getConnectionHandle().sameItemId((IItemHandle)connectionHandle)) {
                SharingDescriptor newDescriptor = new SharingDescriptor(descriptor, ISyncTime.TIME_NONE);
                this.metadata.setSharingDescriptor(sharePath, newDescriptor, (IProgressMonitor)progress.newChild(98));
                CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(newDescriptor.getRootVersionable(), this, sharePath, 6));
            }
            progress.setWorkRemaining(1);
        }
        finally {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    public boolean isLoaded(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemException {
        this.assertReadLocked();
        return this.internalIsLoaded(component, connection, monitor);
    }

    boolean internalIsLoaded(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemException {
        return this.metadata.isLoaded(component, connection, monitor);
    }

    public Collection<LoadedConfigurationDescriptor> allLoadedComponents(IProgressMonitor monitor) throws FileSystemException {
        this.assertReadLocked();
        return this.internalAllLoadedComponents(monitor);
    }

    Collection<LoadedConfigurationDescriptor> internalAllLoadedComponents(IProgressMonitor monitor) throws FileSystemException {
        return this.metadata.allLoadedComponents(monitor);
    }

    public Collection<? extends IConfigurationDescriptor> allLoadedContexts(IProgressMonitor monitor) throws FileSystemException {
        this.assertReadLocked();
        return this.internalAllLoadedContexts(monitor);
    }

    Collection<? extends IConfigurationDescriptor> internalAllLoadedContexts(IProgressMonitor monitor) throws FileSystemException {
        return this.metadata.allLoadedComponents(monitor);
    }

    public void updateWorkspaceComponentState(long workspaceComponentState, boolean overwriteWithAfterStateIfBeforeStateIsUnknown, LoadedConfigurationDescriptor configurationDescriptor, IProgressMonitor monitor) throws FileSystemException {
        if (configurationDescriptor == null) {
            throw new IllegalArgumentException(Messages.CopyFileAreaUtil_ErrorUpdatingWorkspaceComponentStateInMetadata);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (configurationDescriptor.workspaceComponentState != -1L || overwriteWithAfterStateIfBeforeStateIsUnknown) {
            this.componentLoaded(new LoadedConfigurationDescriptor(configurationDescriptor.getRepositoryId(), configurationDescriptor.getConnectionHandle(), configurationDescriptor.connectionName, configurationDescriptor.getComponentHandle(), configurationDescriptor.componentName, workspaceComponentState), (IProgressMonitor)progress.newChild(100));
        } else {
            progress.done();
        }
    }

    public void componentLoaded(LoadedConfigurationDescriptor desc, IProgressMonitor monitor) throws FileSystemException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), desc.connectionHandle, desc.componentHandle), (IProgressMonitor)progress.newChild(1));
        try {
            boolean alreadyLoaded;
            boolean bl = alreadyLoaded = this.metadata.componentLoaded(desc, (IProgressMonitor)progress.newChild(98)) != null;
            if (!alreadyLoaded) {
                CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(null, this, null, 7));
            }
        }
        finally {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    public void componentUnloaded(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connection, component), (IProgressMonitor)progress.newChild(1));
        try {
            boolean wasLoaded;
            if (this.metadata.hasShares(component, connection, (IProgressMonitor)progress.newChild(49))) {
                throw new FileSystemException(Messages.CopyFileAreaStore_20);
            }
            boolean bl = wasLoaded = this.metadata.componentUnloaded(component, connection, (IProgressMonitor)progress.newChild(49)) != null;
            if (wasLoaded) {
                CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(null, this, null, 8));
            }
        }
        finally {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    public boolean isCorrupted() {
        this.assertReadLocked();
        return this.metadata.isCorrupted();
    }

    public int getNumShares(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemException {
        this.assertReadLocked();
        return this.internalGetNumShares(component, connection, monitor);
    }

    int internalGetNumShares(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        int result = this.metadata.getSharingDescriptors(component, connection).size();
        progress.done();
        return result;
    }

    public Map<IRelativeLocation, ISharingDescriptor> getShares(IContextHandle context, IComponentHandle component, IProgressMonitor monitor) throws FileSystemException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), context, component), (IProgressMonitor)progress.newChild(1));
        try {
            Map<IRelativeLocation, ISharingDescriptor> map = this.metadata.getSharingDescriptors(component, context);
            return map;
        }
        finally {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    private void handleExceptions(List<FileSystemException> exceptions, String message) throws FileSystemException {
        if (!exceptions.isEmpty()) {
            if (exceptions.size() == 1) {
                throw new FileSystemException(message, (Throwable)((Object)exceptions.get(0)));
            }
            MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", 0, message, null);
            for (FileSystemException ex : exceptions) {
                multi.add(FileSystemStatusUtil.getStatusFor((Throwable)((Object)ex)));
            }
            throw new FileSystemStatusException((IStatus)multi);
        }
    }

    public MetadataProperties setProperties(IContextHandle connection, IComponentHandle component, IVersionableHandle item, MetadataProperties properties, IProgressMonitor monitor) throws FileSystemException {
        MetadataProperties metadataProperties;
        SubMonitor progress;
        block3: {
            this.assertReadLocked();
            AbstractLock rule = null;
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connection, component), (IProgressMonitor)progress.newChild(1));
                InverseFileItemInfo info = this.getItemInfo(item, component, connection, true);
                InverseFileItemInfo newInfo = new InverseFileItemInfo(info.getVersionableHandle(), info.isContentChanged(), info.getLastContentChangeCheckStamp(), info.getParent(), info.getName(), info.isLoadedWithAnotherName(), info.getRemoteChildren(), info.getLocalParent(), info.getLocalName(), info.getHash(), info.getContentLength(), info.getOriginalLineDelimiter(), info.getLineDelimiter(), info.getOriginalContentType(), info.getContentType(), info.getStoredPredecessorHintHash(), info.getStoredSize(), info.getStoredEncoding(), info.getStoredHash(), info.getStoredNumLineDelimiters(), info.isExecutable(), info.isOriginalExecutable(), info.isDirectoryLink(), info.isOriginalDirectoryLink(), properties.getOriginalProperties(), properties.getRemovedProperties(), properties.getChangedProperties(), info.getExternalLinks(), info.getOriginalExternalLinks());
                this.metadata.setFileItemInfo(item, component, connection, newInfo, (IProgressMonitor)progress.newChild(1));
                metadataProperties = new MetadataProperties(info.getOriginalProperties(), info.getChangedProperties(), info.getRemovedProperties());
                if (rule == null) break block3;
            }
            catch (Throwable throwable) {
                if (rule != null) {
                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                progress.done();
                throw throwable;
            }
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return metadataProperties;
    }

    protected static class RuleDescriptorPair {
        protected AbstractLock rule;
        protected ISharingDescriptor desc;

        protected RuleDescriptorPair() {
        }
    }

    protected static class RuleDescriptorPairForMove {
        protected AbstractLock rule;
        protected ISharingDescriptor sourceDesc;
        protected ISharingDescriptor destDesc;

        protected RuleDescriptorPairForMove() {
        }

        protected void beginBatching(ILocation cfaRoot, ISharingDescriptor sourceDesc, ISharingDescriptor destDesc, SubMonitor monitor) {
            this.sourceDesc = sourceDesc;
            this.destDesc = destDesc;
            AbstractLock lock = sourceDesc == null && destDesc == null ? BatchingLock.NULL_SCHEDULING_RULE : (sourceDesc == null && destDesc != null ? new ComponentLock(cfaRoot, destDesc.getConnectionHandle(), destDesc.getComponent()) : (destDesc == null || this.sameWSC(sourceDesc, destDesc) ? new ComponentLock(cfaRoot, sourceDesc.getConnectionHandle(), sourceDesc.getComponent()) : MultiLock.combine(new ComponentLock(cfaRoot, sourceDesc.getConnectionHandle(), sourceDesc.getComponent()), new ComponentLock(cfaRoot, destDesc.getConnectionHandle(), destDesc.getComponent()))));
            this.rule = CopyFileAreaStore.beginBatching(lock, (IProgressMonitor)monitor);
        }

        protected boolean descriptorsInSameComponent(ISharingDescriptor currentSourceDesc, ISharingDescriptor currentDestDesc) {
            return this.sameWSC(this.sourceDesc, currentSourceDesc) && this.sameWSC(this.destDesc, currentDestDesc);
        }

        private boolean sameWSC(ISharingDescriptor desc1, ISharingDescriptor desc2) {
            if (desc1 == null) {
                return desc2 == null;
            }
            if (desc2 == null) {
                return false;
            }
            return desc1.getComponent().sameItemId((IItemHandle)desc2.getComponent()) && desc1.getConnectionHandle().sameItemId((IItemHandle)desc2.getConnectionHandle());
        }

        public void endBatching(SubMonitor monitor) throws FileSystemException {
            if (this.rule != null) {
                CopyFileAreaStore.endBatching(this.rule, (IProgressMonitor)monitor);
                this.rule = null;
            }
        }
    }
}

