/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFARemoveLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class CopyFileAreaRemovalLockRequest
extends CopyFileAreaLockRequest {
    private final Set<ILocation> cfaPaths;

    public CopyFileAreaRemovalLockRequest(Set<ILocation> cfas) {
        this.cfaPaths = cfas;
    }

    @Override
    public void addLocks(Set<? super AbstractLock> locks, IProgressMonitor monitor) throws FileSystemException {
        for (ILocation path : this.cfaPaths) {
            CFARemoveLock lock = new CFARemoveLock(path);
            locks.add(lock);
        }
    }

    @Override
    public boolean validateLocks(IProgressMonitor monitor) throws FileSystemException {
        for (ILocation path : this.cfaPaths) {
            if (CopyFileAreaManager.instance.batchingLock.isLocked(new CFARemoveLock(path))) continue;
            monitor.done();
            return false;
        }
        return true;
    }
}

