/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.BiPartitionLock;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.api.storage.AbstractSharingMetadata;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.BatchingLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFACreateLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFARemoveLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ComponentLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaEvent;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaLockRequestFactory;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaNotifier;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.copyfileareas.IFlushOperation;
import com.ibm.team.filesystem.client.internal.copyfileareas.ISharingMetadataFactory;
import com.ibm.team.filesystem.client.operations.IMetadataRepairOperation;
import com.ibm.team.filesystem.client.operations.IMetadataValidateOperation;
import com.ibm.team.filesystem.client.operations.MetadataRepairDilemmaHandler;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.internal.IConfigurationDescriptor;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class CopyFileAreaManager
implements ICopyFileAreaManager,
IFlushOperation<ICopyFileAreaEvent> {
    public static final CopyFileAreaManager instance = new CopyFileAreaManager();
    private static final String PT_METADATA_MANAGER = "sharingMetadataManager";
    private Map<String, ISharingMetadataFactory> sharingMetadataFactory;
    protected final BatchingLock batchingLock = new BatchingLock();
    protected final Map<ILocation, CopyFileArea> cfas = new ConcurrentHashMap<ILocation, CopyFileArea>();
    protected final CopyFileAreaNotifier notifier = new CopyFileAreaNotifier();
    protected final BiPartitionLock cfaListLock = new BiPartitionLock();
    protected final ListenerList corruptionListenerList = new ListenerList();

    private CopyFileAreaManager() {
    }

    private synchronized ISharingMetadataFactory getMetadataFactory(String storageId) {
        ISharingMetadataFactory factory;
        if (this.sharingMetadataFactory == null) {
            IConfigurationElement[] configs = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.filesystem.client", PT_METADATA_MANAGER);
            this.sharingMetadataFactory = new HashMap<String, ISharingMetadataFactory>(configs.length);
            IConfigurationElement[] iConfigurationElementArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    ISharingMetadataFactory factory2 = (ISharingMetadataFactory)element.createExecutableExtension("class");
                    String id = element.getAttribute("storageId");
                    if (this.sharingMetadataFactory.get(id) != null) {
                        LoggingHelper.log(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)"Trying to register metadata storage manager with id {0}, but storage manager already registered with this id, for storage type {1}", (Object)id, (Object)storageId), null));
                    } else {
                        this.sharingMetadataFactory.put(id, factory2);
                    }
                }
                catch (CoreException e) {
                    LoggingHelper.log(e);
                }
                ++n2;
            }
        }
        if ((factory = this.sharingMetadataFactory.get(storageId)) == null) {
            throw new IllegalStateException(NLS.bind((String)"Metadata storage manager for storage type {0} is not registered", (Object)storageId));
        }
        return factory;
    }

    @Override
    public void addCorruptionListener(ICorruptCopyFileAreaListener listener) {
        this.corruptionListenerList.add((Object)listener);
        for (CopyFileArea cfa : this.cfas.values()) {
            cfa.internalGetMetadata().addCorruptionListener(listener);
        }
    }

    @Override
    public void removeCorruptionListener(ICorruptCopyFileAreaListener listener) {
        this.corruptionListenerList.remove((Object)listener);
        for (CopyFileArea cfa : this.cfas.values()) {
            cfa.internalGetMetadata().removeCorruptionListener(listener);
        }
    }

    @Override
    public void addListener(ICopyFileAreaListener listener) {
        this.notifier.addGlobalListener(listener);
    }

    @Override
    public void removeListener(ICopyFileAreaListener listener) {
        this.notifier.removeGlobalListener(listener);
    }

    @Override
    public void flush(Collection<ICopyFileAreaEvent> events, IProgressMonitor monitor) throws FileSystemException {
        this.notifier.fireEvents(events.toArray(new ICopyFileAreaEvent[events.size()]));
    }

    public boolean isLocked(AbstractLock lock) {
        return this.batchingLock.isLocked(lock);
    }

    @Override
    public Object beginAvoidNotify() {
        return this.batchingLock.acquire(BatchingLock.AVOID_NOTIFICATION_RULE, this, BatchingLock.NULL_LOCK_PARTICIPANT, true, null);
    }

    @Override
    public void endAvoidNotify(Object beginNotifyToken, IProgressMonitor monitor) throws FileSystemException {
        this.batchingLock.release((AbstractLock)beginNotifyToken, monitor);
    }

    @Override
    public boolean copyFileAreaExists(ILocation root, int option) {
        if (option == 1) {
            return this.getMetadataFactory(root.getStorageId()).hasSharingMetadata(root);
        }
        if (option == 0) {
            if (this.cfas.containsKey(root)) {
                return true;
            }
            return this.cfas.containsKey(root.getCanonicalForm());
        }
        if (option == 2) {
            return this.getMetadataFactory(root.getStorageId()).hasAnySharingMetadata(root);
        }
        return false;
    }

    private ISharingMetadata createSharingMetadata(ILocation root) throws FileSystemException {
        Assert.isLegal((root != null ? 1 : 0) != 0);
        AbstractSharingMetadata md = this.getMetadataFactory(root.getStorageId()).getSharingMetadata(root);
        Object[] objectArray = this.corruptionListenerList.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            md.addCorruptionListener((ICorruptCopyFileAreaListener)listener);
            ++n2;
        }
        return md;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void createCopyFileAreas(Collection<ILocation> roots, IProgressMonitor monitor) throws FileSystemException {
        this.batchingLock.validateAcquire(CFACreateLock.INSTANCE);
        canonicalized = new ArrayList<ILocation>(roots.size());
        for (ILocation root : roots) {
            canonicalized.add(root.getCanonicalForm());
        }
        for (ILocation root : canonicalized) {
            for (ILocation root2 : canonicalized) {
                if (root.equals(root2) || !root.isPrefixOf(root2) && !root2.isPrefixOf(root)) continue;
                throw new IllegalArgumentException("Cannot nest passed CFAs " + root + " and " + root2);
            }
        }
        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        lock = this.batchingLock.acquire(CFACreateLock.INSTANCE, this, BatchingLock.NULL_LOCK_PARTICIPANT, true, (IProgressMonitor)progress.newChild(40));
        toAdd = new HashMap<ILocation, CopyFileArea>();
        try {
            this.cfaListLock.acquirePart1();
            try {
                block19: {
                    for (ILocation candidate : canonicalized) {
                        if (this.cfas.containsKey(candidate)) continue;
                        for (ILocation cfaRoot : this.cfas.keySet()) {
                            if (!cfaRoot.isPrefixOf(candidate) && !candidate.isPrefixOf(cfaRoot)) continue;
                            throw new FileSystemStatusException(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.CopyFileAreaManager_0, (Object)candidate, (Object)cfaRoot)));
                        }
                        if (this.copyFileAreaExists(candidate, 1)) continue;
                        toCheck = candidate.getParent();
                        while (!toCheck.isEmpty()) {
                            if (this.copyFileAreaExists(toCheck, 1)) {
                                throw new FileSystemStatusException(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.CopyFileAreaManager_1, (Object)candidate, (Object)toCheck)));
                            }
                            toCheck = toCheck.getParent();
                        }
                    }
                    completed = false;
                    try {
                        for (ILocation root : canonicalized) {
                            if (this.cfas.containsKey(root)) continue;
                            cfa = new CopyFileArea(root, this.createSharingMetadata(root));
                            toAdd.put(root, cfa);
                        }
                        completed = true;
                    }
                    finally {
                        if (completed) break block19;
                        ** for (entry : toAdd.entrySet())
                    }
lbl-1000:
                    // 1 sources

                    {
                        ((CopyFileArea)entry.getValue()).release(false);
                        continue;
                    }
                }
                this.cfas.putAll(toAdd);
            }
            finally {
                this.cfaListLock.releasePart1();
            }
            for (CopyFileArea cfa : toAdd.values()) {
                this.batchingLock.addChange(new CopyFileAreaEvent(null, cfa, null, 9));
                if (!CopyFileAreaManager.instance.requiresMigration(cfa.getRoot())) continue;
                cfa.internalGetMetadata().setCorrupt(true, "Metadata migration is required", null);
            }
        }
        finally {
            this.batchingLock.release(lock, (IProgressMonitor)progress.newChild(40));
        }
    }

    @Override
    public CopyFileArea createCopyFileArea(ILocation root, IProgressMonitor monitor) throws FileSystemException {
        this.batchingLock.validateAcquire(CFACreateLock.INSTANCE);
        CopyFileArea cfa = this.cfas.get(root);
        if (cfa != null) {
            return cfa;
        }
        cfa = this.cfas.get(root = root.getCanonicalForm());
        if (cfa != null) {
            return cfa;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = this.batchingLock.acquire(CFACreateLock.INSTANCE, this, BatchingLock.NULL_LOCK_PARTICIPANT, true, (IProgressMonitor)progress.newChild(40));
        try {
            root = root.getCanonicalForm();
            cfa = this.cfas.get(root);
            if (cfa != null) {
                CopyFileArea copyFileArea = cfa;
                return copyFileArea;
            }
            for (ILocation cfaRoot : this.cfas.keySet()) {
                if (!cfaRoot.isPrefixOf(root) && !root.isPrefixOf(cfaRoot)) continue;
                throw new FileSystemStatusException(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.CopyFileAreaManager_0, (Object)root, (Object)cfaRoot)));
            }
            if (!this.copyFileAreaExists(root, 1)) {
                ILocation toCheck = root.getParent();
                while (!toCheck.isEmpty()) {
                    if (this.copyFileAreaExists(toCheck, 1)) {
                        throw new FileSystemStatusException(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.CopyFileAreaManager_1, (Object)root, (Object)toCheck)));
                    }
                    toCheck = toCheck.getParent();
                }
            }
            cfa = new CopyFileArea(root, this.createSharingMetadata(root));
            this.cfaListLock.acquirePart1();
            try {
                this.cfas.put(root, cfa);
            }
            finally {
                this.cfaListLock.releasePart1();
            }
            this.batchingLock.addChange(new CopyFileAreaEvent(null, cfa, null, 9));
            if (instance.requiresMigration(root)) {
                cfa.internalGetMetadata().setCorrupt(true, "Metadata migration is required", null);
            }
        }
        finally {
            this.batchingLock.release(lock, (IProgressMonitor)progress.newChild(40));
        }
        return cfa;
    }

    @Override
    public void deregister(ILocation root, boolean eraseCopyFileArea, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!this.cfas.containsKey(root) && !this.cfas.containsKey(root = root.getCanonicalForm())) {
            if (eraseCopyFileArea) {
                this.createCopyFileArea(root, (IProgressMonitor)progress.newChild(1));
            } else {
                this.batchingLock.validateAcquire(new CFARemoveLock(root));
                return;
            }
        }
        AbstractLock lock = this.batchingLock.acquire(new CFARemoveLock(root), this, BatchingLock.NULL_LOCK_PARTICIPANT, true, (IProgressMonitor)progress.newChild(40));
        try {
            CopyFileArea cfa = this.cfas.get(root);
            if (cfa == null) {
                return;
            }
            this.cfaListLock.acquirePart1();
            try {
                try {
                    cfa.release(eraseCopyFileArea);
                }
                finally {
                    this.cfas.remove(root);
                }
            }
            finally {
                this.cfaListLock.releasePart1();
            }
            this.batchingLock.addChange(new CopyFileAreaEvent(null, cfa, null, 10));
        }
        finally {
            this.batchingLock.release(lock, (IProgressMonitor)progress.newChild(40));
        }
    }

    @Override
    public Collection<ICopyFileArea> getAllCopyFileAreas() {
        this.cfaListLock.acquirePart2();
        try {
            ArrayList<ICopyFileArea> arrayList = new ArrayList<ICopyFileArea>(this.cfas.values());
            return arrayList;
        }
        finally {
            this.cfaListLock.releasePart2();
        }
    }

    @Override
    public ICopyFileArea getCopyFileAreaForPath(ILocation location) {
        for (ICopyFileArea cfa : this.getAllCopyFileAreas()) {
            if (!cfa.getRoot().isPrefixOf(location)) continue;
            return cfa;
        }
        return null;
    }

    @Override
    public Collection<ICopyFileArea> getCopyFileAreasForConnection(IConnection connection, IProgressMonitor monitor) throws FileSystemException {
        ArrayList<ICopyFileArea> found;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        this.cfaListLock.acquirePart2();
        try {
            Collection<CopyFileArea> cfas = this.cfas.values();
            found = new ArrayList<ICopyFileArea>(cfas.size());
            progress.setWorkRemaining(cfas.size());
            block5: for (CopyFileArea cfa : cfas) {
                Collection<? extends IConfigurationDescriptor> configurationDescriptors;
                try {
                    configurationDescriptors = cfa.internalAllLoadedContexts((IProgressMonitor)progress.newChild(1));
                }
                catch (Exception exception) {
                    LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, "Exception reading metadata for " + cfa.getRoot(), exception));
                    continue;
                }
                for (IConfigurationDescriptor iConfigurationDescriptor : configurationDescriptors) {
                    if (!connection.getContextHandle().sameItemId((IItemHandle)iConfigurationDescriptor.getConnectionHandle())) continue;
                    found.add(cfa);
                    continue block5;
                }
            }
        }
        finally {
            this.cfaListLock.releasePart2();
        }
        progress.done();
        return found;
    }

    @Override
    public Collection<ICopyFileArea> getCopyFileAreasForConfiguration(IConfigurationDescriptor configuration, IProgressMonitor monitor) throws FileSystemException {
        ArrayList<ICopyFileArea> found;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        this.cfaListLock.acquirePart2();
        try {
            Collection<CopyFileArea> cfas = this.cfas.values();
            found = new ArrayList<ICopyFileArea>(cfas.size());
            progress.setWorkRemaining(cfas.size());
            for (CopyFileArea cfa : cfas) {
                try {
                    if (!cfa.internalIsLoaded(configuration.getComponentHandle(), configuration.getConnectionHandle(), (IProgressMonitor)progress.newChild(1))) continue;
                    found.add(cfa);
                }
                catch (Exception e) {
                    LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, "Exception while querying load state for " + cfa.getRoot(), e));
                }
            }
        }
        finally {
            this.cfaListLock.releasePart2();
        }
        progress.done();
        return found;
    }

    @Override
    public CopyFileArea getExistingCopyFileArea(ILocation root) {
        CopyFileArea cfa = this.cfas.get(root);
        if (cfa != null) {
            return cfa;
        }
        return this.cfas.get(root.getCanonicalForm());
    }

    @Override
    public int getNumShares(IContextHandle connection, IComponentHandle component, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        int cnt = 0;
        this.cfaListLock.acquirePart2();
        try {
            Collection<CopyFileArea> cfas = this.cfas.values();
            progress.setWorkRemaining(cfas.size());
            for (CopyFileArea cfa : cfas) {
                try {
                    cnt += cfa.internalGetNumShares(component, connection, (IProgressMonitor)progress.newChild(1));
                }
                catch (Exception e) {
                    LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, "Exception reading metadata for " + cfa.getRoot(), e));
                }
            }
        }
        finally {
            this.cfaListLock.releasePart2();
        }
        progress.done();
        return cnt;
    }

    @Override
    public AbstractLock getSchedulingRule(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        IShare share = shareable.getShare(monitor);
        if (share != null) {
            ISharingDescriptor desc = share.getSharingDescriptor();
            return new ComponentLock(shareable.getSandbox().getRoot(), desc.getConnectionHandle(), desc.getComponent());
        }
        return null;
    }

    @Override
    public boolean isConnectionShared(IContextHandle connection) throws FileSystemException {
        this.cfaListLock.acquirePart2();
        try {
            Collection<CopyFileArea> cfas = this.cfas.values();
            for (CopyFileArea cfa : cfas) {
                try {
                    if (!cfa.internalIsConnectionShared(connection)) continue;
                    return true;
                }
                catch (Exception e) {
                    LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, "Exception reading metadata for " + cfa.getRoot(), e));
                }
            }
        }
        finally {
            this.cfaListLock.releasePart2();
        }
        return false;
    }

    @Override
    public CopyFileAreasLock lock(Collection<ICopyFileAreaLockRequest> locksToObtain, IProgressMonitor progress) throws FileSystemException {
        CopyFileAreasLock lock = new CopyFileAreasLock(locksToObtain);
        lock.acquire(progress);
        return lock;
    }

    @Override
    public CopyFileAreaLockRequestFactory lockRequestFactory() {
        return CopyFileAreaLockRequestFactory.instance;
    }

    public void internalClear() throws FileSystemException {
        this.waitForJobs(30000L);
        AbstractLock lock = this.batchingLock.acquire(GlobalLock.INSTANCE, this, BatchingLock.NULL_LOCK_PARTICIPANT, true, null);
        try {
            this.cfaListLock.acquirePart1();
            try {
                for (CopyFileArea cfa : this.cfas.values()) {
                    cfa.release(true);
                }
                this.cfas.clear();
            }
            finally {
                this.cfaListLock.releasePart1();
            }
        }
        finally {
            this.batchingLock.release(lock, null);
        }
    }

    @Override
    public void shutdown(IProgressMonitor monitor) throws FileSystemException {
        this.waitForJobs(300000L);
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = this.batchingLock.acquire(GlobalLock.INSTANCE, this, BatchingLock.NULL_LOCK_PARTICIPANT, true, (IProgressMonitor)progress.newChild(10));
        try {
            SubMonitor subProgress = progress.newChild(80);
            this.cfaListLock.acquirePart1();
            try {
                subProgress.setWorkRemaining(this.cfas.size());
                for (CopyFileArea cfa : this.cfas.values()) {
                    try {
                        this.deregister(cfa.getRoot(), false, (IProgressMonitor)subProgress.newChild(1));
                    }
                    catch (Exception e) {
                        errors.add(FileSystemStatusUtil.getStatusFor(e));
                    }
                }
                this.notifier.shutdown();
                subProgress.done();
            }
            finally {
                this.cfaListLock.releasePart1();
            }
        }
        finally {
            this.batchingLock.release(lock, (IProgressMonitor)progress.newChild(10));
        }
        int size = errors.size();
        if (size != 0) {
            throw new FileSystemStatusException((IStatus)new MultiStatus("com.ibm.team.filesystem.client", 0, errors.toArray(new IStatus[size]), Messages.SharingManager_2, null));
        }
    }

    private void waitForJobs(long waitTimeInMillis) {
        try {
            boolean needWait = true;
            long start = System.currentTimeMillis();
            while (needWait) {
                Job[] jobs;
                needWait = false;
                Job[] jobArray = jobs = Job.getJobManager().find((Object)this);
                int n = jobs.length;
                int n2 = 0;
                while (n2 < n) {
                    Job job = jobArray[n2];
                    if (job.belongsTo((Object)this) && job.getState() != 0) {
                        if (System.currentTimeMillis() - start > waitTimeInMillis) {
                            LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)"Job {0} has been in state {1} for too long", (Object)job.getName(), (Object)job.getState()), null));
                            return;
                        }
                        needWait = true;
                        break;
                    }
                    ++n2;
                }
                if (!needWait) continue;
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean hasOldMetaDataFolder(ILocation cfaRoot) {
        return this.getMetadataFactory(cfaRoot.getStorageId()).hasOldSharingMetadata(cfaRoot);
    }

    public boolean hasInterumMetadataFolder(ILocation cfaRoot) {
        return this.getMetadataFactory(cfaRoot.getStorageId()).hasInterumSharingMetadata(cfaRoot);
    }

    public boolean requiresMigration(ILocation root) {
        return this.hasOldMetaDataFolder(root) || this.hasInterumMetadataFolder(root);
    }

    @Override
    public IMetadataRepairOperation getMetadataRepairOperation(ILocation root, MetadataRepairDilemmaHandler dilemmaHandler, IRepositoryResolver resolver) {
        return this.getMetadataFactory(root.getStorageId()).getMetadataRepairOperation(root, dilemmaHandler, resolver);
    }

    public IMetadataValidateOperation getMetadataValidateOperation(ILocation root) {
        return this.getMetadataFactory(root.getStorageId()).getMetadataValidateOperation(root);
    }

    @Override
    public void sendSandboxListeningEvent(boolean listeningEnabled) {
        int reason = listeningEnabled ? 11 : 12;
        this.notifier.fireEvents(new ICopyFileAreaEvent[]{new CopyFileAreaEvent(reason)});
    }

    public void waitForAllEventsToFire() throws InterruptedException {
        this.notifier.waitForAllEventsToFire();
    }

    public void enableEventTracing() {
        CopyFileAreaEvent.TRACE = true;
    }

    public void disableEventTracing() {
        CopyFileAreaEvent.TRACE = false;
    }
}

