/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LinkInfo;
import com.ibm.team.filesystem.client.internal.LinkType;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataProperties;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.ComponentLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ILockParticipant;
import com.ibm.team.filesystem.client.internal.copyfileareas.MultiLock;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.NonCancellingProgressMonitor;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.ContentHashAlgorithmException;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class CopyFileArea
extends CopyFileAreaStore
implements ICopyFileArea {
    protected CopyFileArea(ILocation path, ISharingMetadata metadataStore) {
        super(path, metadataStore);
    }

    @Override
    public Collection<IShare> allShares() throws FileSystemException {
        this.assertReadLocked();
        ArrayList<IShare> result = new ArrayList<IShare>();
        Map<IRelativeLocation, ISharingDescriptor> shareInfo = this.metadata.getSharingDescriptors();
        for (Map.Entry<IRelativeLocation, ISharingDescriptor> entry : shareInfo.entrySet()) {
            result.add(new Share(this.path, entry.getKey(), this.isCaseSensitive(), entry.getValue()));
        }
        return result;
    }

    @Override
    public Collection<IShare> allShares(IContextHandle connection, IComponentHandle component, IProgressMonitor monitor) throws FileSystemException {
        Map<IRelativeLocation, ISharingDescriptor> shareInfo = super.getShares(connection, component, monitor);
        ArrayList<IShare> result = new ArrayList<IShare>(shareInfo.size());
        for (Map.Entry<IRelativeLocation, ISharingDescriptor> entry : shareInfo.entrySet()) {
            result.add(new Share(this.path, entry.getKey(), this.isCaseSensitive(), entry.getValue()));
        }
        return result;
    }

    @Override
    public boolean forget(IRelativeLocation shareablePath, IProgressMonitor monitor) throws FileSystemException {
        return this.forget(shareablePath, false, monitor);
    }

    @Override
    public boolean forgetShares(IRelativeLocation shareablePath, IProgressMonitor monitor) throws FileSystemException {
        return this.forget(shareablePath, true, monitor);
    }

    private boolean forget(IRelativeLocation shareablePath, boolean sharesOnly, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.createAndLockForReading(this.getRoot(), true, (IProgressMonitor)progress.newChild(1));
        try {
            Collection<IRelativeLocation> allSharePaths = this.allSharePaths(shareablePath);
            int size = allSharePaths.size();
            if (size == 0) {
                if (sharesOnly) {
                    return false;
                }
                boolean bl = this.internalForget(shareablePath, (IProgressMonitor)progress.newChild(98));
                return bl;
            }
            progress.setWorkRemaining(size + 2);
            ArrayList<IRelativeLocation> allShareRoots = new ArrayList<IRelativeLocation>();
            allShareRoots.addAll(allSharePaths);
            if (!sharesOnly && !allShareRoots.contains(shareablePath)) {
                allShareRoots.add(shareablePath);
            }
            Collections.sort(allShareRoots, new Comparator<IRelativeLocation>(){

                @Override
                public int compare(IRelativeLocation location1, IRelativeLocation location2) {
                    return location2.segmentCount() - location1.segmentCount();
                }
            });
            boolean unshare = false;
            for (IRelativeLocation location : allShareRoots) {
                unshare |= this.internalForget(location, (IProgressMonitor)progress.newChild(1));
            }
            boolean bl = unshare;
            return bl;
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
        }
    }

    private boolean internalForget(IRelativeLocation shareablePath, IProgressMonitor monitor) throws FileSystemException {
        this.assertReadLocked();
        boolean unshare = true;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileAreaStore.RuleDescriptorPair pair = this.beginBatching(shareablePath, (IProgressMonitor)progress.newChild(1));
        try {
            if (pair.desc == null) {
                throw new IllegalArgumentException();
            }
            SubMonitor uncancelableProgress = SubMonitor.convert((IProgressMonitor)new NonCancellingProgressMonitor((IProgressMonitor)progress.newChild(98)), (int)98);
            if (this.metadata.getSharingDescriptor(shareablePath) == null) {
                unshare = false;
                uncancelableProgress.setWorkRemaining(49);
            }
            this.deleteTreeInfo(shareablePath, true, (IProgressMonitor)uncancelableProgress.newChild(49));
            if (unshare) {
                this.removeSharingInfo(shareablePath, (IProgressMonitor)uncancelableProgress.newChild(49));
            }
        }
        finally {
            CopyFileArea.endBatching(pair.rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return unshare;
    }

    @Override
    public boolean forget(IContextHandle connectionHandle, IComponentHandle component, IVersionableHandle item, IProgressMonitor monitor) throws FileSystemException {
        boolean unshare = true;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CopyFileArea.beginBatching(new ComponentLock(this.getRoot(), connectionHandle, component), (IProgressMonitor)progress.newChild(1));
        try {
            InverseFileItemInfo info;
            if (!this.isShareRoot(item, component, connectionHandle)) {
                unshare = false;
                progress.setWorkRemaining(50);
            }
            if ((info = this.getItemInfo(item, component, connectionHandle, false)) != null) {
                this.deleteTreeInfo(item, component, connectionHandle, (IProgressMonitor)progress.newChild(49));
            }
            if (unshare) {
                this.removeSharingInfo(connectionHandle, component, item, (IProgressMonitor)progress.newChild(49));
            }
        }
        finally {
            CopyFileArea.endBatching(lock, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return unshare;
    }

    @Override
    public Share getShare(IRelativeLocation path) {
        this.assertReadLocked();
        try {
            ISharingMetadata.ISharingDescriptorPath dp = this.metadata.findSharingDescriptorPath(path);
            if (dp != null) {
                return new Share(this.getRoot(), dp.getPath(), this.isCaseSensitive(), dp.getDescriptor());
            }
        }
        catch (FileSystemException e) {
            LoggingHelper.log("com.ibm.team.filesystem.client", e);
        }
        return null;
    }

    @Override
    public IShare getShare(IContextHandle connection, IComponentHandle component, IVersionableHandle versionable, IProgressMonitor monitor) throws FileSystemException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CopyFileArea.beginBatching(new ComponentLock(this.getRoot(), connection, component), (IProgressMonitor)progress.newChild(1));
        try {
            ISharingDescriptor descriptor;
            while (!this.isShareRoot(versionable, component, connection)) {
                InverseFileItemInfo info = this.getItemInfo(versionable, component, connection, false);
                if (info == null) {
                    return null;
                }
                versionable = info.getLocalParent();
                if (versionable != null) continue;
                versionable = info.getParent();
            }
            IRelativeLocation sharePath = this.getLocalPathFor(connection, component, versionable, (IProgressMonitor)progress.newChild(98));
            if (sharePath != null && (descriptor = this.getSharingInfo(sharePath)) != null) {
                Share share = new Share(this.getRoot(), sharePath, this.isCaseSensitive(), descriptor);
                return share;
            }
            return null;
        }
        finally {
            CopyFileArea.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    @Override
    public void syncMetaData() throws FileSystemException {
        this.sync();
    }

    @Override
    public IRelativeLocation getLocalPathFor(IContextHandle connection, IComponentHandle component, IVersionableHandle versionable, IProgressMonitor monitor) throws FileSystemException {
        return this.getLocalPathFor(versionable, component, connection, monitor);
    }

    @Override
    public IRelativeLocation getRemotePathFor(IContextHandle connectionHandle, IComponentHandle component, IVersionableHandle versionable, IProgressMonitor monitor) throws FileSystemException {
        return super.getRemotePathFor(versionable, component, connectionHandle, monitor);
    }

    @Override
    public Collection<IRelativeLocation> getLocalPathsFor(IComponentHandle component, IVersionableHandle versionable, IProgressMonitor monitor) throws FileSystemException {
        return this.getLocalItemPaths(versionable, component, monitor);
    }

    @Override
    public Collection<IRelativeLocation> getLocalPathsFor(IVersionableHandle versionable, IProgressMonitor monitor) throws FileSystemException {
        return this.getLocalItemPaths(versionable, monitor);
    }

    @Override
    public void share(final IRelativeLocation sharePath, final ISharingDescriptor sharingDescriptor, FileItemInfo fileItemInfo, ICopyFileArea.PropertyUpdate updateType, MetadataProperties properties, int options, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)102);
        final ISharingDescriptor[] oldInfo = new ISharingDescriptor[1];
        final FileSystemException[] exception = new FileSystemException[1];
        AbstractLock lock = null;
        try {
            lock = CopyFileArea.beginBatchingWithLock(null, new ILockParticipant(){

                @Override
                public AbstractLock locking(AbstractLock rule) {
                    CopyFileArea.this.sharingInfoLock.lock();
                    try {
                        oldInfo[0] = CopyFileArea.this.metadata.findSharingDescriptor(sharePath);
                        rule = oldInfo[0] != null ? MultiLock.combine(new ComponentLock(CopyFileArea.this.getRoot(), sharingDescriptor.getConnectionHandle(), sharingDescriptor.getComponent()), new ComponentLock(CopyFileArea.this.getRoot(), oldInfo[0].getConnectionHandle(), oldInfo[0].getComponent())) : new ComponentLock(CopyFileArea.this.getRoot(), sharingDescriptor.getConnectionHandle(), sharingDescriptor.getComponent());
                        return rule;
                    }
                    catch (FileSystemException e) {
                        exception[0] = e;
                        return null;
                    }
                }

                @Override
                public void waiting() {
                    CopyFileArea.this.sharingInfoLock.unlock();
                }
            }, (IProgressMonitor)progress.newChild(1));
            if (exception[0] != null) {
                throw exception[0];
            }
            if (oldInfo[0] != null) {
                if ((options & 1) == 1) {
                    if (fileItemInfo != null) {
                        progress.setWorkRemaining(151);
                    }
                    this.forget(sharePath, (IProgressMonitor)progress.newChild(50));
                } else if ((options & 2) != 2) {
                    throw new FileSystemException(NLS.bind((String)Messages.CopyFileArea_0, (Object)sharePath, (Object[])new Object[0]));
                }
            }
            if (fileItemInfo == null) {
                progress.setWorkRemaining(51);
            }
            this.setSharingInfo(sharePath, sharingDescriptor, (IProgressMonitor)progress.newChild(50));
            if (fileItemInfo != null) {
                this.setItemInfo(sharePath, fileItemInfo, updateType, properties, (IProgressMonitor)progress.newChild(50));
            }
        }
        catch (Throwable throwable) {
            this.sharingInfoLock.unlock();
            if (lock != null) {
                CopyFileArea.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            }
            throw throwable;
        }
        this.sharingInfoLock.unlock();
        if (lock != null) {
            CopyFileArea.endBatching(lock, (IProgressMonitor)progress.newChild(1));
        }
    }

    @Override
    public void setItemMetaData(IRelativeLocation shareablePath, FileItemInfo info, ICopyFileArea.PropertyUpdate updateType, MetadataProperties updateProperties, IProgressMonitor monitor) throws FileSystemException {
        if (updateType == ICopyFileArea.PropertyUpdate.PRESERVE && updateProperties != null) {
            throw new IllegalArgumentException();
        }
        if (updateType == ICopyFileArea.PropertyUpdate.CANCEL_CHANGES && updateProperties != null) {
            throw new IllegalArgumentException();
        }
        if (updateType == ICopyFileArea.PropertyUpdate.REPLACE && updateProperties == null) {
            throw new IllegalArgumentException();
        }
        if (updateType == ICopyFileArea.PropertyUpdate.REPLACE_DELTA && updateProperties == null) {
            throw new IllegalArgumentException();
        }
        if (updateType == ICopyFileArea.PropertyUpdate.REPLACE_ORIGINAL && updateProperties == null) {
            throw new IllegalArgumentException();
        }
        this.setItemInfo(shareablePath, info, updateType, updateProperties, monitor);
    }

    @Override
    public void setItemMetaData(IContextHandle connectionHandle, IComponentHandle component, FileItemInfo info, ICopyFileArea.PropertyUpdate updateType, MetadataProperties updateProperties, IProgressMonitor monitor) throws FileSystemException {
        if (updateType == ICopyFileArea.PropertyUpdate.PRESERVE && updateProperties != null) {
            throw new IllegalArgumentException();
        }
        if (updateType == ICopyFileArea.PropertyUpdate.CANCEL_CHANGES && updateProperties != null) {
            throw new IllegalArgumentException();
        }
        if (updateType == ICopyFileArea.PropertyUpdate.REPLACE && updateProperties == null) {
            throw new IllegalArgumentException();
        }
        if (updateType == ICopyFileArea.PropertyUpdate.REPLACE_DELTA && updateProperties == null) {
            throw new IllegalArgumentException();
        }
        if (updateType == ICopyFileArea.PropertyUpdate.REPLACE_ORIGINAL && updateProperties == null) {
            throw new IllegalArgumentException();
        }
        this.setItemInfo(info.getVersionableHandle(), component, connectionHandle, info, updateType, updateProperties, monitor);
    }

    @Override
    public void moveInfo(IRelativeLocation sourcePath, IRelativeLocation destinationPath, boolean remoteMove, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileAreaStore.RuleDescriptorPair pair = this.beginBatching(sourcePath, (IProgressMonitor)progress.newChild(1));
        try {
            if (pair.desc == null) {
                throw new IllegalArgumentException();
            }
            if (this.getSharingInfo(sourcePath) != null) {
                this.moveSharingInfo(sourcePath, destinationPath, monitor);
            } else {
                this.moveTreeInfo(sourcePath, destinationPath, remoteMove, monitor);
            }
        }
        finally {
            CopyFileArea.endBatching(pair.rule, (IProgressMonitor)progress.newChild(1));
        }
    }

    @Override
    public boolean isConfigurationShared(IContextHandle connection, IComponentHandle component, IProgressMonitor progress) throws FileSystemException {
        return this.isLoaded(component, connection, progress);
    }

    @Override
    public Collection<LoadedConfigurationDescriptor> allLoadedConfigurations(IProgressMonitor monitor) throws FileSystemException {
        return this.allLoadedComponents(monitor);
    }

    @Override
    public void makePendingDeletion(IRelativeLocation shareablePath, IProgressMonitor monitor) throws FileSystemException {
        this.deleteTreeInfo(shareablePath, false, monitor);
    }

    /*
     * Exception decompiling
     */
    public void trackFileAddition(IFolderHandle targetParent, IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[CATCHBLOCK]], but top level block is 19[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void trackFolderAddition(IFolderHandle targetParent, IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        FileItemInfo targetInfo;
        Assert.isNotNull((Object)shareable, (String)Messages.LocalChangeTracker_7);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IRelativeLocation path = shareable.getLocalPath();
        if (targetParent == null) {
            IShare share = shareable.getShare((IProgressMonitor)progress.newChild(50));
            ISharingDescriptor desc = share.getSharingDescriptor();
            Assert.isTrue((boolean)(desc.getRootVersionable() instanceof IFolderHandle));
            Assert.isTrue((boolean)share.getPath().equals(path));
            targetInfo = this.getItemInfo(desc.getRootVersionable(), desc.getComponent(), desc.getConnectionHandle(), false);
            if (targetInfo == null) {
                targetInfo = new FileItemInfo((IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(desc.getRootVersionable().getItemId(), null), null, null, false);
            }
        } else {
            IShare share = shareable.getShare((IProgressMonitor)progress.newChild(50));
            targetInfo = this.getDeletedItem(targetParent, path.getName(), share.getSharingDescriptor().getComponent(), share.getSharingDescriptor().getConnectionHandle(), (IProgressMonitor)progress.newChild(50));
            if (targetInfo == null || targetInfo.getVersionableHandle().getItemType() != IFolder.ITEM_TYPE) {
                targetInfo = null;
            }
        }
        if (targetInfo == null) {
            targetInfo = new FileItemInfo((IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(UUID.generate(), null), null, null, false);
        }
        progress.setWorkRemaining(50);
        this.setItemMetaData(path, targetInfo, ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)progress.newChild(50));
        progress.done();
    }

    public void trackSymbolicLinkAddition(IFolderHandle targetParent, IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        IFileStorage storage;
        LinkInfo linkInfo;
        FileItemInfo targetInfo;
        IShare share;
        Assert.isNotNull((Object)shareable, (String)Messages.LocalChangeTracker_7);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IRelativeLocation path = shareable.getLocalPath();
        if (targetParent == null) {
            share = shareable.getShare((IProgressMonitor)progress.newChild(15));
            ISharingDescriptor desc = share.getSharingDescriptor();
            Assert.isTrue((boolean)(desc.getRootVersionable() instanceof ISymbolicLinkHandle));
            Assert.isTrue((boolean)share.getPath().equals(path));
            targetInfo = this.getItemInfo(desc.getRootVersionable(), desc.getComponent(), desc.getConnectionHandle(), false);
            if (targetInfo == null) {
                targetInfo = new FileItemInfo((ISymbolicLinkHandle)ISymbolicLink.ITEM_TYPE.createItemHandle(desc.getRootVersionable().getItemId(), null), false, null, null, false, null, null, false, false);
            }
        } else {
            share = shareable.getShare((IProgressMonitor)progress.newChild(15));
            targetInfo = this.getDeletedItem(targetParent, path.getName(), share.getSharingDescriptor().getComponent(), share.getSharingDescriptor().getConnectionHandle(), (IProgressMonitor)progress.newChild(25));
            if (targetInfo != null && targetInfo.getVersionableHandle().getItemType() != ISymbolicLink.ITEM_TYPE) {
                targetInfo = null;
            }
        }
        if ((linkInfo = (storage = ((Shareable)shareable).getFileStorage()).getLinkInfo((IProgressMonitor)progress.newChild(1))).getType() == LinkType.NONE && storage.isDirectory((IProgressMonitor)progress.newChild(1))) {
            linkInfo = new LinkInfo(linkInfo.getTarget(), LinkType.DIRECTORY);
        }
        if (targetInfo == null) {
            boolean directoryLink = LinkType.DIRECTORY == linkInfo.getType();
            targetInfo = new FileItemInfo((ISymbolicLinkHandle)ISymbolicLink.ITEM_TYPE.createItemHandle(UUID.generate(), null), false, null, null, false, null, null, directoryLink, false);
        } else if (targetInfo.getHash() != null) {
            boolean directoryLink = LinkType.NONE == linkInfo.getType() ? targetInfo.isDirectoryLink() : LinkType.DIRECTORY == linkInfo.getType();
            boolean contentChanged = CopyFileArea.contentChanged(targetInfo, linkInfo);
            targetInfo = new FileItemInfo((ISymbolicLinkHandle)targetInfo.getVersionableHandle(), contentChanged, targetInfo.getParent(), targetInfo.getName(), targetInfo.isLoadedWithAnotherName(), targetInfo.getHash(), targetInfo.getStoredHash(), directoryLink, targetInfo.isOriginalDirectoryLink());
        }
        progress.setWorkRemaining(50);
        this.setItemMetaData(path, targetInfo, ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)progress.newChild(50));
        progress.done();
    }

    public static boolean contentChanged(FileItemInfo targetInfo, LinkInfo localTargetInfo, IProgressMonitor progress) {
        if (targetInfo.getHash() == null) {
            return false;
        }
        return CopyFileArea.contentChanged(targetInfo, localTargetInfo);
    }

    public static boolean contentChanged(FileItemInfo targetInfo, LinkInfo storageTargetInfo) {
        block6: {
            block5: {
                if (storageTargetInfo != null) break block5;
                return true;
            }
            if (targetInfo.getHash() != null) break block6;
            return false;
        }
        try {
            return !CopyFileArea.getLinkHash(storageTargetInfo.getTarget()).equals((Object)targetInfo.getHash());
        }
        catch (ContentHashAlgorithmException e) {
            return true;
        }
        catch (IOException e) {
            return true;
        }
    }

    public static ContentHash getLinkHash(String linkTarget) throws ContentHashAlgorithmException, IOException {
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(linkTarget.getBytes("UTF-8"));
            ContentHash newHash = ContentHash.valueOf((InputStream)in);
            ((InputStream)in).close();
            in = null;
            ContentHash contentHash = newHash;
            return contentHash;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {
                }
                catch (RuntimeException runtimeException) {}
            }
        }
    }

    public InverseFileItemInfo getItemInfo(IContextHandle connectionHandle, IComponentHandle component, IVersionableHandle item, boolean mustBePresent) {
        return super.getItemInfo(item, component, connectionHandle, mustBePresent);
    }

    @Override
    public Date getLastSandboxListenerEvent() throws FileSystemException {
        return this.metadata.getLastSandboxListenerEvent();
    }

    @Override
    public void markSandboxListenerEvent(Date d) throws FileSystemException {
        this.metadata.markSandboxListenerEvent(d);
    }

    @Override
    public void unloadComponentIfNoShares(IComponentHandle component, IContextHandle connectionHandle, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (!this.metadata.hasShares(component, connectionHandle, (IProgressMonitor)progress.newChild(50))) {
                LocalChangeManager.getInstance().clearPendingChanges(connectionHandle, component, this.getRoot());
                this.metadata.componentUnloaded(component, connectionHandle, (IProgressMonitor)progress.newChild(50));
            }
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
    }
}

