/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.BatchingLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFAReadLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFARemoveLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ComponentLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalCFALock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.MultiLock;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public final class CFALockUtil {
    public static final Comparator<IRelativeLocation> RelativeLocationComparator = new Comparator<IRelativeLocation>(){

        @Override
        public int compare(IRelativeLocation location1, IRelativeLocation location2) {
            return location1.segmentCount() - location2.segmentCount();
        }
    };
    public static final int LOCK_OBTAINED = 0;
    public static final int PATH_NOT_MANAGED = 1;
    public static final int LOCK_HELD_BY_ANOTHER_THREAD = 2;
    public static final int LOCK_REQUEST_CANCELED = 3;
    public static final int LOCK_REQUEST_FAILED = 4;

    private CFALockUtil() {
    }

    public static boolean isLocked(AbstractLock lock) {
        return CopyFileAreaManager.instance.isLocked(lock);
    }

    public static boolean isLockedForUpdate(ILocation cfaRoot, IComponentHandle component, IContextHandle connection) {
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        if (cfa == null) {
            return false;
        }
        return CFALockUtil.isLocked(new ComponentLock(cfa.getRoot(), connection, component));
    }

    public static AbstractLock lockExistingForUpdate(ILocation cfaRoot, IRelativeLocation rootRelativePath, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.lockExistingForRead(cfaRoot, (IProgressMonitor)progress.newChild(20));
        if (lock == null) {
            progress.done();
            return null;
        }
        boolean success = false;
        try {
            CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
            ISharingDescriptor desc = cfa.findSharingDescriptor(rootRelativePath);
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            success = true;
            if (desc == null) {
                progress.done();
                return null;
            }
            ILocation rootPath = cfa.getRoot();
            while (true) {
                lock = CFALockUtil.beginBatching(new ComponentLock(rootPath, desc.getConnectionHandle(), desc.getComponent()), true, (IProgressMonitor)progress.newChild(30));
                success = false;
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                if (cfa == null) {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    progress.done();
                    success = true;
                    return null;
                }
                ILocation newRoot = cfa.getRoot();
                if (!newRoot.equals(rootPath)) {
                    rootPath = newRoot;
                } else {
                    ISharingDescriptor newDesc = cfa.findSharingDescriptor(rootRelativePath);
                    if (newDesc == null) {
                        CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                        progress.done();
                        success = true;
                        return null;
                    }
                    if (newDesc.getComponent().sameItemId((IItemHandle)desc.getComponent()) && newDesc.getConnectionHandle().sameItemId((IItemHandle)desc.getConnectionHandle())) {
                        progress.done();
                        success = true;
                        AbstractLock abstractLock = lock;
                        return abstractLock;
                    }
                    desc = newDesc;
                }
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                success = true;
                progress.setWorkRemaining(79);
            }
        }
        finally {
            if (!success) {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            }
        }
    }

    public static AbstractLock lockExistingForRead(ILocation cfaRoot, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        if (cfa == null) {
            progress.done();
            return null;
        }
        ILocation rootPath = cfa.getRoot();
        while (true) {
            AbstractLock lock = CFALockUtil.beginBatching(new CFAReadLock(rootPath), true, (IProgressMonitor)progress.newChild(50));
            boolean success = false;
            try {
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                if (cfa == null) {
                    return null;
                }
                ILocation newRootPath = cfa.getRoot();
                if (newRootPath.equals(rootPath)) {
                    progress.done();
                    success = true;
                    AbstractLock abstractLock = lock;
                    return abstractLock;
                }
                rootPath = newRootPath;
            }
            finally {
                if (!success) {
                    CopyFileAreaStore.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                }
            }
            progress.setWorkRemaining(100);
        }
    }

    public static AbstractLock lockExistingForGlobalUpdate(ILocation cfaRoot, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        if (cfa == null) {
            progress.done();
            return null;
        }
        ILocation rootPath = cfa.getRoot();
        while (true) {
            AbstractLock lock = CFALockUtil.beginBatching(new GlobalCFALock(rootPath), true, (IProgressMonitor)progress.newChild(50));
            boolean success = false;
            try {
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                if (cfa == null) {
                    return null;
                }
                ILocation newRootPath = cfa.getRoot();
                if (newRootPath.equals(rootPath)) {
                    progress.done();
                    success = true;
                    AbstractLock abstractLock = lock;
                    return abstractLock;
                }
                rootPath = newRootPath;
            }
            finally {
                if (!success) {
                    CopyFileAreaStore.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                }
            }
            progress.setWorkRemaining(100);
        }
    }

    public static AbstractLock lockExistingForUpdate(ILocation cfaRoot, IContextHandle connection, IComponentHandle component, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        if (cfa == null) {
            progress.done();
            return null;
        }
        ILocation rootPath = cfa.getRoot();
        while (true) {
            AbstractLock lock = CFALockUtil.beginBatching(new ComponentLock(rootPath, connection, component), true, (IProgressMonitor)progress.newChild(50));
            boolean success = false;
            try {
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                if (cfa == null) {
                    return null;
                }
                ILocation newRootPath = cfa.getRoot();
                if (newRootPath.equals(rootPath)) {
                    progress.done();
                    success = true;
                    AbstractLock abstractLock = lock;
                    return abstractLock;
                }
                rootPath = newRootPath;
            }
            finally {
                if (!success) {
                    CopyFileAreaStore.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                }
            }
            progress.setWorkRemaining(100);
        }
    }

    public static AbstractLock lockExistingForReadForLocation(ILocation location, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ICopyFileArea cfa = CopyFileAreaManager.instance.getCopyFileAreaForPath(location);
        if (cfa == null) {
            progress.done();
            return null;
        }
        ILocation rootPath = cfa.getRoot();
        while (true) {
            AbstractLock lock = CFALockUtil.beginBatching(new CFAReadLock(rootPath), true, (IProgressMonitor)progress.newChild(50));
            boolean success = false;
            try {
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(rootPath);
                if (cfa != null) {
                    ILocation newRootPath = cfa.getRoot();
                    if (newRootPath.equals(rootPath)) {
                        progress.done();
                        success = true;
                        AbstractLock abstractLock = lock;
                        return abstractLock;
                    }
                    rootPath = newRootPath;
                } else {
                    CopyFileAreaStore.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                    cfa = CopyFileAreaManager.instance.getCopyFileAreaForPath(location);
                    if (cfa == null) {
                        progress.done();
                        return null;
                    }
                    rootPath = cfa.getRoot();
                }
            }
            finally {
                if (!success) {
                    CopyFileAreaStore.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                }
            }
            progress.setWorkRemaining(100);
        }
    }

    public static AbstractLock beginBatching(AbstractLock resourceRule, boolean waitForLock, IProgressMonitor monitor) {
        CopyFileAreaManager instance = CopyFileAreaManager.instance;
        return instance.batchingLock.acquire(resourceRule, instance, BatchingLock.NULL_LOCK_PARTICIPANT, waitForLock, monitor);
    }

    public static void endBatching(AbstractLock rule, IProgressMonitor monitor) throws FileSystemException {
        CopyFileAreaManager.instance.batchingLock.release(rule, monitor);
    }

    public static AbstractLock createAndLockSuperExclusive(ILocation cfaRoot, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        if (cfa == null) {
            cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(30));
        }
        ILocation rootPath = cfa.getRoot();
        while (true) {
            AbstractLock lock = CFALockUtil.beginBatching(new CFARemoveLock(rootPath), true, (IProgressMonitor)progress.newChild(20));
            boolean success = false;
            try {
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(rootPath);
                if (cfa != null) {
                    ILocation newRootPath = cfa.getRoot();
                    if (newRootPath.equals(rootPath)) {
                        progress.done();
                        success = true;
                        AbstractLock abstractLock = lock;
                        return abstractLock;
                    }
                    rootPath = newRootPath;
                } else {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                    cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(1));
                    rootPath = cfa.getRoot();
                }
            }
            finally {
                if (!success) {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                }
            }
            progress.setWorkRemaining(70);
        }
    }

    public static AbstractLock createAndLockForReading(ILocation cfaRoot, boolean waitForLock, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        if (cfa == null) {
            cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(30));
        }
        ILocation rootPath = cfa.getRoot();
        AbstractLock lock;
        while ((lock = CFALockUtil.beginBatching(new CFAReadLock(rootPath), waitForLock, (IProgressMonitor)progress.newChild(20))) != null) {
            boolean success = false;
            try {
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(rootPath);
                if (cfa != null) {
                    ILocation newRootPath = cfa.getRoot();
                    if (newRootPath.equals(rootPath)) {
                        progress.done();
                        success = true;
                        AbstractLock abstractLock = lock;
                        return abstractLock;
                    }
                    rootPath = newRootPath;
                } else {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                    cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(1));
                    rootPath = cfa.getRoot();
                }
            }
            finally {
                if (!success) {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                }
            }
            progress.setWorkRemaining(70);
        }
        return null;
    }

    private static Collection<ISharingDescriptor> getSharingDescriptors(CopyFileArea cfa, Collection<IRelativeLocation> rootRelativePaths) throws FileSystemException {
        HashSet<ISharingDescriptor> result = new HashSet<ISharingDescriptor>();
        for (IRelativeLocation rootRelativePath : rootRelativePaths) {
            Collection<IRelativeLocation> allSharePaths;
            ISharingDescriptor desc = cfa.findSharingDescriptor(rootRelativePath);
            if (desc != null) {
                result.add(desc);
            }
            if ((allSharePaths = cfa.allSharePaths(rootRelativePath)).size() == 0) continue;
            for (IRelativeLocation location : allSharePaths) {
                Share share = cfa.getShare(location);
                if (share == null) continue;
                ISharingDescriptor childDesc = share.getSharingDescriptor();
                result.add(childDesc);
            }
        }
        return result;
    }

    public static AbstractLock createAndLockForUpdate(ILocation cfaRoot, IRelativeLocation rootRelativePath, boolean waitForLock, IProgressMonitor monitor) throws FileSystemException {
        return CFALockUtil.createAndLockForUpdate(cfaRoot, Collections.singletonList(rootRelativePath), waitForLock, monitor);
    }

    public static AbstractLock createAndLockForUpdate(ILocation cfaRoot, Collection<IRelativeLocation> rootRelativePaths, boolean waitForLock, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.createAndLockForReading(cfaRoot, waitForLock, (IProgressMonitor)progress.newChild(20));
        if (lock == null) {
            return null;
        }
        boolean success = false;
        try {
            CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
            Collection<ISharingDescriptor> descriptors = CFALockUtil.getSharingDescriptors(cfa, rootRelativePaths);
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            success = true;
            if (descriptors.isEmpty()) {
                progress.done();
                return null;
            }
            while (true) {
                ILocation rootPath;
                AbstractLock tempLock;
                if ((tempLock = CFALockUtil.createLock(rootPath = cfa.getRoot(), descriptors)) == null) {
                    return null;
                }
                lock = CFALockUtil.beginBatching(tempLock, waitForLock, (IProgressMonitor)progress.newChild(30));
                if (lock == null) {
                    return null;
                }
                success = false;
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                if (cfa == null) {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                    cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(1));
                    rootPath = cfa.getRoot();
                } else {
                    ILocation newRoot = cfa.getRoot();
                    if (!newRoot.equals(rootPath)) {
                        rootPath = newRoot;
                    } else {
                        Collection<ISharingDescriptor> newDescriptors = CFALockUtil.getSharingDescriptors(cfa, rootRelativePaths);
                        if (descriptors.isEmpty()) {
                            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                            progress.done();
                            success = true;
                            return null;
                        }
                        if (CFALockUtil.sameDescriptors(descriptors, newDescriptors)) {
                            progress.done();
                            success = true;
                            AbstractLock abstractLock = lock;
                            return abstractLock;
                        }
                        descriptors = newDescriptors;
                    }
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                }
                progress.setWorkRemaining(79);
            }
        }
        finally {
            if (!success) {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            }
        }
    }

    private static AbstractLock createLock(ILocation rootPath, Collection<ISharingDescriptor> descriptors) {
        HashSet<UUID> componentsUUID = new HashSet<UUID>();
        AbstractLock tempLock = null;
        for (ISharingDescriptor desc : descriptors) {
            IComponentHandle component = desc.getComponent();
            UUID componentId = component.getItemId();
            if (tempLock != null) {
                if (componentsUUID.contains(componentId)) continue;
                tempLock = MultiLock.combine(tempLock, new ComponentLock(rootPath, desc.getConnectionHandle(), component));
                componentsUUID.add(componentId);
                continue;
            }
            tempLock = new ComponentLock(rootPath, desc.getConnectionHandle(), component);
            componentsUUID.add(componentId);
        }
        return tempLock;
    }

    private static boolean sameDescriptors(Collection<ISharingDescriptor> descriptors, Collection<ISharingDescriptor> newDescriptors) {
        if (descriptors.size() != newDescriptors.size()) {
            return false;
        }
        for (ISharingDescriptor desc : newDescriptors) {
            if (descriptors.contains(desc)) continue;
            return false;
        }
        return true;
    }

    public static AbstractLock createAndLockForUpdate(ILocation cfaRoot, IContextHandle connection, IComponentHandle component, IProgressMonitor monitor) throws FileSystemException {
        return CFALockUtil.createAndLockForUpdate(cfaRoot, connection, component, true, monitor);
    }

    public static AbstractLock createAndLockForUpdate(ILocation cfaRoot, IContextHandle connection, IComponentHandle component, boolean waitForLock, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        if (cfa == null) {
            cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(30));
        }
        ILocation rootPath = cfa.getRoot();
        while (true) {
            AbstractLock lock = CFALockUtil.beginBatching(new ComponentLock(rootPath, connection, component), waitForLock, (IProgressMonitor)progress.newChild(20));
            boolean success = false;
            try {
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(rootPath);
                if (cfa != null) {
                    ILocation newRootPath = cfa.getRoot();
                    if (newRootPath.equals(rootPath)) {
                        progress.done();
                        success = true;
                        AbstractLock abstractLock = lock;
                        return abstractLock;
                    }
                    rootPath = newRootPath;
                } else {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                    cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(1));
                    rootPath = cfa.getRoot();
                }
            }
            finally {
                if (!success) {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                }
            }
            progress.setWorkRemaining(70);
        }
    }

    public static boolean isLockedForUpdateOfChildren(ILocation cfaRoot, IRelativeLocation rootRelativePath, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        if (cfa == null) {
            progress.done();
            return false;
        }
        ILocation rootPath = cfa.getRoot();
        if (!CFALockUtil.isLocked(new CFAReadLock(rootPath))) {
            return false;
        }
        IRelativeLocation[] sharePaths = cfa.allSharePaths();
        IRelativeLocation convertedPath = rootRelativePath.getCanonicalForm(cfa.isCaseSensitive(), true);
        IShare containingShare = null;
        boolean parentOfShare = false;
        IRelativeLocation[] iRelativeLocationArray = sharePaths;
        int n = sharePaths.length;
        int n2 = 0;
        while (n2 < n) {
            IRelativeLocation sharePath = iRelativeLocationArray[n2];
            IRelativeLocation shareRootPath = sharePath.getCanonicalForm(cfa.isCaseSensitive(), true);
            if (shareRootPath.isPrefixOf(convertedPath)) {
                containingShare = cfa.getShare(sharePath);
                if (containingShare != null) break;
                return false;
            }
            if (convertedPath.isPrefixOf(shareRootPath)) {
                parentOfShare = true;
                break;
            }
            ++n2;
        }
        ISharingDescriptor desc = null;
        if (containingShare != null) {
            desc = containingShare.getSharingDescriptor();
        } else if (!parentOfShare) {
            return false;
        }
        AbstractLock lock = desc == null ? new GlobalCFALock(rootPath) : new ComponentLock(rootPath, desc.getConnectionHandle(), desc.getComponent());
        return CFALockUtil.isLocked(lock);
    }

    public static LockResult createAndLockForUpdateOfChildren(ILocation cfaRoot, IRelativeLocation rootRelativePath, boolean waitForLock, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.createAndLockForReading(cfaRoot, waitForLock, (IProgressMonitor)progress.newChild(20));
        if (lock == null) {
            return new LockResult(waitForLock, progress);
        }
        boolean success = false;
        try {
            RequiredLocks requiredLocks = new RequiredLocks(cfaRoot, rootRelativePath);
            if (!requiredLocks.hasComponentsToLock()) {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                success = true;
                progress.done();
                LockResult lockResult = new LockResult(1);
                return lockResult;
            }
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            success = true;
            while (true) {
                CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                ILocation rootPath = cfa.getRoot();
                lock = requiredLocks.createLock();
                if ((lock = CFALockUtil.beginBatching(lock, waitForLock, (IProgressMonitor)progress.newChild(30))) == null) {
                    LockResult lockResult = new LockResult(waitForLock, progress);
                    return lockResult;
                }
                success = false;
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                if (cfa == null) {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                    cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(1));
                    rootPath = cfa.getRoot();
                } else {
                    ILocation newRoot = cfa.getRoot();
                    if (!newRoot.equals(rootPath)) {
                        rootPath = newRoot;
                    } else {
                        RequiredLocks newRequiredLocks = new RequiredLocks(cfaRoot, rootRelativePath);
                        if (!newRequiredLocks.hasComponentsToLock()) {
                            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                            success = true;
                            progress.done();
                            LockResult lockResult = new LockResult(1);
                            return lockResult;
                        }
                        if (newRequiredLocks.matches(requiredLocks)) {
                            progress.done();
                            LockResult result = new LockResult(lock);
                            success = true;
                            LockResult lockResult = result;
                            return lockResult;
                        }
                        requiredLocks = newRequiredLocks;
                    }
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                }
                progress.setWorkRemaining(79);
            }
        }
        finally {
            if (!success) {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            }
        }
    }

    public static AbstractLock createAndLockForReading(List<? extends ILocation> cfaRoots, boolean waitForLocks, IProgressMonitor monitor) throws FileSystemException {
        int size = cfaRoots.size();
        Assert.isTrue((size != 0 ? 1 : 0) != 0);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ILocation[] cfas = new ILocation[size];
        SubMonitor createMonitor = progress.newChild(30);
        createMonitor.setWorkRemaining(size);
        int i = 0;
        AbstractLock[] readLocks = new AbstractLock[size];
        for (ILocation iLocation : cfaRoots) {
            ILocation iLocation2;
            CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(iLocation);
            if (cfa == null) {
                cfa = CopyFileAreaManager.instance.createCopyFileArea(iLocation, (IProgressMonitor)createMonitor.newChild(1));
            }
            cfas[i] = iLocation2 = cfa.getRoot();
            readLocks[i] = new CFAReadLock(iLocation2);
            ++i;
        }
        AbstractLock abstractLock;
        while ((abstractLock = CFALockUtil.beginBatching(MultiLock.combine(readLocks), waitForLocks, (IProgressMonitor)progress.newChild(20))) != null) {
            boolean unlocked = false;
            try {
                i = 0;
                SubMonitor checkProgress = progress.newChild(1);
                checkProgress.setWorkRemaining(size + 1);
                for (ILocation iLocation : cfaRoots) {
                    ILocation newRootPath;
                    CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(iLocation);
                    if (cfa != null) {
                        newRootPath = cfa.getRoot();
                        if (!newRootPath.equals(cfas[i])) {
                            if (!unlocked) {
                                CFALockUtil.endBatching(abstractLock, (IProgressMonitor)checkProgress.newChild(1));
                                unlocked = true;
                            }
                            cfas[i] = newRootPath;
                            readLocks[i] = new CFAReadLock(newRootPath);
                        }
                    } else {
                        if (!unlocked) {
                            CFALockUtil.endBatching(abstractLock, (IProgressMonitor)checkProgress.newChild(1));
                            unlocked = true;
                        }
                        cfa = CopyFileAreaManager.instance.createCopyFileArea(iLocation, (IProgressMonitor)checkProgress.newChild(1));
                        cfas[i] = newRootPath = cfa.getRoot();
                        readLocks[i] = new CFAReadLock(newRootPath);
                    }
                    ++i;
                }
                checkProgress.done();
                if (!unlocked) {
                    progress.done();
                    unlocked = true;
                    AbstractLock abstractLock2 = abstractLock;
                    return abstractLock2;
                }
            }
            finally {
                if (!unlocked) {
                    CFALockUtil.endBatching(abstractLock, (IProgressMonitor)progress.newChild(1));
                }
            }
            progress.setWorkRemaining(70);
        }
        return null;
    }

    public static LockResult createAndLockForUpdateOfChildren(List<? extends ILocation> cfaRoots, List<? extends IRelativeLocation> rootRelativePaths, boolean waitForLock, IProgressMonitor monitor) throws FileSystemException {
        int size = cfaRoots.size();
        Assert.isTrue((size == rootRelativePaths.size() ? 1 : 0) != 0);
        Assert.isTrue((size != 0 ? 1 : 0) != 0);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.createAndLockForReading(cfaRoots, waitForLock, (IProgressMonitor)progress.newChild(20));
        if (lock == null) {
            return new LockResult(waitForLock, progress);
        }
        boolean success = false;
        HashMap<ILocation, Map<UUID, AbstractLock>> tempLocks = new HashMap<ILocation, Map<UUID, AbstractLock>>();
        UUID globalUUID = UUID.generate();
        try {
            int n;
            ILocation[] paths = new ILocation[size];
            Iterator<? extends ILocation> cfaIt = cfaRoots.iterator();
            Iterator<? extends IRelativeLocation> pathIt = rootRelativePaths.iterator();
            int i = 0;
            while (i != size) {
                ILocation cfaRoot = cfaIt.next();
                IRelativeLocation rootRelativePath = pathIt.next();
                CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                ILocation rootPath = cfa.getRoot();
                IRelativeLocation[] sharePaths = cfa.allSharePaths();
                Arrays.sort(sharePaths, RelativeLocationComparator);
                IRelativeLocation convertedPath = rootRelativePath.getCanonicalForm(cfa.isCaseSensitive(), true);
                IRelativeLocation[] mostSpecificShares = CFALockUtil.getMostSpecificShares(cfa, sharePaths, convertedPath);
                Share containingShare = null;
                HashMap<UUID, AbstractLock> temp = (HashMap<UUID, AbstractLock>)tempLocks.get(rootPath);
                boolean assigningValue = false;
                if (mostSpecificShares != null) {
                    IRelativeLocation[] iRelativeLocationArray = mostSpecificShares;
                    n = mostSpecificShares.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IRelativeLocation location = iRelativeLocationArray[n2];
                        containingShare = cfa.getShare(location);
                        if (containingShare == null) {
                            LoggingHelper.log(FileSystemStatusUtil.getStatusFor(0, NLS.bind((String)"Expected share could not be found at ''{0}''", (Object)location.toString())));
                        } else {
                            assigningValue = true;
                            ISharingDescriptor desc = containingShare.getSharingDescriptor();
                            IComponentHandle component = desc.getComponent();
                            UUID componentId = component.getItemId();
                            if (temp == null) {
                                temp = new HashMap();
                                tempLocks.put(rootPath, temp);
                            }
                            if (temp.get(componentId) == null) {
                                temp.put(componentId, new ComponentLock(rootPath, desc.getConnectionHandle(), component));
                            }
                        }
                        ++n2;
                    }
                }
                if (!assigningValue) {
                    if (temp == null) {
                        temp = new HashMap<UUID, AbstractLock>();
                        tempLocks.put(rootPath, temp);
                    }
                    if (temp.get(globalUUID) == null) {
                        temp.put(globalUUID, new GlobalCFALock(rootPath));
                    }
                }
                paths[i] = rootPath;
                ++i;
            }
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            success = true;
            while (true) {
                if ((lock = CFALockUtil.beginBatching(CFALockUtil.combineLocks(tempLocks), waitForLock, (IProgressMonitor)progress.newChild(30))) == null) {
                    LockResult lockResult = new LockResult(waitForLock, progress);
                    return lockResult;
                }
                success = false;
                cfaIt = cfaRoots.iterator();
                pathIt = rootRelativePaths.iterator();
                boolean goAgain = false;
                boolean noneContainShares = true;
                int i2 = 0;
                while (i2 != size) {
                    ILocation cfaRoot = cfaIt.next();
                    IRelativeLocation rootRelativePath = pathIt.next();
                    CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                    if (cfa == null) {
                        if (!success) {
                            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                            success = true;
                        }
                        cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(1));
                        ILocation rootPath = cfa.getRoot();
                        HashMap<UUID, GlobalCFALock> locks = new HashMap<UUID, GlobalCFALock>();
                        locks.put(globalUUID, new GlobalCFALock(rootPath));
                        tempLocks.put(rootPath, locks);
                        paths[i2] = rootPath;
                        goAgain = true;
                    } else {
                        ILocation newRoot = cfa.getRoot();
                        if (!newRoot.equals(paths[i2])) {
                            paths[i2] = newRoot;
                            goAgain = true;
                        } else if (!success) {
                            IRelativeLocation[] sharePaths = cfa.allSharePaths();
                            Arrays.sort(sharePaths, RelativeLocationComparator);
                            IRelativeLocation convertedPath = rootRelativePath.getCanonicalForm(cfa.isCaseSensitive(), true);
                            IRelativeLocation[] mostSpecificShares = CFALockUtil.getMostSpecificShares(cfa, sharePaths, convertedPath);
                            Share containingShare = null;
                            Map map = (Map)tempLocks.get(newRoot);
                            if (mostSpecificShares != null) {
                                IRelativeLocation[] iRelativeLocationArray = mostSpecificShares;
                                int n3 = mostSpecificShares.length;
                                n = 0;
                                while (n < n3) {
                                    IRelativeLocation location = iRelativeLocationArray[n];
                                    containingShare = cfa.getShare(location);
                                    if (containingShare != null) {
                                        ISharingDescriptor newDesc = containingShare.getSharingDescriptor();
                                        noneContainShares = false;
                                        AbstractLock abstractLock = (AbstractLock)map.get(newDesc.getComponent().getItemId());
                                        ComponentLock componentLock = new ComponentLock(newRoot, newDesc.getConnectionHandle(), newDesc.getComponent());
                                        if (abstractLock == null || !abstractLock.equals(componentLock)) {
                                            map.put(newDesc.getComponent().getItemId(), componentLock);
                                            goAgain = true;
                                        }
                                    }
                                    ++n;
                                }
                            }
                            if (containingShare == null) {
                                map.put(globalUUID, new GlobalCFALock(newRoot));
                            }
                        }
                    }
                    ++i2;
                }
                if (!goAgain) {
                    if (noneContainShares) {
                        CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                        success = true;
                        progress.done();
                        LockResult lockResult = new LockResult(1);
                        return lockResult;
                    }
                    progress.done();
                    LockResult result = new LockResult(lock);
                    success = true;
                    LockResult lockResult = result;
                    return lockResult;
                }
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                success = true;
                progress.setWorkRemaining(79);
            }
        }
        finally {
            if (!success) {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            }
        }
    }

    private static IRelativeLocation[] getMostSpecificShares(CopyFileArea cfa, IRelativeLocation[] sharePaths, IRelativeLocation convertedPath) {
        try {
            Collection<IRelativeLocation> allSharePaths = cfa.allSharePaths(convertedPath);
            if (allSharePaths.size() != 0) {
                return allSharePaths.toArray(new IRelativeLocation[allSharePaths.size()]);
            }
        }
        catch (FileSystemException allSharePaths) {
            // empty catch block
        }
        int i = sharePaths.length - 1;
        while (i >= 0) {
            IRelativeLocation canonicalForm = sharePaths[i].getCanonicalForm(cfa.isCaseSensitive(), true);
            if (canonicalForm.isPrefixOf(convertedPath)) {
                IRelativeLocation[] result = new IRelativeLocation[]{sharePaths[i]};
                return result;
            }
            --i;
        }
        return null;
    }

    private static AbstractLock combineLocks(Map<ILocation, Map<UUID, AbstractLock>> tempLocks) {
        ArrayList<AbstractLock> locks = new ArrayList<AbstractLock>();
        for (Map<UUID, AbstractLock> map : tempLocks.values()) {
            locks.addAll(map.values());
        }
        return MultiLock.combine(locks);
    }

    public static void endBatching(LockResult lock, SubMonitor monitor) throws FileSystemException {
        if (lock.code == 0) {
            CFALockUtil.endBatching(lock.lock, (IProgressMonitor)monitor);
        }
    }

    private static class ComponentToLock {
        private IContextHandle context;
        private IComponentHandle component;

        ComponentToLock(IContextHandle context, IComponentHandle component) {
            this.context = context;
            this.component = component;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ComponentToLock) {
                ComponentToLock other = (ComponentToLock)o;
                return other.context.sameItemId((IItemHandle)this.context) && other.component.sameItemId((IItemHandle)this.component);
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.context.getItemId().hashCode();
            result = 31 * result + this.component.getItemId().hashCode();
            return result;
        }

        public ComponentLock createLock(ILocation rootPath) {
            return new ComponentLock(rootPath, this.context, this.component);
        }
    }

    public static class LockResult {
        public final AbstractLock lock;
        public final int code;

        public LockResult(AbstractLock lock) {
            this.code = 0;
            this.lock = lock;
        }

        public LockResult(int code) {
            this.code = code;
            this.lock = null;
        }

        public LockResult(boolean waitForLock, SubMonitor progress) {
            this.lock = null;
            this.code = progress.isCanceled() ? 3 : (!waitForLock ? 2 : 4);
        }
    }

    private static class RequiredLocks {
        private ILocation cfaRoot;
        private IRelativeLocation rootRelativePath;
        private Set<ComponentToLock> toLock = new HashSet<ComponentToLock>();

        RequiredLocks(ILocation cfaRoot, IRelativeLocation rootRelativePath) throws FileSystemException {
            this.cfaRoot = cfaRoot;
            this.rootRelativePath = rootRelativePath;
            this.toLock = this.calculateComponentsToLock();
        }

        private Set<ComponentToLock> calculateComponentsToLock() throws FileSystemException {
            HashSet<ComponentToLock> result = new HashSet<ComponentToLock>();
            CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaRoot);
            IRelativeLocation convertedPath = this.rootRelativePath.getCanonicalForm(cfa.isCaseSensitive(), true);
            IRelativeLocation[] allSharePaths = cfa.allSharePaths();
            if (allSharePaths.length != 0) {
                IRelativeLocation[] iRelativeLocationArray = allSharePaths;
                int n = allSharePaths.length;
                int n2 = 0;
                while (n2 < n) {
                    ISharingDescriptor desc;
                    IRelativeLocation location = iRelativeLocationArray[n2];
                    IRelativeLocation currentLocation = location.getCanonicalForm(cfa.isCaseSensitive(), true);
                    if ((currentLocation.isPrefixOf(convertedPath) || convertedPath.isPrefixOf(currentLocation)) && (desc = cfa.getSharingInfo(location)) != null) {
                        ComponentToLock componentToLock = new ComponentToLock(desc.getConnectionHandle(), desc.getComponent());
                        result.add(componentToLock);
                    }
                    ++n2;
                }
            } else {
                IRelativeLocation shareRootPath;
                Share share = cfa.getShare(convertedPath);
                if (share != null && (shareRootPath = share.getPath().getCanonicalForm(cfa.isCaseSensitive(), true)).isPrefixOf(convertedPath)) {
                    ISharingDescriptor desc = share.getSharingDescriptor();
                    ComponentToLock componentToLock = new ComponentToLock(desc.getConnectionHandle(), desc.getComponent());
                    result.add(componentToLock);
                }
            }
            return result;
        }

        public boolean hasComponentsToLock() {
            return !this.toLock.isEmpty();
        }

        public AbstractLock createLock() {
            CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaRoot);
            ILocation rootPath = cfa.getRoot();
            if (!this.hasComponentsToLock()) {
                return new GlobalCFALock(rootPath);
            }
            ArrayList<ComponentLock> componentLocks = new ArrayList<ComponentLock>(this.toLock.size());
            for (ComponentToLock componentToLock : this.toLock) {
                componentLocks.add(componentToLock.createLock(rootPath));
            }
            return MultiLock.create(componentLocks);
        }

        public boolean matches(RequiredLocks other) {
            if (other.toLock.size() != this.toLock.size()) {
                return false;
            }
            for (ComponentToLock componentToLock : this.toLock) {
                if (other.toLock.contains(componentToLock)) continue;
                return false;
            }
            return true;
        }
    }
}

