/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.IFlushOperation;
import com.ibm.team.filesystem.client.internal.copyfileareas.ILockParticipant;
import com.ibm.team.filesystem.client.internal.copyfileareas.MultiLock;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;

public class BatchingLock<T> {
    public static final ILockParticipant NULL_LOCK_PARTICIPANT = new ILockParticipant(){

        @Override
        public AbstractLock locking(AbstractLock rule) {
            return rule;
        }

        @Override
        public void waiting() {
        }
    };
    private static final boolean DEBUG = System.getProperty("filesystem.debug.batchingLock", "false").equals("true");
    static final AbstractLock NULL_SCHEDULING_RULE = new AbstractLock(){

        @Override
        public boolean contains(AbstractLock rule) {
            return rule == this;
        }

        @Override
        public boolean isConflicting(AbstractLock rule) {
            return false;
        }

        @Override
        public boolean mayPromoteTo(AbstractLock rule) {
            return true;
        }

        public String toString() {
            return "NullLock";
        }
    };
    static final AbstractLock AVOID_NOTIFICATION_RULE = new AbstractLock(){

        @Override
        public boolean contains(AbstractLock rule) {
            return rule == this;
        }

        @Override
        public boolean isConflicting(AbstractLock rule) {
            return false;
        }

        @Override
        public boolean mayPromoteTo(AbstractLock rule) {
            return true;
        }

        public String toString() {
            return "AvoidNotificationLock";
        }
    };
    private final LinkedHashMap<Thread, ThreadInfo> infos = new LinkedHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThreadInfo getThreadInfo() {
        Thread thisThread = Thread.currentThread();
        LinkedHashMap<Thread, ThreadInfo> linkedHashMap = this.infos;
        synchronized (linkedHashMap) {
            ThreadInfo info = this.infos.get(thisThread);
            return info;
        }
    }

    private AbstractLock getRuleForResoure(AbstractLock resourceRule) {
        return resourceRule == null ? NULL_SCHEDULING_RULE : resourceRule;
    }

    public boolean isLocked(AbstractLock resourceRule) {
        AbstractLock rule = this.getRuleForResoure(resourceRule);
        if (rule == AVOID_NOTIFICATION_RULE || rule == NULL_SCHEDULING_RULE) {
            return false;
        }
        ThreadInfo info = this.getThreadInfo();
        if (info == null) {
            return false;
        }
        return info.ruleContained(rule);
    }

    public void validateAcquire(AbstractLock lock) {
        ThreadInfo info = this.getThreadInfo();
        if (info == null) {
            return;
        }
        info.checkRule(this.getRuleForResoure(lock));
    }

    /*
     * Exception decompiling
     */
    public AbstractLock acquire(AbstractLock resourceRule, IFlushOperation operation, ILockParticipant participant, boolean doWait, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 33[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected ThreadInfo createThreadInfo(IFlushOperation operation) {
        return new ThreadInfo(operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(AbstractLock rule, IProgressMonitor monitor) throws FileSystemException {
        ThreadInfo info = this.getThreadInfo();
        Assert.isNotNull((Object)info, (String)"Unmatched acquire/release.");
        Assert.isTrue((boolean)info.isNested(), (String)"Unmatched acquire/release.");
        info.popRule(rule, monitor);
        if (!info.isNested()) {
            Thread thisThread = Thread.currentThread();
            if (DEBUG) {
                System.out.println("[" + thisThread.getName() + "] released batching lock");
            }
            LinkedHashMap<Thread, ThreadInfo> linkedHashMap = this.infos;
            synchronized (linkedHashMap) {
                this.infos.remove(thisThread);
            }
        }
    }

    public void addChange(T change) {
        ThreadInfo info = this.getThreadInfo();
        Assert.isNotNull((Object)info, (String)"A change occurred without a lock being held");
        info.addChange(change);
    }

    public void flush(IProgressMonitor monitor) throws FileSystemException {
        ThreadInfo info = this.getThreadInfo();
        Assert.isNotNull((Object)info, (String)"Flush requested outside of resource lock");
        info.flush(monitor);
    }

    private class ThreadInfo {
        private final ArrayList<T> changes = new ArrayList();
        private final IFlushOperation<T> operation;
        private Job job;
        private final ArrayList<AbstractLock> rules = new ArrayList();
        private final ArrayList<AbstractLock> baseRule = new ArrayList();

        public ThreadInfo(IFlushOperation<T> operation) {
            this.operation = operation;
        }

        public AbstractLock pushRule(AbstractLock rule) {
            this.checkRule(rule);
            this.addRule(rule);
            return rule;
        }

        public void popRule(AbstractLock rule, IProgressMonitor monitor) throws FileSystemException {
            try {
                if (this.isFlushRequired(rule)) {
                    this.flush(monitor);
                }
            }
            finally {
                this.removeRule(rule);
            }
        }

        public boolean isNested() {
            return !this.rules.isEmpty();
        }

        public void addChange(T change) {
            this.changes.add(change);
        }

        public void flush(IProgressMonitor monitor) throws FileSystemException {
            try {
                try {
                    if (this.operation != null) {
                        this.operation.flush(this.changes, monitor);
                    }
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (Error e) {
                    this.handleAbortedFlush(e);
                    throw e;
                }
                catch (RuntimeException e) {
                    this.handleAbortedFlush(e);
                    throw e;
                }
            }
            finally {
                this.changes.clear();
            }
        }

        private boolean isFlushRequired(AbstractLock toRelease) {
            for (AbstractLock rule : this.rules) {
                if (rule == toRelease) {
                    toRelease = NULL_SCHEDULING_RULE;
                    continue;
                }
                if (rule == NULL_SCHEDULING_RULE) continue;
                return false;
            }
            return true;
        }

        private void handleAbortedFlush(Throwable t) {
            LoggingHelper.error("com.ibm.team.filesystem.client", "Flush aborted", t);
        }

        public void checkRule(AbstractLock lock) {
            AbstractLock base;
            int size;
            if (lock != NULL_SCHEDULING_RULE && lock != AVOID_NOTIFICATION_RULE && (size = this.baseRule.size()) != 0 && !(base = this.baseRule.get(size - 1)).mayPromoteTo(lock)) {
                throw new IllegalStateException("The rule " + lock + " is not promotable from the base rule " + base);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addRule(AbstractLock resource) {
            AbstractLock base = null;
            if (resource != NULL_SCHEDULING_RULE && resource != AVOID_NOTIFICATION_RULE) {
                int size = this.baseRule.size();
                base = size == 0 ? resource : (this.ruleContained(resource) ? this.baseRule.get(size - 1) : MultiLock.combine(resource, this.baseRule.get(size - 1)));
            }
            ArrayList<AbstractLock> arrayList = this.rules;
            synchronized (arrayList) {
                this.rules.add(resource);
                if (base != null) {
                    this.baseRule.add(base);
                }
                this.job = Job.getJobManager().currentJob();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeRule(AbstractLock rule) {
            int idx = -1;
            int numNonNull = 0;
            int i = this.rules.size() - 1;
            while (i >= 0) {
                AbstractLock l = this.rules.get(i);
                if (l == rule) {
                    idx = i;
                    break;
                }
                if (l != NULL_SCHEDULING_RULE && l != AVOID_NOTIFICATION_RULE) {
                    ++numNonNull;
                }
                --i;
            }
            if (idx == -1) {
                Assert.isTrue((boolean)false, (String)("end for lock '" + rule + "' does not match any stacked rule"));
            }
            ArrayList<AbstractLock> newBase = null;
            if (numNonNull != 0 && rule != NULL_SCHEDULING_RULE && rule != AVOID_NOTIFICATION_RULE) {
                newBase = new ArrayList<AbstractLock>(numNonNull);
                AbstractLock base = this.baseRule.get(this.baseRule.size() - numNonNull - 1);
                int top = this.rules.size();
                int i2 = idx + 1;
                while (i2 < top) {
                    AbstractLock l = this.rules.get(i2);
                    if (l != NULL_SCHEDULING_RULE && l != AVOID_NOTIFICATION_RULE) {
                        base = MultiLock.combine(base, l);
                        newBase.add(base);
                    }
                    ++i2;
                }
            }
            ArrayList<AbstractLock> arrayList = this.rules;
            synchronized (arrayList) {
                this.job = Job.getJobManager().currentJob();
                int baseSize = this.baseRule.size();
                if (rule != NULL_SCHEDULING_RULE && rule != AVOID_NOTIFICATION_RULE) {
                    this.rules.notifyAll();
                    this.baseRule.subList(baseSize - 1 - numNonNull, baseSize).clear();
                    if (newBase != null) {
                        this.baseRule.addAll(newBase);
                    }
                }
                this.rules.remove(idx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean ruleConflicts(AbstractLock resource) {
            ArrayList<AbstractLock> arrayList = this.rules;
            synchronized (arrayList) {
                int size = this.baseRule.size();
                if (size != 0) {
                    return this.baseRule.get(size - 1).isConflicting(resource);
                }
                return false;
            }
        }

        public boolean ruleContained(AbstractLock resource) {
            int size = this.baseRule.size();
            if (size == 0) {
                return false;
            }
            return this.baseRule.get(size - 1).contains(resource);
        }

        static /* synthetic */ ArrayList access$0(ThreadInfo threadInfo) {
            return threadInfo.rules;
        }

        static /* synthetic */ Job access$1(ThreadInfo threadInfo) {
            return threadInfo.job;
        }
    }
}

