/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.calm;

import com.ibm.team.calm.foundation.client.preview.ResourceReferenceResolver;
import com.ibm.team.calm.foundation.common.preview.ResourcePreview;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.calm.RESTClient;
import com.ibm.team.foundation.client.internal.util.ClientURIUtils;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.ILinkHandle;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.transport.client.ITeamRawRestServiceClient;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IChangeSetLinkSummary;
import com.ibm.team.scm.common.internal.util.XMLUtil;
import com.ibm.team.scm.common.links.ChangeSetLinks;
import com.ibm.team.scm.common.links.ChangeSetLocationFactory;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OslcLinkUtil {
    public static final String CALM_TRACK_CHANGES_NODE = "calm:tracksChanges";
    private static final String OSLC_SCM_SEGMENT = "oslc-scm";
    private static final String OSLC_SCM_WORKSPACE_SEGMENT = "workspaceId";
    private static final String OSLC_SCM_CHANGESET_SEGMENT = "changeSetId";

    public static boolean isScmOslcLink(ILink link) {
        return link.getLinkTypeId().equals("com.ibm.team.filesystem.oslc_cm.change_request.change_set");
    }

    public static List<ILink> createScmOslcLinks(ITeamRepository repo, IChangeSetHandle changeSet, IWorkspaceHandle workspace, List<ResourceURIInfo> infos, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        ArrayList<URI> resourceUris = new ArrayList<URI>();
        ArrayList<String> comments = new ArrayList<String>();
        ArrayList<String> extraInfos = new ArrayList<String>();
        for (ResourceURIInfo info : infos) {
            resourceUris.add(info.uri);
            comments.add(info.label);
            String extraInfo = null;
            if (info.repo != null) {
                extraInfo = ChangeSetLinks.serializeExtraInfo((String)info.repo.getRepositoryURI(), (UUID)info.repo.getId());
            } else if (info.repoInfo != null && info.repoInfo.repoId != null && info.repoInfo.repositoryURI != null) {
                extraInfo = ChangeSetLinks.serializeExtraInfo((String)info.repoInfo.repositoryURI, (UUID)UUID.valueOf((String)info.repoInfo.repoId));
            }
            extraInfos.add(extraInfo);
        }
        return wm.createLinks("com.ibm.team.filesystem.oslc_cm.change_request.change_set", workspace, changeSet, resourceUris, comments, extraInfos, null, false, false, monitor).getLinksAdded();
    }

    public static OslcRepositoryInfo fetchOslcTargetRepoInfo(ITeamRepository sourceRepo, URI targetURI, IProgressMonitor monitor) throws TeamRepositoryException {
        OslcRepositoryInfo result = new OslcRepositoryInfo();
        RESTClient client = new RESTClient((IClientLibraryContext)sourceRepo);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("ACCEPT", "application/json");
        headers.put("OSLC-Core-Version", "2.0");
        String query = "oslc.properties=rtc_cm:repository{*}";
        try {
            URI uri = new URI(targetURI.getScheme(), targetURI.getRawUserInfo(), targetURI.getHost(), targetURI.getPort(), targetURI.getRawPath(), query, targetURI.getRawFragment());
            ITeamRawRestServiceClient.IRawRestClientConnection.Response response = client.performGET(uri, headers, NLS.bind((String)"Error when retrieving repository attribute for {0}", (Object)uri.toString()), monitor);
            BufferedReader reader = new BufferedReader(new InputStreamReader(response.getResponseStream(), "UTF-8"));
            JSONObject json = JSONObject.parse((Reader)reader);
            JSONObject repository = (JSONObject)json.get((Object)"rtc_cm:repository");
            if (repository != null) {
                result.repoId = (String)repository.get((Object)"rtc_cm:id");
                JSONObject publicUri = (JSONObject)repository.get((Object)"rtc_cm:publicUri");
                if (publicUri != null) {
                    String resource;
                    result.repositoryURI = resource = (String)publicUri.get((Object)"rdf:resource");
                }
            }
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return result;
    }

    public static ITeamRepository deserializeExtraInfo(String extraInfo, IRepositoryResolver resolver) throws IOException {
        Document document;
        DocumentBuilder builder;
        DocumentBuilderFactory factory;
        if (extraInfo == null) {
            return null;
        }
        try {
            factory = XMLUtil.getSecureDocumentBuilderFactory();
            factory.setValidating(false);
        }
        catch (ParserConfigurationException e) {
            IOException e1 = new IOException(e.toString());
            e1.initCause(e);
            throw e1;
        }
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            IOException e2 = new IOException(e.toString());
            e2.initCause(e);
            throw e2;
        }
        try {
            document = builder.parse(new ByteArrayInputStream(extraInfo.getBytes("UTF-8")));
        }
        catch (SAXException e) {
            IOException e2 = new IOException(e.toString());
            e2.initCause(e);
            throw e2;
        }
        NodeList nodeList = document.getElementsByTagName("repository");
        if (nodeList.getLength() != 1) {
            return null;
        }
        Element repoNode = (Element)nodeList.item(0);
        String repositoryUri = repoNode.getAttribute("uri");
        String id = repoNode.getAttribute("id");
        try {
            return resolver.getRepoFor(repositoryUri, UUID.valueOf((String)id));
        }
        catch (TeamRepositoryException e) {
            return null;
        }
    }

    public static List<ILink> fetchScmOslcLinks(ITeamRepository repo, Collection<? extends IChangeSetHandle> changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<ILink> result = new ArrayList<ILink>();
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        List summaries = wm.getChangeSetLinkSummary(changeSets, (IProgressMonitor)progress.newChild(50));
        ArrayList linkHandles = new ArrayList();
        for (IChangeSetLinkSummary summary : summaries) {
            linkHandles.addAll(summary.getLinks());
        }
        List links = repo.itemManager().fetchCompleteItems(linkHandles, 0, (IProgressMonitor)progress.newChild(50));
        for (ILink link : links) {
            if (!OslcLinkUtil.isScmOslcLink(link)) continue;
            result.add(link);
        }
        return result;
    }

    public static Map<String, List<ILink>> fetchOslcLinks(ITeamRepository repo, Collection<? extends IChangeSetHandle> changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashMap<String, List<ILink>> result = new HashMap<String, List<ILink>>();
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        List summaries = wm.getChangeSetLinkSummary(changeSets, (IProgressMonitor)progress.newChild(50));
        for (IChangeSetLinkSummary summary : summaries) {
            ArrayList<ILink> temp = null;
            List links = repo.itemManager().fetchCompleteItems(summary.getLinks(), 0, (IProgressMonitor)progress.newChild(50));
            for (ILink link : links) {
                if (!OslcLinkUtil.isScmOslcLink(link)) continue;
                if (temp == null) {
                    temp = new ArrayList<ILink>();
                }
                temp.add(link);
            }
            if (temp == null) continue;
            result.put(summary.getChangeSet().getItemId().getUuidValue(), temp);
        }
        return result;
    }

    public static void deleteScmOslcLinks(ITeamRepository repo, List<ILink> links, IProgressMonitor monitor) throws TeamRepositoryException {
        for (ILink link : links) {
            if (OslcLinkUtil.isScmOslcLink(link)) continue;
            throw new IllegalArgumentException();
        }
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        wm.deleteLinks(links, monitor);
    }

    public static Map<ITeamRepository, List<IURIReference>> groupByBestRepo(Collection<IURIReference> references, ITeamRepository friendRepo, IRepositoryResolver resolver) {
        HashMap<ITeamRepository, List<IURIReference>> result = new HashMap<ITeamRepository, List<IURIReference>>();
        for (IURIReference ref : references) {
            ArrayList<IURIReference> values;
            ITeamRepository key = friendRepo;
            String extraInfo = ref.getExtraInfo();
            if (extraInfo != null) {
                try {
                    ITeamRepository repo = OslcLinkUtil.deserializeExtraInfo(extraInfo, resolver);
                    if (repo != null) {
                        key = repo;
                    }
                }
                catch (IOException repo) {
                    // empty catch block
                }
            }
            if ((values = (ArrayList<IURIReference>)result.get(key)) == null) {
                values = new ArrayList<IURIReference>();
                result.put(key, values);
            }
            values.add(ref);
        }
        return result;
    }

    public static List<DetailsInfo> fetchDetails(ITeamRepository repo, List<IURIReference> references, boolean quiet, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ArrayList<DetailsInfo> result = new ArrayList<DetailsInfo>();
        if (references.size() > 0) {
            String[] descriptionsArray;
            IReference[] resolvedArray;
            IReference[] resolvableArray;
            block7: {
                resolvableArray = new IReference[references.size()];
                resolvedArray = new IReference[references.size()];
                descriptionsArray = new String[references.size()];
                ResourceReferenceResolver resolver = new ResourceReferenceResolver();
                List resolvable = resolver.makeResolvable(references, (Object)repo);
                resolvable.toArray(resolvableArray);
                try {
                    List resolved = resolver.resolve(resolvable, 0, (IProgressMonitor)progress.newChild(1));
                    List<String> descriptions = OslcLinkUtil.resolveDescriptions(repo, resolved, (IProgressMonitor)progress.newChild(1));
                    if (references.size() != resolvable.size()) {
                        throw new IllegalStateException();
                    }
                    if (references.size() != resolved.size()) {
                        throw new IllegalStateException();
                    }
                    if (references.size() != descriptions.size()) {
                        throw new IllegalStateException();
                    }
                    resolved.toArray(resolvedArray);
                    descriptions.toArray(descriptionsArray);
                }
                catch (TeamRepositoryException e) {
                    LoggingHelper.log("com.ibm.team.filesystem.client", e);
                    if (quiet) break block7;
                    throw e;
                }
            }
            int i = 0;
            for (IURIReference unresolved : references) {
                DetailsInfo info = new DetailsInfo();
                info.unresolved = unresolved;
                info.resolvable = resolvableArray[i];
                info.resolved = resolvedArray[i];
                info.description = descriptionsArray[i];
                result.add(info);
                ++i;
            }
        }
        return result;
    }

    private static List<String> resolveDescriptions(ITeamRepository repo, List<IReference> references, IProgressMonitor monitor) throws TeamRepositoryException {
        String[] result = new String[references.size()];
        int[] indexes = new int[references.size()];
        ArrayList<IItemHandle> itemHandles = new ArrayList<IItemHandle>();
        int i = 0;
        for (IReference reference : references) {
            Object resolve = reference.resolve();
            if (resolve instanceof IItemHandle) {
                indexes[i] = itemHandles.size();
                itemHandles.add((IItemHandle)resolve);
            } else {
                String description;
                result[i] = description = OslcLinkUtil.getDescription(resolve);
                indexes[i] = -1;
            }
            ++i;
        }
        boolean sameRepo = true;
        for (IItemHandle itemHandle : itemHandles) {
            Object origin = itemHandle.getOrigin();
            ITeamRepository itemRepo = origin instanceof ITeamRepository ? (ITeamRepository)origin : null;
            boolean bl = sameRepo = itemRepo != null && itemRepo.getId().equals((Object)repo.getId());
            if (!sameRepo) break;
        }
        if (sameRepo) {
            List items = repo.itemManager().fetchCompleteItems(itemHandles, 0, monitor);
            IItem[] itemsArray = items.toArray(new IItem[items.size()]);
            i = 0;
            while (i < references.size()) {
                if (indexes[i] != -1) {
                    String description;
                    IItem item = itemsArray[indexes[i]];
                    String string = description = item != null ? ChangeSetLinks.describe((IItem)item) : null;
                    if (description != null) {
                        description = XMLString.createFromXMLText((String)description).getPlainText();
                    }
                    result[i] = description;
                }
                ++i;
            }
        }
        return Arrays.asList(result);
    }

    public static List<IChangeSetLinkSummary> getChangeSetLinkSummary(ITeamRepository repoSource, Collection<? extends IChangeSetHandle> changeSets, IRepositoryResolver resolver, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        ArrayList<IChangeSetLinkSummary> result = new ArrayList<IChangeSetLinkSummary>();
        List summaries = SCMPlatform.getWorkspaceManager((ITeamRepository)repoSource).getChangeSetLinkSummary(changeSets, (IProgressMonitor)progress.newChild(1));
        String EMPTY = "";
        ArrayList<IChangeSetLinkSummary> missing = new ArrayList<IChangeSetLinkSummary>();
        for (IChangeSetLinkSummary summary : summaries) {
            if (!summary.getSummary().equals(EMPTY) || summary.getLinks().isEmpty()) {
                result.add(summary);
                continue;
            }
            missing.add(summary);
        }
        ArrayList linkHandles = new ArrayList();
        for (IChangeSetLinkSummary summary : missing) {
            linkHandles.addAll(summary.getLinks());
        }
        List links = repoSource.itemManager().fetchCompleteItems(linkHandles, 0, (IProgressMonitor)progress.newChild(1));
        ArrayList<IURIReference> references = new ArrayList<IURIReference>();
        for (ILink link : links) {
            if (!OslcLinkUtil.isScmOslcLink(link)) continue;
            references.add((IURIReference)link.getTargetRef());
        }
        Map<ITeamRepository, List<IURIReference>> repo2References = OslcLinkUtil.groupByBestRepo(references, repoSource, resolver);
        HashMap<UUID, String> link2Description = new HashMap<UUID, String>();
        Set<Map.Entry<ITeamRepository, List<IURIReference>>> entries = repo2References.entrySet();
        SubMonitor resolveProgress = progress.newChild(1);
        resolveProgress.setWorkRemaining(entries.size());
        for (Map.Entry<ITeamRepository, List<IURIReference>> entry : entries) {
            ITeamRepository repo = entry.getKey();
            List<IURIReference> refs = entry.getValue();
            List<DetailsInfo> infos = OslcLinkUtil.fetchDetails(repo, refs, true, (IProgressMonitor)resolveProgress.newChild(1));
            for (DetailsInfo info : infos) {
                String value = info.description != null ? info.description : info.resolvable.getComment();
                link2Description.put(info.resolvable.getLink().getItemId(), value);
            }
        }
        block5: for (IChangeSetLinkSummary summary : missing) {
            boolean found = false;
            for (ILinkHandle link : summary.getLinks()) {
                String description = (String)link2Description.get(link.getItemId());
                if (description != null) {
                    result.add(new ChangeSetLinkSummary(summary.getChangeSet(), summary.getLinks(), description));
                    found = true;
                    continue block5;
                }
                if (found) continue;
                result.add(summary);
            }
        }
        return result;
    }

    public static String getDescription(Object resolve) {
        if (resolve instanceof ResourcePreview) {
            ResourcePreview details = (ResourcePreview)resolve;
            XMLString title = details.getTitle();
            return title != null ? title.getPlainText() : null;
        }
        if (resolve instanceof IItem) {
            return ChangeSetLinks.describe((IItem)((IItem)resolve));
        }
        return null;
    }

    public static URI getIconUri(Object resolve) {
        if (resolve instanceof ResourcePreview) {
            ResourcePreview details = (ResourcePreview)resolve;
            return details.getIconURI();
        }
        return null;
    }

    public static void createOslcCMBacklink(ITeamRepository repo, IChangeSetHandle changeSet, IWorkspaceHandle workspace, ITeamRepository uriRepo, URI uri, IProgressMonitor monitor) throws TeamRepositoryException {
        URI collrefURI;
        Document document;
        DocumentBuilder builder;
        DocumentBuilderFactory factory;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        try {
            factory = XMLUtil.getSecureDocumentBuilderFactory();
        }
        catch (ParserConfigurationException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        URI csResourceUri = OslcLinkUtil.getWebURL(repo, changeSet, workspace);
        IChangeSet cs = (IChangeSet)repo.itemManager().fetchCompleteItem((IItemHandle)changeSet, 0, (IProgressMonitor)progress.newChild(1));
        ITeamRepository proxyRepo = uriRepo != null ? uriRepo : repo;
        RESTClient client = new RESTClient((IClientLibraryContext)proxyRepo);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("ACCEPT", "application/x-oslc-cm-change-request+xml");
        ITeamRawRestServiceClient.IRawRestClientConnection.Response response = client.performGET(uri, headers, "error message", (IProgressMonitor)progress.newChild(1));
        try {
            document = builder.parse(response.getResponseStream());
        }
        catch (SAXException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        NodeList nodeList = document.getElementsByTagName(CALM_TRACK_CHANGES_NODE);
        if (nodeList.getLength() != 1) {
            throw new TeamRepositoryException("Missing element calm:tracksChanges");
        }
        Element relatedChangeManagementElement = (Element)nodeList.item(0);
        String collref = relatedChangeManagementElement.getAttribute("oslc_cm:collref");
        try {
            collrefURI = new URI(collref);
        }
        catch (URISyntaxException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        String template = "<oslc_cm:relatedChangeManagement {0} rdf:resource=\"{1}\" oslc_cm:label=\"{2}\"/>";
        String namespaces = "xmlns:dc=\"http://purl.org/dc/terms/\" xmlns:oslc_cm=\"http://open-services.net/xmlns/cm/1.0/\"  xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"";
        String comment = cs.getComment();
        String scmURI = csResourceUri.toString();
        String newLink = NLS.bind((String)template, (Object[])new Object[]{namespaces, scmURI, comment});
        headers = new HashMap();
        headers.put("ACCEPT", "text/xml");
        headers.put("Content-Type", "application/x-oslc-cm-change-request+xml");
        client.performPOST(collrefURI, headers, newLink, "error message", (IProgressMonitor)progress.newChild(1));
    }

    public static BacklinkResult removeOslcCMBacklink(ITeamRepository repo, IChangeSetHandle changeSet, ITeamRepository uriRepo, URI oslcCMResourceURI, IProgressMonitor monitor) throws TeamRepositoryException {
        String content;
        URI collrefURI;
        Document document;
        DocumentBuilder builder;
        DocumentBuilderFactory factory;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            factory = XMLUtil.getSecureDocumentBuilderFactory();
        }
        catch (ParserConfigurationException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        ITeamRepository friendRepo = uriRepo != null ? uriRepo : repo;
        RESTClient client = new RESTClient((IClientLibraryContext)friendRepo);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("ACCEPT", "application/x-oslc-cm-change-request+xml");
        ITeamRawRestServiceClient.IRawRestClientConnection.Response response = client.performGET(oslcCMResourceURI, headers, "error message", (IProgressMonitor)progress.newChild(1));
        try {
            document = builder.parse(response.getResponseStream());
        }
        catch (SAXException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        NodeList nodeList = document.getElementsByTagName(CALM_TRACK_CHANGES_NODE);
        if (nodeList.getLength() != 1) {
            return BacklinkResult.NOT_FOUND;
        }
        Element relatedChangeManagementElement = (Element)nodeList.item(0);
        String collref = relatedChangeManagementElement.getAttribute("oslc_cm:collref");
        try {
            collrefURI = new URI(collref);
        }
        catch (URISyntaxException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        response = client.performGET(collrefURI, headers, "error message", (IProgressMonitor)progress.newChild(1));
        try {
            document = builder.parse(response.getResponseStream());
        }
        catch (SAXException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        nodeList = document.getElementsByTagName("rtc_cm:Reference");
        if (nodeList.getLength() == 0) {
            nodeList = document.getElementsByTagName(CALM_TRACK_CHANGES_NODE);
        }
        ArrayList<Element> backLinks = new ArrayList<Element>();
        String csResourceUri = OslcLinkUtil.getWebURL(repo, changeSet, null).toString();
        int i = 0;
        while (i < nodeList.getLength()) {
            Element link = (Element)nodeList.item(i);
            String uri = link.getAttribute("rdf:resource");
            if (OslcLinkUtil.isMatch(csResourceUri, uri)) {
                backLinks.add(link);
                link.getParentNode().removeChild(link);
            }
            ++i;
        }
        if (backLinks.isEmpty()) {
            return BacklinkResult.NOT_FOUND;
        }
        try {
            content = OslcLinkUtil.xmlNodeToString(document);
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        headers = new HashMap();
        headers.put("ACCEPT", "text/xml");
        headers.put("Content-Type", "application/x-oslc-cm-change-request+xml");
        client.performPUT(collrefURI, headers, content, "error message", (IProgressMonitor)progress.newChild(1));
        return BacklinkResult.SUCCESS;
    }

    private static boolean isMatch(String expected, String actual) {
        Parsed expectedParsed = OslcLinkUtil.get(expected);
        Parsed actualParsed = OslcLinkUtil.get(actual);
        if (expectedParsed.changeSetId == null || actualParsed.changeSetId == null) {
            return actual.startsWith(expected);
        }
        return expectedParsed.changeSetId.equals(actualParsed.changeSetId);
    }

    public static boolean hasOslcCMBacklink(ITeamRepository uriRepo, URI oslcCMResourceURI, ITeamRepository repo, IChangeSetHandle changeSet, IWorkspaceHandle workspace, IProgressMonitor monitor) throws TeamRepositoryException {
        URI collrefURI;
        Document document;
        DocumentBuilder builder;
        DocumentBuilderFactory factory;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        try {
            factory = XMLUtil.getSecureDocumentBuilderFactory();
        }
        catch (ParserConfigurationException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        String csResourceUri = OslcLinkUtil.getWebURL(repo, changeSet, workspace).toString();
        RESTClient client = new RESTClient((IClientLibraryContext)uriRepo);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("ACCEPT", "application/x-oslc-cm-change-request+xml");
        ITeamRawRestServiceClient.IRawRestClientConnection.Response response = client.performGET(oslcCMResourceURI, headers, "error message", (IProgressMonitor)progress.newChild(1));
        try {
            document = builder.parse(response.getResponseStream());
        }
        catch (SAXException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        NodeList nodeList = document.getElementsByTagName(CALM_TRACK_CHANGES_NODE);
        if (nodeList.getLength() != 1) {
            return false;
        }
        Element relatedChangeManagementElement = (Element)nodeList.item(0);
        String collref = relatedChangeManagementElement.getAttribute("oslc_cm:collref");
        try {
            collrefURI = new URI(collref);
        }
        catch (URISyntaxException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        response = client.performGET(collrefURI, headers, "error message", (IProgressMonitor)progress.newChild(1));
        try {
            document = builder.parse(response.getResponseStream());
        }
        catch (SAXException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        nodeList = document.getElementsByTagName("rtc_cm:Reference");
        int i = 0;
        while (i < nodeList.getLength()) {
            Element link = (Element)nodeList.item(i);
            String uri = link.getAttribute("rdf:resource");
            if (csResourceUri.equals(uri)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static URI getWebURL(ITeamRepository repo, IChangeSetHandle changeSetHandle, IWorkspaceHandle workspace) {
        String repoURI = repo.publicUriRoot();
        if (repoURI == null) {
            repoURI = repo.getRepositoryURI();
        }
        try {
            URI result = ChangeSetLocationFactory.createChangeSetWebURL((IChangeSetHandle)changeSetHandle, (IWorkspaceHandle)workspace, (String)repoURI, null);
            return result;
        }
        catch (TeamRepositoryException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static URI convertToLegacyResourceUri(URI oslcScmResourceUri) throws URISyntaxException {
        String path = oslcScmResourceUri.getPath();
        String[] segments = path.split("/");
        String changeSetId = null;
        String workspaceId = null;
        String OSLC_SCM_SEGMENT = OSLC_SCM_SEGMENT;
        String OSLC_SCM_WORKSPACE_SEGMENT = OSLC_SCM_WORKSPACE_SEGMENT;
        String OSLC_SCM_CHANGESET_SEGMENT = OSLC_SCM_CHANGESET_SEGMENT;
        boolean foundOslcScmSegment = false;
        int i = 0;
        while (i < segments.length) {
            if (!foundOslcScmSegment && segments[i].equals(OSLC_SCM_SEGMENT)) {
                foundOslcScmSegment = true;
            }
            if (foundOslcScmSegment && workspaceId == null && segments[i].equals(OSLC_SCM_WORKSPACE_SEGMENT)) {
                if (i == segments.length - 1) {
                    return null;
                }
                workspaceId = segments[i + 1];
                ++i;
            }
            if (foundOslcScmSegment && changeSetId == null && segments[i].equals(OSLC_SCM_CHANGESET_SEGMENT)) {
                if (i == segments.length - 1) {
                    return null;
                }
                changeSetId = segments[i + 1];
                ++i;
                break;
            }
            ++i;
        }
        if (workspaceId == null || changeSetId == null) {
            return null;
        }
        String result = NLS.bind((String)"resource/itemOid/com.ibm.team.scm.ChangeSet/{0}?workspace=itemOid/com.ibm.team.scm.Workspace/{1}", changeSetId, workspaceId);
        String webUrlString = oslcScmResourceUri.toString();
        int prefix = webUrlString.indexOf(OSLC_SCM_SEGMENT);
        result = String.valueOf(webUrlString.substring(0, prefix)) + result;
        return new URI(result);
    }

    public static String xmlNodeToString(Node node) throws Exception {
        DOMSource source = new DOMSource(node);
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.transform(source, result);
        return sw.getBuffer().toString();
    }

    public static ITeamRepository findTeamRepository(URI oslcResourceUri) {
        return ClientURIUtils.findTeamRepository((URI)oslcResourceUri);
    }

    public static URI convertToLegacyWebUrl(URI webUrl) throws URISyntaxException {
        Parsed ids = OslcLinkUtil.get(webUrl.toString());
        if (ids.changeSetId == null) {
            return null;
        }
        String webUrlString = webUrl.toString();
        int prefix = webUrlString.indexOf(OSLC_SCM_SEGMENT);
        StringBuffer buf = new StringBuffer(webUrlString.substring(0, prefix));
        buf.append("resource/itemOid/com.ibm.team.scm.ChangeSet/");
        buf.append(ids.changeSetId);
        if (ids.workspaceId != null) {
            buf.append("?workspace=itemOid/com.ibm.team.scm.Workspace/");
            buf.append(ids.workspaceId);
        }
        String string = buf.toString();
        URI result = new URI(string);
        return result;
    }

    private static Parsed get(String uriString) {
        Parsed result = new Parsed();
        String[] segments = uriString.split("/");
        boolean foundOslcScmSegment = false;
        int i = 0;
        while (i < segments.length) {
            if (!foundOslcScmSegment && segments[i].equals(OSLC_SCM_SEGMENT)) {
                foundOslcScmSegment = true;
            }
            if (foundOslcScmSegment && result.workspaceId == null && segments[i].equals(OSLC_SCM_WORKSPACE_SEGMENT)) {
                if (i == segments.length - 1) break;
                result.workspaceId = segments[i + 1];
                ++i;
            }
            if (foundOslcScmSegment && result.changeSetId == null && segments[i].equals(OSLC_SCM_CHANGESET_SEGMENT)) {
                if (i == segments.length - 1) break;
                result.changeSetId = segments[i + 1];
                ++i;
            }
            ++i;
        }
        return result;
    }

    public static enum BacklinkResult {
        SUCCESS,
        NOT_FOUND;

    }

    static class ChangeSetLinkSummary
    implements IChangeSetLinkSummary {
        IChangeSetHandle changeSet;
        List<ILinkHandle> links;
        String summary;

        private ChangeSetLinkSummary(IChangeSetHandle changeSet, List<ILinkHandle> links, String summary) {
            this.changeSet = changeSet;
            this.links = links;
            this.summary = summary;
        }

        public IChangeSetHandle getChangeSet() {
            return this.changeSet;
        }

        public List<ILinkHandle> getLinks() {
            return this.links;
        }

        public String getSummary() {
            return this.summary;
        }

        public List<String> getPlannedForNames() {
            return Collections.EMPTY_LIST;
        }
    }

    public static class DetailsInfo {
        public IURIReference unresolved;
        public IReference resolvable;
        public IReference resolved;
        public String description;
    }

    public static class OslcRepositoryInfo {
        public String repositoryURI;
        public String repoId;
    }

    static class Parsed {
        String workspaceId;
        String changeSetId;

        Parsed() {
        }
    }

    public static class ResourceURIInfo {
        public ITeamRepository repo;
        public OslcRepositoryInfo repoInfo;
        public URI uri;
        public String label;
    }
}

