/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.api.content;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.api.content.MagicContentExaminer;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SniffContentExaminer {
    public static final byte[] BOM_UTF_8 = new byte[]{-17, -69, -65};
    public static final byte[] BOM_UTF_16BE = new byte[]{-2, -1};
    public static final byte[] BOM_UTF_16LE = new byte[]{-1, -2};
    private static final byte[] XML_TEXT_DECL_ASCII = new byte[]{60, 63, 120, 109, 108};
    private static final String ASCII_ENCODING = "ASCII";
    private static final String UTF_32_NO_ENDIAN = "UTF-32";
    private static final String UTF_16_NO_ENDIAN = "UTF-16";
    private static final Pattern XML_ENCODING_PATTERN = Pattern.compile("^<\\?xml.*encoding=\"([^\"]+)\"");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String sniffEncoding(MagicContentExaminer.IStreamSource data) throws FileSystemException {
        InputStream input = data.getStream();
        if (input == null) {
            return null;
        }
        try {
            byte[] buffer = new byte[5];
            int len = 0;
            int offset = 0;
            int max = buffer.length;
            while (true) {
                if (len == -1 || offset >= buffer.length) {
                    if (!SniffContentExaminer.startsWith(buffer, offset, BOM_UTF_8)) break;
                    return "UTF-8";
                }
                len = input.read(buffer, offset, max);
                if (len == -1) continue;
                offset += len;
                max -= len;
            }
            if (SniffContentExaminer.startsWith(buffer, offset, BOM_UTF_16BE)) {
                return "UTF-16BE";
            }
            if (SniffContentExaminer.startsWith(buffer, offset, BOM_UTF_16LE) && offset > 2 && buffer[2] != 0) {
                return "UTF-16LE";
            }
            if (SniffContentExaminer.startsWith(buffer, offset, XML_TEXT_DECL_ASCII)) {
                String string = SniffContentExaminer.sniffXMLEncoding(buffer, offset, input);
                return string;
            }
            String string = this.sniffEncoding(buffer, offset, input);
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected String sniffEncoding(byte[] buffer, int offset, InputStream input) {
        return null;
    }

    private static String sniffXMLEncoding(byte[] existingBuffer, int bufferSize, InputStream input) {
        byte[] declBuffer = new byte[76];
        System.arraycopy(existingBuffer, 0, declBuffer, 0, bufferSize);
        int declSize = -1;
        int max = 76 - bufferSize;
        int len = 0;
        try {
            while (len != -1 && bufferSize < max) {
                len = input.read(declBuffer, bufferSize, max - bufferSize);
                if (len == -1) continue;
                int newBufferSize = bufferSize + len;
                int pos = bufferSize;
                while (pos < newBufferSize) {
                    if (declBuffer[pos] == 62) {
                        declSize = pos + 1;
                        break;
                    }
                    ++pos;
                }
                if (declSize == -1) {
                    bufferSize += len;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            return null;
        }
        if (declSize == -1 || declSize < 35) {
            return null;
        }
        String textDeclaration = null;
        try {
            textDeclaration = new String(declBuffer, 0, declSize, ASCII_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        Matcher m = XML_ENCODING_PATTERN.matcher(textDeclaration);
        if (!m.find()) {
            return null;
        }
        String encoding = m.group(1);
        if (UTF_16_NO_ENDIAN.equals(encoding) || UTF_32_NO_ENDIAN.equals(encoding)) {
            return null;
        }
        return encoding;
    }

    private static boolean startsWith(byte[] buffer, int size, byte[] bom) {
        if (size < bom.length) {
            return false;
        }
        int i = 0;
        while (i < bom.length) {
            if (buffer[i] != bom[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

