/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.LinkInfo;
import com.ibm.team.filesystem.client.internal.LinkType;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.api.storage.IBackupHandler;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.scm.common.ContentHash;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class Shed {
    private BackupDilemmaHandler problemHandler;
    private boolean backupEnabled;
    private Map<ILocation, IBackupHandler> sheds;

    public Shed(BackupDilemmaHandler backupDilemmaHandler) {
        this.problemHandler = backupDilemmaHandler == null ? BackupDilemmaHandler.getDefault() : backupDilemmaHandler;
        this.backupEnabled = this.problemHandler.backupEnabled();
        this.sheds = new HashMap<ILocation, IBackupHandler>();
    }

    public void forceBackup(final Shareable shareable, IProgressMonitor monitor) throws FileSystemException {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        SharingManager.getInstance().doSilentChange(new SharingManager.FileSystemAccessor(){

            @Override
            public void run() throws FileSystemException {
                boolean backedUp = Shed.this.backup(shareable, (IProgressMonitor)progress.newChild(50));
                if (!backedUp) {
                    IFileStorage storage = shareable.getFileStorage();
                    storage.preserveHistory((IProgressMonitor)progress.newChild(50));
                }
            }
        });
    }

    public boolean backupIfDirty(final Shareable shareable, final IProgressMonitor monitor) throws FileSystemException {
        final boolean[] backupResult = new boolean[1];
        if (this.backupEnabled) {
            SharingManager.getInstance().doSilentChange(new SharingManager.FileSystemAccessor(){

                @Override
                public void run() throws FileSystemException {
                    backupResult[0] = Shed.this.backup(shareable, monitor);
                }
            });
        }
        return backupResult[0];
    }

    private boolean backup(Shareable shareable, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IBackupHandler shedDelegate = this.getShed(shareable.getSandbox());
        if (!shedDelegate.supportsShedBackup()) {
            return false;
        }
        boolean dirty = false;
        try {
            ResourceType resourceType = shareable.getResourceType((IProgressMonitor)progress.newChild(1));
            FileItemInfo info = shareable.getFileItemInfo((IProgressMonitor)progress.newChild(1));
            if (resourceType == ResourceType.FILE) {
                if (info == null || !info.isFile() || info.isContentChanged()) {
                    dirty = true;
                } else {
                    long size = shareable.getFileStorage().getSize((IProgressMonitor)progress.newChild(1));
                    if (size != -1L && info.getContentLength() != shareable.getFileStorage().getSize((IProgressMonitor)progress.newChild(1))) {
                        dirty = true;
                    } else if (shareable.getFileStorage().getModificationStamp() > info.getLastContentChangeCheckStamp()) {
                        dirty = true;
                    }
                }
            } else if (resourceType == ResourceType.FOLDER) {
                Collection<IFileStorage> children = shareable.getFileStorage().getChildren(true, (IProgressMonitor)progress.newChild(1));
                if (children != null && children.size() != 0) {
                    dirty = true;
                }
            } else if (resourceType == ResourceType.SYMBOLIC_LINK) {
                if (info == null || info.isContentChanged() || !info.isSymbolicLink()) {
                    dirty = true;
                } else {
                    LinkInfo linkInfo = shareable.getFileStorage().getLinkInfo((IProgressMonitor)progress.newChild(1));
                    String linkTarget = linkInfo.getTarget();
                    LinkType linkType = linkInfo.getType();
                    if (linkTarget == null) {
                        dirty = true;
                    } else {
                        ContentHash code = FileItemInfoProxy.getLinkTargetHash(linkTarget);
                        if (!code.equals((Object)info.getHash()) || linkType != LinkType.NONE && info.isDirectoryLink() != (linkType == LinkType.DIRECTORY)) {
                            dirty = true;
                        }
                    }
                }
            }
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        if (!dirty) {
            dirty = shareable.getFileStorage().requiresBackup((IProgressMonitor)progress.newChild(1));
        }
        if (dirty) {
            shareable.getFileStorage().backup(shedDelegate, this.problemHandler, (IProgressMonitor)progress.newChild(98));
        }
        return dirty;
    }

    public void backupInShed(Shareable itemToBackup, IProgressMonitor monitor) throws FileSystemException {
        IBackupHandler shedDelegate = this.getShed(itemToBackup.getSandbox());
        shedDelegate.backupInShed(itemToBackup, monitor);
    }

    private IBackupHandler getShed(ISandbox sandbox) {
        IBackupHandler delegate = this.sheds.get(sandbox.getRoot());
        if (delegate == null) {
            delegate = SharingManager.getInstance().getShed(sandbox, this.problemHandler);
            this.sheds.put(sandbox.getRoot(), delegate);
        }
        return delegate;
    }
}

