/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.ItemHandleHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

public class SharingDescriptor
implements ISharingDescriptor,
Serializable {
    private static final int METADATA_VERSION3 = 3;
    private static final int METADATA_VERSION4 = 4;
    private static final int METADATA_VERSION5 = 5;
    private static final UUID UNKNOWN_CONFIGURATION_STATE_UUID = UUID.valueOf((String)"_R9t0ULhfEduBzK-rvZth-A");
    private static final UUID NEW_CONFIGURATION_STATE_UUID = UUID.valueOf((String)"_EHcPcCUoEdyQ476u2X18-Q");
    private static final long serialVersionUID = 7918534741066530000L;
    private String repositoryUri;
    private UUID repoId;
    private transient IContextHandle connectionHandle;
    private transient IComponentHandle component;
    private transient IVersionableHandle rootVersionable;
    private transient IFolderHandle loadRoot;
    private String connectionName;
    private String componentName;
    private ISyncTime configurationState;
    private int flags;
    private Map<String, byte[]> clientData;
    private static final int UNKNOWN_CONFIG_STATE = 1;
    private static final int FILE_ROOT = 2;
    private static final int LINK_ROOT = 4;
    private static final int HAS_LOAD_ROOT = 8;
    private static final int HAS_CLIENT_DATA = 16;

    public static SharingDescriptor create(IConnection connection, IComponent component, IVersionableHandle versionable) {
        return SharingDescriptor.create(connection, component, versionable, null, null, ISyncTime.TIME_NONE);
    }

    public static SharingDescriptor create(IConnection connection, IComponent component, IVersionableHandle versionable, ISyncTime componentSyncState) {
        return SharingDescriptor.create(connection, component, versionable, null, null, componentSyncState);
    }

    public static SharingDescriptor create(IConnection connection, IComponent component, IVersionableHandle versionable, ISyncTime componentSyncState, Map<String, byte[]> clientData) {
        return SharingDescriptor.create(connection, component, versionable, null, clientData, componentSyncState);
    }

    public static SharingDescriptor create(IConnection connection, IComponent component, IVersionableHandle versionable, Map<String, byte[]> clientData) {
        return SharingDescriptor.create(connection, component, versionable, null, clientData, ISyncTime.TIME_NONE);
    }

    public static SharingDescriptor create(IConnection connection, IComponent component, IVersionableHandle versionable, IFolderHandle loadRoot, Map<String, byte[]> clientData) {
        return SharingDescriptor.create(connection, component, versionable, loadRoot, clientData, ISyncTime.TIME_NONE);
    }

    public static SharingDescriptor create(IConnection connection, IComponent component, IVersionableHandle versionable, IFolderHandle loadRoot, Map<String, byte[]> clientData, ISyncTime componentSyncState) {
        Assert.isLegal((connection instanceof IWorkspaceConnection || connection instanceof IBaselineConnection ? 1 : 0) != 0);
        IBaselineHandle connectionHandle = connection instanceof IBaselineConnection ? ((IBaselineConnection)connection).getBaseline() : ((IWorkspaceConnection)connection).getResolvedWorkspace();
        ITeamRepository repo = connection.teamRepository();
        return new SharingDescriptor(repo.getRepositoryURI(), repo.getId(), (IContextHandle)connectionHandle, connection.getName(), (IComponentHandle)component.getItemHandle(), component.getName(), versionable, loadRoot, clientData, componentSyncState);
    }

    public SharingDescriptor(String repositoryUri, UUID repoId, IContextHandle connectionHandle, String connectionName, IComponentHandle component, String componentName, IVersionableHandle rootItem, IFolderHandle loadRoot, Map<String, byte[]> additionalInfo) {
        this(repositoryUri, repoId, connectionHandle, connectionName, component, componentName, rootItem, loadRoot, additionalInfo, ISyncTime.TIME_NONE);
    }

    public SharingDescriptor(ISharingDescriptor desc, String connectionName, String componentName) {
        this(((SharingDescriptor)desc).getRepositoryUri(), desc.getRepositoryId(), desc.getConnectionHandle(), connectionName, desc.getComponent(), componentName, desc.getRootVersionable(), desc.getReloadRoot().sameItemId((IItemHandle)desc.getRootVersionable()) ? null : (IFolderHandle)desc.getReloadRoot(), ((SharingDescriptor)desc).getClientData(), ((SharingDescriptor)desc).configurationState);
    }

    private SharingDescriptor(String repositoryUri, UUID repoId, IContextHandle connectionHandle, String connectionName, IComponentHandle component, String componentName, IVersionableHandle rootItem, IFolderHandle loadRoot, Map<String, byte[]> additionalInfo, ISyncTime configurationState) {
        Assert.isNotNull((Object)repositoryUri);
        Assert.isNotNull((Object)repoId);
        Assert.isNotNull((Object)component);
        Assert.isNotNull((Object)componentName);
        Assert.isNotNull((Object)rootItem);
        Assert.isNotNull((Object)connectionName);
        Assert.isNotNull((Object)connectionHandle);
        Assert.isNotNull((Object)configurationState);
        Assert.isLegal((connectionHandle instanceof IWorkspaceHandle || connectionHandle instanceof IBaselineHandle ? 1 : 0) != 0);
        this.repositoryUri = repositoryUri;
        this.repoId = repoId;
        this.connectionHandle = connectionHandle.hasFullState() ? (IContextHandle)connectionHandle.getItemType().createItemHandle(connectionHandle.getItemId(), connectionHandle.getStateId()) : connectionHandle;
        this.connectionName = connectionName;
        this.component = component.hasFullState() ? (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(component.getItemId(), component.getStateId()) : component;
        this.componentName = componentName;
        this.rootVersionable = rootItem.hasFullState() ? (IVersionableHandle)rootItem.getItemType().createItemHandle(rootItem.getItemId(), rootItem.getStateId()) : rootItem;
        if (loadRoot != null && !loadRoot.sameItemId((IItemHandle)rootItem)) {
            this.loadRoot = loadRoot.hasFullState() ? (IFolderHandle)loadRoot.getItemType().createItemHandle(loadRoot.getItemId(), null) : loadRoot;
        }
        this.flags = 0;
        this.configurationState = configurationState;
        if (configurationState.equals(ISyncTime.TIME_NONE)) {
            this.flags |= 1;
        }
        if (rootItem instanceof IFileItemHandle) {
            this.flags |= 2;
        } else if (rootItem instanceof ISymbolicLinkHandle) {
            this.flags |= 4;
        }
        this.clientData = additionalInfo;
        if (this.clientData != null) {
            this.flags |= 0x10;
        }
        if (this.loadRoot != null) {
            this.flags |= 8;
        }
    }

    public SharingDescriptor(ISharingDescriptor descriptor, ISyncTime newConfigurationState) {
        if (descriptor == null) {
            throw new IllegalArgumentException();
        }
        if (newConfigurationState == null) {
            throw new IllegalArgumentException();
        }
        this.component = descriptor.getComponent();
        this.componentName = descriptor.getComponentName();
        this.configurationState = newConfigurationState;
        this.connectionHandle = descriptor.getConnectionHandle();
        this.connectionName = descriptor.getConnectionName();
        this.repoId = descriptor.getRepositoryId();
        this.repositoryUri = ((SharingDescriptor)descriptor).getRepositoryUri();
        this.rootVersionable = descriptor.getRootVersionable();
        this.loadRoot = descriptor.getReloadRoot().sameItemId((IItemHandle)descriptor.getRootVersionable()) ? null : (IFolderHandle)descriptor.getReloadRoot();
        this.clientData = ((SharingDescriptor)descriptor).getClientData();
        if (this.rootVersionable instanceof IFileItemHandle) {
            this.flags = 2;
        } else if (this.rootVersionable instanceof ISymbolicLinkHandle) {
            this.flags = 4;
        }
        if (this.clientData != null) {
            this.flags |= 0x10;
        }
        if (this.loadRoot != null) {
            this.flags |= 8;
        }
        this.setConfigurationState(newConfigurationState);
    }

    private void setConfigurationState(ISyncTime newConfigurationState) {
        this.flags = newConfigurationState.equals(ISyncTime.TIME_NONE) ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        this.configurationState = newConfigurationState;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version != 5 && version != 4 && version != 3) {
            throw new ClassNotFoundException(NLS.bind((String)Messages.SharingDescriptor_0, (Object[])new Object[]{version, 4}, (Object[])new Object[0]));
        }
        this.repositoryUri = in.readUTF();
        this.repoId = UUID.valueOf((String)in.readUTF());
        this.component = (IComponentHandle)ItemHandleHelper.fromString(IComponent.ITEM_TYPE, in.readUTF());
        this.componentName = in.readUTF();
        IItemType connectionType = in.readBoolean() ? IBaseline.ITEM_TYPE : IWorkspace.ITEM_TYPE;
        this.connectionHandle = (IContextHandle)ItemHandleHelper.fromString(connectionType, in.readUTF());
        this.connectionName = in.readUTF();
        String rootItemId = null;
        rootItemId = in.readUTF();
        if (version == 3) {
            this.configurationState = this.getConfigState(in.readUTF());
        } else {
            this.configurationState = ISyncTime.FACTORY.createFrom(in.readUTF());
            this.flags = in.readInt();
        }
        this.rootVersionable = (this.flags & 2) == 2 ? (IFileItemHandle)ItemHandleHelper.fromString(IFileItem.ITEM_TYPE, rootItemId) : ((this.flags & 4) == 4 ? (ISymbolicLinkHandle)ItemHandleHelper.fromString(ISymbolicLink.ITEM_TYPE, rootItemId) : (IFolderHandle)ItemHandleHelper.fromString(IFolder.ITEM_TYPE, rootItemId));
        if ((this.flags & 8) == 8) {
            this.loadRoot = (IFolderHandle)ItemHandleHelper.fromString(IFolder.ITEM_TYPE, in.readUTF());
        }
        if ((this.flags & 0x10) == 16) {
            int count = in.readShort();
            this.clientData = new HashMap<String, byte[]>(count);
            int i = 0;
            while (i < count) {
                String namespace = in.readUTF();
                short size = in.readShort();
                byte[] info = new byte[size];
                in.readFully(info);
                this.clientData.put(namespace, info);
                ++i;
            }
        }
    }

    private ISyncTime getConfigState(String uuidStr) {
        if (uuidStr.equals(NEW_CONFIGURATION_STATE_UUID.getUuidValue())) {
            this.flags = 1;
            this.configurationState = ISyncTime.TIME_NONE;
        } else if (uuidStr.equals(UNKNOWN_CONFIGURATION_STATE_UUID.getUuidValue())) {
            this.flags = 1;
            this.configurationState = ISyncTime.TIME_NONE;
        }
        return ISyncTime.FACTORY.convertFromUUID(UUID.valueOf((String)uuidStr));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(5);
        out.writeUTF(this.repositoryUri);
        out.writeUTF(this.repoId.getUuidValue());
        out.writeUTF(ItemHandleHelper.toString((IItemHandle)this.component));
        out.writeUTF(this.componentName);
        out.writeBoolean(this.connectionHandle.getItemType() == IBaseline.ITEM_TYPE);
        out.writeUTF(ItemHandleHelper.toString((IItemHandle)this.connectionHandle));
        out.writeUTF(this.connectionName);
        out.writeUTF(ItemHandleHelper.toString((IItemHandle)this.rootVersionable));
        out.writeUTF(this.configurationState.toString());
        out.writeInt(this.flags);
        if (this.loadRoot != null) {
            out.writeUTF(ItemHandleHelper.toString((IItemHandle)this.loadRoot));
        }
        if (this.clientData != null) {
            out.writeShort(this.clientData.size());
            for (Map.Entry<String, byte[]> entry : this.clientData.entrySet()) {
                out.writeUTF(entry.getKey());
                byte[] info = entry.getValue();
                out.writeShort(info.length);
                out.write(info);
            }
        }
    }

    @Override
    public IComponentHandle getComponent() {
        return this.component;
    }

    @Override
    public IVersionableHandle getRootVersionable() {
        return this.rootVersionable;
    }

    @Override
    public IContextHandle getConnectionHandle() {
        return this.connectionHandle;
    }

    public String getRepositoryUri() {
        return this.repositoryUri;
    }

    @Override
    public UUID getRepositoryId() {
        return this.repoId;
    }

    @Override
    public boolean associatedWithWorkspace() {
        return this.connectionHandle instanceof IWorkspaceHandle;
    }

    @Override
    public boolean isAssociatedWithConnection(IConnection connection) {
        if (connection instanceof IWorkspaceConnection) {
            return ((IWorkspaceConnection)connection).getResolvedWorkspace().sameItemId((IItemHandle)this.getConnectionHandle());
        }
        return ((IBaselineConnection)connection).getBaseline().sameItemId((IItemHandle)this.getConnectionHandle());
    }

    public boolean equals(Object obj) {
        boolean same;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SharingDescriptor)) {
            return false;
        }
        SharingDescriptor another = (SharingDescriptor)obj;
        boolean bl = same = this.repoId.equals((Object)another.repoId) && this.rootVersionable.sameItemId((IItemHandle)another.rootVersionable) && this.component.sameItemId((IItemHandle)another.component) && this.connectionHandle.sameItemId((IItemHandle)another.connectionHandle);
        if (!same) {
            return false;
        }
        if (this.loadRoot == null && another.loadRoot != this.loadRoot) {
            return false;
        }
        if (this.loadRoot != null && !this.loadRoot.sameItemId((IItemHandle)another.loadRoot)) {
            return false;
        }
        Map<String, byte[]> extra1 = this.getClientData();
        Map<String, byte[]> extra2 = another.getClientData();
        if (extra1 == null && extra2 == null) {
            return true;
        }
        if (extra1 == null || extra2 == null || extra1.size() != extra2.size()) {
            return false;
        }
        for (String namespace : extra1.keySet()) {
            byte[] v2;
            byte[] v1 = extra1.get(namespace);
            if (Arrays.equals(v1, v2 = extra2.get(namespace))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.rootVersionable.getItemId().hashCode() ^ this.connectionHandle.getItemId().hashCode() ^ this.component.getItemId().hashCode() ^ this.repoId.hashCode();
    }

    @Override
    public String getConnectionName() {
        return this.connectionName;
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    public ISyncTime getConfigurationState() {
        return this.configurationState;
    }

    public boolean isUnknownState() {
        return (this.flags & 1) == 1;
    }

    public Map<String, byte[]> getClientData() {
        return this.clientData;
    }

    @Override
    public IVersionableHandle getReloadRoot() {
        if (this.loadRoot == null) {
            return this.rootVersionable;
        }
        return this.loadRoot;
    }

    @Override
    public byte[] getClientData(String namespace) {
        if (this.clientData != null) {
            return this.clientData.get(namespace);
        }
        return null;
    }
}

