/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.IFileOptions;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.MetadataProperties;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ComponentLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.ContentHashAlgorithmException;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class RestoreVersionableOperation {
    private RestoreVersionableOperation() {
    }

    public static void restoreFile(IShareable file, InputStream in, IFileOptions fileOptions, IVersionableHandle handle, IProgressMonitor monitor) throws FileSystemException, IOException {
        if (in == null) {
            throw new NullPointerException();
        }
        try {
            try {
                Shareable shareable;
                Shareable parentShareable;
                if (file == null) {
                    throw new NullPointerException();
                }
                if (handle == null) {
                    throw new NullPointerException();
                }
                if (handle.getItemId() == null) {
                    throw new NullPointerException();
                }
                if (!(handle instanceof IFileItemHandle)) {
                    throw new IllegalArgumentException("Cannot give a file a versionable of type " + handle.getItemType().getName());
                }
                if (handle.hasStateId() || handle.hasFullState()) {
                    handle = (IVersionableHandle)handle.getItemType().createItemHandle(handle.getItemId(), null);
                }
                if ((parentShareable = (Shareable)(shareable = (Shareable)file).getParent()) == null) {
                    throw new IllegalArgumentException("Cannot restore file at " + shareable.getLocalPath() + " outside of share");
                }
                IFileStorage parent = parentShareable.getFileStorage();
                if (parent == null) {
                    throw new IllegalArgumentException("Cannot restore file at " + shareable.getLocalPath() + " outside of share");
                }
                IFileStorage storage = shareable.getFileStorage();
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                LockData lock = RestoreVersionableOperation.lockTree(parent, (IProgressMonitor)progress.newChild(5));
                if (lock == null) {
                    throw new IllegalArgumentException(shareable.getLocalPath() + " is not in a shared location");
                }
                try {
                    FileItemInfo info;
                    if (shareable.exists((IProgressMonitor)progress.newChild(1))) {
                        throw new IllegalArgumentException(shareable.getLocalPath() + " already exists");
                    }
                    ResourceType parentType = parentShareable.getResourceType((IProgressMonitor)progress.newChild(1));
                    if (parentType == null) {
                        throw new IllegalArgumentException("Parent folder " + parent.getShareable().getLocalPath() + " does not exist");
                    }
                    if (parentType != ResourceType.FOLDER) {
                        throw new IllegalArgumentException("Parent " + parent.getShareable().getLocalPath() + " is not a folder");
                    }
                    IShare share = shareable.getShare((IProgressMonitor)progress.newChild(1));
                    if (share.getPath().equals(shareable.getLocalPath())) {
                        throw new IllegalArgumentException("Cannot restore file at share root");
                    }
                    ISharingDescriptor desc = share.getSharingDescriptor();
                    CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(shareable.getCopyFileAreaRoot());
                    if (cfa.isShareRoot((IVersionableHandle)((IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(handle.getItemId(), null)), desc.getComponent(), desc.getConnectionHandle())) {
                        throw new IllegalArgumentException(handle.getItemId() + " already exists");
                    }
                    InverseFileItemInfo existing = cfa.getItemInfo(handle, desc.getComponent(), desc.getConnectionHandle(), false);
                    if (existing != null) {
                        if (existing.getLocalName() != null) {
                            throw new IllegalArgumentException(handle.getItemId() + " already exists");
                        }
                        if (existing.getVersionableHandle().getItemType() != handle.getItemType()) {
                            throw new IllegalArgumentException("Type mismatch, existing: " + existing.getVersionableHandle().getItemType().getName() + ", restoring: " + handle.getItemType().getName());
                        }
                    }
                    SharingManager.getInstance().disableChangeMonitoring();
                    try {
                        storage.create(fileOptions, in, (IProgressMonitor)progress.newChild(60));
                    }
                    finally {
                        SharingManager.getInstance().enableChangeMonitoring();
                    }
                    in = null;
                    if (existing != null) {
                        boolean contentChanged = existing.getVersionableHandle().hasStateId() && (storage.getSize((IProgressMonitor)progress.newChild(1)) != existing.getContentLength() || !ContentHash.valueOf((InputStream)storage.getLocalChangeDetectionStream(fileOptions)).equals((Object)existing.getHash()));
                        info = new FileItemInfo(existing.getVersionableHandle(), contentChanged, storage.getModificationStamp(), existing.getParent(), existing.getName(), existing.isLoadedWithAnotherName(), existing.getHash(), existing.getContentLength(), existing.getOriginalLineDelimiter(), existing.getLineDelimiter(), existing.getOriginalContentType(), existing.getContentType(), existing.getStoredPredecessorHintHash(), existing.getStoredSize(), existing.getStoredEncoding(), existing.getStoredHash(), existing.getStoredNumLineDelimiters(), existing.isOriginalExecutable(), existing.isOriginalExecutable(), existing.isDirectoryLink(), existing.isOriginalDirectoryLink(), existing.getExternalLinks(), existing.getOriginalExternalLinks());
                    } else {
                        info = new FileItemInfo(handle, false, -1L, null, null, false, null, -1L, null, null, null, null, null, -1L, null, null, -1L, false, false, false, false, null, null);
                    }
                    MetadataProperties metadataProperties = new MetadataProperties(Collections.EMPTY_MAP, fileOptions.getProperties(), Collections.EMPTY_SET);
                    ICopyFileArea.PropertyUpdate propertyUpdateDirection = ICopyFileArea.PropertyUpdate.REPLACE_DELTA;
                    cfa.setItemMetaData(shareable.getLocalPath(), info, propertyUpdateDirection, metadataProperties, (IProgressMonitor)progress.newChild(25));
                }
                finally {
                    RestoreVersionableOperation.unlockTree(lock, (IProgressMonitor)progress.newChild(5));
                }
            }
            catch (ContentHashAlgorithmException e) {
                throw new FileSystemException(e);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void restoreFolder(IShareable folder, Map<String, String> properties, IFolderHandle handle, IProgressMonitor monitor) throws FileSystemException {
        if (folder == null) {
            throw new NullPointerException();
        }
        if (handle == null || handle.getItemId() == null) {
            throw new NullPointerException();
        }
        if (handle.hasStateId() || handle.hasFullState()) {
            handle = (IFolderHandle)handle.getItemType().createItemHandle(handle.getItemId(), null);
        }
        Shareable shareable = (Shareable)folder;
        IFileStorage storage = shareable.getFileStorage();
        Shareable parentShareable = (Shareable)shareable.getParent();
        if (parentShareable == null) {
            throw new IllegalArgumentException("Cannot restore file at " + shareable.getLocalPath() + " outside of share");
        }
        IFileStorage parent = parentShareable.getFileStorage();
        if (parent == null) {
            throw new IllegalArgumentException("Cannot restore file at " + shareable.getLocalPath() + " outside of share");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        LockData lock = RestoreVersionableOperation.lockTree(storage, (IProgressMonitor)progress.newChild(5));
        if (lock == null) {
            throw new IllegalArgumentException(shareable.getLocalPath() + " is not in a shared location");
        }
        try {
            ICopyFileArea.PropertyUpdate propertyUpdateDirection;
            MetadataProperties metadataProperties;
            FileItemInfo info;
            if (shareable.exists((IProgressMonitor)progress.newChild(1))) {
                throw new IllegalArgumentException(shareable.getLocalPath() + " already exists");
            }
            ResourceType parentType = parentShareable.getResourceType((IProgressMonitor)progress.newChild(1));
            if (parentType == null) {
                throw new IllegalArgumentException("Parent folder " + parent.getShareable().getLocalPath() + " does not exist");
            }
            if (parentType != ResourceType.FOLDER) {
                throw new IllegalArgumentException("Parent " + parent.getShareable().getLocalPath() + " is not a folder");
            }
            IShare share = shareable.getShare((IProgressMonitor)progress.newChild(1));
            if (share.getPath().equals(shareable.getLocalPath())) {
                throw new IllegalArgumentException("Cannot restore folder at share root");
            }
            ISharingDescriptor desc = share.getSharingDescriptor();
            CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(shareable.getCopyFileAreaRoot());
            if (cfa.isShareRoot((IVersionableHandle)handle, desc.getComponent(), desc.getConnectionHandle())) {
                throw new IllegalArgumentException(handle.getItemId() + " already exists");
            }
            InverseFileItemInfo existing = cfa.getItemInfo((IVersionableHandle)handle, desc.getComponent(), desc.getConnectionHandle(), false);
            if (existing != null) {
                if (existing.getLocalName() != null) {
                    throw new IllegalArgumentException(handle.getItemId() + " already exists");
                }
                if (existing.getVersionableHandle().getItemType() != handle.getItemType()) {
                    throw new IllegalArgumentException("Type mismatch, existing: " + existing.getVersionableHandle().getItemType().getName() + ", restoring: " + handle.getItemType().getName());
                }
                info = new FileItemInfo(existing.getVersionableHandle(), false, existing.getLastContentChangeCheckStamp(), existing.getParent(), existing.getName(), existing.isLoadedWithAnotherName(), existing.getHash(), existing.getContentLength(), existing.getOriginalLineDelimiter(), existing.getLineDelimiter(), existing.getOriginalContentType(), existing.getContentType(), existing.getStoredPredecessorHintHash(), existing.getStoredSize(), existing.getStoredEncoding(), existing.getStoredHash(), existing.getStoredNumLineDelimiters(), false, false, false, false, existing.getExternalLinks(), existing.getOriginalExternalLinks());
            } else {
                info = new FileItemInfo(handle, null, null, false);
            }
            SharingManager.getInstance().disableChangeMonitoring();
            try {
                storage.create(false, existing, (IProgressMonitor)progress.newChild(30));
            }
            finally {
                SharingManager.getInstance().enableChangeMonitoring();
            }
            if (properties == null) {
                metadataProperties = null;
                propertyUpdateDirection = ICopyFileArea.PropertyUpdate.PRESERVE;
            } else {
                metadataProperties = new MetadataProperties(Collections.EMPTY_MAP, properties, Collections.EMPTY_SET);
                propertyUpdateDirection = ICopyFileArea.PropertyUpdate.REPLACE_DELTA;
            }
            cfa.setItemMetaData(shareable.getLocalPath(), info, propertyUpdateDirection, metadataProperties, (IProgressMonitor)progress.newChild(55));
        }
        finally {
            RestoreVersionableOperation.unlockTree(lock, (IProgressMonitor)progress.newChild(5));
        }
    }

    public static void restoreLink(IShareable linkShareable, String target, boolean isDirectory, Map<String, String> properties, ISymbolicLinkHandle handle, IProgressMonitor monitor) throws FileSystemException {
        if (target == null) {
            throw new NullPointerException();
        }
        try {
            Shareable shareable;
            Shareable parentShareable;
            if (linkShareable == null) {
                throw new NullPointerException();
            }
            if (handle == null) {
                throw new NullPointerException();
            }
            if (handle.getItemId() == null) {
                throw new NullPointerException();
            }
            if (!(handle instanceof ISymbolicLinkHandle)) {
                throw new IllegalArgumentException("Cannot give a link a versionable of type " + handle.getItemType().getName());
            }
            String targetInLocalForm = ((Shareable)linkShareable).getFileStorage().convertTargetIntoLocalForm(target);
            if (handle.hasStateId() || handle.hasFullState()) {
                handle = (ISymbolicLinkHandle)handle.getItemType().createItemHandle(handle.getItemId(), null);
            }
            if ((parentShareable = (Shareable)(shareable = (Shareable)linkShareable).getParent()) == null) {
                throw new IllegalArgumentException("Cannot restore link at " + shareable.getLocalPath() + " outside of share");
            }
            IFileStorage parent = parentShareable.getFileStorage();
            if (parent == null) {
                throw new IllegalArgumentException("Cannot restore link at " + shareable.getLocalPath() + " outside of share");
            }
            IFileStorage storage = shareable.getFileStorage();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            LockData lock = RestoreVersionableOperation.lockTree(parent, (IProgressMonitor)progress.newChild(5));
            if (lock == null) {
                throw new IllegalArgumentException(shareable.getLocalPath() + " is not in a shared location");
            }
            try {
                ICopyFileArea.PropertyUpdate propertyUpdateDirection;
                MetadataProperties metadataProperties;
                FileItemInfo info;
                if (shareable.exists((IProgressMonitor)progress.newChild(1))) {
                    throw new IllegalArgumentException(shareable.getLocalPath() + " already exists");
                }
                ResourceType parentType = parentShareable.getResourceType((IProgressMonitor)progress.newChild(1));
                if (parentType == null) {
                    throw new IllegalArgumentException("Parent folder " + parent.getShareable().getLocalPath() + " does not exist");
                }
                if (parentType != ResourceType.FOLDER) {
                    throw new IllegalArgumentException("Parent " + parent.getShareable().getLocalPath() + " is not a folder");
                }
                IShare share = shareable.getShare((IProgressMonitor)progress.newChild(1));
                if (share.getPath().equals(shareable.getLocalPath())) {
                    throw new IllegalArgumentException("Cannot restore link at share root");
                }
                ISharingDescriptor desc = share.getSharingDescriptor();
                CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(shareable.getCopyFileAreaRoot());
                if (cfa.isShareRoot((IVersionableHandle)((IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(handle.getItemId(), null)), desc.getComponent(), desc.getConnectionHandle())) {
                    throw new IllegalArgumentException(handle.getItemId() + " already exists");
                }
                InverseFileItemInfo existing = cfa.getItemInfo((IVersionableHandle)handle, desc.getComponent(), desc.getConnectionHandle(), false);
                if (existing != null) {
                    if (existing.getLocalName() != null) {
                        throw new IllegalArgumentException(handle.getItemId() + " already exists");
                    }
                    if (existing.getVersionableHandle().getItemType() != handle.getItemType()) {
                        throw new IllegalArgumentException("Type mismatch, existing: " + existing.getVersionableHandle().getItemType().getName() + ", restoring: " + handle.getItemType().getName());
                    }
                }
                SharingManager.getInstance().disableChangeMonitoring();
                try {
                    storage.create(targetInLocalForm, isDirectory, (IProgressMonitor)progress.newChild(60));
                }
                finally {
                    SharingManager.getInstance().enableChangeMonitoring();
                }
                if (existing != null) {
                    boolean contentChanged;
                    if (!existing.getVersionableHandle().hasStateId()) {
                        contentChanged = false;
                    } else {
                        ContentHash targetHash = CopyFileArea.getLinkHash(targetInLocalForm);
                        contentChanged = targetHash.equals((Object)existing.getHash());
                    }
                    info = new FileItemInfo(existing.getVersionableHandle(), contentChanged, storage.getModificationStamp(), existing.getParent(), existing.getName(), existing.isLoadedWithAnotherName(), existing.getHash(), existing.getContentLength(), existing.getOriginalLineDelimiter(), existing.getLineDelimiter(), existing.getOriginalContentType(), existing.getContentType(), existing.getStoredPredecessorHintHash(), existing.getStoredSize(), existing.getStoredEncoding(), existing.getStoredHash(), existing.getStoredNumLineDelimiters(), existing.isOriginalExecutable(), existing.isOriginalExecutable(), existing.isOriginalDirectoryLink(), existing.isOriginalDirectoryLink(), existing.getExternalLinks(), existing.getOriginalExternalLinks());
                } else {
                    info = new FileItemInfo(handle, false, null, null, false, null, null, false, false);
                }
                if (properties == null) {
                    metadataProperties = null;
                    propertyUpdateDirection = ICopyFileArea.PropertyUpdate.PRESERVE;
                } else {
                    metadataProperties = new MetadataProperties(Collections.EMPTY_MAP, properties, Collections.EMPTY_SET);
                    propertyUpdateDirection = ICopyFileArea.PropertyUpdate.REPLACE_DELTA;
                }
                cfa.setItemMetaData(shareable.getLocalPath(), info, propertyUpdateDirection, metadataProperties, (IProgressMonitor)progress.newChild(25));
            }
            finally {
                RestoreVersionableOperation.unlockTree(lock, (IProgressMonitor)progress.newChild(5));
            }
        }
        catch (ContentHashAlgorithmException e) {
            throw new FileSystemException(e);
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
    }

    private static LockData lockTree(IFileStorage storage, IProgressMonitor monitor) throws FileSystemException {
        ISchedulingRule rule = SharingManager.getInstance().makeSchedulingRuleForIDE(Collections.singletonList(storage.getShareable()), ISharingManager.RuleKind.CREATE);
        boolean success = false;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ICopyFileAreasLock cfaRule = null;
        try {
            Job.getJobManager().beginRule(rule, (IProgressMonitor)progress.newChild(45));
            Shareable shareable = storage.getShareable();
            cfaRule = CopyFileAreaManager.instance.lock(Collections.singleton(CopyFileAreaManager.instance.lockRequestFactory().getLockRequest(Collections.singleton(shareable))), (IProgressMonitor)progress.newChild(50));
            IShare share = shareable.getShare((IProgressMonitor)progress.newChild(5));
            if (share == null) {
                return null;
            }
            CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(shareable.getSandbox().getRoot());
            if (!CopyFileAreaManager.instance.isLocked(new ComponentLock(cfa.getRoot(), share.getSharingDescriptor().getConnectionHandle(), share.getSharingDescriptor().getComponent()))) {
                return null;
            }
            LockData result = new LockData(rule, cfaRule);
            success = true;
            LockData lockData = result;
            return lockData;
        }
        finally {
            if (!success) {
                try {
                    if (cfaRule != null) {
                        ((CopyFileAreasLock)cfaRule).release((IProgressMonitor)progress.newChild(1));
                    }
                }
                finally {
                    Job.getJobManager().endRule(rule);
                }
            }
        }
    }

    private static void unlockTree(LockData data, IProgressMonitor monitor) throws FileSystemException {
        try {
            data.cfaRule.release(monitor);
        }
        finally {
            Job.getJobManager().endRule(data.fsRule);
        }
    }

    private static class LockData {
        public final ICopyFileAreasLock cfaRule;
        public final ISchedulingRule fsRule;

        public LockData(ISchedulingRule fsRule, ICopyFileAreasLock cfaRule) {
            this.cfaRule = cfaRule;
            this.fsRule = fsRule;
        }
    }
}

