/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.SymLinkHelper;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.CoreException;

class NativeSymLinkHelper
extends SymLinkHelper {
    static SymLinkHelper newInstance(Log log) {
        try {
            System.loadLibrary("fsnatives");
        }
        catch (UnsatisfiedLinkError e) {
            if (log != null) {
                log.debug((Object)"Unable to instantiate symlink natives", (Throwable)e);
            }
            return null;
        }
        return new NativeSymLinkHelper();
    }

    private NativeSymLinkHelper() {
    }

    private static native void createLink(String var0, String var1) throws CoreException;

    private static native boolean nativeSupportsSymlinks();

    private static native String getRealPath(String var0) throws CoreException;

    @Override
    public void createSymlink(String path, String targetPath) throws CoreException {
        NativeSymLinkHelper.createLink(targetPath, path);
    }

    @Override
    public void createSymlink(String path, String targetPath, boolean isDirectory) throws CoreException {
        NativeSymLinkHelper.createLink(targetPath, path);
    }

    @Override
    public String getResolvedPath(String path) throws CoreException {
        return NativeSymLinkHelper.getRealPath(path);
    }

    @Override
    public boolean supportsSymLinks() {
        return true;
    }

    @Override
    public boolean hasEmbeddedTargetType() {
        return false;
    }

    @Override
    public String normalizeSymlinkTarget(String targetPath) throws CoreException {
        return targetPath;
    }
}

