/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.IMetadataProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MetadataProperties
implements IMetadataProperties {
    private final Map<String, String> originalProperties;
    private final Map<String, String> changedProperties;
    private final Set<String> removedProperties;

    public MetadataProperties() {
        this.originalProperties = Collections.EMPTY_MAP;
        this.changedProperties = Collections.EMPTY_MAP;
        this.removedProperties = Collections.EMPTY_SET;
    }

    public MetadataProperties(Map<String, String> originalProperties) {
        this.originalProperties = originalProperties;
        this.changedProperties = Collections.EMPTY_MAP;
        this.removedProperties = Collections.EMPTY_SET;
    }

    public MetadataProperties(Map<String, String> originalProperties, Map<String, String> propertyChanges, Set<String> removedProperties) {
        this.originalProperties = originalProperties;
        this.changedProperties = propertyChanges;
        this.removedProperties = removedProperties;
    }

    public MetadataProperties(Map<String, String> originalProperties, Map<String, String> currentProperties) {
        this.originalProperties = originalProperties;
        this.changedProperties = MetadataProperties.calcPropertyChanges(originalProperties, currentProperties);
        this.removedProperties = MetadataProperties.calcRemovedProperties(originalProperties, currentProperties);
    }

    public MetadataProperties(Map<String, String> newOriginalProperties, MetadataProperties oldProperties) {
        this.originalProperties = newOriginalProperties;
        this.changedProperties = MetadataProperties.calcPropertyChanges(newOriginalProperties, oldProperties.getChangedProperties());
        this.removedProperties = oldProperties.getRemovedProperties();
        Iterator<String> iRemoved = this.removedProperties.iterator();
        while (iRemoved.hasNext()) {
            String property = iRemoved.next();
            if (newOriginalProperties.containsKey(property)) continue;
            iRemoved.remove();
        }
    }

    public Set<String> getRemovedProperties() {
        return this.removedProperties;
    }

    public Map<String, String> getChangedProperties() {
        return this.changedProperties;
    }

    @Override
    public Map<String, String> getOriginalProperties() {
        return this.originalProperties;
    }

    public static Map<String, String> calcPropertyChanges(Map<String, String> originalProperties, Map<String, String> currentProperties) {
        if (currentProperties.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        if (originalProperties.isEmpty()) {
            return currentProperties;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : currentProperties.entrySet()) {
            String oldValue = originalProperties.get(entry.getKey());
            if (oldValue != null && oldValue.equals(entry.getValue())) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    public static Set<String> calcRemovedProperties(Map<String, String> originalProperties, Map<String, String> currentProperties) {
        if (originalProperties.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        if (currentProperties.isEmpty()) {
            return Collections.unmodifiableSet(originalProperties.keySet());
        }
        HashMap<String, String> properties = new HashMap<String, String>(originalProperties);
        for (String property : currentProperties.keySet()) {
            properties.remove(property);
        }
        return properties.keySet();
    }

    @Override
    public Map<String, String> getCurrentProperties() {
        return MetadataProperties.getCurrentProperties(this.originalProperties, this.changedProperties, this.removedProperties);
    }

    public static Map<String, String> getCurrentProperties(Map<String, String> originalProperties, Map<String, String> changedProperties, Set<String> removedProperties) {
        if (changedProperties.isEmpty() && removedProperties.isEmpty()) {
            return Collections.unmodifiableMap(originalProperties);
        }
        HashMap<String, String> current = new HashMap<String, String>(originalProperties);
        current.putAll(changedProperties);
        for (String property : removedProperties) {
            current.remove(property);
        }
        return Collections.unmodifiableMap(current);
    }
}

