/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;

public class LoggingHelperLog
implements Log {
    private final Log log;
    private final boolean logToHelper;
    private final ILog eclipseLog;

    public LoggingHelperLog(boolean logToHelper, Log log, ILog eclipseLog) {
        this.logToHelper = logToHelper;
        this.log = log;
        this.eclipseLog = eclipseLog;
    }

    public boolean isTraceEnabled() {
        return this.logToHelper || this.log.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logToHelper || this.log.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logToHelper || this.log.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.logToHelper || this.log.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logToHelper || this.log.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logToHelper || this.log.isWarnEnabled();
    }

    public void trace(Object message) {
        if (this.logToHelper) {
            this.logToHelper(2, message);
        } else {
            this.log.trace(message);
        }
    }

    public void trace(Object message, Throwable t) {
        if (this.logToHelper) {
            this.logToHelper(2, message, t);
        } else {
            this.log.trace(message, t);
        }
    }

    public void debug(Object message) {
        if (this.logToHelper) {
            this.logToHelper(2, message);
        } else {
            this.log.debug(message);
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.logToHelper) {
            this.logToHelper(2, message, t);
        } else {
            this.log.debug(message, t);
        }
    }

    public void info(Object message) {
        if (this.logToHelper) {
            this.logToHelper(2, message);
        } else {
            this.log.info(message);
        }
    }

    public void info(Object message, Throwable t) {
        if (this.logToHelper) {
            this.logToHelper(2, message, t);
        } else {
            this.log.info(message, t);
        }
    }

    public void warn(Object message) {
        if (this.logToHelper) {
            this.logToHelper(2, message);
        } else {
            this.log.warn(message);
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.logToHelper) {
            this.logToHelper(2, message, t);
        } else {
            this.log.warn(message, t);
        }
    }

    public void error(Object message) {
        if (this.logToHelper) {
            this.logToHelper(4, message);
        } else {
            this.log.error(message);
        }
    }

    public void error(Object message, Throwable t) {
        if (this.logToHelper) {
            this.logToHelper(4, message, t);
        } else {
            this.log.error(message, t);
        }
    }

    public void fatal(Object message) {
        if (this.logToHelper) {
            this.logToHelper(4, message);
        } else {
            this.log.fatal(message);
        }
    }

    public void fatal(Object message, Throwable t) {
        if (this.logToHelper) {
            this.logToHelper(4, message, t);
        } else {
            this.log.fatal(message, t);
        }
    }

    private void logToHelper(int severity, Object message) {
        IStatus status = this.getStatus(severity, message);
        if (this.eclipseLog == null) {
            LoggingHelper.log(status);
        } else {
            this.eclipseLog.log(status);
        }
    }

    private IStatus getStatus(int severity, Object message) {
        if (message instanceof IStatus) {
            return (IStatus)message;
        }
        if (message instanceof Throwable) {
            Throwable t = (Throwable)message;
            return FileSystemStatusUtil.getStatusFor(severity, t.getMessage(), t);
        }
        return FileSystemStatusUtil.getStatusFor(severity, message.toString());
    }

    private void logToHelper(int severity, Object message, Throwable t) {
        IStatus status = this.getStatus(severity, message, t);
        LoggingHelper.log(status);
    }

    private IStatus getStatus(int severity, Object message, Throwable t) {
        return FileSystemStatusUtil.getStatusFor(severity, message.toString(), t);
    }
}

