/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.internal.LoggingHelperLog;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;

public class LoggingHelper {
    private static final String SCM_LOGGER_PREFIX = "scm.logger.";
    private static final String SCM_LOGGER_ENABLEMENT = "scm.logger.enabled";
    private static ILog eclipseLog;

    public static void log(IStatus status) {
        Log logger = LogFactory.getLog((String)status.getPlugin());
        switch (status.getSeverity()) {
            case 4: {
                logger.error((Object)status, status.getException());
                break;
            }
            case 2: {
                logger.warn((Object)status, status.getException());
                break;
            }
            case 1: {
                logger.info((Object)status, status.getException());
                break;
            }
            default: {
                logger.error((Object)status, status.getException());
            }
        }
    }

    public static void error(String namespace, String message, Throwable exception) {
        Log logger = LogFactory.getLog((String)namespace);
        if (exception instanceof CoreException) {
            IStatus status = ((CoreException)exception).getStatus();
            MultiStatus multi = new MultiStatus(status.getPlugin(), status.getCode(), new IStatus[]{status}, message, exception);
            logger.error((Object)multi, exception);
        } else if (exception instanceof FileSystemStatusException) {
            IStatus status = ((FileSystemStatusException)((Object)exception)).getStatus();
            MultiStatus multi = new MultiStatus(status.getPlugin(), status.getCode(), new IStatus[]{status}, message, exception);
            logger.error((Object)multi, exception);
        } else {
            logger.error((Object)message, exception);
        }
    }

    public static void log(CoreException exception) {
        IStatus status = exception.getStatus();
        MultiStatus multi = new MultiStatus(status.getPlugin(), status.getCode(), new IStatus[]{status}, status.getMessage(), (Throwable)exception);
        LoggingHelper.log((IStatus)multi);
    }

    public static void log(String namespace, TeamRepositoryException exception) {
        Log logger = LogFactory.getLog((String)namespace);
        if (exception instanceof FileSystemStatusException) {
            IStatus status = ((FileSystemStatusException)exception).getStatus();
            logger.error((Object)status, (Throwable)exception);
        } else {
            logger.error((Object)exception);
        }
    }

    public static Log getLog(String logName) {
        try {
            boolean logToHelper = LoggingHelper.isLogToHelperEnabledFor(logName);
            if (logToHelper) {
                Log log = LogFactory.getLog((String)"com.ibm.team.filesystem.client");
                return new LoggingHelperLog(logToHelper, log, eclipseLog);
            }
        }
        catch (Throwable e) {
            LoggingHelper.error("com.ibm.team.filesystem.client", e.getMessage(), e);
        }
        try {
            return LogFactory.getLog((String)logName);
        }
        catch (Throwable e) {
            LoggingHelper.error("com.ibm.team.filesystem.client", e.getMessage(), e);
            return null;
        }
    }

    public static Log getLog(Class clazz) {
        return LoggingHelper.getLog(clazz.getName());
    }

    public static Log getLog(Class clazz, String suffix) {
        try {
            String logName = LoggingHelper.combine(clazz.getName(), suffix);
            return LoggingHelper.getLog(logName);
        }
        catch (Throwable e) {
            LoggingHelper.error("com.ibm.team.filesystem.client", e.getMessage(), e);
            return null;
        }
    }

    private static boolean isLogToHelperEnabledFor(String logName) {
        if (Boolean.getBoolean(SCM_LOGGER_ENABLEMENT)) {
            String nameToTest = logName;
            while (nameToTest.length() > 0) {
                String propertyName = SCM_LOGGER_PREFIX + nameToTest;
                String value = System.getProperty(propertyName);
                if (value != null) {
                    return Boolean.parseBoolean(value);
                }
                int index = nameToTest.lastIndexOf(46);
                if (index == -1) break;
                nameToTest = nameToTest.substring(0, index);
            }
        }
        return false;
    }

    private static String combine(String prefix, String suffix) {
        if (prefix.endsWith(".")) {
            if (suffix.endsWith(".")) {
                return String.valueOf(prefix) + suffix.substring(1, suffix.length());
            }
            return String.valueOf(prefix) + suffix;
        }
        if (suffix.startsWith(".")) {
            return String.valueOf(prefix) + suffix;
        }
        return String.valueOf(prefix) + "." + suffix;
    }

    public static void setILog(ILog log) {
        eclipseLog = log;
    }

    public static void logWithThread(Log log, String message) {
        String threadId = String.valueOf(Thread.currentThread().getId()) + ":" + Thread.currentThread().getName();
        log.trace((Object)NLS.bind((String)"{0}: {1}", (Object)threadId, (Object)message));
    }
}

