/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.AbstractKeywordProcessingInputStream;
import com.ibm.team.filesystem.common.FileKeyword;
import java.io.IOException;
import java.io.InputStream;

public class KeywordExpansionInputStream
extends AbstractKeywordProcessingInputStream {
    private int expandedKeywordBufferSize;
    private int expandedKeywordBufferPosition;
    private byte[] expandedKeywordBuffer = new byte[256];
    private IKeywordExpander expander;

    public KeywordExpansionInputStream(InputStream in, IKeywordExpander expander) {
        super(in);
        this.expander = expander;
    }

    private int fillFromKeywordExpansionBuffer(byte[] b, int off, int len) {
        int maxToGive = Math.min(len, this.expandedKeywordBufferSize - this.expandedKeywordBufferPosition);
        System.arraycopy(this.expandedKeywordBuffer, this.expandedKeywordBufferPosition, b, off, maxToGive);
        this.expandedKeywordBufferPosition += maxToGive;
        return maxToGive;
    }

    private void expandKeywordIntoKeywordExpansionBuffer(String keywordText) {
        this.expandedKeywordBufferPosition = 0;
        this.expandedKeywordBufferSize = 0;
        int pos = 0;
        FileKeyword fileKeyword = FileKeyword.getFileKeyword((String)keywordText);
        this.expandedKeywordBuffer[pos++] = 36;
        byte[] byArray = keywordText.getBytes();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            this.expandedKeywordBuffer[pos++] = b;
            ++n2;
        }
        this.expandedKeywordBuffer[pos++] = 58;
        this.expandedKeywordBuffer[pos++] = 32;
        String expansion = this.getExpansionForKeyword(fileKeyword);
        byte[] byArray2 = expansion.getBytes();
        int n3 = byArray2.length;
        n = 0;
        while (n < n3) {
            byte b = byArray2[n];
            if (pos == 255) break;
            this.expandedKeywordBuffer[pos++] = b;
            ++n;
        }
        this.expandedKeywordBuffer[pos++] = 36;
        this.expandedKeywordBufferSize = pos;
    }

    private String getExpansionForKeyword(FileKeyword fileKeyword) {
        return this.expander.getExpansionFor(fileKeyword);
    }

    private boolean hasContentInKeywordExpansionBuffer() {
        return this.expandedKeywordBufferPosition < this.expandedKeywordBufferSize;
    }

    private void expandKeywordAt(int start) {
        int end = this.findNextKeywordDelimiterInBuffer(start + 1);
        if (end == -1) {
            throw new IllegalArgumentException();
        }
        String keyword = this.extractPotentialKeyword(start, end);
        this.expandKeywordIntoKeywordExpansionBuffer(keyword);
        this.setPosition(end + 1);
    }

    @Override
    protected int handleKeyword(int keywordPosition, byte[] buffer, int offset, int length) {
        this.expandKeywordAt(keywordPosition);
        return this.fillFromKeywordExpansionBuffer(buffer, offset, length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0) {
            throw new IllegalArgumentException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.hasContentInKeywordExpansionBuffer()) {
            return this.fillFromKeywordExpansionBuffer(b, off, len);
        }
        return super.read(b, off, len);
    }

    public static interface IKeywordExpander {
        public String getExpansionFor(FileKeyword var1);
    }
}

