/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.AbstractKeywordProcessingInputStream;
import java.io.IOException;
import java.io.InputStream;

public class KeywordContractionInputStream
extends AbstractKeywordProcessingInputStream {
    private int currentKeywordPosition;
    private byte[] currentKeywordBuffer;

    public KeywordContractionInputStream(InputStream in) {
        super(in);
    }

    @Override
    protected int handleKeyword(int keywordPosition, byte[] buffer, int offset, int length) {
        int end = this.findNextKeywordDelimiterInBuffer(keywordPosition + 1);
        if (end == -1) {
            throw new IllegalArgumentException();
        }
        this.setPosition(end + 1);
        String keyword = this.extractPotentialKeyword(keywordPosition, end);
        this.currentKeywordBuffer = keyword.getBytes();
        this.currentKeywordPosition = 0;
        return this.fillFromKeywordBuffer(buffer, offset, length, true);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0) {
            throw new IllegalArgumentException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.hasContentInKeywordBuffer()) {
            return this.fillFromKeywordBuffer(b, off, len, false);
        }
        return super.read(b, off, len);
    }

    private boolean hasContentInKeywordBuffer() {
        return this.currentKeywordBuffer != null;
    }

    private int fillFromKeywordBuffer(byte[] buffer, int offset, int length, boolean includeStartDelimiter) {
        int maxToWrite = length - offset;
        int writtenCount = 0;
        if (includeStartDelimiter) {
            buffer[offset++] = 36;
            ++writtenCount;
        }
        if (writtenCount < maxToWrite) {
            int i = this.currentKeywordPosition;
            while (i < this.currentKeywordBuffer.length) {
                buffer[offset++] = this.currentKeywordBuffer[i];
                ++this.currentKeywordPosition;
                if (++writtenCount == maxToWrite) break;
                ++i;
            }
        }
        if (writtenCount < maxToWrite) {
            ++writtenCount;
            buffer[offset++] = 36;
            this.currentKeywordBuffer = null;
            this.currentKeywordPosition = 0;
        }
        return writtenCount;
    }
}

