/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.SymLinkHelper;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class JavaSymLinkHelper
extends SymLinkHelper {
    private static final String altSeparator = File.separator.equals("\\") ? "/" : null;
    final FileSystem fs = FileSystems.getDefault();
    final boolean supportsLinks;

    static JavaSymLinkHelper newInstance() {
        return new JavaSymLinkHelper();
    }

    private JavaSymLinkHelper() {
        boolean supported = true;
        try {
            Files.readSymbolicLink(this.fs.getPath(System.getProperty("user.dir"), new String[0]));
        }
        catch (UnsupportedOperationException e) {
            supported = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.supportsLinks = supported;
    }

    @Override
    public void createSymlink(String path, String targetPath) throws CoreException {
        try {
            Files.createSymbolicLink(this.fs.getPath(path, new String[0]), this.fs.getPath(targetPath, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.client", e.getMessage(), (Throwable)e));
        }
        catch (UnsupportedOperationException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.client", e.getMessage(), (Throwable)e));
        }
        catch (InvalidPathException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.client", e.getMessage(), (Throwable)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getResolvedPath(String path) throws CoreException {
        if (path.length() == 0) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.client", "The empty path is not valid"));
        }
        try {
            Path p;
            block17: {
                Path relativePart;
                p = this.fs.getPath(path, new String[0]).toAbsolutePath();
                Path parent = p.getParent();
                Path existingParent = null;
                while (true) {
                    if (parent == null) {
                        if (existingParent != null) {
                            relativePart = existingParent.relativize(p);
                            try {
                                existingParent = existingParent.toRealPath(LinkOption.NOFOLLOW_LINKS);
                                break;
                            }
                            catch (IOException e) {
                                throw new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.client", e.getMessage(), (Throwable)e));
                            }
                        }
                        break block17;
                    }
                    BasicFileAttributeView v = Files.getFileAttributeView(parent, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
                    try {
                        BasicFileAttributes a = v.readAttributes();
                        if (!a.isDirectory()) {
                            return null;
                        }
                        if (existingParent == null) {
                            existingParent = parent;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    parent = parent.getParent();
                }
                p = existingParent.resolve(relativePart);
            }
            p = p.normalize();
            String result = p.toString();
            if (!path.endsWith(File.separator)) {
                if (altSeparator == null) return result;
                if (!path.endsWith(altSeparator)) return result;
            }
            BasicFileAttributeView v = Files.getFileAttributeView(p, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
            try {
                BasicFileAttributes a = v.readAttributes();
                if (!a.isDirectory()) {
                    return null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (result.endsWith(File.separator)) return result;
            return String.valueOf(result) + File.separator;
        }
        catch (IOError e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.client", e.getMessage(), (Throwable)e));
        }
        catch (InvalidPathException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.client", e.getMessage(), (Throwable)e));
        }
    }

    @Override
    public boolean supportsSymLinks() {
        return this.supportsLinks;
    }

    @Override
    public boolean hasEmbeddedTargetType() {
        return false;
    }

    @Override
    public void createSymlink(String path, String targetPath, boolean isDirectory) throws CoreException {
        this.createSymlink(path, targetPath);
    }

    @Override
    public String normalizeSymlinkTarget(String targetPath) throws CoreException {
        try {
            return FileSystems.getDefault().getPath(targetPath, new String[0]).toString();
        }
        catch (InvalidPathException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.client", e.getMessage(), (Throwable)e));
        }
    }
}

