/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;

public interface IRepositoryResolver {
    public static final IRepositoryResolver EXISTING_SHARED = new IRepositoryResolver(){

        @Override
        public ITeamRepository getRepoFor(String uri, UUID id) throws TeamRepositoryException {
            if (id == null) {
                return RepositoryUtils.getTeamRepository(uri, 4);
            }
            return RepositoryUtils.getTeamRepository(id, uri, 4);
        }
    };
    public static final IRepositoryResolver UNSHARED = new IRepositoryResolver(){

        @Override
        public ITeamRepository getRepoFor(String uri, UUID id) throws TeamRepositoryException {
            if (id == null) {
                return RepositoryUtils.getTeamRepository(uri, 1);
            }
            return RepositoryUtils.getTeamRepository(id, uri, 1);
        }
    };
    public static final IRepositoryResolver DEFAULT = new IRepositoryResolver(){

        @Override
        public ITeamRepository getRepoFor(String uri, UUID id) throws TeamRepositoryException {
            if (id == null) {
                return RepositoryUtils.getTeamRepository(uri, 4);
            }
            return RepositoryUtils.getTeamRepository(id, uri, 4);
        }
    };

    public ITeamRepository getRepoFor(String var1, UUID var2) throws TeamRepositoryException;

    default public ITeamRepository getDefaultRepository() {
        return null;
    }
}

