/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.FileSystemCoreActivator;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.PlatformDetector;
import com.ibm.team.filesystem.client.internal.utils.IPermissionUtil;
import com.ibm.team.process.internal.common.NLS;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.IPath;

public class HardcodedPermissionUtils
implements IPermissionUtil {
    public static final String SCRIPTS_DIR = "scripts";
    public static final int RETCODE_CANNOT_MODIFY = 1;
    public static final int RETCODE_CANNOT_CREATE = 2;
    public static final String MKFILE_CMD = "mkfile";
    public static final String MKROOT_CMD = "mkroot";
    private String mkFile = null;
    private String mkRoot = null;
    private final PlatformDetector.Platform platform = PlatformDetector.getPlatform();

    public HardcodedPermissionUtils(PlatformDetector.LauncherType context, Map<String, String> env) {
        IPath mkFileCandidatePath = this.platform.getScript(context, env, MKFILE_CMD);
        IPath mkRootCandidatePath = this.platform.getScript(context, env, MKROOT_CMD);
        File mkFileCandidate = null;
        File mkRootCandidate = null;
        if (mkFileCandidatePath != null) {
            mkFileCandidate = mkFileCandidatePath.toFile();
        }
        if (mkRootCandidatePath != null) {
            mkRootCandidate = mkRootCandidatePath.toFile();
        }
        if (mkFileCandidate != null && mkFileCandidate.exists()) {
            try {
                this.mkFile = mkFileCandidate.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (mkRootCandidate != null && mkRootCandidate.exists()) {
            try {
                this.mkRoot = mkRootCandidate.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (FileSystemCoreActivator.TRACE_PERMISSION_UTIL) {
            System.err.println("mkFile: " + this.mkFile);
            System.err.println("mkRoot: " + this.mkRoot);
        }
    }

    private boolean run(String script, String pathTo) throws InterruptedException, IPermissionUtil.PermissionUtilsException {
        Process proc;
        if (script == null) {
            if (FileSystemCoreActivator.TRACE_PERMISSION_UTIL) {
                System.err.println("No script: " + script);
            }
            return false;
        }
        ProcessBuilder pb = new ProcessBuilder(script, pathTo);
        try {
            proc = pb.start();
        }
        catch (IOException e) {
            if (FileSystemCoreActivator.TRACE_PERMISSION_UTIL) {
                System.err.println("IOException when starting " + script);
            }
            throw new FailedToRunException(this, script, pathTo, e);
        }
        int r = proc.waitFor();
        if (r == 0) {
            return true;
        }
        if (FileSystemCoreActivator.TRACE_PERMISSION_UTIL) {
            System.err.println("Nonzero return from " + script + ": " + r);
        }
        switch (r) {
            case 1: {
                throw new IPermissionUtil.CannotModifyException(this, pathTo);
            }
            case 2: {
                throw new IPermissionUtil.CannotCreateException(this, pathTo);
            }
        }
        throw new MisbehavingScriptException(this, script, pathTo, r);
    }

    @Override
    public boolean mkFile(String pathToFile) throws IPermissionUtil.PermissionUtilsException, InterruptedException {
        if (this.run(this.mkFile, pathToFile)) {
            return true;
        }
        File file = new File(pathToFile);
        if (file.exists() && file.isFile()) {
            return false;
        }
        boolean success = false;
        try {
            success = file.createNewFile();
        }
        catch (IOException e) {
            LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
            success = false;
        }
        if (!success) {
            throw new IPermissionUtil.CannotCreateException(this, pathToFile);
        }
        return false;
    }

    @Override
    public boolean mkRoot(String pathToRoot) throws IPermissionUtil.PermissionUtilsException, InterruptedException {
        if (this.run(this.mkRoot, pathToRoot)) {
            return true;
        }
        File dir = new File(pathToRoot);
        if (dir.exists() && dir.isDirectory()) {
            return false;
        }
        dir.mkdirs();
        return false;
    }

    public String getMkRoot() {
        return this.mkRoot;
    }

    @Override
    public boolean shouldRunOnPlatform() {
        return this.platform.isScriptRequired();
    }

    public static class FailedToRunException
    extends IPermissionUtil.PermissionUtilsException {
        private final String path;

        public FailedToRunException(IPermissionUtil util, String target, String script, IOException e) {
            super(util, target, e);
            this.path = script;
        }

        public String getPath() {
            return this.path;
        }
    }

    public static class MisbehavingScriptException
    extends IPermissionUtil.PermissionUtilsException {
        private final String script;
        private final int returnValue;

        public MisbehavingScriptException(IPermissionUtil util, String script, String target, int r) {
            super(util, target);
            this.script = script;
            this.returnValue = r;
        }

        public int getReturnValue() {
            return this.returnValue;
        }

        public String getScript() {
            return this.script;
        }

        @Override
        public String getMessage() {
            return NLS.bind((String)"Could not change permissions. Running \"{0} {1}\" terminated with return code {2}", (Object[])new Object[]{this.getScript(), this.getTarget(), Integer.toString(this.getReturnValue())});
        }
    }
}

