/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileOptions;
import com.ibm.team.filesystem.client.internal.FileStorage;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileOptions;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IFileStorageVisitor;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.filesystem.client.internal.LinkInfo;
import com.ibm.team.filesystem.client.internal.LinkType;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.api.storage.ContentMeta;
import com.ibm.team.filesystem.client.internal.api.storage.IBackupHandler;
import com.ibm.team.filesystem.client.internal.api.storage.IRetryRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.exceptions.ContentRetrievalFailure;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.ContentHashAlgorithmException;
import com.ibm.team.scm.common.LocaleUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public final class FileStorageWrapper
implements IFileStorage {
    private final Shareable shareable;
    private final ResourceType resourceTypeHint;
    private FileStorage underlyingStorage = null;
    protected IFileStorage parent;

    public FileStorageWrapper(IShareableInternal shareable, ResourceType resourceTypeHint) {
        this.shareable = (Shareable)shareable;
        this.resourceTypeHint = resourceTypeHint;
        this.shareable.setFileStorage(this);
        this.parent = null;
    }

    public FileStorageWrapper(IShareableInternal shareable, IFileStorage parent, ResourceType resourceTypeHint) {
        this.shareable = (Shareable)shareable;
        this.resourceTypeHint = resourceTypeHint;
        this.parent = parent;
        this.shareable.setFileStorage(this);
    }

    public FileStorageWrapper(ISandbox sandbox, IRelativeLocation localPath, ResourceType resourceTypeHint) {
        this.shareable = new Shareable(sandbox, localPath, resourceTypeHint);
        this.shareable.setFileStorage(this);
        this.resourceTypeHint = resourceTypeHint;
    }

    private FileStorage getUnderlyingStorage() {
        if (this.underlyingStorage == null) {
            if (this.parent == null || ((FileStorageWrapper)this.parent).underlyingStorage == null) {
                SharingManager.getInstance().resolveFileStorage(this, this.resourceTypeHint);
            } else {
                ((FileStorageWrapper)this.parent).underlyingStorage.resolveChildStorage(this, this.shareable.getLocalPath().getName(), this.resourceTypeHint);
            }
        }
        return this.underlyingStorage;
    }

    @Override
    public final boolean isContentChangedFrom(FileItemInfo info, Map<String, String> properties, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progress.beginTask(Messages.FileStorage_0, 100);
        long size = this.getSize((IProgressMonitor)progress.newChild(50));
        if (info.getContentLength() != size && size != -1L) {
            progress.done();
            return true;
        }
        if (info.getLastContentChangeCheckStamp() != -1L && info.getLastContentChangeCheckStamp() == this.getModificationStamp()) {
            progress.done();
            return info.isContentChanged();
        }
        InputStream in = this.getUnderlyingStorage().getLocalChangeDetectionStream(new FileOptions(true, info, properties));
        try {
            ContentHash newHash = ContentHash.valueOf((InputStream)in);
            in.close();
            in = null;
            boolean isSame = newHash.equals((Object)info.getHash());
            progress.done();
            boolean bl = !isSame;
            return bl;
        }
        catch (ContentHashAlgorithmException e) {
            throw new FileSystemException(NLS.bind((String)Messages.FileStorage_1, (Object)this.shareable.getLocalPath(), (Object[])new Object[0]), e);
        }
        catch (IOException e) {
            throw new FileSystemException(NLS.bind((String)Messages.FileStorage_1, (Object)this.shareable.getLocalPath(), (Object[])new Object[0]), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LoggingHelper.error("com.ibm.team.filesystem.client", Messages.FileStorage_2, e);
                }
                catch (RuntimeException e) {
                    LoggingHelper.error("com.ibm.team.filesystem.client", Messages.FileStorage_2, e);
                }
            }
        }
    }

    @Override
    public final IFileStorage getParent() {
        if (this.parent == null) {
            try {
                if (this.shareable.isShare(null)) {
                    return null;
                }
            }
            catch (FileSystemException e) {
                return null;
            }
            if (this.underlyingStorage != null) {
                this.parent = this.underlyingStorage.getParent();
            } else {
                IRelativeLocation parentPath = this.shareable.getLocalPath().getParent();
                Shareable parentShareable = new Shareable(this.shareable.getSandbox(), parentPath, ResourceType.FOLDER);
                this.parent = parentShareable.getFileStorage();
            }
        }
        return this.parent;
    }

    @Override
    public boolean supportsExecBit() {
        return this.getUnderlyingStorage().supportsExecBit();
    }

    @Override
    public boolean supportSymbolicLinks() {
        if (this.getFileStore() != null) {
            return ManagedFileStore.supportsSymLinks();
        }
        return this.getUnderlyingStorage().supportsSymbolicLinks();
    }

    @Override
    public String convertTargetIntoLocalForm(String target) throws FileSystemException {
        if (this.getFileStore() != null) {
            try {
                return this.getFileStore().convertIntoLocalForm(target);
            }
            catch (CoreException e) {
                throw new FileSystemException(e.getMessage(), e);
            }
        }
        return this.getUnderlyingStorage().convertIntoLocalForm(target);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setExecutable(boolean exec, IProgressMonitor monitor) {
        if (this.getUnderlyingStorage().supportsExecBit()) {
            return this.getUnderlyingStorage().setExecutable(exec, monitor);
        }
        Shareable shareable = this.getShareable();
        ICopyFileAreaLockRequest request = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(Collections.singleton(shareable));
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            ICopyFileAreasLock lock = ICopyFileAreaManager.instance.lock(Collections.singleton(request), (IProgressMonitor)progress.newChild(15));
            try {
                if (shareable.getShare((IProgressMonitor)progress.newChild(10)) == null) {
                    return false;
                }
                ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(shareable.getSandbox().getRoot());
                FileItemInfo info = cfa.getItemInfo(shareable.getLocalPath());
                if (info == null) {
                    return false;
                }
                if (exec == info.isExecutable()) return true;
                FileItemInfoProxy proxy = new FileItemInfoProxy(info);
                proxy.setExecutable(info.isOriginalExecutable(), exec);
                info = proxy.getFileItemInfo();
                cfa.setItemMetaData(shareable.getLocalPath(), info, ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)progress.newChild(50));
                return true;
            }
            finally {
                lock.release((IProgressMonitor)progress.newChild(25));
            }
        }
        catch (Exception e) {
            LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
            return false;
        }
    }

    @Override
    public boolean isExecutable(IProgressMonitor monitor) throws FileSystemException {
        if (this.getUnderlyingStorage().supportsExecBit()) {
            return this.getUnderlyingStorage().isExecutable(monitor);
        }
        FileItemInfo info = this.getShareable().getFileItemInfo(monitor);
        return info == null ? false : info.isExecutable();
    }

    @Override
    public boolean shouldBeIgnored(IProgressMonitor monitor) throws FileSystemException {
        return this.getUnderlyingStorage().shouldBeIgnored(monitor);
    }

    @Override
    public final Shareable getShareable() {
        return this.shareable;
    }

    @Override
    public void accept(IFileStorageVisitor visitor, int depth, IProgressMonitor progress) throws FileSystemException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)20);
        this.getUnderlyingStorage().lock((IProgressMonitor)mon.newChild(1));
        try {
            IFileStorage storage;
            if (depth == 0) {
                visitor.visit(this, (IProgressMonitor)mon);
                return;
            }
            if (depth == 1) {
                if (visitor.visit(this, (IProgressMonitor)mon.newChild(1))) {
                    Collection<IFileStorage> children = this.getChildren(true, (IProgressMonitor)mon.newChild(1));
                    mon.setWorkRemaining(children.size());
                    for (IFileStorage child : children) {
                        child.accept(visitor, 0, (IProgressMonitor)mon.newChild(1));
                    }
                }
                return;
            }
            LinkedList<IFileStorage> toVisit = new LinkedList<IFileStorage>();
            toVisit.add(this);
            while ((storage = (IFileStorage)toVisit.poll()) != null) {
                boolean descend = visitor.visit(storage, (IProgressMonitor)mon);
                if (!descend) continue;
                Collection<IFileStorage> children = storage.getChildren(true, (IProgressMonitor)mon.newChild(1));
                toVisit.addAll(children);
            }
        }
        finally {
            this.getUnderlyingStorage().unlock();
        }
    }

    @Override
    public boolean requiresBackup(IProgressMonitor monitor) throws FileSystemException {
        return this.getUnderlyingStorage().requiresBackup(monitor);
    }

    @Override
    public final String getName() {
        return this.shareable.getLocalPath().getName();
    }

    private final ManagedFileStore getFileStore() {
        if (SharingManager.getInstance().hasEFSSupport(this.shareable.getSandbox().getRoot())) {
            IFileStore fileStore;
            IPath fullPath = (IPath)this.shareable.getFullPath().getAdapter(IPath.class);
            if (fullPath != null) {
                return new ManagedFileStore(this.shareable.getSandbox().getRoot(), this.shareable.getLocalPath(), EFS.getLocalFileSystem().getStore(fullPath));
            }
            FileStorage underlyingStorage = this.getUnderlyingStorage();
            if (underlyingStorage != null && (fileStore = underlyingStorage.getFileStore()) instanceof ManagedFileStore) {
                return (ManagedFileStore)fileStore;
            }
        }
        return null;
    }

    @Override
    public void create(String target, boolean isDirectory, IProgressMonitor progress) throws FileSystemException {
        ManagedFileStore fileStore = this.getFileStore();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        if (fileStore != null) {
            if (ManagedFileStore.supportsSymLinks() && SharingManager.getInstance().hasEFSSupport(this.shareable.getSandbox().getRoot())) {
                try {
                    this.getFileStore().symlink(target, isDirectory, (IProgressMonitor)monitor.newChild(80));
                    this.refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)monitor.newChild(20));
                }
                catch (CoreException e) {
                    throw new FileSystemException(NLS.bind((String)Messages.FileStorageWrapper_7, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[]{target.toString(), e.getMessage()}), e);
                }
            }
        } else if (this.getUnderlyingStorage().supportsSymbolicLinks()) {
            this.getUnderlyingStorage().create(target, (IProgressMonitor)monitor.newChild(80));
        }
    }

    private LinkType getTargetType(IProgressMonitor monitor) {
        ManagedFileStore fileStore = this.getFileStore();
        if (fileStore != null) {
            return fileStore.getTargetType(monitor);
        }
        return LinkType.NONE;
    }

    @Override
    public boolean isBrokenLink(IProgressMonitor monitor) throws FileSystemException {
        ManagedFileStore fileStore = this.getFileStore();
        if (fileStore != null) {
            try {
                return fileStore.isBrokenLink(monitor);
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return this.getUnderlyingStorage().isBrokenSymbolicLink(monitor);
    }

    @Override
    public boolean isInteroperableLink(LinkInfo targetInfo, boolean directory, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        if (targetInfo.isAbsoluteTarget()) {
            return false;
        }
        if (targetInfo.getType() == LinkType.NONE) {
            ManagedFileStore fileStore = this.getFileStore();
            if (fileStore != null) {
                try {
                    return fileStore.verifyLinkTargetType(directory, (IProgressMonitor)progress.newChild(10));
                }
                catch (CoreException coreException) {
                    return true;
                }
            }
            return this.getUnderlyingStorage().verifySymbolicLinkTargetType(directory, (IProgressMonitor)progress.newChild(10));
        }
        return true;
    }

    @Override
    public boolean exists(IProgressMonitor progress) throws FileSystemException {
        ManagedFileStore fileStore = this.getFileStore();
        if (fileStore != null) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
            try {
                File localFile = fileStore.toLocalFile(0, (IProgressMonitor)monitor.newChild(1));
                if (localFile != null && localFile.exists()) {
                    return true;
                }
            }
            catch (CoreException localFile) {
                // empty catch block
            }
            SharingManager sm = SharingManager.getInstance();
            sm.disableChangeMonitoring();
            try {
                IFileInfo fileInfo = fileStore.fetchInfo(0, (IProgressMonitor)monitor.newChild(1));
                boolean bl = fileInfo.getAttribute(32) || fileInfo.exists();
                return bl;
            }
            catch (CoreException e) {
                throw new FileSystemException(NLS.bind((String)Messages.FileStorageWrapper_0, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[]{e.getMessage()}), e);
            }
            finally {
                sm.enableChangeMonitoring();
            }
        }
        return this.getUnderlyingStorage().storageExists(progress);
    }

    @Override
    public long getSize(IProgressMonitor progress) throws FileSystemException {
        SharingManager sm = SharingManager.getInstance();
        sm.disableChangeMonitoring();
        try {
            ManagedFileStore fileStore = this.getFileStore();
            if (fileStore != null) {
                IFileInfo fileInfo = fileStore.fetchInfo(0, progress);
                if (!fileInfo.exists() || fileInfo.isDirectory() || fileInfo.getAttribute(32)) {
                    return -1L;
                }
                long l = fileInfo.getLength();
                return l;
            }
            long l = this.getUnderlyingStorage().getSize(progress);
            return l;
        }
        catch (CoreException e) {
            throw new FileSystemException(NLS.bind((String)Messages.FileStorageWrapper_1, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[]{e.getMessage()}), e);
        }
        finally {
            sm.enableChangeMonitoring();
        }
    }

    @Override
    public final ResourceType getResourceType(IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        SharingManager sm = SharingManager.getInstance();
        sm.disableChangeMonitoring();
        try {
            ManagedFileStore fileStore = this.getFileStore();
            if (fileStore != null) {
                IFileInfo fileInfo = fileStore.fetchInfo(0, (IProgressMonitor)monitor.newChild(100));
                if (fileInfo.getAttribute(32)) {
                    ResourceType resourceType = ResourceType.SYMBOLIC_LINK;
                    return resourceType;
                }
                if (fileInfo.isDirectory()) {
                    ResourceType resourceType = ResourceType.FOLDER;
                    return resourceType;
                }
                if (fileInfo.exists()) {
                    ResourceType resourceType = ResourceType.FILE;
                    return resourceType;
                }
                return null;
            }
            ResourceType resourceType = this.getUnderlyingStorage().getResourceType(progress);
            return resourceType;
        }
        catch (CoreException e) {
            throw new FileSystemException(NLS.bind((String)Messages.FileStorageWrapper_13, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[]{e.getMessage()}), e);
        }
        finally {
            sm.enableChangeMonitoring();
        }
    }

    @Override
    public boolean isReadOnly(IProgressMonitor progress) throws FileSystemException {
        SharingManager sm = SharingManager.getInstance();
        sm.disableChangeMonitoring();
        try {
            ManagedFileStore fileStore = this.getFileStore();
            if (fileStore != null) {
                IFileInfo fileInfo = fileStore.fetchInfo(0, progress);
                boolean bl = fileInfo.getAttribute(2);
                return bl;
            }
            boolean bl = this.getUnderlyingStorage().isReadOnly(progress);
            return bl;
        }
        catch (CoreException e) {
            throw new FileSystemException(NLS.bind((String)Messages.FileStorageWrapper_5, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[]{e.getMessage()}), e);
        }
        finally {
            sm.enableChangeMonitoring();
        }
    }

    @Override
    public void setTarget(Shed backupShed, String targetPath, boolean isDirectory, IProgressMonitor progress) throws FileSystemException {
        boolean isSymbolicLink;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ManagedFileStore fileStore = this.getFileStore();
        SharingManager sm = SharingManager.getInstance();
        sm.disableChangeMonitoring();
        try {
            try {
                if (fileStore != null) {
                    IFileInfo info = fileStore.fetchInfo(0, (IProgressMonitor)monitor.newChild(1));
                    isSymbolicLink = info.getAttribute(32);
                } else {
                    isSymbolicLink = this.getUnderlyingStorage().isSymbolicLink((IProgressMonitor)monitor.newChild(1));
                }
            }
            catch (CoreException e) {
                throw new FileSystemException(NLS.bind((String)Messages.FileStorageWrapper_8, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[]{targetPath.toString(), e.getMessage()}), e);
            }
        }
        finally {
            sm.enableChangeMonitoring();
        }
        if (!isSymbolicLink) {
            throw new FileSystemException(NLS.bind((String)Messages.FileStorageWrapper_11, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[]{targetPath.toString()}));
        }
        backupShed.backupIfDirty(this.shareable, (IProgressMonitor)monitor.newChild(9));
        if (fileStore != null) {
            try {
                fileStore.delete(0, (IProgressMonitor)monitor.newChild(35));
                fileStore.symlink(targetPath, isDirectory, (IProgressMonitor)monitor.newChild(35));
            }
            catch (CoreException e) {
                throw new FileSystemException(NLS.bind((String)Messages.FileStorageWrapper_8, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[]{targetPath.toString(), e.getMessage()}), e);
            }
            this.refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)monitor.newChild(20));
        } else {
            this.getUnderlyingStorage().setSymLinkTarget(targetPath, (IProgressMonitor)monitor.newChild(90));
        }
    }

    @Override
    public boolean isDirectory(IProgressMonitor monitor) {
        SharingManager sharingManager = SharingManager.getInstance();
        sharingManager.disableChangeMonitoring();
        try {
            ManagedFileStore fileStore = this.getFileStore();
            boolean bl = fileStore.isDirectory(monitor);
            return bl;
        }
        finally {
            sharingManager.enableChangeMonitoring();
        }
    }

    @Override
    public LinkInfo getLinkInfo(IProgressMonitor progress) throws FileSystemException {
        Object info;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        String target = null;
        SharingManager sm = SharingManager.getInstance();
        sm.disableChangeMonitoring();
        try {
            try {
                ManagedFileStore fileStore = this.getFileStore();
                target = fileStore != null ? (!(info = fileStore.fetchInfo(0, (IProgressMonitor)monitor.newChild(10))).getAttribute(32) ? null : info.getStringAttribute(64)) : (this.getUnderlyingStorage().isSymbolicLink((IProgressMonitor)monitor.newChild(10)) ? this.getUnderlyingStorage().getSymLinkTarget((IProgressMonitor)monitor.newChild(90)) : null);
            }
            catch (CoreException e) {
                throw new FileSystemException(NLS.bind((String)Messages.FileStorageWrapper_12, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[]{e.getMessage()}), e);
            }
        }
        finally {
            sm.enableChangeMonitoring();
        }
        if (target == null) {
            return null;
        }
        LinkType type = this.getTargetType((IProgressMonitor)monitor.newChild(1));
        info = new LinkInfo(target, type);
        return info;
    }

    @Deprecated
    public String getTarget(IProgressMonitor monitor) throws FileSystemException {
        LinkInfo info = this.getLinkInfo(monitor);
        if (info == null) {
            return null;
        }
        return info.getTarget();
    }

    @Override
    public void backup(IBackupHandler shed, BackupDilemmaHandler dilemmaHandler, IProgressMonitor monitor) throws FileSystemException {
        this.getUnderlyingStorage().backup(shed, dilemmaHandler, monitor);
    }

    @Override
    public void delete(IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ManagedFileStore fileStore = this.getFileStore();
        if (fileStore != null) {
            SharingManager sm = SharingManager.getInstance();
            sm.disableChangeMonitoring();
            try {
                try {
                    fileStore.fetchInfo(0, (IProgressMonitor)progress.newChild(1));
                }
                catch (CoreException e) {
                    throw new FileSystemException(NLS.bind((String)Messages.FileStorageWrapper_9, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[]{e.getMessage()}), e);
                }
            }
            finally {
                sm.enableChangeMonitoring();
            }
        }
        this.getUnderlyingStorage().delete((IProgressMonitor)progress.newChild(99));
    }

    @Override
    public void delete(Shed backupShed, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        backupShed.backupIfDirty(this.shareable, (IProgressMonitor)progress.newChild(10));
        this.delete((IProgressMonitor)progress.newChild(90));
    }

    @Override
    public void deregisterRepositoryProvider(IProgressMonitor monitor) throws FileSystemException {
        this.getUnderlyingStorage().deregisterRepositoryProvider(monitor);
    }

    @Override
    public String getActualName() {
        return this.getUnderlyingStorage().getActualName();
    }

    @Override
    public String getActualNameOnDisk(IProgressMonitor monitor) {
        return this.getUnderlyingStorage().getActualNameOnDisk(monitor);
    }

    @Override
    public IFileStorage getChild(String name, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        SharingManager sm = SharingManager.getInstance();
        sm.disableChangeMonitoring();
        try {
            ResourceType childType;
            ManagedFileStore fileStore = this.getFileStore();
            if (fileStore == null) {
                if (this.getUnderlyingStorage().getResourceType((IProgressMonitor)monitor.newChild(1)) != ResourceType.FOLDER) {
                    return null;
                }
                IFileStorage iFileStorage = this.getUnderlyingStorage().getChild(name, (IProgressMonitor)monitor.newChild(99));
                return iFileStorage;
            }
            IFileInfo fileInfo = fileStore.fetchInfo(0, (IProgressMonitor)monitor.newChild(1));
            if (!fileInfo.isDirectory() || fileInfo.getAttribute(32)) {
                return null;
            }
            IFileInfo childInfo = null;
            if (this.shareable.getSandbox().isCaseSensitive()) {
                IFileStore potentialChild = fileStore.getChild(name);
                childInfo = potentialChild.fetchInfo(0, (IProgressMonitor)monitor.newChild(1));
            } else {
                String[] potentialChildren;
                String caseInsensitiveName = LocaleUtil.fileSystemNormalization((String)name);
                String[] stringArray = potentialChildren = fileStore.childNames(0, (IProgressMonitor)monitor.newChild(1));
                int n = potentialChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    String potentialChild = stringArray[n2];
                    if (potentialChild.length() == caseInsensitiveName.length() && LocaleUtil.fileSystemNormalization((String)potentialChild).equals(caseInsensitiveName)) {
                        childInfo = fileStore.getChild(potentialChild).fetchInfo(0, (IProgressMonitor)monitor.newChild(1));
                        break;
                    }
                    ++n2;
                }
            }
            if (childInfo == null) {
                return null;
            }
            IRelativeLocation childPath = this.shareable.getLocalPath().append(childInfo.getName());
            if (childInfo.getAttribute(32)) {
                childType = ResourceType.SYMBOLIC_LINK;
            } else {
                if (!childInfo.exists()) {
                    return null;
                }
                childType = childInfo.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE;
            }
            Shareable childShareable = new Shareable(this.shareable.getSandbox(), childPath, childType);
            FileStorageWrapper fileStorageWrapper = new FileStorageWrapper(childShareable, this, childType);
            return fileStorageWrapper;
        }
        catch (CoreException e) {
            throw new FileSystemException(NLS.bind((String)Messages.FileStorageWrapper_6, (Object)name, (Object[])new Object[]{this.shareable.getLocalPath().toString(), e.getMessage()}), e);
        }
        finally {
            sm.enableChangeMonitoring();
        }
    }

    @Override
    public IFileStorage getChild(IRelativeLocation relativePath, IProgressMonitor monitor) throws FileSystemException {
        IFileStorage storage = this;
        String[] nameParts = relativePath.segments();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)nameParts.length);
        String[] stringArray = nameParts;
        int n = nameParts.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (storage == null) {
                return null;
            }
            storage = storage.getChild(name, (IProgressMonitor)progress.newChild(1));
            ++n2;
        }
        return storage;
    }

    @Override
    public Collection<IFileStorage> getChildren(boolean refreshAllowed, IProgressMonitor progress) throws FileSystemException {
        return this.getUnderlyingStorage().getChildren(refreshAllowed, progress);
    }

    @Override
    public IRelativeLocation getIDEPath() {
        return this.getUnderlyingStorage().getIDEPath();
    }

    @Override
    public long getLocalTimeStamp() throws FileSystemException {
        return this.getUnderlyingStorage().getLocalTimeStamp();
    }

    @Override
    public long getModificationStamp() throws FileSystemException {
        return this.getUnderlyingStorage().getModificationStamp();
    }

    @Override
    public void setLocalTimeStamp(long timeStamp, IProgressMonitor monitor) throws FileSystemException {
        SharingManager sm = SharingManager.getInstance();
        sm.disableChangeMonitoring();
        try {
            try {
                ManagedFileStore fileStore = this.getFileStore();
                if (fileStore != null) {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    IFileInfo fileInfo = fileStore.fetchInfo(0, (IProgressMonitor)progress.newChild(50));
                    fileInfo.setLastModified(timeStamp);
                    fileStore.putInfo(fileInfo, 2048, (IProgressMonitor)progress.newChild(50));
                } else {
                    this.getUnderlyingStorage().setLocalTimeStamp(timeStamp, monitor);
                }
            }
            catch (CoreException e) {
                throw new FileSystemException(NLS.bind((String)Messages.FileStorageWrapper_2, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[]{e.getMessage()}), e);
            }
        }
        finally {
            sm.enableChangeMonitoring();
        }
    }

    @Override
    public ISchedulingRule getResourceRuleForIDE(ISharingManager.RuleKind kind) {
        return this.getUnderlyingStorage().getResourceRuleForIDE(kind);
    }

    @Override
    public boolean isRepositoryProviderRegistered(IProgressMonitor monitor) throws FileSystemException {
        return this.getUnderlyingStorage().isRepositoryProviderRegistered(monitor);
    }

    @Override
    public void move(ISandbox sandbox, IRelativeLocation relativeDestination, IProgressMonitor monitor) throws FileSystemException {
        IPath path;
        if (!sandbox.equals(this.getShareable().getSandbox())) {
            throw new IllegalArgumentException();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ResourceType resourceType = this.getResourceType((IProgressMonitor)progress.newChild(1));
        if (resourceType == null) {
            throw new FileSystemException(NLS.bind((String)Messages.FileStorageWrapper_14, (Object)this.getShareable().getLocalPath().toString(), (Object[])new Object[0]));
        }
        FileStorage source = this.getUnderlyingStorage();
        ResourceType targetHint = resourceType;
        if (resourceType == ResourceType.SYMBOLIC_LINK && this.getShareable().getFullPath().getStorageId().equals("com.ibm.team.filesystem.hfs") && (path = (IPath)this.getShareable().getFullPath().getAdapter(IPath.class)) != null) {
            targetHint = path.toFile().isDirectory() ? ResourceType.FOLDER : ResourceType.FILE;
        }
        Shareable targetShareable = new Shareable(sandbox, relativeDestination, targetHint);
        FileStorageWrapper targetStorage = new FileStorageWrapper(targetShareable, targetHint);
        SharingManager.getInstance().resolveFileStorage(targetStorage, targetHint);
        FileStorage target = targetStorage.underlyingStorage;
        source.move(target, monitor);
    }

    @Override
    public void preserveHistory(IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (ResourceType.FILE == this.getResourceType((IProgressMonitor)progress.newChild(1))) {
            this.getUnderlyingStorage().preserveHistory((IProgressMonitor)progress.newChild(99));
        }
    }

    @Override
    public void refreshCachedSubTree(int depth, IProgressMonitor monitor) throws FileSystemException {
        this.getUnderlyingStorage().refreshCachedSubTree(depth, monitor);
    }

    @Override
    public void registerRepositorProvider(IProgressMonitor monitor) throws FileSystemException {
        this.getUnderlyingStorage().registerRepositorProvider(monitor);
    }

    @Override
    public void setContents(IFileOptions fileOptions, InputStream in, Shed backupShed, IProgressMonitor monitor) throws FileSystemException {
        this.getUnderlyingStorage().setContents(fileOptions, in, backupShed, monitor);
    }

    @Override
    public boolean storageExists(IProgressMonitor progress) throws FileSystemException {
        return this.getUnderlyingStorage().storageExists(progress);
    }

    public boolean contains(ISchedulingRule rule) {
        return this.getUnderlyingStorage().contains(rule);
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return this.getUnderlyingStorage().isConflicting(rule);
    }

    public Object getAdapter(Class adapter) {
        return this.getUnderlyingStorage().getAdapter(adapter);
    }

    public final void setUnderlyingStorage(FileStorage underlyingStorage) {
        this.underlyingStorage = underlyingStorage;
    }

    @Override
    public boolean setWritable(boolean writable, IProgressMonitor progress) {
        return this.getUnderlyingStorage().setWritable(writable, progress);
    }

    @Override
    public void create(boolean createParents, Object additionalInfo, IProgressMonitor progress) throws FileSystemException {
        this.getUnderlyingStorage().create(createParents, additionalInfo, progress);
    }

    @Override
    public void create(IFileOptions fileOptions, InputStream in, IProgressMonitor monitor) throws FileSystemException {
        this.getUnderlyingStorage().create(fileOptions, in, monitor);
    }

    @Override
    public InputStream getContents(IFileOptions fileOptions) throws ContentRetrievalFailure {
        return this.getUnderlyingStorage().getContents(fileOptions);
    }

    @Override
    public IRetryRequest recoverFromUploadFailure(Exception e, IProgressMonitor progress) {
        return this.getUnderlyingStorage().recoverFromUploadFailure(e, progress);
    }

    @Override
    public InputStream getLocalChangeDetectionStream(IFileOptions fileInfo) throws ContentRetrievalFailure {
        return this.getUnderlyingStorage().getLocalChangeDetectionStream(fileInfo);
    }

    @Override
    public InputStream getContents(IFileOptions fileOptions, InputStream inputStream) throws ContentRetrievalFailure {
        return this.getUnderlyingStorage().getContents(fileOptions, inputStream);
    }

    @Override
    public ContentMeta setContentsCalcMeta(IFileOptions optionsForWrite, InputStream tmpIn, Shed backupShed, IProgressMonitor progress) throws TeamRepositoryException {
        return this.getUnderlyingStorage().setContentsCalcMeta(optionsForWrite, tmpIn, backupShed, progress);
    }
}

