/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.LinkTypeClientUtils;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.ContentHashAlgorithmException;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.Pair;
import com.ibm.team.scm.common.internal.gc.ExternalLinks;
import com.ibm.team.scm.common.internal.gc.GCUriUtils;
import com.ibm.team.scm.common.internal.gc.LinkUtils;
import com.ibm.team.scm.common.internal.gc.OslcFileLink;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class FileItemInfoProxy {
    private IVersionableHandle handle;
    private long lastContentChangeCheckStamp = -1L;
    private boolean contentChanged = false;
    private IFolderHandle parent;
    private String name;
    private boolean loadedWithAnotherName = false;
    private long contentLength = -1L;
    private ContentHash hash = null;
    private FileLineDelimiter lineDelimiter = null;
    private FileLineDelimiter originalLineDelimiter = null;
    private String contentType = null;
    private String originalContentType = null;
    ContentHash predecessorHintHash = null;
    long sizeInRepo = -1L;
    String encoding = null;
    ContentHash hashInRepo = null;
    long numLineDelimiters = -1L;
    private boolean originalExecutable = false;
    private boolean executable = false;
    private boolean originalDirectoryLink = false;
    private boolean directoryLink = false;
    private ExternalLinks externalLinks;
    private ExternalLinks originalExternalLinks;

    public FileItemInfoProxy(IVersionableHandle handle, IFolderHandle parent, String name, boolean loadedWithAnotherName) {
        this.handle = handle;
        this.parent = parent;
        this.name = name == null || name.isEmpty() ? null : name;
        this.loadedWithAnotherName = loadedWithAnotherName;
    }

    public FileItemInfoProxy(IVersionableHandle handle, IFolderHandle parent, String name) {
        this.handle = handle;
        this.parent = parent;
        this.name = name == null || name.length() == 0 ? null : name;
        this.loadedWithAnotherName = false;
    }

    public FileItemInfoProxy(FileItemInfo oldInfo) {
        this.handle = oldInfo.getVersionableHandle();
        this.hashInRepo = oldInfo.getStoredHash();
        this.contentChanged = oldInfo.isContentChanged();
        this.contentLength = oldInfo.getContentLength();
        this.contentType = oldInfo.getContentType();
        this.predecessorHintHash = oldInfo.getStoredPredecessorHintHash();
        this.encoding = oldInfo.getStoredEncoding();
        this.executable = oldInfo.isExecutable();
        this.directoryLink = oldInfo.isDirectoryLink();
        this.hash = oldInfo.getHash();
        this.lastContentChangeCheckStamp = oldInfo.getLastContentChangeCheckStamp();
        this.lineDelimiter = oldInfo.getLineDelimiter();
        this.loadedWithAnotherName = oldInfo.isLoadedWithAnotherName();
        this.name = oldInfo.getName();
        this.numLineDelimiters = oldInfo.getStoredNumLineDelimiters();
        this.originalContentType = oldInfo.getOriginalContentType();
        this.originalExecutable = oldInfo.isOriginalExecutable();
        this.originalDirectoryLink = oldInfo.isOriginalDirectoryLink();
        this.originalLineDelimiter = oldInfo.getOriginalLineDelimiter();
        this.originalExternalLinks = oldInfo.getOriginalExternalLinks();
        this.externalLinks = oldInfo.getExternalLinks();
        this.parent = oldInfo.getParent();
        this.sizeInRepo = oldInfo.getStoredSize();
    }

    public FileItemInfo getFileItemInfo() {
        if (this.handle instanceof IFolderHandle) {
            return new FileItemInfo((IFolderHandle)this.handle, this.parent, this.name, this.loadedWithAnotherName);
        }
        if (this.handle instanceof ISymbolicLinkHandle) {
            return new FileItemInfo((ISymbolicLinkHandle)this.handle, this.contentChanged, this.parent, this.name, this.loadedWithAnotherName, this.hash, this.hashInRepo, this.directoryLink, this.originalDirectoryLink);
        }
        return new FileItemInfo(this.handle, this.contentChanged, this.lastContentChangeCheckStamp, this.parent, this.name, this.loadedWithAnotherName, this.hash, this.contentLength, this.originalLineDelimiter, this.lineDelimiter, this.originalContentType, this.contentType, this.predecessorHintHash, this.sizeInRepo, this.encoding, this.hashInRepo, this.numLineDelimiters, this.executable, this.originalExecutable, false, false, this.externalLinks, this.originalExternalLinks);
    }

    public void setContentInfo(long modificationStamp, ContentHash hashCode, long contentSize, FileContent content) {
        this.contentChanged = false;
        this.lastContentChangeCheckStamp = modificationStamp;
        this.hash = hashCode;
        this.contentLength = contentSize;
        this.originalLineDelimiter = content.getLineDelimiter();
        this.lineDelimiter = content.getLineDelimiter();
        this.predecessorHintHash = content.getPredecessorHintHash();
        this.sizeInRepo = content.getSize();
        this.encoding = content.getCharacterEncoding();
        this.hashInRepo = content.getHash();
        this.numLineDelimiters = content.getLineDelimiterCount();
    }

    public void setContentChanged(boolean contentChanged, long modificationStamp) {
        this.contentChanged = contentChanged;
        this.lastContentChangeCheckStamp = modificationStamp;
    }

    public void setProperties(IVersionable versionable, ExternalLinks newExternalLinks) {
        if (versionable instanceof IFileItem) {
            IFileItem fileItem = (IFileItem)versionable;
            this.originalExecutable = fileItem.isExecutable();
            this.executable = fileItem.isExecutable();
            this.originalContentType = fileItem.getContentType();
            this.contentType = fileItem.getContentType();
        } else if (versionable instanceof ISymbolicLink) {
            ISymbolicLink link = (ISymbolicLink)versionable;
            this.originalDirectoryLink = link.isDirectoryLink();
            this.directoryLink = link.isDirectoryLink();
        }
        this.originalExternalLinks = newExternalLinks;
        this.externalLinks = newExternalLinks;
    }

    public void setContentType(String contentType) {
        this.originalContentType = contentType;
        this.contentType = contentType;
    }

    public void setExecutable(boolean originalExecutable, boolean executable) {
        this.originalExecutable = originalExecutable;
        this.executable = executable;
    }

    public void setLinks(ExternalLinks links) {
        this.externalLinks = links;
        this.originalExternalLinks = links;
    }

    public void setItemState(IVersionableHandle itemState) {
        this.handle = itemState;
    }

    public void changeIdentity(IFolderHandle newParent, String newName) {
        this.parent = newParent;
        this.name = newName;
    }

    public void changeProperties(boolean contentChanged, long lastContentChangeCheckStamp, FileLineDelimiter currentLineDelimiter, String currentContentType, boolean currentExecutable) {
        this.contentChanged = contentChanged;
        this.lastContentChangeCheckStamp = lastContentChangeCheckStamp;
        this.lineDelimiter = currentLineDelimiter;
        this.contentType = currentContentType;
        this.executable = currentExecutable;
    }

    public void addExternalLinks(ExternalLinks links, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.externalLinks == null) {
            this.externalLinks = links;
        } else {
            this.checkDuplicatedLinks(links, repo, monitor);
            this.externalLinks = LinkUtils.union((ExternalLinks)this.externalLinks, (ExternalLinks)links);
        }
    }

    private void checkDuplicatedLinks(ExternalLinks newLinks, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        Collection existingOslcFileLinks = LinkTypeClientUtils.asOslcFileLinks((ExternalLinks)this.externalLinks, null, (ITeamRepository)repo, (IProgressMonitor)progress.newChild(1));
        Collection newOslcFileLinks = LinkTypeClientUtils.asOslcFileLinks((ExternalLinks)newLinks, null, (ITeamRepository)repo, (IProgressMonitor)progress.newChild(1));
        for (Pair newLink : newOslcFileLinks) {
            for (Pair existingLink : existingOslcFileLinks) {
                if (!GCUriUtils.isSameLink((OslcFileLink)((OslcFileLink)newLink.getSecond()), (OslcFileLink)((OslcFileLink)existingLink.getSecond()))) continue;
                throw new TeamRepositoryException(NLS.bind((String)Messages.Duplicated_Links, (Object)((OslcFileLink)existingLink.getSecond()).getRelationshipDisplayName(), (Object[])new Object[0]));
            }
        }
    }

    public void removeExternalLinks(ExternalLinks links) {
        if (this.externalLinks != null) {
            this.externalLinks = LinkUtils.difference((ExternalLinks)this.externalLinks, (ExternalLinks)links);
            if (this.externalLinks.isEmpty()) {
                this.externalLinks = null;
            }
        }
    }

    public void setNewExternalLinks(ExternalLinks links) throws TeamRepositoryException {
        this.externalLinks = links != null && !links.isEmpty() ? ExternalLinks.create((ExternalLinks)links) : null;
    }

    public void setTarget(long modificationStamp, String target, String targetInLocalForm, boolean directoryLink) throws FileSystemException {
        this.contentChanged = false;
        this.lastContentChangeCheckStamp = modificationStamp;
        this.hash = FileItemInfoProxy.getLinkTargetHash(targetInLocalForm);
        this.hashInRepo = FileItemInfoProxy.getLinkTargetHash(target);
        this.directoryLink = directoryLink;
        this.originalDirectoryLink = directoryLink;
    }

    public void setDirectoryLink(boolean directoryLink) {
        this.directoryLink = directoryLink;
    }

    public static ContentHash getLinkTargetHash(String linkTarget) throws FileSystemException {
        try {
            return CopyFileArea.getLinkHash(linkTarget);
        }
        catch (ContentHashAlgorithmException e) {
            throw new FileSystemException(NLS.bind((String)Messages.FileItemInfoProxy_0, (Object)linkTarget, (Object[])new Object[0]), e);
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
    }
}

