/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.gc.ExternalLinks;
import java.util.Collections;
import org.eclipse.core.runtime.Assert;

public class FileItemInfo {
    public static final long NULL_STAMP = -1L;
    public static final long NULL_DELIMITER_COUNT = -1L;
    private final IVersionableHandle handle;
    private final long lastContentChangeCheckStamp;
    private final boolean contentChanged;
    private final IFolderHandle parent;
    private final String name;
    private final boolean loadedWithAnotherName;
    public static final long NULL_SIZE = -1L;
    private final long contentLength;
    private final ContentHash hash;
    private final FileLineDelimiter lineDelimiter;
    private final FileLineDelimiter originalLineDelimiter;
    private final String contentType;
    private final String originalContentType;
    private final ContentHash predecessorHintHash;
    private final long sizeInRepo;
    private final String encoding;
    private final ContentHash storedHash;
    private final long numLineDelimiters;
    private final boolean originalExecutable;
    private final boolean executable;
    private final boolean originalDirectoryLink;
    private final boolean directoryLink;
    private final ExternalLinks externalLinks;
    private final ExternalLinks originalExternalLinks;

    public FileItemInfo(IVersionableHandle handle, boolean contentChanged, long lastContentChangeCheckStamp, IFolderHandle parent, String name, boolean loadedAsAlternativeName, ContentHash hash, long size, FileLineDelimiter originalLineDelimiter, FileLineDelimiter lineDelimiter, String originalContentType, String contentType, ContentHash contentPredecessorHintHash, long contentSizeInRepo, String originalEncoding, ContentHash hashInRepo, long lineDelimiterCountInRepo, boolean executable, boolean originalExecutable, boolean directoryLink, boolean originalDirectoryLink, ExternalLinks externalLinks, ExternalLinks originalExternalLinks) {
        this.validateFileItemInfo(handle, parent, name, loadedAsAlternativeName);
        if (handle instanceof IFileItemHandle) {
            if (contentType == null && originalContentType != null) {
                throw new IllegalArgumentException();
            }
            if (lineDelimiter == null && originalLineDelimiter != null) {
                throw new IllegalArgumentException();
            }
        } else {
            if (originalContentType != null || contentType != null) {
                throw new IllegalArgumentException();
            }
            if (originalLineDelimiter != null || lineDelimiter != null) {
                throw new IllegalArgumentException();
            }
            executable = false;
            originalExecutable = false;
        }
        if (!(handle instanceof ISymbolicLinkHandle)) {
            directoryLink = false;
            originalDirectoryLink = false;
        }
        if (!handle.hasStateId() || handle instanceof IFolderHandle) {
            if (hash != null) {
                throw new IllegalArgumentException();
            }
            if (lastContentChangeCheckStamp != -1L) {
                throw new IllegalArgumentException();
            }
            if (contentChanged) {
                throw new IllegalArgumentException();
            }
            if (size != -1L) {
                throw new IllegalArgumentException();
            }
            if (originalLineDelimiter != null) {
                throw new IllegalArgumentException();
            }
            if (originalContentType != null) {
                throw new IllegalArgumentException();
            }
            if (contentPredecessorHintHash != null) {
                throw new IllegalArgumentException();
            }
            if (contentSizeInRepo != -1L) {
                throw new IllegalArgumentException();
            }
            if (originalEncoding != null) {
                throw new IllegalArgumentException();
            }
            if (hashInRepo != null) {
                throw new IllegalArgumentException();
            }
            if (lineDelimiterCountInRepo != -1L) {
                throw new IllegalArgumentException();
            }
        } else if (handle.hasStateId()) {
            if (hash == null) {
                throw new IllegalArgumentException();
            }
            if (hashInRepo == null) {
                throw new IllegalArgumentException();
            }
            if (handle instanceof IFileItemHandle ? size == -1L : size != -1L) {
                throw new IllegalArgumentException();
            }
        }
        if (hashInRepo == null) {
            Assert.isTrue((originalLineDelimiter == null ? 1 : 0) != 0);
            Assert.isTrue((originalContentType == null ? 1 : 0) != 0);
            Assert.isTrue((contentPredecessorHintHash == null ? 1 : 0) != 0);
            Assert.isTrue((contentSizeInRepo == -1L ? 1 : 0) != 0);
            Assert.isTrue((originalEncoding == null ? 1 : 0) != 0);
            Assert.isTrue((lineDelimiterCountInRepo == -1L ? 1 : 0) != 0);
        } else {
            Assert.isTrue((boolean)handle.hasStateId());
            Assert.isTrue((!(handle instanceof IFolderHandle) ? 1 : 0) != 0);
            if (handle instanceof IFileItemHandle) {
                Assert.isTrue((contentSizeInRepo != -1L ? 1 : 0) != 0);
                Assert.isTrue((originalLineDelimiter != null ? 1 : 0) != 0);
                Assert.isTrue((originalContentType != null ? 1 : 0) != 0);
            } else {
                Assert.isTrue((contentSizeInRepo == -1L ? 1 : 0) != 0);
                Assert.isTrue((originalLineDelimiter == null ? 1 : 0) != 0);
                Assert.isTrue((originalContentType == null ? 1 : 0) != 0);
            }
        }
        this.handle = handle;
        this.parent = parent;
        this.name = name;
        this.loadedWithAnotherName = loadedAsAlternativeName;
        this.lastContentChangeCheckStamp = lastContentChangeCheckStamp;
        this.contentChanged = contentChanged;
        this.hash = hash;
        this.contentLength = size;
        this.lineDelimiter = lineDelimiter;
        this.originalLineDelimiter = originalLineDelimiter;
        this.originalContentType = originalContentType;
        this.contentType = contentType;
        this.predecessorHintHash = contentPredecessorHintHash;
        this.sizeInRepo = contentSizeInRepo;
        this.encoding = originalEncoding;
        this.storedHash = hashInRepo;
        this.numLineDelimiters = lineDelimiterCountInRepo;
        this.executable = executable;
        this.originalExecutable = originalExecutable;
        this.directoryLink = directoryLink;
        this.originalDirectoryLink = originalDirectoryLink;
        this.externalLinks = externalLinks;
        this.originalExternalLinks = originalExternalLinks;
    }

    public FileItemInfo(IFolderHandle handle, IFolderHandle parent, String name, boolean loadedWithAlternativeName) {
        this.validateFileItemInfo((IVersionableHandle)handle, parent, name, loadedWithAlternativeName);
        this.handle = handle;
        this.parent = parent;
        this.name = name;
        this.loadedWithAnotherName = loadedWithAlternativeName;
        this.lastContentChangeCheckStamp = -1L;
        this.contentChanged = false;
        this.contentLength = -1L;
        this.originalLineDelimiter = null;
        this.lineDelimiter = null;
        this.hash = null;
        this.originalContentType = null;
        this.contentType = null;
        this.predecessorHintHash = null;
        this.sizeInRepo = -1L;
        this.encoding = null;
        this.storedHash = null;
        this.numLineDelimiters = -1L;
        this.originalExecutable = false;
        this.executable = false;
        this.directoryLink = false;
        this.originalDirectoryLink = false;
        this.externalLinks = null;
        this.originalExternalLinks = null;
    }

    public FileItemInfo(ISymbolicLinkHandle handle, boolean contentChanged, IFolderHandle parent, String name, boolean loadedAsAlternativeName, ContentHash hash, ContentHash hashInRepo, boolean directoryLink, boolean originalDirectoryLink) {
        this((IVersionableHandle)handle, contentChanged, -1L, parent, name, loadedAsAlternativeName, hash, -1L, null, null, null, null, null, -1L, null, hashInRepo, -1L, false, false, directoryLink, originalDirectoryLink, null, null);
    }

    private void validateFileItemInfo(IVersionableHandle handle, IFolderHandle parent, String name, boolean loadedWithAlternativeName) {
        Assert.isNotNull((Object)handle);
        Assert.isTrue((!handle.hasFullState() ? 1 : 0) != 0);
        Assert.isTrue((parent == null || !parent.hasFullState() ? 1 : 0) != 0);
        if (name != null && name.length() == 0) {
            name = null;
        }
        Assert.isTrue((parent == null == (name == null) ? 1 : 0) != 0);
        Assert.isTrue((parent == null || handle.hasStateId() ? 1 : 0) != 0);
        if (handle.hasStateId() && parent == null) {
            Assert.isTrue((boolean)loadedWithAlternativeName);
        } else if (!handle.hasStateId()) {
            Assert.isTrue((!loadedWithAlternativeName ? 1 : 0) != 0);
        }
        Assert.isTrue((parent != null || !handle.hasStateId() || handle instanceof IFolderHandle ? 1 : 0) != 0);
    }

    public IVersionableHandle getVersionableHandle() {
        return this.handle;
    }

    public boolean isFolder() {
        return this.handle instanceof IFolderHandle;
    }

    public boolean isFile() {
        return this.handle instanceof IFileItemHandle;
    }

    public boolean isSymbolicLink() {
        return this.handle instanceof ISymbolicLinkHandle;
    }

    public long getLastContentChangeCheckStamp() {
        return this.lastContentChangeCheckStamp;
    }

    public boolean isContentChanged() {
        return this.contentChanged;
    }

    public IFolderHandle getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public boolean isLoadedWithAnotherName() {
        return this.loadedWithAnotherName;
    }

    public ContentHash getHash() {
        return this.hash;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public FileLineDelimiter getOriginalLineDelimiter() {
        return this.originalLineDelimiter;
    }

    public FileLineDelimiter getLineDelimiter() {
        return this.lineDelimiter;
    }

    public String getOriginalContentType() {
        return this.originalContentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ContentHash getStoredPredecessorHintHash() {
        return this.predecessorHintHash;
    }

    public long getStoredSize() {
        return this.sizeInRepo;
    }

    public String getStoredEncoding() {
        return this.encoding;
    }

    public ContentHash getStoredHash() {
        return this.storedHash;
    }

    public long getStoredNumLineDelimiters() {
        return this.numLineDelimiters;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public boolean isOriginalExecutable() {
        return this.originalExecutable;
    }

    public boolean isDirectoryLink() {
        return this.directoryLink;
    }

    public boolean isOriginalDirectoryLink() {
        return this.originalDirectoryLink;
    }

    public InverseFileItemInfo createInverseFileItemInfoForLocalItem(IFolderHandle localParent, String localName) {
        return new InverseFileItemInfo(this.getVersionableHandle(), false, -1L, null, null, false, Collections.EMPTY_MAP, localParent, localName, null, -1L, null, this.getLineDelimiter(), null, this.getContentType(), null, -1L, null, null, -1L, this.isExecutable(), false, this.isDirectoryLink(), false, Collections.EMPTY_MAP, Collections.EMPTY_SET, Collections.EMPTY_MAP, this.getExternalLinks(), this.getOriginalExternalLinks());
    }

    public ExternalLinks getExternalLinks() {
        return this.externalLinks;
    }

    public ExternalLinks getOriginalExternalLinks() {
        return this.originalExternalLinks;
    }
}

