/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class ClientRepositoryUtil {
    public static ITeamRepository getDefaultRepository() {
        ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        if (repositories.length == 1) {
            return repositories[0];
        }
        boolean found = false;
        ITeamRepository targetRepository = null;
        int i = 0;
        while (i < repositories.length) {
            ITeamRepository teamRepository = repositories[i];
            if (teamRepository.loggedIn()) {
                if (found) {
                    targetRepository = null;
                } else {
                    targetRepository = teamRepository;
                    found = true;
                }
            }
            ++i;
        }
        return targetRepository;
    }

    public static ITeamRepository getRepository(IItemHandle sharedItem) throws IllegalArgumentException {
        Object origin = sharedItem.getOrigin();
        if (origin instanceof ITeamRepository) {
            return (ITeamRepository)origin;
        }
        throw new IllegalArgumentException("Argument was not a shared item");
    }

    public static void checkCanceled(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException(Messages.ClientRepositoryUtil_0);
        }
    }

    public static boolean isSharedItem(ITeamRepository repo, IItem toTest) {
        try {
            return repo.itemManager().getImmutableState(toTest) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

