/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.FileContentInputStreamProvider;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.common.changemodel.VersionablePathSegment;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IVersionableIdentifier;
import com.ibm.team.scm.common.internal.ItemWithLinks;
import com.ibm.team.scm.common.internal.gc.ExternalLinks;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ClientFileStateFactory {
    public static FileState create(ITeamRepository repo, IItemType type, ItemWithLinks<? extends IVersionable> itemWithLinks) {
        return ClientFileStateFactory.create(repo, type, itemWithLinks, false, null);
    }

    public static FileState create(ITeamRepository repo, IItemType type, ItemWithLinks<? extends IVersionable> itemWithLinks, boolean getVersionIds, IProgressMonitor monitor) {
        if (itemWithLinks == null) {
            return ClientFileStateFactory.create(type);
        }
        IVersionable item = (IVersionable)itemWithLinks.getItem();
        if (item instanceof IFileItem) {
            IFileItem fileItem = (IFileItem)item;
            return ClientFileStateFactory.getFileState(repo, fileItem, itemWithLinks.getLinks(), getVersionIds, monitor);
        }
        if (item instanceof IFolder) {
            return FileState.create((VersionablePathSegment)VersionablePathSegment.pathFor((IVersionable)item), (Date)item.modified(), (boolean)false, (Map)item.getUserProperties(), (StateId)StateId.forItem((IItem)item));
        }
        if (item instanceof ISymbolicLink) {
            return ClientFileStateFactory.getSymbolicLinkState(repo, (ISymbolicLink)item);
        }
        return FileState.getDeletedState((IItemType)type, (VersionablePathSegment)VersionablePathSegment.pathFor((IVersionable)item));
    }

    public static FileState create(IItemType type) {
        return FileState.getDeletedState((IItemType)type, null);
    }

    @Deprecated
    public static FileState create(ITeamRepository repo, IItemType type, IVersionable item) {
        if (item == null) {
            return ClientFileStateFactory.create(type);
        }
        ItemWithLinks withLinks = new ItemWithLinks((IItem)item);
        return ClientFileStateFactory.create(repo, type, (ItemWithLinks<? extends IVersionable>)withLinks);
    }

    private static FileState getFileState(ITeamRepository repo, IFileItem item, ExternalLinks links, boolean getVersionIds, IProgressMonitor monitor) {
        IFileContent content = item.getContent();
        String mimeType = item.getContentType();
        FileLineDelimiter delimiter = content.getLineDelimiter();
        boolean isText = FileState.isTextType((String)mimeType);
        FileState.VersionIdType versionIds = FileState.VERSION_IDS_UNKNOWN;
        if (getVersionIds) {
            versionIds = ClientFileStateFactory.getVersionIds(repo, (IVersionableHandle)item, monitor);
        }
        FileContentInputStreamProvider inputStreamProvider = new FileContentInputStreamProvider(repo, (IFileItemHandle)item, content);
        return FileState.create((VersionablePathSegment)VersionablePathSegment.pathFor((IVersionable)item), (Date)item.getFileTimestamp(), (IInputStreamProvider)inputStreamProvider, (boolean)item.isExecutable(), (String)mimeType, (FileLineDelimiter)delimiter, (boolean)isText, (String)content.getCharacterEncoding(), (boolean)false, (Map)item.getUserProperties(), (StateId)StateId.forItem((IItem)item), (ExternalLinks)links, (FileState.VersionIdType)versionIds);
    }

    private static FileState.VersionIdType getVersionIds(ITeamRepository repository, IVersionableHandle versionableHandle, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        try {
            IVersionableIdentifier identifier = wm.getVersionableIdentifiers(new IVersionableHandle[]{versionableHandle}, (IProgressMonitor)progress.newChild(100))[0];
            if (identifier == null) {
                return FileState.VERSION_IDS_UNKNOWN;
            }
            return FileState.createVersionIds((String)identifier.getShortVersionId(), (String)identifier.getLongVersionId());
        }
        catch (TeamRepositoryException e) {
            return FileState.VERSION_IDS_UNKNOWN;
        }
    }

    private static FileState getSymbolicLinkState(ITeamRepository repo, ISymbolicLink item) {
        String target = item.getTarget();
        boolean directoryLink = item.isDirectoryLink();
        return FileState.create((VersionablePathSegment)VersionablePathSegment.pathFor((IVersionable)item), (Date)item.modified(), (boolean)false, (Map)item.getUserProperties(), (StateId)StateId.forItem((IItem)item), (String)target, (boolean)directoryLink);
    }
}

