/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.ClientFileStateFactory;
import com.ibm.team.filesystem.common.changemodel.ConfigurationChange;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.common.changemodel.StateNode;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.FetchedItems;
import com.ibm.team.scm.common.internal.ItemWithLinks;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ClientConfigurationChangeFactory {
    public static Map<ItemId<IChangeSet>, ConfigurationChange> createChanges(ITeamRepository repository, Collection<IChangeSet> changeSetList, IProgressMonitor monitor) throws TeamRepositoryException {
        return ClientConfigurationChangeFactory.createChanges(repository, changeSetList, null, monitor);
    }

    public static Map<ItemId<IChangeSet>, ConfigurationChange> createChanges(ITeamRepository repository, Collection<IChangeSet> changeSetList, List<String> changeItemIds, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repo = repository;
        progress.setWorkRemaining(changeSetList.size());
        HashSet<StateId> toFetch = new HashSet<StateId>();
        for (IChangeSet nextChangeSet : changeSetList) {
            List nextChanges = nextChangeSet.changes();
            for (IChange next : nextChanges) {
                toFetch.addAll(ChangeSetUtil.getBeforeStates((IChange)next));
                toFetch.add(ChangeSetUtil.getAfterState((IChange)next));
            }
        }
        HashMap<ItemId<IChangeSet>, ConfigurationChange> result = new HashMap<ItemId<IChangeSet>, ConfigurationChange>();
        FetchedItems fetched = RepoFetcher.fetchItemsWithLinks((ITeamRepository)repository, toFetch, (IProgressMonitor)progress.newChild(50));
        for (IChangeSet nextChangeSet : changeSetList) {
            ConfigurationChange nextChange = ClientConfigurationChangeFactory.createChange((FetchedItems<IVersionable>)fetched, repo, nextChangeSet, changeItemIds);
            result.put((ItemId<IChangeSet>)ItemId.forItem((IItem)nextChangeSet), nextChange);
        }
        return result;
    }

    public static ConfigurationChange createChange(FetchedItems<IVersionable> versionables, ITeamRepository repo, IChangeSet changeSet) {
        return ClientConfigurationChangeFactory.createChange(versionables, repo, changeSet, null);
    }

    public static ConfigurationChange createChange(FetchedItems<IVersionable> versionables, ITeamRepository repo, IChangeSet changeSet, List<String> changeItemIds) {
        ConfigurationChange nextChange = new ConfigurationChange();
        ItemId component = ChangeSetUtil.getComponent((IChangeSet)changeSet);
        List nextChanges = changeSet.changes();
        for (IChange next : nextChanges) {
            boolean found = false;
            UUID affectedItem = next.item().getItemId();
            for (StateId versionable : versionables.keySet()) {
                if (!versionable.getItemUUID().equals((Object)affectedItem) || changeItemIds != null && !changeItemIds.contains(affectedItem.getUuidValue())) continue;
                found = true;
                break;
            }
            if (!found) continue;
            StateId beforeState = ChangeSetUtil.getLastMergeState((IChange)next);
            StateId afterState = ChangeSetUtil.getAfterState((IChange)next);
            ItemWithLinks afterVersionable = versionables.getItemWithLinks(afterState);
            FileState after = ClientFileStateFactory.create(repo, afterState.getItemType(), (ItemWithLinks<? extends IVersionable>)afterVersionable);
            for (StateId nextBeforeState : ChangeSetUtil.getBeforeStates((IChange)next)) {
                ItemWithLinks beforeVersionable = versionables.getItemWithLinks(nextBeforeState);
                FileState before = ClientFileStateFactory.create(repo, beforeState.getItemType(), (ItemWithLinks<? extends IVersionable>)beforeVersionable);
                FileChange nextFileChange = new FileChange(before, after, SiloedItemId.create((ItemId)beforeState.getItemId(), (ItemId)component));
                if (nextBeforeState.equals((Object)beforeState)) {
                    nextChange.addChange(nextFileChange);
                    continue;
                }
                nextChange.addMerge(nextFileChange);
            }
        }
        return nextChange;
    }

    public static ConfigurationChange createChange(ITeamRepository repository, Collection<IChangeSet> changeSetList, List<String> changeItemIds, IProgressMonitor monitor) throws TeamRepositoryException {
        Collection<ConfigurationChange> individualChanges = ClientConfigurationChangeFactory.createChanges(repository, changeSetList, changeItemIds, monitor).values();
        ConfigurationChange netChange = ConfigurationChange.merge(individualChanges);
        return netChange;
    }

    public static ConfigurationChange createChange(ITeamRepository repository, Collection<IChangeSet> changeSetList, IProgressMonitor monitor) throws TeamRepositoryException {
        return ClientConfigurationChangeFactory.createChange(repository, changeSetList, null, monitor);
    }

    public static ConfigurationChange createChangeForHandles(ITeamRepository repo, List<ItemId<IChangeSet>> changeSetHandle, List<String> changeItemIds, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Map fetched = RepoFetcher.fetchCurrents((ITeamRepository)repo, changeSetHandle, (boolean)true, (IProgressMonitor)progress.newChild(10));
        List ordered = CollectionUtil.reorderValues((Map)fetched, changeSetHandle);
        return ClientConfigurationChangeFactory.createChange(repo, ordered, changeItemIds, (IProgressMonitor)progress);
    }

    public static ConfigurationChange createChangeForHandles(ITeamRepository repo, List<ItemId<IChangeSet>> changeSetHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return ClientConfigurationChangeFactory.createChangeForHandles(repo, changeSetHandle, null, monitor);
    }

    public static final List<FileChange> getChangeForTarget(ITeamRepository repository, List<IChangeSet> changeSetList, boolean getVersionIds, SubMonitor monitor, SiloedItemId<IVersionable> target) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repo = repository;
        progress.setWorkRemaining(changeSetList.size());
        HashSet<StateId> toFetch = new HashSet<StateId>();
        for (IChangeSet nextChangeSet : changeSetList) {
            List nextChanges = nextChangeSet.changes();
            for (IChange next : nextChanges) {
                if (!target.getItemUUID().equals((Object)next.item().getItemId())) continue;
                toFetch.addAll(ChangeSetUtil.getBeforeStates((IChange)next));
                toFetch.add(ChangeSetUtil.getAfterState((IChange)next));
            }
        }
        HashMap<ItemId, ConfigurationChange> result = new HashMap<ItemId, ConfigurationChange>();
        FetchedItems fetched = RepoFetcher.fetchItemsWithLinks((ITeamRepository)repository, toFetch, (IProgressMonitor)progress.newChild(40));
        for (IChangeSet nextChangeSet : changeSetList) {
            ConfigurationChange nextChange = new ConfigurationChange();
            ItemId component = ChangeSetUtil.getComponent((IChangeSet)nextChangeSet);
            List nextChanges = nextChangeSet.changes();
            SubMonitor changeLoopMonitor = progress.newChild(10).setWorkRemaining(nextChanges.size() * 2);
            for (IChange next : nextChanges) {
                if (!target.getItemUUID().equals((Object)next.item().getItemId())) continue;
                StateId beforeState = ChangeSetUtil.getLastMergeState((IChange)next);
                StateId afterState = ChangeSetUtil.getAfterState((IChange)next);
                ItemWithLinks afterVersionable = fetched.getItemWithLinks(afterState);
                FileState after = ClientFileStateFactory.create(repo, afterState.getItemType(), (ItemWithLinks<? extends IVersionable>)afterVersionable, getVersionIds, (IProgressMonitor)changeLoopMonitor.newChild(1));
                SubMonitor stateLoopMonitor = changeLoopMonitor.newChild(1).setWorkRemaining(nextChanges.size());
                for (StateId nextBeforeState : ChangeSetUtil.getBeforeStates((IChange)next)) {
                    ItemWithLinks beforeVersionable = fetched.getItemWithLinks(nextBeforeState);
                    FileState before = ClientFileStateFactory.create(repo, beforeState.getItemType(), (ItemWithLinks<? extends IVersionable>)beforeVersionable, getVersionIds, (IProgressMonitor)stateLoopMonitor.newChild(1));
                    FileChange nextFileChange = new FileChange(before, after, SiloedItemId.create((ItemId)beforeState.getItemId(), (ItemId)component));
                    if (nextBeforeState.equals((Object)beforeState)) {
                        nextChange.addChange(nextFileChange);
                        continue;
                    }
                    nextChange.addMerge(nextFileChange);
                }
            }
            result.put(ItemId.forItem((IItem)nextChangeSet), nextChange);
        }
        HashMap<ItemId, ConfigurationChange> createChanges = result;
        Collection individualChanges = createChanges.values();
        ConfigurationChange result1 = new ConfigurationChange();
        for (ConfigurationChange nextConfig : individualChanges) {
            for (StateNode next : nextConfig.getStateGraph().values()) {
                if (!next.getState().getStateId().getItemUUID().equals((Object)target.getItemUUID())) continue;
                for (FileChange nextChange : next.getActiveIncoming()) {
                    result1.addChange(nextChange);
                }
                for (FileChange nextMerge : next.getMerges()) {
                    result1.addMerge(nextMerge);
                }
            }
        }
        ConfigurationChange netChange = result1;
        return netChange.getChanges(target);
    }
}

