/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.internal.repository.rcp.streams.DigestComputingOutputStream;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.eclipse.core.runtime.Assert;

public class ChangeTrackingOutputStream
extends DigestComputingOutputStream {
    final ContentHash targetHash;
    final IFileItemHandle handle;
    private final Share share;
    final ManagedFileStore managed;
    final long targetSize;
    boolean closed = false;

    public ChangeTrackingOutputStream(MessageDigest start, OutputStream out, ManagedFileStore managed, IFileItemHandle handle, Share share, ContentHash targetHash, long targetSize) {
        super(start, out);
        this.managed = managed;
        this.handle = handle;
        this.share = share;
        this.targetHash = targetHash;
        this.targetSize = targetSize;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.close();
        ISharingDescriptor desc = this.share.getSharingDescriptor();
        try {
            AbstractLock lock = CFALockUtil.lockExistingForUpdate(this.share.getSandbox().getRoot(), desc.getConnectionHandle(), desc.getComponent(), null);
            if (lock == null) {
                return;
            }
            try {
                CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(this.share.getSandbox().getRoot());
                IRelativeLocation path = cfa.getLocalPathFor((IVersionableHandle)this.handle, this.share.getSharingDescriptor().getComponent(), this.share.getSharingDescriptor().getConnectionHandle(), null);
                if (path != null) {
                    ContentHash hash;
                    boolean modified;
                    FileItemInfo fiInfo = cfa.getItemInfo(path);
                    Assert.isTrue((boolean)fiInfo.getVersionableHandle().sameItemId((IItemHandle)this.handle));
                    if (this.targetSize == this.getContentSize()) {
                        this.managed.addDatelessItem((IVersionableHandle)this.handle, this.share.getSharingDescriptor().getComponent(), this.share.getSharingDescriptor().getConnectionHandle(), null);
                    }
                    boolean bl = modified = !(hash = ContentHash.valueOf((byte[])this.getFinalDigest())).equals((Object)this.targetHash) || this.targetSize != this.getContentSize();
                    if (modified != fiInfo.isContentChanged()) {
                        long modStamp = new Shareable(this.share.getSandboxRoot(), path, ResourceType.FILE).getFileStorage().getModificationStamp();
                        cfa.setItemMetaData(path, new FileItemInfo(fiInfo.getVersionableHandle(), modified, modStamp, fiInfo.getParent(), fiInfo.getName(), fiInfo.isLoadedWithAnotherName(), fiInfo.getHash(), fiInfo.getContentLength(), fiInfo.getOriginalLineDelimiter(), fiInfo.getLineDelimiter(), fiInfo.getOriginalContentType(), fiInfo.getContentType(), fiInfo.getStoredPredecessorHintHash(), fiInfo.getStoredSize(), fiInfo.getStoredEncoding(), fiInfo.getStoredHash(), fiInfo.getStoredNumLineDelimiters(), fiInfo.isExecutable(), fiInfo.isOriginalExecutable(), fiInfo.isDirectoryLink(), fiInfo.isOriginalDirectoryLink(), fiInfo.getExternalLinks(), fiInfo.getOriginalExternalLinks()), ICopyFileArea.PropertyUpdate.PRESERVE, null, null);
                    }
                }
            }
            finally {
                CFALockUtil.endBatching(lock, null);
            }
        }
        catch (FileSystemException e) {
            LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, "com.ibm.team.filesystem.client", "Error aquiring path for shareable", (Throwable)((Object)e)));
            return;
        }
    }

    protected void finalize() throws IOException {
        if (!this.closed) {
            this.close();
            LoggingHelper.log("com.ibm.team.filesystem.client", new FileSystemException("Stream finalized without beind close()ed"));
        }
    }
}

