/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.common.FileKeyword;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractKeywordProcessingInputStream
extends FilterInputStream {
    public static final int MAX_EXPANDED_SIZE = 256;
    public static final int BUFFER_SIZE = 1024;
    public static final char KEYWORD_DELIMITER = '$';
    public static final char KEYWORD_SEPARATOR = ':';
    private int bufferSize;
    private int bufferPosition;
    private byte[] buffer = new byte[1024];
    private boolean endOfFileReached;

    protected AbstractKeywordProcessingInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        byte[] readBuffer = new byte[1];
        int size = 0;
        while (size == 0) {
            size = this.read(readBuffer, 0, 1);
        }
        if (size == 1) {
            return readBuffer[0];
        }
        return size;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0) {
            throw new IllegalArgumentException();
        }
        if (len == 0) {
            return 0;
        }
        this.fillBufferIfNecessary();
        if (this.bufferPosition >= this.bufferSize && this.endOfFileReached) {
            return -1;
        }
        int nextDelimiter = this.findNextKeywordDelimiterInBuffer(this.bufferPosition);
        int maxToGive = Math.min(len, this.bufferSize - this.bufferPosition);
        if (nextDelimiter >= 0) {
            if (this.isPotentialKeywordStart(nextDelimiter)) {
                if (nextDelimiter > this.bufferPosition) {
                    maxToGive = Math.min(maxToGive, nextDelimiter - this.bufferPosition);
                } else {
                    if (this.isPotentialKeywordAtEndOfBuffer(nextDelimiter)) {
                        this.shiftAndFillBuffer(nextDelimiter);
                        nextDelimiter = 0;
                    }
                    if (this.isKeywordStart(nextDelimiter)) {
                        return this.handleKeyword(nextDelimiter, b, off, len);
                    }
                    maxToGive = Math.min(maxToGive, nextDelimiter - this.bufferPosition + 1);
                }
            } else {
                maxToGive = Math.min(maxToGive, nextDelimiter - this.bufferPosition + 1);
            }
        }
        System.arraycopy(this.buffer, this.bufferPosition, b, off, maxToGive);
        this.bufferPosition += maxToGive;
        return maxToGive;
    }

    private void fillBufferIfNecessary() throws IOException {
        if (this.bufferPosition >= this.bufferSize && !this.endOfFileReached) {
            this.fillBuffer(true);
        }
    }

    private void fillBuffer(boolean fromScratch) throws IOException {
        if (fromScratch) {
            if (this.bufferPosition < this.bufferSize) {
                throw new IllegalStateException();
            }
            this.bufferPosition = 0;
            this.bufferSize = 0;
        }
        while (this.bufferSize < this.buffer.length) {
            int count = super.read(this.buffer, this.bufferSize, this.buffer.length - this.bufferSize);
            if (count == -1) {
                this.endOfFileReached = true;
                return;
            }
            this.bufferSize += count;
        }
    }

    private void shiftAndFillBuffer(int start) throws IOException {
        int j = 0;
        int i = start;
        while (i < this.bufferSize) {
            this.buffer[j++] = this.buffer[i];
            ++i;
        }
        this.bufferPosition = 0;
        this.bufferSize = j;
        this.fillBuffer(false);
    }

    private boolean isPotentialKeywordAtEndOfBuffer(int start) {
        int end = this.findNextKeywordDelimiterInBuffer(start + 1);
        return end == -1 && !this.endOfFileReached;
    }

    private boolean isKeywordStart(int start) {
        int end = this.findNextKeywordDelimiterInBuffer(start + 1);
        if (end == -1) {
            return false;
        }
        if (end == start + 1) {
            return false;
        }
        return this.isKeyword(start, end);
    }

    private boolean isKeyword(int start, int end) {
        String keyword = this.extractPotentialKeyword(start, end);
        return this.isKeyword(keyword);
    }

    protected String extractPotentialKeyword(int start, int end) {
        int length = end - start + 1;
        if (length > 256) {
            return null;
        }
        byte[] keywordBytes = new byte[length];
        System.arraycopy(this.buffer, start, keywordBytes, 0, length);
        return this.extractPotentialKeyword(keywordBytes);
    }

    private boolean isPotentialKeywordStart(int start) {
        if (start >= this.bufferSize) {
            throw new IllegalArgumentException();
        }
        if (start < this.bufferPosition) {
            throw new IllegalArgumentException();
        }
        if (this.buffer[start] != 36) {
            return false;
        }
        int end = this.findNextKeywordDelimiterInBuffer(start + 1);
        if (end == -1) {
            if (this.endOfFileReached) {
                return false;
            }
            if (start == this.bufferSize - 1) {
                return true;
            }
            int length = this.bufferSize - start;
            if (length > 256) {
                return false;
            }
            byte[] keywordBytes = new byte[length];
            System.arraycopy(this.buffer, start, keywordBytes, 0, length);
            String keyword = this.extractPotentialKeyword(keywordBytes);
            return this.isKeywordStart(keyword);
        }
        if (end == start + 1) {
            return false;
        }
        return this.isKeyword(start, end);
    }

    private boolean isKeywordStart(String keywordText) {
        return keywordText != null && FileKeyword.isFileKeywordPrefix((String)keywordText);
    }

    private boolean isKeyword(String keywordText) {
        if (keywordText == null || keywordText.length() == 0) {
            return false;
        }
        return FileKeyword.getFileKeyword((String)keywordText) != null;
    }

    private String extractPotentialKeyword(byte[] keywordBytes) {
        int length = 0;
        int i = 1;
        while (i < keywordBytes.length) {
            if (keywordBytes[i] == 58 || keywordBytes[i] == 36) break;
            ++length;
            ++i;
        }
        if (length == 0) {
            return null;
        }
        return new String(keywordBytes, 1, length);
    }

    protected int findNextKeywordDelimiterInBuffer(int start) {
        int i = start;
        while (i < this.bufferSize) {
            if (this.buffer[i] == 36) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void setPosition(int pos) {
        this.bufferPosition = pos;
    }

    protected abstract int handleKeyword(int var1, byte[] var2, int var3, int var4);
}

