/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.restproxy.notification;

import com.ibm.team.filesystem.client.internal.http.LengthLimitedInputStream;
import com.ibm.team.filesystem.client.internal.marshalling.JSONConverter;
import com.ibm.team.filesystem.client.internal.marshalling.ParameterWrapperHandlerWithFallback;
import com.ibm.team.filesystem.client.restproxy.exceptions.RestMarshallingException;
import com.ibm.team.filesystem.client.restproxy.exceptions.RestMessageException;
import com.ibm.team.filesystem.client.restproxy.notification.Notification;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Reader;

public class NotificationMarshaller {
    JSONConverter converter = new JSONConverter(null, new ParameterWrapperHandlerWithFallback(this.getClass().getClassLoader()));
    public static char FIELD_SEPARATOR = (char)32;
    public static char MESSAGE_TERMINATOR = (char)10;

    public void write(OutputStream out, String key, String type, IParameterWrapper notification) throws IOException {
        out.write(key.getBytes("UTF-8"));
        out.write(FIELD_SEPARATOR);
        out.write(type.getBytes("UTF-8"));
        out.write(FIELD_SEPARATOR);
        String serialized = this.converter.convertToString(IParameterWrapper.class, notification);
        out.write(Integer.toString(serialized.length()).getBytes("UTF-8"));
        out.write(FIELD_SEPARATOR);
        out.write(serialized.getBytes("UTF-8"));
        out.write(MESSAGE_TERMINATOR);
    }

    private String readString(PushbackInputStream in, boolean allowTermination) throws IOException, RestMessageException {
        int i;
        StringBuffer buf = new StringBuffer();
        while (true) {
            if ((i = in.read()) == -1) {
                if (allowTermination) {
                    return null;
                }
                throw new IOException("Unexpected stream end");
            }
            if (Character.isWhitespace(i)) {
                in.unread(i);
                return buf.toString();
            }
            if (!(i >= 97 && i <= 122 || i >= 65 && i <= 90 || i >= 48 && i <= 57 || i == 46) && i != 95) break;
            buf.append((char)i);
        }
        throw new RestMessageException(false, "Unexpected character: " + (char)i + " at end of:" + buf.toString());
    }

    public Notification read(InputStream toRead, ITypeFinder finder) throws IOException, RestMessageException {
        int len;
        PushbackInputStream in = new PushbackInputStream(toRead, 1);
        RestMarshallingException recoverableException = null;
        String key = this.readString(in, true);
        if (key == null) {
            return null;
        }
        this.readFieldSeparator(in);
        String type = this.readString(in, false);
        this.readFieldSeparator(in);
        Object result = null;
        String lenStr = this.readString(in, false);
        this.readFieldSeparator(in);
        try {
            len = Integer.parseInt(lenStr);
        }
        catch (NumberFormatException e) {
            throw new RestMessageException(false, "Could not parse number: " + lenStr);
        }
        InputStreamReader r = new InputStreamReader(new LengthLimitedInputStream(in, len));
        Object parsed = JSONObject.parseAny((Reader)r);
        Class<?> c = finder.findTypeFor(type);
        if (c != null) {
            try {
                result = this.converter.convertFromJSON(c.getClassLoader(), c, parsed);
            }
            catch (RestMarshallingException e) {
                recoverableException = e;
            }
        }
        this.readMessageTerminator(in);
        if (recoverableException != null) {
            throw new RestMessageException(true, (Exception)recoverableException);
        }
        return new Notification<IParameterWrapper>(key, type, (IParameterWrapper)result);
    }

    private void readFieldSeparator(InputStream in) throws RestMessageException, IOException {
        if (FIELD_SEPARATOR != in.read()) {
            throw new RestMessageException(false, "Missing field separator");
        }
    }

    private void readMessageTerminator(InputStream in) throws RestMessageException, IOException {
        if (MESSAGE_TERMINATOR != in.read()) {
            throw new RestMessageException(false, "Missing message terminator");
        }
    }

    public static interface ITypeFinder {
        public Class<?> findTypeFor(String var1);
    }
}

