/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.restproxy.notification;

import com.ibm.team.filesystem.client.daemon.OrderlyShutdownNotification;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.restproxy.exceptions.RestMessageException;
import com.ibm.team.filesystem.client.restproxy.notification.ClientNotificationChannel;
import com.ibm.team.filesystem.client.restproxy.notification.Notification;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationMarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.osgi.util.NLS;

public class NotificationJob
extends Job {
    private static String PLUGIN_ID = "com.ibm.team.filesystem.client.daemon";
    private final Log log = LoggingHelper.getLog(NotificationJob.class);
    private final ClientNotificationChannel channel;
    private final NotificationMarshaller marshaller = new NotificationMarshaller();
    private final String uri;
    private final String key;
    private final Object waitLock = new Object();
    private boolean isConnected = false;
    private volatile boolean shouldShutdown = false;
    private HttpRequestBase request;

    public NotificationJob(String name, String key, ClientNotificationChannel channel, String uri) {
        super(name);
        this.channel = channel;
        this.uri = uri;
        this.key = key;
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent event) {
                Object object = NotificationJob.this.waitLock;
                synchronized (object) {
                    NotificationJob.this.waitLock.notifyAll();
                }
            }
        });
        this.setSystem(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected IStatus run(IProgressMonitor monitor) {
        if (this.shouldShutdown) {
            return Status.OK_STATUS;
        }
        HttpGet get = new HttpGet();
        Object object = this.waitLock;
        synchronized (object) {
            this.request = get;
        }
        try {
            get.setURI(new URI(this.uri));
        }
        catch (URISyntaxException e) {
            this.log.error((Object)("Unable to set URI: " + this.uri), (Throwable)e);
            return new Status(4, PLUGIN_ID, "Could not generate URI " + this.uri, (Throwable)e);
        }
        catch (NullPointerException e) {
            this.log.error((Object)("Unable to set URI: " + this.uri), (Throwable)e);
            return new Status(4, PLUGIN_ID, "Could not generate URI " + this.uri, (Throwable)e);
        }
        get.addHeader("X-Secret-Key", this.key);
        this.channel.getClient().beginRequest();
        if (this.channel.getClient().isShutdown()) {
            this.channel.getClient().endRequest();
            return Status.OK_STATUS;
        }
        if (this.isTraceEnabled()) {
            this.trace(NLS.bind((String)"{0} is issuing request {1}.", (Object)((Object)this), (Object)get));
        }
        try {
            try {
                Throwable e = null;
                Object var4_10 = null;
                try (CloseableHttpResponse response = this.channel.getClient().executeRequest((HttpUriRequest)get);){
                    InputStream s = response.getEntity().getContent();
                    Object object2 = this.waitLock;
                    synchronized (object2) {
                        this.isConnected = true;
                        this.waitLock.notifyAll();
                    }
                    try {
                        while (this.readNotification(s)) {
                        }
                    }
                    catch (Throwable throwable) {
                        Object object3 = this.waitLock;
                        synchronized (object3) {
                            this.isConnected = false;
                            if (!this.shouldShutdown) {
                                this.schedule();
                            }
                        }
                        try {
                            s.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    Object object4 = this.waitLock;
                    synchronized (object4) {
                        this.isConnected = false;
                        if (!this.shouldShutdown) {
                            this.schedule();
                        }
                    }
                    try {
                        s.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (HttpResponseException e) {
                this.log.error((Object)("Problem during get: " + this.uri), (Throwable)e);
                Status status = new Status(4, PLUGIN_ID, "Could execute get: " + this.uri, (Throwable)e);
                try {
                    if (this.isTraceEnabled()) {
                        this.trace(NLS.bind((String)"{0} is releasing connection for request {1}.", (Object)((Object)this), (Object)get));
                    }
                    get.releaseConnection();
                }
                finally {
                    this.channel.getClient().endRequest();
                }
                return status;
            }
            catch (IOException e) {
                this.log.error((Object)("Problem during get: " + this.uri), (Throwable)e);
                Status status = new Status(4, PLUGIN_ID, "Could execute get: " + this.uri, (Throwable)e);
                try {
                    if (this.isTraceEnabled()) {
                        this.trace(NLS.bind((String)"{0} is releasing connection for request {1}.", (Object)((Object)this), (Object)get));
                    }
                    get.releaseConnection();
                }
                finally {
                    this.channel.getClient().endRequest();
                }
                return status;
            }
            catch (RuntimeException e) {
                this.log.error((Object)("Problem during get: " + this.uri), (Throwable)e);
                Status status = new Status(4, PLUGIN_ID, "Could execute get: " + this.uri, (Throwable)e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (this.isTraceEnabled()) {
                        this.trace(NLS.bind((String)"{0} is releasing connection for request {1}.", (Object)((Object)this), (Object)get));
                    }
                    get.releaseConnection();
                }
                finally {
                    this.channel.getClient().endRequest();
                }
                return status;
            }
        }
        finally {
            try {
                if (this.isTraceEnabled()) {
                    this.trace(NLS.bind((String)"{0} is releasing connection for request {1}.", (Object)((Object)this), (Object)get));
                }
                get.releaseConnection();
            }
            finally {
                this.channel.getClient().endRequest();
            }
        }
        return Status.OK_STATUS;
    }

    public boolean readNotification(InputStream in) throws IOException {
        Notification n;
        if (this.isTraceEnabled()) {
            this.trace(NLS.bind((String)"{0} is reading a notification", (Object)((Object)this)));
        }
        try {
            n = this.marshaller.read(in, this.channel);
        }
        catch (RestMessageException e) {
            this.log.error((Object)"Exception deserializing", (Throwable)e);
            if (e.isRecoverable()) {
                return !this.shouldShutdown;
            }
            return false;
        }
        catch (SocketException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        if (n == null) {
            if (this.isTraceEnabled()) {
                this.trace(NLS.bind((String)"{0} is issuing a reconnect due to a missing notification.", (Object)((Object)this), (Object)n));
            }
            return false;
        }
        if (this.isTraceEnabled()) {
            this.trace(NLS.bind((String)"{0} read notification {1}", (Object)((Object)this), (Object)n));
        }
        if ("orderlyShutdown".equals(n.getKey()) && OrderlyShutdownNotification.TYPE.equals(n.getType())) {
            if (this.isTraceEnabled()) {
                this.trace(NLS.bind((String)"{0} has recieved a shutdown request.", (Object)((Object)this)));
            }
            this.shouldShutdown = true;
        }
        this.channel.notificationReceived(n);
        return !this.shouldShutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        if (this.isTraceEnabled()) {
            this.trace(NLS.bind((String)"Connection request received for {0}", (Object)((Object)this)));
        }
        Object object = this.waitLock;
        synchronized (object) {
            this.shouldShutdown = false;
            this.schedule();
            try {
                while (!this.isConnected && !this.shouldShutdown && this.getState() != 0) {
                    if (this.isTraceEnabled()) {
                        this.trace(NLS.bind((String)"{0} is waiting to be connected", (Object)((Object)this)));
                    }
                    this.waitLock.wait();
                }
            }
            catch (InterruptedException e) {
                this.log.info((Object)"Unexpected interrupt", (Throwable)e);
            }
        }
        if (this.isTraceEnabled()) {
            this.trace(NLS.bind((String)"{0} is connected", (Object)((Object)this)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (this.isTraceEnabled()) {
            this.trace(NLS.bind((String)"{0} is disconnecting", (Object)((Object)this)));
        }
        Object object = this.waitLock;
        synchronized (object) {
            this.shouldShutdown = true;
            if (this.request != null) {
                if (this.isTraceEnabled()) {
                    this.trace(NLS.bind((String)"{0} is aborting request {1}.", (Object)((Object)this), (Object)this.request));
                }
                this.request.abort();
            }
            this.waitLock.notifyAll();
        }
        if (this.isTraceEnabled()) {
            this.trace(NLS.bind((String)"{0} is disconnected", (Object)((Object)this)));
        }
    }

    private boolean isTraceEnabled() {
        return this.log != null && this.log.isTraceEnabled();
    }

    private void trace(String message) {
        if (this.log != null) {
            LoggingHelper.logWithThread((Log)this.log, (String)message);
        }
    }
}

