/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.restproxy.exceptions;

import com.ibm.team.filesystem.client.restproxy.exceptions.RestTransportException;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

public class RestHttpException
extends RestTransportException {
    protected HttpResponse response;
    protected HttpRequestBase request;

    public RestHttpException(HttpRequestBase request, Exception e) {
        super(e);
        this.setRequest(request);
    }

    public RestHttpException(String string, HttpRequestBase request, HttpResponse response, Exception e) {
        super(string, e);
        this.setRequest(request);
        this.setResponse(response);
    }

    public void setRequest(HttpRequestBase request) {
        this.request = request;
    }

    public void setResponse(HttpResponse response) {
        this.response = response;
    }

    public int getHttpCode() {
        if (this.response != null && this.response.getStatusLine() != null) {
            return this.response.getStatusLine().getStatusCode();
        }
        return -1;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessage());
        if (this.request != null) {
            String requestType = this.request instanceof HttpGet ? "GET" : "POST";
            sb.append("\nRequest detail:");
            sb.append("\n\tMethod: " + requestType);
            URI uri = this.request.getURI();
            if (uri != null) {
                sb.append("\n\tURI: " + uri.toString());
            }
        }
        if (this.response != null && this.response.getStatusLine() != null) {
            StatusLine line = this.response.getStatusLine();
            sb.append("\nResponse detail:");
            sb.append("\n\tCode: " + line.getStatusCode());
            sb.append("\n\tReason: " + line.getReasonPhrase());
        }
        return sb.toString();
    }
}

