/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.restproxy;

import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.daemon.Messages;
import com.ibm.team.filesystem.client.internal.http.constants.ResponseCode;
import com.ibm.team.filesystem.client.internal.marshalling.EObjectJSONDeserializer;
import com.ibm.team.filesystem.client.internal.marshalling.ParameterWrapperSerializer;
import com.ibm.team.filesystem.client.restproxy.HttpClientWrapper;
import com.ibm.team.filesystem.client.restproxy.RestInvocationParticipant;
import com.ibm.team.filesystem.client.restproxy.exceptions.RestAuthenticationException;
import com.ibm.team.filesystem.client.restproxy.exceptions.RestHttpException;
import com.ibm.team.filesystem.client.restproxy.exceptions.RestInvocationTimeoutException;
import com.ibm.team.filesystem.client.restproxy.exceptions.RestMarshallingException;
import com.ibm.team.filesystem.client.restproxy.exceptions.RestTransportException;
import com.ibm.team.filesystem.client.restproxy.notification.ClientNotificationChannel;
import com.ibm.team.repository.common.serialize.internal.IJSONDeserializationParticipant;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.repository.common.transport.ServiceMethodInvocationError;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class RestInvocationHandler
implements InvocationHandler {
    public static final boolean DEBUG_HIDE_MARSHALLING = System.getProperty("debug.rest.hide_marshalling") != null;
    private static final String PREFIX_GET = "get";
    private static final String PREFIX_POST = "post";
    private final InvocationParameters params;
    private final Class<?> wrapped;
    private final String uri;
    private final HttpClientWrapper client;
    private final ParameterWrapperSerializer serializer;
    private final EObjectJSONDeserializer deserializer;
    private final LinkedList<RestInvocationParticipant> participants = new LinkedList();
    private ClientNotificationChannel channel;
    private Log log;

    public RestInvocationHandler(Class<?> proxying, String baseUri, HttpClientWrapper client, ParameterWrapperSerializer serializer, EObjectJSONDeserializer deserializer, InvocationParameters params) {
        this.wrapped = proxying;
        this.uri = baseUri.endsWith("/") ? baseUri : String.valueOf(baseUri) + '/';
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.client = client;
        this.params = params;
        this.log = LoggingHelper.getLog(RestInvocationHandler.class);
    }

    public RestInvocationHandler(Class<?> proxying, String baseUri, HttpClientWrapper client) {
        this(proxying, baseUri, client, new ParameterWrapperSerializer(), new EObjectJSONDeserializer(), new InvocationParameters());
    }

    private HttpRequestBase generateRequest(RestInvocationParticipant.CallKey key, Method method) {
        HttpGet request;
        String methodName = method.getName();
        if (methodName.startsWith(PREFIX_GET)) {
            request = new HttpGet();
        } else if (methodName.startsWith(PREFIX_POST)) {
            request = new HttpPost();
        } else {
            throw new IllegalArgumentException("only know how to handle get* and post*");
        }
        RequestConfig.Builder builder = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT);
        builder.setSocketTimeout(this.params.getSocketTimeout());
        request.setConfig(builder.build());
        return request;
    }

    public String getBaseUri() {
        return this.uri;
    }

    public static String generateURI(Class<?> type, String baseUri, Method method) {
        String lastRemoteSegment = null;
        String methodName = method.getName();
        if (methodName.startsWith(PREFIX_GET)) {
            lastRemoteSegment = methodName.substring(PREFIX_GET.length());
        } else if (methodName.startsWith(PREFIX_POST)) {
            lastRemoteSegment = methodName.substring(PREFIX_POST.length());
        } else {
            throw new IllegalArgumentException("Only know how to handle get*/post*. Method \"" + methodName + "\" is invalid.");
        }
        return String.valueOf(baseUri) + "service" + '/' + type.getCanonicalName() + "/" + lastRemoteSegment;
    }

    private void generateParameters(Object proxy, Method method, String encoding, Object[] args, HttpRequestBase request) {
        if (args != null && args[0] instanceof IParameterWrapper) {
            Class<?> parameterType = method.getParameterTypes()[0];
            String queryString = this.serializer.serialize(parameterType, args[0], false);
            if (request instanceof HttpGet) {
                try {
                    URIBuilder builder = new URIBuilder(request.getURI());
                    builder.setQuery(queryString);
                    request.setURI(builder.build());
                }
                catch (URISyntaxException e) {
                    throw new ServiceMethodInvocationError((Throwable)e);
                }
            } else if (request instanceof HttpPost) {
                this.generatePostParameters(proxy, method, encoding, queryString, (HttpPost)request);
            } else {
                throw new IllegalArgumentException("Don't know how to handle request type " + request);
            }
        }
    }

    private void generatePostParameters(Object proxy, Method method, String encoding, String queryString, HttpPost request) {
        ByteArrayEntity requestEntity;
        try {
            requestEntity = new ByteArrayEntity(queryString.getBytes(encoding), ContentType.APPLICATION_FORM_URLENCODED);
        }
        catch (UnsupportedEncodingException e) {
            throw new RestMarshallingException(e);
        }
        request.setEntity((HttpEntity)requestEntity);
    }

    protected Object executeAndReturnResult(RestInvocationParticipant.CallKey key, HttpRequestBase request, Method method, Object[] args) throws Throwable {
        Throwable throwable = null;
        Object var6_7 = null;
        try (CloseableHttpResponse response = this.executeRequest(key, request, method, args);){
            InputStream inputStream = response.getEntity().getContent();
            return this.deserializer.deserialize(this.wrapped.getClassLoader(), inputStream, method.getReturnType());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected CloseableHttpResponse executeRequest(RestInvocationParticipant.CallKey key, HttpRequestBase request, Method method, Object[] args) throws Throwable {
        for (RestInvocationParticipant part : this.participants) {
            part.preRequest(key, (HttpUriRequest)request);
        }
        response = null;
        code = -1;
        t = null;
        try {
            try {
                response = this.client.executeRequest((HttpUriRequest)request);
                code = response.getStatusLine().getStatusCode();
            }
            catch (IllegalStateException e) {
                t = e;
                throw new RestHttpException(request, (Exception)e);
            }
            catch (SocketTimeoutException e) {
                throw new RestInvocationTimeoutException(request.getConfig().getSocketTimeout(), (Exception)e);
            }
            catch (HttpResponseException e) {
                t = e;
                throw new RestHttpException(request, (Exception)e);
            }
            catch (IOException e) {
                t = e;
                throw new RestTransportException("Failure when connecting to: " + request.getURI(), e);
            }
        }
        finally {
            ** for (part : this.participants)
        }
lbl-1000:
        // 1 sources

        {
            part.postRequest(key, (HttpUriRequest)request, (HttpResponse)response, t);
            continue;
        }
lbl27:
        // 1 sources

        if (code == ResponseCode.OK.getCode()) {
            return response;
        }
        try {
            if (code == ResponseCode.FORBIDDEN.getCode()) {
                throw new RestAuthenticationException(null);
            }
            if (this.responseContainsStackTrace((HttpResponse)response)) {
                requestType = request instanceof HttpGet != false ? "GET" : "POST";
                content = response.getEntity().getContent();
                throw this.deserializer.deserializeError(content, this.wrapped.getClassLoader(), String.valueOf(requestType) + " " + request.getURI());
            }
            if (code == ResponseCode.INTERNAL_SERVER_ERROR.getCode()) {
                reason = response.getStatusLine().getReasonPhrase();
                throw new RestMarshallingException("Internal server error without stack trace: " + reason);
            }
            if (code == ResponseCode.BAD_REQUEST.getCode()) {
                reason = response.getStatusLine().getReasonPhrase();
                throw new RestMarshallingException("Bad request without stack trace: " + reason);
            }
            throw new RestHttpException("Unexpected status: " + code, request, (HttpResponse)response, null);
        }
        catch (Throwable var10_22) {
            response.close();
            throw var10_22;
        }
    }

    private boolean responseContainsStackTrace(HttpResponse response) {
        Header[] headers = response.getHeaders("Content-Type");
        if (headers == null) {
            return false;
        }
        Header[] headerArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            HeaderElement[] elements = header.getElements();
            if (elements.length > 0) {
                return "application/vnd.ibm.jazz-json-stacktrace-1.0".equals(elements[0].getName());
            }
            ++n2;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        key = new RestInvocationParticipant.CallKey();
        for (RestInvocationParticipant part : this.participants) {
            part.preInvoke(key, proxy, method, args);
        }
        result = null;
        thrown = null;
        try {
            try {
                result = this.invokeInternal(key, proxy, method, args);
            }
            catch (Throwable t) {
                thrown = t;
                throw t;
            }
        }
        finally {
            ** for (part : this.participants)
        }
lbl-1000:
        // 1 sources

        {
            part.postInvoke(key, proxy, method, args, result, thrown);
            continue;
        }
lbl18:
        // 1 sources

        return result;
    }

    private Object invokeInternal(RestInvocationParticipant.CallKey key, Object proxy, Method method, Object[] args) throws Throwable {
        assert (args == null || args.length == 1 && (args[0] == null || args[0] instanceof IParameterWrapper || args[0] instanceof IProgressMonitor) || args.length == 2 && (args[0] == null || args[0] instanceof IParameterWrapper) && (args[1] == null || args[1] instanceof IProgressMonitor));
        HttpRequestBase request = this.generateRequest(key, method);
        request.setURI(new URI(RestInvocationHandler.generateURI(this.wrapped, this.uri, method)));
        this.generateParameters(proxy, method, "UTF-8", args, request);
        final LinkedList<Runnable> toRun = new LinkedList<Runnable>();
        RestInvocationParticipant.ISynchronousCallback cb = new RestInvocationParticipant.ISynchronousCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void call(Runnable runnable) {
                LinkedList linkedList = toRun;
                synchronized (linkedList) {
                    toRun.add(runnable);
                    toRun.notifyAll();
                }
            }
        };
        boolean needsSynchronousParticipation = false;
        for (RestInvocationParticipant part : this.participants) {
            needsSynchronousParticipation |= part.setSynchronousCallback(key, (HttpUriRequest)request, proxy, method, args, cb);
        }
        this.client.beginRequest();
        try {
            if (needsSynchronousParticipation) {
                RequestExecutor re = new RequestExecutor(key, request, method, args, toRun);
                Object object = re.execute();
                return object;
            }
            Object object = this.executeAndReturnResult(key, request, method, args);
            return object;
        }
        finally {
            try {
                request.releaseConnection();
            }
            finally {
                this.client.endRequest();
            }
        }
    }

    protected void rethrow(Throwable ex) throws Throwable {
        StackTraceElement[] original = ex.getStackTrace();
        StackTraceElement[] current = Thread.currentThread().getStackTrace();
        StackTraceElement[] combined = new StackTraceElement[original.length + current.length];
        int i = original.length - 1;
        while (i >= 0) {
            combined[i] = original[i];
            --i;
        }
        int j = combined.length - 1;
        int i2 = current.length - 1;
        while (i2 >= 0) {
            combined[j] = current[i2];
            --j;
            --i2;
        }
        ex.setStackTrace(combined);
        throw ex;
    }

    public void addParticipant(RestInvocationParticipant part) {
        this.participants.add(part);
    }

    public void setNotificationChannel(ClientNotificationChannel channel) {
        this.channel = channel;
    }

    public void setDeserializationParticipant(IJSONDeserializationParticipant part) {
        this.deserializer.setDeserializationParticipant(part);
    }

    public ClientNotificationChannel getNotificationChannel() {
        return this.channel;
    }

    private boolean isTraceEnabled() {
        return this.log != null && this.log.isTraceEnabled();
    }

    private void trace(String message) {
        if (this.log != null) {
            LoggingHelper.logWithThread((Log)this.log, (String)message);
        }
    }

    static /* synthetic */ boolean access$0(RestInvocationHandler restInvocationHandler) {
        return restInvocationHandler.isTraceEnabled();
    }

    static /* synthetic */ void access$1(RestInvocationHandler restInvocationHandler, String string) {
        restInvocationHandler.trace(string);
    }

    static /* synthetic */ LinkedList access$2(RestInvocationHandler restInvocationHandler) {
        return restInvocationHandler.participants;
    }

    public static class InvocationParameters {
        public int timeout = 0;

        public int getSocketTimeout() {
            return this.timeout;
        }

        public void setSocketTimeout(int t) {
            this.timeout = t;
        }
    }

    protected class RequestExecutor
    extends Job {
        public final RestInvocationParticipant.CallKey key;
        public Throwable ex;
        public Object result;
        public HttpRequestBase request;
        public Method method;
        public Object[] args;
        public LinkedList<Runnable> toRun;
        public boolean finished;

        public RequestExecutor(RestInvocationParticipant.CallKey key, HttpRequestBase request, Method method, Object[] args, LinkedList<Runnable> notifier) {
            super(Messages.getString("RestInvocationHandler.0"));
            this.key = key;
            this.request = request;
            this.method = method;
            this.args = args;
            this.toRun = notifier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public Object execute() throws Throwable {
            this.schedule();
            do {
                var1_1 = this.toRun;
                synchronized (var1_1) {
                    this.toRun.wait(100L);
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 6] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
                    if (true) ** GOTO lbl23
                }
                do {
                    completed = false;
                    try {
                        nextRunnable.run();
                        completed = true;
                    }
                    finally {
                        if (!completed) {
                            if (RestInvocationHandler.access$0(RestInvocationHandler.this)) {
                                RestInvocationHandler.access$1(RestInvocationHandler.this, NLS.bind((String)"{0} is aborting request {1}.", (Object)RestInvocationHandler.this, (Object)this.request));
                            }
                            this.request.abort();
                        }
                    }
lbl23:
                    // 2 sources

                } while ((nextRunnable = this.nextRunnable()) != null);
                for (RestInvocationParticipant part : RestInvocationHandler.access$2(RestInvocationHandler.this)) {
                    part.duringInvoke(this.key, (HttpUriRequest)this.request);
                }
            } while (this.isAlive());
            if (this.ex != null) {
                RestInvocationHandler.this.rethrow(this.ex);
            }
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Runnable nextRunnable() {
            LinkedList<Runnable> linkedList = this.toRun;
            synchronized (linkedList) {
                block4: {
                    if (!this.toRun.isEmpty()) break block4;
                    return null;
                }
                return this.toRun.remove();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            LinkedList<Runnable> linkedList;
            IStatus iStatus;
            try {
                try {
                    this.result = RestInvocationHandler.this.executeAndReturnResult(this.key, this.request, this.method, this.args);
                }
                catch (Throwable e) {
                    this.ex = e;
                }
                iStatus = Status.OK_STATUS;
                linkedList = this.toRun;
            }
            catch (Throwable throwable) {
                LinkedList<Runnable> linkedList2 = this.toRun;
                synchronized (linkedList2) {
                    this.finished = true;
                    this.toRun.notifyAll();
                }
                throw throwable;
            }
            synchronized (linkedList) {
                this.finished = true;
                this.toRun.notifyAll();
            }
            return iStatus;
        }

        public boolean isAlive() {
            return this.getState() != 0 && !this.finished;
        }
    }
}

