/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.restproxy;

import java.io.IOException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;

public class HttpClientWrapper {
    private final HttpClientConnectionManager manager;
    private final CloseableHttpClient client;
    private HttpContext httpContext;
    final ReentrantReadWriteLock lock;
    private volatile boolean shutdown;

    public HttpClientWrapper(HttpClientConnectionManager manager) {
        this.manager = manager;
        this.client = this.createHttpClient();
        this.httpContext = HttpClientContext.create();
        this.lock = new ReentrantReadWriteLock();
    }

    private CloseableHttpClient createHttpClient() {
        HttpClientBuilder builder = HttpClients.custom();
        builder.setConnectionManager(this.manager);
        builder.setRetryHandler((exception, executionCount, context) -> false);
        return builder.build();
    }

    public CloseableHttpResponse executeRequest(HttpUriRequest request) throws ClientProtocolException, IOException {
        return this.client.execute(request, this.httpContext);
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            this.manager.shutdown();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void beginRequest() {
        this.lock.readLock().lock();
    }

    public void endRequest() {
        this.lock.readLock().unlock();
    }
}

