/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest;

import com.ibm.team.filesystem.client.daemon.events.ConnectionEvent;
import com.ibm.team.filesystem.client.daemon.events.IConnectionEvent;
import com.ibm.team.filesystem.client.daemon.events.IHttpServerEvent;
import com.ibm.team.filesystem.client.daemon.events.ILightweightEventListener;
import com.ibm.team.filesystem.client.internal.rest.LifecycleRestClient;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class InactivityTimingJob
extends Job
implements ILightweightEventListener<IHttpServerEvent> {
    private volatile long timeToDie = -1L;
    private volatile long timeout = -1L;
    private LifecycleRestClient controller;

    public InactivityTimingJob() {
        super("Inactivity timer");
    }

    private void reschedule() {
        long tillTimeToDie = this.timeToDie - System.currentTimeMillis();
        if (tillTimeToDie < 0L) {
            this.schedule(this.timeout);
        } else {
            this.schedule(tillTimeToDie);
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.attemptShutdown();
        this.reschedule();
        return Status.OK_STATUS;
    }

    public void setTimeout(long millisOfInactivityBeforeShutdown) {
        this.timeout = millisOfInactivityBeforeShutdown;
        if (millisOfInactivityBeforeShutdown == -1L) {
            this.timeToDie = -1L;
            return;
        }
        this.timeToDie = System.currentTimeMillis() + millisOfInactivityBeforeShutdown;
    }

    void connect(LifecycleRestClient controller) {
        this.controller = controller;
    }

    @Override
    public void handleEvent(IHttpServerEvent e) {
        if (!(e instanceof ConnectionEvent)) {
            return;
        }
        ConnectionEvent event = (ConnectionEvent)e;
        this.cancel();
        if (event.getType().equals((Object)IConnectionEvent.Type.CLOSED) && this.timeout >= 0L) {
            this.reschedule();
        }
    }

    public void attemptShutdown() {
        if (this.timeToDie != -1L && this.timeToDie < System.currentTimeMillis() && this.controller.mayShutdownDueToInactivityTimeout()) {
            this.controller.shutdown();
        }
    }
}

