/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.marshalling;

import com.ibm.team.filesystem.client.internal.marshalling.ExceptionHandlingJSONDeserializer;
import com.ibm.team.filesystem.client.restproxy.RestInvocationHandler;
import com.ibm.team.filesystem.client.restproxy.exceptions.RestMarshallingException;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.internal.marshal.MarshalFactory;
import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.marshal.MarshallingException;
import com.ibm.team.repository.common.internal.marshal.impl.WebServicesMarshaller;
import com.ibm.team.repository.common.serialize.IStackAdjuster;
import com.ibm.team.repository.common.serialize.IURISerializer;
import com.ibm.team.repository.common.serialize.SerializeException;
import com.ibm.team.repository.common.serialize.StackUtil;
import com.ibm.team.repository.common.serialize.internal.IJSONDeserializationParticipant;
import com.ibm.team.repository.common.serialize.internal.UriSerializer;
import com.ibm.team.repository.common.transport.HttpUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.nio.charset.Charset;

public class EObjectJSONDeserializer {
    IJSONDeserializationParticipant participant = null;

    public Object deserialize(ClassLoader cl, InputStream stream, Class<?> cls) throws RestMarshallingException {
        WebServicesMarshaller marshaller = (WebServicesMarshaller)MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.WEB_SERVICES_LITERAL);
        try {
            return marshaller.demarshalInputStreamToReturnValue(stream, Charset.forName("UTF-8"), cls, 1);
        }
        catch (MarshallingException e) {
            throw new RestMarshallingException("Deserialization failure", (Exception)((Object)e));
        }
    }

    public Throwable deserializeError(InputStream stream, ClassLoader classloader, String note) throws RestMarshallingException {
        InputStreamReader r = new InputStreamReader(stream, Charset.forName("UTF-8"));
        StackAdjuster adj = null;
        if (RestInvocationHandler.DEBUG_HIDE_MARSHALLING) {
            adj = new StackAdjuster(note);
        }
        ExceptionHandlingJSONDeserializer deserializer = new ExceptionHandlingJSONDeserializer(HttpUtil.MediaType.JSON, (IURISerializer)new UriSerializer());
        if (this.participant != null) {
            deserializer.setParticipant(this.participant);
        }
        try {
            return deserializer.deserializeException(r, classloader, adj);
        }
        catch (SerializeException e) {
            throw new RestMarshallingException("Deserialization failure", (Exception)((Object)e));
        }
    }

    public void setDeserializationParticipant(IJSONDeserializationParticipant part) {
        this.participant = part;
    }

    private static class StackAdjuster
    implements IStackAdjuster {
        private final String serverNote;

        public StackAdjuster(String serverNote) {
            this.serverNote = serverNote;
        }

        public StackTraceElement[] adjustDeserializedFrames(StackTraceElement[] original) {
            StackTraceElement[] remote = StackUtil.pruneUpTo((String)".FilesystemRestClient", (StackTraceElement[])original);
            int deleted = original.length - remote.length;
            return StackUtil.append((StackTraceElement[])remote, (StackTraceElement[])new StackTraceElement[]{new StackTraceElement("<" + deleted + " server frames removed>", "<" + this.serverNote + ">", null, 0)});
        }

        public StackTraceElement[] adjustLocalFrames(StackTraceElement[] original) {
            Method m = null;
            try {
                m = RestInvocationHandler.class.getMethod("invoke", Object.class, Method.class, Array.newInstance(Object.class, 0).getClass());
            }
            catch (NoSuchMethodException e) {
                LogFactory.getLog((String)EObjectJSONDeserializer.class.getName()).error((Object)e.getMessage(), (Throwable)e);
                return original;
            }
            StackTraceElement[] local = StackUtil.pruneDownTo((Method)m, (StackTraceElement[])original);
            int deleted = original.length - local.length;
            return StackUtil.append((StackTraceElement[])new StackTraceElement[]{new StackTraceElement("<" + deleted + " proxy frames removed>", "<>", null, 0)}, (StackTraceElement[])local);
        }

        public StackTraceElement[] adjustFrames(StackTraceElement[] original, int joinPoint) {
            StackTraceElement[] local = new StackTraceElement[original.length - joinPoint];
            System.arraycopy(original, joinPoint, local, 0, local.length);
            local = this.adjustLocalFrames(local);
            StackTraceElement[] remote = new StackTraceElement[joinPoint];
            System.arraycopy(original, 0, remote, 0, remote.length);
            remote = this.adjustDeserializedFrames(remote);
            return StackUtil.append((StackTraceElement[])remote, (StackTraceElement[])local);
        }
    }
}

