/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.http;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpUtil {
    protected static final String TOKEN_REGEX = "[!-~&&[^]\\[()<>@,;:\\\\\"/?={}]]";
    protected static final String QUOTED_STRING_REGEX = "\"([\t !-~&&[^\"]]|(\\\\\\p{ASCII}))*\"";
    protected static final String LWS_REGEX_STR = "[\t ]";
    protected static final Pattern PATH_SEPERATOR_REGEX = Pattern.compile("/");
    protected static final Pattern TOKEN_LIST_REGEX = Pattern.compile("([!-~&&[^]\\[()<>@,;:\\\\\"/?={}]]*([\t ]*,[\t ]*)*)*");
    protected static final Pattern TOKEN_LIST_SPLIT_REGEX = Pattern.compile("[\t ,]+");
    protected static final Pattern HTTP_REQUEST = Pattern.compile("^([!-~&&[^]\\[()<>@,;:\\\\\"/?={}]]+) (\\p{ASCII}*) HTTP/(\\d+)[.](\\d+)$");
    protected static final Pattern HEADER_FIELD = Pattern.compile("^([!-~&&[^]\\[()<>@,;:\\\\\"/?={}]]+)[\t ]*:[\t ]*(.*)$", 32);

    public static String[] getPathSegments(String path) {
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return PATH_SEPERATOR_REGEX.split(path);
    }

    public static List<String> getTokenList(String str) {
        Matcher m = TOKEN_LIST_REGEX.matcher(str);
        if (!m.matches()) {
            return null;
        }
        String[] tokens = TOKEN_LIST_SPLIT_REGEX.split(str);
        ArrayList<String> result = new ArrayList<String>(tokens.length);
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            if (t.length() != 0) {
                result.add(t);
            }
            ++n2;
        }
        return result;
    }

    public static String removeWhiteSpace(String str) {
        char[] chars = str.toCharArray();
        int len = chars.length;
        if (len == 0) {
            return str;
        }
        int start = 0;
        int end = chars.length - 1;
        while (chars[start] == ' ' || chars[start] == '\t') {
            if (++start != len) continue;
            return "";
        }
        while (chars[end] == ' ' || chars[end] == '\t') {
            --end;
        }
        return str.substring(start, end + 1);
    }

    public static String[] parseHttpHeader(String header) {
        Matcher m = HEADER_FIELD.matcher(header);
        if (!m.matches()) {
            return null;
        }
        String key = m.group(1);
        String value = HttpUtil.removeWhiteSpace(m.group(2));
        return new String[]{key, value};
    }

    public static String[] parseHttpRequest(String request) {
        Matcher m = HTTP_REQUEST.matcher(request);
        if (!m.matches()) {
            return null;
        }
        String method = m.group(1);
        String uri = m.group(2);
        String majorVer = m.group(3);
        String minorVer = m.group(4);
        return new String[]{method, uri, majorVer, minorVer};
    }
}

