/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.http;

import com.ibm.team.filesystem.client.daemon.IHttpServer;
import com.ibm.team.filesystem.client.daemon.events.ConnectionEvent;
import com.ibm.team.filesystem.client.daemon.events.IConnectionEvent;
import com.ibm.team.filesystem.client.daemon.events.IHttpServerEvent;
import com.ibm.team.filesystem.client.daemon.events.ILightweightEventListener;
import com.ibm.team.filesystem.client.daemon.events.LightweightEventSource;
import com.ibm.team.filesystem.client.daemon.events.ShutdownStartedEvent;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.http.HttpConnection;
import com.ibm.team.filesystem.client.internal.http.HttpContext;
import com.ibm.team.filesystem.client.internal.http.HttpRequest;
import com.ibm.team.filesystem.client.internal.http.HttpResponse;
import com.ibm.team.filesystem.client.internal.http.HttpUtil;
import com.ibm.team.filesystem.client.internal.http.constants.HttpMethod;
import com.ibm.team.filesystem.client.internal.http.constants.ResponseCode;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.eclipse.osgi.util.NLS;

public class HttpServer
implements IHttpServer {
    LightweightEventSource eventManager = new LightweightEventSource();
    protected ServerSocketChannel s;
    protected final Object selLock;
    protected volatile Selector sel;
    protected SelectionKey skey;
    protected ContextTree[] contextTree;
    protected String key;
    protected volatile boolean shutdown;
    protected final Map<HttpConnection, Object> connections = new ConcurrentHashMap<HttpConnection, Object>();
    private final Log log;

    public HttpServer() {
        this.contextTree = new ContextTree[HttpMethod.values().length];
        int i = this.contextTree.length - 1;
        while (i >= 0) {
            this.contextTree[i] = new ContextTree();
            --i;
        }
        this.selLock = new Object();
        this.log = LoggingHelper.getLog(HttpServer.class);
    }

    public void addContext(HttpContext c) {
        this.contextTree[c.getMethod().ordinal()].addContext(HttpUtil.getPathSegments(c.getPath()), c);
    }

    public void bind(SocketAddress addr) throws IOException {
        Selector selector;
        ServerSocketChannel sc;
        this.s = sc = ServerSocketChannel.open();
        sc.socket().bind(addr);
        sc.configureBlocking(false);
        this.sel = selector = Selector.open();
        this.skey = sc.register(selector, 16);
    }

    /*
     * Unable to fully structure code
     */
    public void run(String keyString) throws IOException {
        shuttingDown = false;
        this.key = keyString;
        selector = this.sel;
        if (this.isTraceEnabled()) {
            this.trace(NLS.bind((String)"Running HTTPServer {0} with key {1}.", (Object)this, (Object)keyString));
        }
        try {
            block7: while (true) {
                if (!shuttingDown && this.shutdown) {
                    this.closeListeningSocket();
                    shuttingDown = true;
                }
                if (shuttingDown && this.connections.isEmpty()) {
                }
                selector.select();
                v0 = this.selLock;
                ** synchronized (v0)
lbl17:
                // 1 sources

                if (!shuttingDown && this.shutdown) continue;
                it = selector.selectedKeys().iterator();
                while (true) {
                    if (it.hasNext()) ** break;
                    continue block7;
                    key = it.next();
                    it.remove();
                    if (this.isTraceEnabled()) {
                        this.trace(NLS.bind((String)"{0} processing selection key {1}.", (Object)this, (Object)this.getKeyDescription(key)));
                    }
                    try {
                        ops = key.readyOps();
                        if ((ops & 16) != 0) {
                            this.accept();
                            continue;
                        }
                        conn = (HttpConnection)key.attachment();
                        if ((ops & 4) != 0) {
                            if (this.isTraceEnabled()) {
                                this.trace(NLS.bind((String)"{0} issuing write operation to {1}.", (Object)this, (Object)conn));
                            }
                            conn.writeSocket();
                        }
                        if ((ops & 1) == 0) continue;
                        if (this.isTraceEnabled()) {
                            this.trace(NLS.bind((String)"{0} issuing read operation to {1}.", (Object)this, (Object)conn));
                        }
                        conn.readSocket();
                    }
                    catch (CancelledKeyException ops) {
                    }
                    catch (IOException e) {
                        this.log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                break;
            }
        }
        finally {
            var12_12 = this.contextTree;
            var11_14 = this.contextTree.length;
            var10_16 = 0;
            ** while (var10_16 < var11_14)
        }
lbl-1000:
        // 1 sources

        {
            tree = var12_12[var10_16];
            tree.shutdownNotification();
            ++var10_16;
            continue;
        }
lbl55:
        // 1 sources

        if (this.isTraceEnabled()) {
            this.trace(NLS.bind((String)"Exiting {0} for key {1}.", (Object)this, (Object)keyString));
        }
    }

    public void accept() throws IOException {
        SocketChannel c = this.s.accept();
        if (c == null) {
            return;
        }
        HttpConnection connection = new HttpConnection(this, c);
        this.connections.put(connection, connection);
        this.eventManager.fireEvent(new ConnectionEvent(this, connection, IConnectionEvent.Type.OPENED));
        if (this.isTraceEnabled()) {
            this.trace(NLS.bind((String)"{0} created connection {1}.", (Object)this, (Object)connection));
        }
        connection.handleSocket();
    }

    @Override
    public int getLocalPort() {
        if (this.s == null) {
            throw new IllegalStateException();
        }
        return this.s.socket().getLocalPort();
    }

    public void closeListeningSocket() throws IOException {
        try {
            ServerSocketChannel sc = this.s;
            if (sc != null) {
                sc.close();
                this.s = null;
            }
        }
        finally {
            SelectionKey key = this.skey;
            if (key != null) {
                key.cancel();
                this.skey = null;
            }
        }
    }

    public void cleanUp() throws IOException {
        Selector selector = this.sel;
        try {
            if (selector != null) {
                selector.close();
                this.sel = null;
                this.skey = null;
            }
        }
        finally {
            ServerSocketChannel sc = this.s;
            if (sc != null) {
                sc.close();
                this.s = null;
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.eventManager.fireEvent(new ShutdownStartedEvent(this));
        this.shutdown = true;
        Selector selector = this.sel;
        if (selector != null) {
            selector.wakeup();
        }
        for (HttpConnection conn : this.connections.keySet()) {
            conn.shutDown();
        }
    }

    HttpContext getContextFor(HttpRequest req) {
        return this.getContextFor(req.getMethod(), req.getPathSegments());
    }

    public HttpContext getContextFor(HttpMethod method, String[] path) {
        return this.contextTree[method.ordinal()].getContext(path);
    }

    boolean authenticates(HttpConnection conn, HttpRequest req, HttpResponse resp) throws IOException {
        String clientKey = req.getFirstHeader("X-Secret-Key");
        if (clientKey == null) {
            resp.setCode(ResponseCode.FORBIDDEN.getCode(), "Key required");
            return false;
        }
        if (!this.key.equals(clientKey.toUpperCase(Locale.ENGLISH))) {
            resp.setCode(ResponseCode.FORBIDDEN.getCode(), "Client passed in invalid key");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregister(HttpConnection conn) {
        Object object = this.selLock;
        synchronized (object) {
            Selector selector = this.sel;
            if (selector != null) {
                selector.wakeup();
            }
            this.connections.remove(conn);
        }
        this.eventManager.fireEvent(new ConnectionEvent(this, conn, IConnectionEvent.Type.CLOSED));
    }

    @Override
    public void addListener(ILightweightEventListener<? super IHttpServerEvent> l) {
        this.eventManager.addListener(l);
    }

    @Override
    public void removeListener(ILightweightEventListener<? super IHttpServerEvent> l) {
        this.eventManager.removeListener(l);
    }

    @Override
    public boolean hasConnections() {
        return !this.connections.isEmpty();
    }

    @Override
    public boolean isWorking() {
        for (HttpConnection conn : this.connections.keySet()) {
            if (!conn.hasRequests()) continue;
            return true;
        }
        return false;
    }

    private boolean isTraceEnabled() {
        return this.log != null && this.log.isTraceEnabled();
    }

    private void trace(String message) {
        if (this.log != null) {
            LoggingHelper.logWithThread((Log)this.log, (String)message);
        }
    }

    private String getKeyDescription(SelectionKey key) {
        return String.valueOf(key.toString()) + ": " + HttpServer.getOperationString(key.readyOps());
    }

    public static String getOperationString(int ops) {
        StringBuffer buffer = new StringBuffer();
        boolean includeComma = false;
        if ((ops & 0x10) != 0) {
            buffer.append("OP_ACCEPT");
            includeComma = true;
        }
        if ((ops & 8) != 0) {
            if (includeComma) {
                buffer.append(", ");
            }
            buffer.append("OP_CONNECT");
            includeComma = true;
        }
        if ((ops & 4) != 0) {
            if (includeComma) {
                buffer.append(", ");
            }
            buffer.append("OP_WRITE");
            includeComma = true;
        }
        if ((ops & 1) != 0) {
            if (includeComma) {
                buffer.append(", ");
            }
            buffer.append("OP_READ");
            includeComma = true;
        }
        return buffer.toString();
    }

    protected static class ContextTree {
        public HttpContext context;
        public Map<String, ContextTree> children = Collections.emptyMap();

        public void addContext(String[] path, HttpContext c) {
            this.addContent(0, path, c);
        }

        public HttpContext getContext(String[] path) {
            return this.getContext(0, path);
        }

        public ContextTree getNode(String[] path) {
            return this.getNode(0, path);
        }

        protected void addContent(int i, String[] path, HttpContext c) {
            if (i == path.length) {
                this.context = c;
                return;
            }
            ContextTree child = this.children.get(path[i]);
            if (child == null) {
                child = new ContextTree();
                if (this.children.isEmpty()) {
                    this.children = new HashMap<String, ContextTree>();
                }
                this.children.put(path[i], child);
            }
            child.addContent(i + 1, path, c);
        }

        protected ContextTree getNode(int i, String[] path) {
            if (i == path.length) {
                return this;
            }
            ContextTree child = this.children.get(path[i]);
            if (child == null) {
                return null;
            }
            return child.getNode(i + 1, path);
        }

        protected HttpContext getContext(int i, String[] path) {
            if (i == path.length) {
                return this.context;
            }
            ContextTree child = this.children.get(path[i]);
            if (child == null) {
                return this.context;
            }
            HttpContext result = child.getContext(i + 1, path);
            if (result == null) {
                return this.context;
            }
            return result;
        }

        public void shutdownNotification() {
            if (this.context != null) {
                this.context.getHandler().shutdownNotification();
            }
            for (ContextTree child : this.children.values()) {
                child.shutdownNotification();
            }
        }
    }
}

