/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.daemon.trace.reader;

import com.ibm.team.filesystem.client.internal.daemon.trace.RotatingDaemonTracer;
import com.ibm.team.filesystem.client.internal.daemon.trace.reader.ILogDirectory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;

public class RotatedLogInputStream
extends InputStream {
    private final Iterator<ILogDirectory.ILogDirectoryEntry> entries;
    private final ILogDirectory dir;
    private InputStream currentIn;
    private static final Comparator<ILogDirectory.ILogDirectoryEntry> comparator = new Comparator<ILogDirectory.ILogDirectoryEntry>(){

        @Override
        public int compare(ILogDirectory.ILogDirectoryEntry o1, ILogDirectory.ILogDirectoryEntry o2) {
            return String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName());
        }
    };

    public RotatedLogInputStream(ILogDirectory dir) {
        this.dir = dir;
        TreeSet<ILogDirectory.ILogDirectoryEntry> sorted = new TreeSet<ILogDirectory.ILogDirectoryEntry>(comparator);
        Collections.addAll(sorted, dir.getEntries());
        this.entries = sorted.iterator();
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int read = this.read(buf);
        if (read == -1) {
            return -1;
        }
        return buf[0];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read;
        while (true) {
            if (this.currentIn == null) {
                try {
                    this.currentIn = RotatingDaemonTracer.getInputStreamForLogFile(this.entries.next());
                }
                catch (NoSuchElementException e) {
                    return -1;
                }
            }
            if ((read = this.currentIn.read(b, off, len)) != -1) break;
            this.currentIn.close();
            this.currentIn = null;
        }
        return read;
    }

    @Override
    public void close() throws IOException {
        super.close();
        try {
            if (this.currentIn != null) {
                this.currentIn.close();
            }
        }
        finally {
            this.dir.close();
        }
    }
}

