/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.daemon.trace.reader;

import com.ibm.team.filesystem.client.internal.daemon.trace.RotatingDaemonTracer;
import com.ibm.team.filesystem.client.internal.daemon.trace.reader.ILogDirectory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;

public class FilesystemLogDirectory
implements ILogDirectory {
    private final File root;
    private static final Comparator<File> comparator = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            return String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName());
        }
    };

    public FilesystemLogDirectory(File directoryRoot) {
        this.root = directoryRoot;
    }

    @Override
    public ILogDirectory.ILogDirectoryEntry[] getEntries() {
        File[] files = this.root.listFiles(RotatingDaemonTracer.FILTER_LOGFILE);
        ILogDirectory.ILogDirectoryEntry[] entries = new ILogDirectory.ILogDirectoryEntry[files.length];
        TreeSet<File> sorted = new TreeSet<File>(comparator);
        Collections.addAll(sorted, files);
        int i = 0;
        for (File file : sorted) {
            entries[i++] = new FilesystemLogDirectoryEntry(file);
        }
        return entries;
    }

    @Override
    public void close() {
    }

    public class FilesystemLogDirectoryEntry
    implements ILogDirectory.ILogDirectoryEntry {
        private final File file;

        FilesystemLogDirectoryEntry(File file) {
            this.file = file;
        }

        @Override
        public String getName() {
            return this.file.getName();
        }

        @Override
        public InputStream getContent() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public long getSize() throws IOException {
            return this.file.length();
        }

        public void delete() {
            this.file.delete();
        }
    }
}

