/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.daemon;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.daemon.DaemonPlugin;
import com.ibm.team.filesystem.client.daemon.events.IHttpServerEvent;
import com.ibm.team.filesystem.client.daemon.events.ILightweightEvent;
import com.ibm.team.filesystem.client.daemon.events.ILightweightEventListener;
import com.ibm.team.filesystem.client.daemon.events.LightweightEventSource;
import com.ibm.team.filesystem.client.daemon.events.ShutdownStartedEvent;
import com.ibm.team.filesystem.client.internal.PlatformDetector;
import com.ibm.team.filesystem.client.internal.daemon.RegisteredSandboxPseudoEvent;
import com.ibm.team.filesystem.client.internal.http.HttpContext;
import com.ibm.team.filesystem.client.internal.http.HttpHandler;
import com.ibm.team.filesystem.client.internal.http.HttpRequest;
import com.ibm.team.filesystem.client.internal.http.HttpResponse;
import com.ibm.team.filesystem.client.internal.http.HttpServer;
import com.ibm.team.filesystem.client.internal.http.constants.HttpMethod;
import com.ibm.team.filesystem.client.internal.http.constants.ResponseCode;
import com.ibm.team.filesystem.client.internal.utils.IDaemonRegistry;
import com.ibm.team.filesystem.client.internal.utils.IFSDaemon;
import com.ibm.team.filesystem.client.restproxy.DaemonRegistry;
import com.ibm.team.filesystem.client.restproxy.notification.IServerNotificationChannel;
import com.ibm.team.filesystem.client.restproxy.notification.Notification;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationDiscardedEvent;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationEvent;
import com.ibm.team.filesystem.client.restproxy.notification.ServerNotificationChannel;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.FileLock;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.RegistryFactory;

public class FSDaemon
implements IFSDaemon {
    public static final int UNSPECIFIED_PORT = 0;
    private int listenPort = 0;
    private final LightweightEventSource<ILightweightEvent> eventSource = new LightweightEventSource();
    private static final String LOCK_PATH = ".metadata" + File.separator + ".jazzlock";
    private static final String LOCATION_PATH = ".metadata" + File.separator + ".jazzwhere";
    private static final int KEY_SIZE = 16;
    protected RandomAccessFile lockRAF;
    protected FileLock lock;
    protected volatile HttpServer server;
    protected ILockFile location = null;
    protected byte[] keyBytes = null;
    protected Collection<ILightweightEventListener<IHttpServerEvent>> initialServerListeners = new LinkedList<ILightweightEventListener<IHttpServerEvent>>();
    private DaemonRegistry registry;
    private File daemonEntryDir;
    private PlatformDetector.LauncherType launcherType;
    private final ServerNotificationChannelWrapper notifierWrapper = new ServerNotificationChannelWrapper();
    private ILightweightEventListener logger;
    private static int COMPLETE_LOCKFILE_SIZE = 20;
    protected static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public void setDaemonRegistry(DaemonRegistry registry) {
        this.registry = registry;
    }

    public void setLauncherType(PlatformDetector.LauncherType launcherType) {
        this.launcherType = launcherType;
    }

    public void start() throws IOException {
        try {
            HttpServer srv = new HttpServer();
            for (ILightweightEventListener<IHttpServerEvent> l : this.initialServerListeners) {
                srv.addListener(l);
            }
            InetSocketAddress addr = new InetSocketAddress(InetAddress.getByName(null), this.listenPort);
            this.server = srv;
            try {
                srv.bind(addr);
            }
            catch (IOException e) {
                throw new BindException(addr.toString());
            }
            int port = srv.getLocalPort();
            this.keyBytes = new byte[16];
            SecureRandom rnd = new SecureRandom();
            rnd.nextBytes(this.keyBytes);
            this.location = new LockFile(FSDaemon.generateKeyString(this.keyBytes), port);
            if (!this.loadHandlers()) {
                return;
            }
            this.register();
            if (this.logger != null) {
                this.eventSource.addListener(this.logger);
                this.server.addListener(this.logger);
                this.notifierWrapper.addListener(this.logger);
            }
            this.eventSource.fireEvent(new IInitializedEvent(){

                @Override
                public FSDaemon getDaemon() {
                    return FSDaemon.this;
                }
            });
            srv.addListener((ILightweightEventListener<? super IHttpServerEvent>)new ILightweightEventListener<IHttpServerEvent>(){

                @Override
                public void handleEvent(IHttpServerEvent event) {
                    if (event instanceof ShutdownStartedEvent) {
                        FSDaemon.this.deregister();
                        FSDaemon.this.eventSource.fireEvent(new IShutdownEvent(){

                            @Override
                            public FSDaemon getDaemon() {
                                return FSDaemon.this;
                            }
                        });
                    }
                }
            });
            srv.run(this.location.getKey());
        }
        finally {
            this.cleanUpLocation();
        }
    }

    private void register() throws IOException {
        if (this.registry == null) {
            this.registry = (DaemonRegistry)DaemonRegistry.getInstance();
        }
        try {
            this.daemonEntryDir = this.registry.registerDaemon(this, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (FileSystemException fileSystemException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void deregister() {
        try {
            this.registry.deregisterDaemon(this, null);
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
    }

    private static void writeLocation(File locationPath, int port, byte[] key) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(12);
        DataOutputStream dout = new DataOutputStream(out);
        dout.writeInt(port);
        dout.write(key);
        dout.flush();
        FileOutputStream locationFile = new FileOutputStream(locationPath);
        try {
            locationFile.write(out.toByteArray(), 0, out.size());
        }
        finally {
            try {
                locationFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void writeLocation(File locationFile) throws IOException, IllegalArgumentException {
        if (this.location == null) {
            throw new IllegalArgumentException();
        }
        FSDaemon.writeLocation(locationFile, this.location.getPort(), this.keyBytes);
    }

    protected boolean loadHandlers() {
        IConfigurationElement[] configs = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.filesystem.client.daemon", "httphandler");
        HttpServer srv = this.server;
        try {
            IConfigurationElement[] iConfigurationElementArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                HttpHandler handler = (HttpHandler)config.createExecutableExtension("class");
                IConfigurationElement[] methods = config.getChildren("method");
                ArrayList<HttpContext> contexts = new ArrayList<HttpContext>(methods.length);
                IConfigurationElement[] iConfigurationElementArray2 = config.getChildren("method");
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement methodConfig = iConfigurationElementArray2[n4];
                    String path = methodConfig.getAttribute("path");
                    HttpMethod method = HttpMethod.valueOf(methodConfig.getAttribute("type"));
                    HttpContext ctx = new HttpContext(method, path, handler);
                    srv.addContext(ctx);
                    contexts.add(ctx);
                    ++n4;
                }
                handler.registered(this, srv, contexts);
                ++n2;
            }
        }
        catch (CoreException e) {
            return false;
        }
        return true;
    }

    protected void cleanUpLocation() {
        HttpServer srv = this.server;
        if (srv != null) {
            try {
                srv.cleanUp();
                this.server = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void stop() {
        HttpServer srv = this.server;
        if (srv != null) {
            srv.shutdown();
        }
    }

    public void setNotificationChannel(IServerNotificationChannel notifier) {
        this.notifierWrapper.setChannel(notifier);
    }

    public void setDescription(String description, IProgressMonitor progress) throws IDaemonRegistry.DaemonRegistryException {
        this.registry.setDescription(this, description, progress);
    }

    public IServerNotificationChannel getNotificationChannel() {
        return this.notifierWrapper;
    }

    public int getPort() {
        HttpServer srv = this.server;
        if (srv == null) {
            return -1;
        }
        return srv.getLocalPort();
    }

    public String getKey() {
        if (this.location != null) {
            return this.location.getKey();
        }
        return null;
    }

    public static ILockFile readActiveLock(File cfaRoot) throws IOException, InterruptedException {
        File lockPath = new File(cfaRoot, LOCK_PATH);
        File parent = lockPath.getParentFile();
        if (!parent.exists()) {
            return null;
        }
        RandomAccessFile lockFile = new RandomAccessFile(lockPath, "rw");
        FileLock lock = null;
        try {
            try {
                lock = lockFile.getChannel().tryLock(0L, 1L, false);
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
            }
        }
        finally {
            try {
                lockFile.close();
            }
            catch (IOException iOException) {}
        }
        if (lock != null) {
            return null;
        }
        File locationPath = FSDaemon.generateLocationFile(cfaRoot);
        int i = 0;
        while (locationPath.length() < (long)COMPLETE_LOCKFILE_SIZE) {
            Thread.sleep(100L);
            if (i++ < 50) continue;
            throw new IOException("Location file is too small after waiting: " + locationPath.getAbsolutePath());
        }
        return FSDaemon.readLock(locationPath);
    }

    public static ILockFile readLock(File locationPath) throws IOException {
        byte[] keyBytes;
        int port;
        try (DataInputStream dis = new DataInputStream(new FileInputStream(locationPath));){
            port = dis.readInt();
            keyBytes = new byte[16];
            dis.readFully(keyBytes);
        }
        return new LockFile(FSDaemon.generateKeyString(keyBytes), port);
    }

    private static final File generateLocationFile(File cfaPath) {
        return new File(cfaPath, LOCATION_PATH);
    }

    private static final String generateKeyString(byte[] key) {
        StringBuilder keyStr = new StringBuilder(key.length * 2);
        byte[] byArray = key;
        int n = key.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            keyStr.append(digits[b >>> 4 & 0xF]);
            keyStr.append(digits[b & 0xF]);
            ++n2;
        }
        return keyStr.toString();
    }

    public ILockFile getLockFile() {
        return this.location;
    }

    public HttpServer getHttpServer() {
        return this.server;
    }

    public void addListener(ILightweightEventListener<ILightweightEvent> l) {
        this.eventSource.addListener(l);
    }

    public void removeListener(ILightweightEventListener<ILightweightEvent> l) {
        this.eventSource.removeListener(l);
    }

    public void queueEvent(ILightweightEvent event) {
        this.eventSource.fireEvent(event);
    }

    public DaemonRegistry getDaemonRegistry() {
        return this.registry;
    }

    public void enableRequestTracing(ILightweightEventListener<?> listener) {
        if (this.server != null) {
            throw new IllegalStateException();
        }
        this.logger = listener;
    }

    public String getProcessUuid() {
        return DaemonPlugin.getProcessUuid();
    }

    public void addInitialDaemonListeners(LinkedList<ILightweightEventListener<IHttpServerEvent>> initialListeners) {
        if (this.server != null) {
            throw new IllegalStateException("HttpServer already running. Can't set listeners.");
        }
        this.initialServerListeners.addAll(initialListeners);
    }

    public void setPort(int startPort) {
        if (this.server != null) {
            throw new IllegalStateException("HttpServer already running. Can't set port.");
        }
        this.listenPort = startPort;
    }

    public void logAutojoinedSandbox(String string) {
        if (this.logger != null) {
            this.logger.handleEvent(new RegisteredSandboxPseudoEvent(string));
        }
    }

    public File getDaemonEntryDir() {
        return this.daemonEntryDir;
    }

    public PlatformDetector.LauncherType getLauncherType() {
        return this.launcherType;
    }

    public static class BindException
    extends IOException {
        public BindException() {
        }

        public BindException(String s) {
            super(s);
        }
    }

    public static interface IInitializedEvent
    extends ILifecycleEvent {
    }

    public static interface ILifecycleEvent
    extends ILightweightEvent {
        public FSDaemon getDaemon();
    }

    public static interface ILifecycleListener
    extends ILightweightEventListener<ILifecycleEvent> {
    }

    public static interface ILockFile {
        public int getPort();

        public String getKey();
    }

    public static interface IShutdownEvent
    extends ILifecycleEvent {
    }

    private static class LockFile
    implements ILockFile {
        final String key;
        final int port;

        private LockFile(String k, int p) {
            this.key = k;
            this.port = p;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public int getPort() {
            return this.port;
        }
    }

    private class ServerNotificationChannelWrapper
    implements IServerNotificationChannel {
        LightweightEventSource eventManager = new LightweightEventSource();
        protected volatile ServerNotificationChannel wrappedChannel;

        private ServerNotificationChannelWrapper() {
        }

        @Override
        public void manage(HttpRequest rq, HttpResponse resp) throws IOException {
            ServerNotificationChannel notifier = this.wrappedChannel;
            if (notifier == null) {
                resp.setCode(ResponseCode.NOT_FOUND);
                return;
            }
            notifier.manage(rq, resp);
        }

        protected void setChannel(IServerNotificationChannel notifier) {
            assert (this.wrappedChannel == null);
            ((ServerNotificationChannel)notifier).setEventManager(this.eventManager);
            this.wrappedChannel = (ServerNotificationChannel)notifier;
        }

        @Override
        public void queueNotification(String key, String type, IParameterWrapper notification) {
            ServerNotificationChannel notifier = this.wrappedChannel;
            Notification<IParameterWrapper> n = new Notification<IParameterWrapper>(key, type, notification);
            if (notifier == null) {
                this.eventManager.fireEvent(new NotificationDiscardedEvent(this, n));
                return;
            }
            notifier.queueNotification(n);
        }

        @Override
        public boolean isLastPendingNotification(String key) {
            ServerNotificationChannel notifier = this.wrappedChannel;
            return notifier.isLastPendingNotification(key);
        }

        @Override
        public void addListener(ILightweightEventListener<? super NotificationEvent> l) {
            this.eventManager.addListener(l);
        }

        @Override
        public void removeListener(ILightweightEventListener<? super NotificationEvent> l) {
            this.eventManager.removeListener(l);
        }

        @Override
        public FSDaemon getFSDaemon() {
            return FSDaemon.this;
        }
    }
}

