/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.daemon;

import com.ibm.team.filesystem.client.daemon.JSONHandlerEvent;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.http.HttpRequest;
import com.ibm.team.filesystem.client.internal.http.HttpResponse;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public class JSONHandlerResponseEvent
extends JSONHandlerEvent {
    private final Charset payloadCharset;
    private final byte[] payload;
    private final int payloadSize;
    private final int payloadOffset;

    public JSONHandlerResponseEvent(HttpRequest req, HttpResponse resp, Charset payloadCharset, byte[] payload) {
        super(req, resp);
        this.payloadCharset = payloadCharset;
        this.payload = payload;
        this.payloadSize = payload != null ? payload.length : -1;
        this.payloadOffset = payload != null ? 0 : -1;
    }

    public JSONHandlerResponseEvent(HttpRequest req, HttpResponse resp, Charset payloadCharset, byte[] payload, int payloadOffset, int payloadSize) {
        super(req, resp);
        this.payloadCharset = payloadCharset;
        this.payload = payload;
        this.payloadSize = payloadSize;
        this.payloadOffset = payloadOffset;
    }

    public JSONObject getFormattedPayload() {
        if (this.payload == null || this.payloadSize < 1) {
            return null;
        }
        JSONObject parsed = null;
        try {
            parsed = JSONObject.parse((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(this.payload, this.payloadOffset, this.payloadSize), this.payloadCharset));
        }
        catch (IOException e) {
            LoggingHelper.log((String)"com.ibm.team.filesystem.client.daemon", (TeamRepositoryException)new TeamRepositoryException("Exception decoding: " + e.getMessage() + "\nFull text: "));
            return null;
        }
        return parsed;
    }
}

