/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.tools.verify;

import com.ibm.team.filesystem.cli.core.AbstractSubcommand;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsActivate;
import com.ibm.team.filesystem.client.rest.parameters.ParmsAutoMerge;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBackupDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCheckInChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCheckInShareablesRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCompleteChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsConflictsToResolve;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeletedContentDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetWorkspaceDetails;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPostWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPreOperationRefresh;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResumeChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsShare;
import com.ibm.team.filesystem.client.rest.parameters.ParmsShareRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSuspendChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.CheckInResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.share.ShareResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ComponentSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ConflictSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.SyncViewDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.UnresolvedFolderSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.WorkspaceSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.GetWorkspaceDetailsResultDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.Date;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PackagingTestCmd
extends AbstractSubcommand
implements IOptionSource {
    private static NamedOptionDefinition SANDBOX_LOC = new NamedOptionDefinition("s", "sandbox", 1);

    public Options getOptions() throws ConflictingOptionException {
        Options opts = new Options(false, true);
        opts.setLongHelp("This test command will test out the packaging of this install to\nensure that certain known areas are working.\nNote: this command should be run in an empty directory.");
        SubcommandUtil.addRepoLocationToOptions((Options)opts);
        opts.addOption((INamedOptionDefinition)SANDBOX_LOC, "Temporary sandbox location. Sandbox must be empty and must be canonical.");
        return opts;
    }

    public void run() throws FileSystemException {
        block62: {
            String contents;
            ByteArrayOutputStream baos;
            FileInputStream fis;
            WorkspaceDetailsDTO wsDetails;
            ICommandLine subargs = this.config.getSubcommandCommandLine();
            String url = subargs.getOption((IOptionKey)CommonOptions.OPT_URI, null);
            if (url == null) {
                throw StatusHelper.argSyntax((String)"Must define a repository url");
            }
            ConnectionInfo info = this.config.getConnectionInfo(url, null, true, false);
            IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
            ITeamRepository repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)info);
            if (repo.getErrorState() != 0) {
                repo.getLastError().printStackTrace(this.config.getContext().stderr());
                return;
            }
            this.config.getWrappedOutputStream().println((CharSequence)"Logged in");
            ParmsPostWorkspace parms = new ParmsPostWorkspace();
            parms.name = "CLI Sniff Test " + new Date().toString();
            parms.description = "";
            parms.repositoryUrl = repo.getRepositoryURI();
            parms.isStream = false;
            try {
                wsDetails = client.postWorkspace(parms, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)"Could not create repository workspace", (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)parms.repositoryUrl);
            }
            this.config.getWrappedOutputStream().println((CharSequence)("Repository workspace created: " + parms.name));
            this.config.getWrappedOutputStream().println((CharSequence)"Note: A new component is created each time that this command is executed.");
            this.config.getWrappedOutputStream().println((CharSequence)"      This command should be run against a test server and not a production one.");
            ParmsWorkspace parmsWorkspace = new ParmsWorkspace();
            parmsWorkspace.repositoryUrl = repo.getRepositoryURI();
            parmsWorkspace.workspaceItemId = wsDetails.getItemId();
            ParmsActivate activateParms = new ParmsActivate();
            activateParms.workspaces = new ParmsWorkspace[]{parmsWorkspace};
            try {
                client.postActivate(activateParms, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)"Could not activate workspace", (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)parms.repositoryUrl);
            }
            this.config.getWrappedOutputStream().println((CharSequence)"Repository workspace activated");
            IPath sandboxPath = null;
            File sandbox = null;
            if (this.config.getSubcommandCommandLine().hasOption((IOptionKey)SANDBOX_LOC)) {
                sandboxPath = new Path(ScmCommandLineArgument.create((ICommandLineArgument)this.config.getSubcommandCommandLine().getOptionValue((IOptionKey)SANDBOX_LOC), (IScmClientConfiguration)this.config).getStringValue());
                sandbox = sandboxPath.toFile();
                if (sandbox.isFile()) {
                    this.config.getWrappedErrorStream().println((CharSequence)"ERROR: Sandbox is a file, not a directory. Aborting...");
                    return;
                }
                String[] children = sandbox.list();
                if (children != null && children.length != 0) {
                    this.config.getWrappedErrorStream().println((CharSequence)"ERROR: Sandbox is not completely empty. Aborting...");
                    return;
                }
            } else {
                sandboxPath = new Path(System.getProperty("java.io.tmpdir")).append(UUID.generate().getUuidValue());
                sandbox = sandboxPath.toFile();
                if (!sandbox.mkdirs()) {
                    this.config.getWrappedErrorStream().println((CharSequence)("ERROR: Could not create sandbox in " + sandbox + ". Try again using the sandbox option (-s) to provide the location of an empty sandbox."));
                    return;
                }
            }
            try {
                String resolvedPath = ManagedFileStore.getResolvedPath((String)sandboxPath.toOSString());
                if (resolvedPath == null || !sandboxPath.toOSString().equals(resolvedPath)) {
                    this.config.getWrappedErrorStream().println((CharSequence)"ERROR: Sandbox path is not in canonical form. Try again using the sandbox option (-s) to provide the location of an empty sandbox in canonical form.");
                    return;
                }
            }
            catch (CoreException e1) {
                e1.printStackTrace(this.config.getContext().stderr());
                this.config.getWrappedErrorStream().println((CharSequence)"ERROR: Sandbox path is not in a correct form. Try again using the sandbox option (-s) to provide the location of an empty sandbox in canonical form.");
                return;
            }
            File folder = new File(sandbox, "folder");
            folder.mkdirs();
            try {
                PrintStream os = new PrintStream(new File(folder, "file.txt"));
                this.writeFileContents(os, false, false);
                os.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(this.config.getContext().stderr());
                this.config.getWrappedErrorStream().println((CharSequence)"ERROR: Could not write new file contents. Aborting...");
                return;
            }
            this.config.getWrappedOutputStream().println((CharSequence)("Sample files created in " + sandbox.getAbsolutePath()));
            ParmsShare parmsShare = new ParmsShare();
            ParmsShareRequest shareRequest = new ParmsShareRequest();
            shareRequest.workspace = parmsWorkspace;
            shareRequest.componentName = parms.name;
            shareRequest.sandboxPath = sandbox.getAbsolutePath();
            shareRequest.itemsToShare = new String[]{"folder"};
            parmsShare.shareRequests = new ParmsShareRequest[]{shareRequest};
            parmsShare.overwrite = false;
            parmsShare.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
            parmsShare.sandboxUpdateDilemmaHandler.backupDilemmaHandler = new ParmsBackupDilemmaHandler();
            parmsShare.sandboxUpdateDilemmaHandler.backupDilemmaHandler.backupEnabled = false;
            parmsShare.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler = new ParmsDeletedContentDilemmaHandler();
            parmsShare.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler.deletedContentDirection = "fail";
            ShareResultDTO shareResult = null;
            try {
                shareResult = client.postShare(parmsShare, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)"Share failed", (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)"");
            }
            this.config.getWrappedOutputStream().println((CharSequence)"Shared files to repository workspace");
            String cs1Id = (String)shareResult.getChangeSetsCommitted().get(0);
            ParmsCompleteChangeSets parmsComplete = new ParmsCompleteChangeSets();
            parmsComplete.changeSetItemIds = new String[]{cs1Id};
            parmsComplete.workspace = parmsWorkspace;
            try {
                client.postCompleteChangeSets(parmsComplete, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)"Complete failed", (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)"");
            }
            this.config.getWrappedOutputStream().println((CharSequence)"Completed initial change set");
            try {
                PrintStream os = new PrintStream(new File(folder, "file.txt"));
                this.writeFileContents(os, true, false);
                os.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(this.config.getContext().stderr());
                this.config.getWrappedErrorStream().println((CharSequence)"ERROR: Could not write file contents to disk. Aborting...");
                return;
            }
            boolean linkCreated = true;
            try {
                IFileStore linkStore = EFS.getStore((URI)new File(folder, "link").toURI());
                ManagedFileStore.createSymlink((IFileStore)linkStore, (String)"file.txt", (boolean)false, null);
            }
            catch (CoreException e) {
                this.config.getWrappedErrorStream().println((CharSequence)"ERROR: Could not create symbolic link.");
                this.config.getWrappedErrorStream().println((CharSequence)"       On Windows make sure to run the command prompt \"As Administrator\" and try again.");
                this.config.getWrappedErrorStream().println((CharSequence)"       Check that SCM filesystem libraries are available for this platform.");
                e.printStackTrace(this.config.getContext().stderr());
                linkCreated = false;
            }
            ParmsCheckInChanges parmsCheckIn = new ParmsCheckInChanges();
            ParmsCheckInShareablesRequest parmsCIShareable = new ParmsCheckInShareablesRequest();
            parmsCIShareable.sandboxPath = sandbox.getAbsolutePath();
            parmsCIShareable.resourcesToCheckIn = linkCreated ? new String[]{"folder/file.txt", "folder/link"} : new String[]{"folder/file.txt"};
            parmsCheckIn.paths = new ParmsCheckInShareablesRequest[]{parmsCIShareable};
            parmsCheckIn.preoperationRefresh = new ParmsPreOperationRefresh();
            parmsCheckIn.preoperationRefresh.refreshMode = "complete";
            CheckInResultDTO checkInResult = null;
            try {
                checkInResult = client.postCheckInChanges(parmsCheckIn, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)"Checkin failed", (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)"");
            }
            this.config.getWrappedOutputStream().println((CharSequence)"Checked in changes to the file");
            String cs2Id = (String)checkInResult.getChangeSetsCommitted().get(0);
            parmsComplete = new ParmsCompleteChangeSets();
            parmsComplete.changeSetItemIds = new String[]{cs2Id};
            parmsComplete.workspace = parmsWorkspace;
            try {
                client.postCompleteChangeSets(parmsComplete, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)"Complete failed", (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)"");
            }
            this.config.getWrappedOutputStream().println((CharSequence)"Completed the new change set");
            ParmsSuspendChangeSets parmsSuspend = new ParmsSuspendChangeSets();
            parmsSuspend.workspace = parmsWorkspace;
            parmsSuspend.changeSetItemIds = new String[]{cs2Id};
            try {
                client.postSuspendChangeSets(parmsSuspend, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)"Suspend failed", (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)"");
            }
            this.config.getWrappedOutputStream().println((CharSequence)"Suspended the new change set");
            try {
                PrintStream os = new PrintStream(new File(folder, "file.txt"));
                this.writeFileContents(os, false, true);
                os.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(this.config.getContext().stderr());
                this.config.getWrappedErrorStream().println((CharSequence)"ERROR: Could not write file changes to disk. Aborting...");
                return;
            }
            parmsCheckIn = new ParmsCheckInChanges();
            parmsCIShareable = new ParmsCheckInShareablesRequest();
            parmsCIShareable.sandboxPath = sandbox.getAbsolutePath();
            parmsCIShareable.resourcesToCheckIn = new String[]{"folder/file.txt"};
            parmsCheckIn.paths = new ParmsCheckInShareablesRequest[]{parmsCIShareable};
            parmsCheckIn.preoperationRefresh = new ParmsPreOperationRefresh();
            parmsCheckIn.preoperationRefresh.refreshMode = "complete";
            checkInResult = null;
            try {
                checkInResult = client.postCheckInChanges(parmsCheckIn, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)"Checkin failed", (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)"");
            }
            this.config.getWrappedOutputStream().println((CharSequence)"Checked in new changes to the file");
            ParmsResumeChangeSets parmsResume = new ParmsResumeChangeSets();
            parmsResume.changeSetItemIds = new String[]{cs2Id};
            parmsResume.workspace = parmsWorkspace;
            try {
                client.postResumeChangeSets(parmsResume, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)"Resume failed", (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)"");
            }
            this.config.getWrappedOutputStream().println((CharSequence)"Resumed existing change set");
            ParmsGetWorkspaceDetails parmsWsInfo = new ParmsGetWorkspaceDetails();
            parmsWsInfo.workspaces = new ParmsGetWorkspace[1];
            parmsWsInfo.workspaces[0] = new ParmsGetWorkspace();
            parmsWsInfo.workspaces[0].refresh = true;
            parmsWsInfo.workspaces[0].includeComponents = true;
            parmsWsInfo.workspaces[0].workspace = parmsWorkspace;
            GetWorkspaceDetailsResultDTO wsInfo = null;
            try {
                wsInfo = client.postGetWorkspaceDetails(parmsWsInfo, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)"Workspace lookup failed.", (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)"");
            }
            String componentId = ((WorkspaceComponentDTO)((WorkspaceDetailsDTO)wsInfo.getWorkspaceDetails().get(0)).getComponents().get(0)).getItemId();
            try {
                client.getRefreshSyncView(null);
                client.getJoinSyncView(null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)"Sync view retrieval failed", (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)"");
            }
            SyncViewDTO syncView = null;
            try {
                syncView = client.getJoinSyncView(null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)"Sync view retrieval failed", (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)"");
            }
            ParmsConflictsToResolve parmsConflictToResolve = null;
            for (WorkspaceSyncDTO workspaceView : syncView.getWorkspaces()) {
                if (workspaceView.getWorkspaceItemId().equals(parmsWorkspace.workspaceItemId)) {
                    for (ComponentSyncDTO componentView : workspaceView.getComponents()) {
                        for (UnresolvedFolderSyncDTO folderView : componentView.getUnresolved()) {
                            ConflictSyncDTO conflict = (ConflictSyncDTO)folderView.getConflicts().get(0);
                            parmsConflictToResolve = new ParmsConflictsToResolve();
                            parmsConflictToResolve.componentItemId = componentId;
                            parmsConflictToResolve.versionableItemId = conflict.getVersionableItemId();
                            parmsConflictToResolve.kind = conflict.getKind();
                            if (!"conflict".equals(conflict.getKind())) continue;
                            parmsConflictToResolve.conflictType = conflict.getConflictType();
                        }
                    }
                    continue;
                }
                this.config.getWrappedOutputStream().println((CharSequence)"That's weird, there are other workspaces in this sync view.");
            }
            if (parmsConflictToResolve == null) {
                this.config.getWrappedErrorStream().println((CharSequence)"ERROR: Could not find the conflict in the sync view in order to auto-resolve. Aborting...");
                return;
            }
            ParmsAutoMerge parmsAutoMerge = new ParmsAutoMerge();
            parmsAutoMerge.workspace = parmsWorkspace;
            parmsAutoMerge.conflictsToResolve = new ParmsConflictsToResolve[]{parmsConflictToResolve};
            parmsAutoMerge.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
            parmsAutoMerge.pendingChangesDilemmaHandler.pendingChangesInstruction = "continue";
            try {
                client.postAutoResolve(parmsAutoMerge, null);
            }
            catch (TeamRepositoryException e) {
                e.printStackTrace(this.config.getContext().stderr());
            }
            this.config.getWrappedOutputStream().println((CharSequence)"Auto-merged the conflict");
            try {
                fis = new FileInputStream(new File(folder, "file.txt"));
                baos = new ByteArrayOutputStream();
                int b = fis.read();
                while (b != -1) {
                    baos.write(b);
                    b = fis.read();
                }
                baos.close();
                fis.close();
                contents = new String(baos.toByteArray());
                if (!contents.contains("Line9") || !contents.contains("Line0")) {
                    this.config.getWrappedErrorStream().println((CharSequence)"ERROR: File was not auto-merged. Verify that SWT libraries are available for this platform.");
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(this.config.getContext().stderr());
            }
            catch (IOException e) {
                e.printStackTrace(this.config.getContext().stderr());
            }
            this.config.getWrappedOutputStream().println((CharSequence)"Finished checking file contents");
            try {
                fis = new FileInputStream(new File(folder, "link"));
                baos = new ByteArrayOutputStream();
                int b = fis.read();
                while (b != -1) {
                    baos.write(b);
                    b = fis.read();
                }
                baos.close();
                fis.close();
                contents = new String(baos.toByteArray());
                if (!contents.contains("Line1")) {
                    this.config.getWrappedErrorStream().println((CharSequence)"ERROR: Symbolic link was not created. Verify that Eclipse Filesystem libraries are available for this platform.");
                }
                new File(folder, "file.txt").delete();
                try {
                    fis = new FileInputStream(new File(folder, "link"));
                    fis.read();
                    this.config.getWrappedErrorStream().println((CharSequence)"ERROR: Symbolic link is not a symbolic link. Verify that Eclipse Filesystem libraries are available for this platform.");
                }
                catch (IOException iOException) {}
            }
            catch (FileNotFoundException e) {
                if (linkCreated) {
                    e.printStackTrace(this.config.getContext().stderr());
                    this.config.getWrappedErrorStream().println((CharSequence)"ERROR: Link could not be read because it was not found. Aborting...");
                }
            }
            catch (IOException e) {
                if (!linkCreated) break block62;
                e.printStackTrace(this.config.getContext().stderr());
                this.config.getWrappedErrorStream().println((CharSequence)"ERROR: Link could not be read. Aborting...");
            }
        }
        this.config.getWrappedOutputStream().println((CharSequence)"Finished checking symbolic link");
    }

    private void writeFileContents(PrintStream os, boolean prepend, boolean append) {
        if (prepend) {
            os.println("Line0");
        }
        os.println("Line1");
        os.println("Line2");
        os.println("Line3");
        os.println("Line4");
        os.println("Line5");
        os.println("Line6");
        os.println("Line7");
        os.println("Line8");
        if (append) {
            os.println("Line9");
        }
    }
}

