/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.tools.verify;

import com.ibm.team.filesystem.cli.core.AbstractSubcommand;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.MetronomeEventModel;
import com.ibm.team.filesystem.client.internal.utils.IFSDaemon;
import com.ibm.team.filesystem.client.rest.IDebugRestClient;
import com.ibm.team.filesystem.client.restproxy.DaemonRegistry;
import com.ibm.team.filesystem.client.restproxy.Discovery2;
import com.ibm.team.filesystem.common.internal.rest.debug.core.MetronomeRootDTO;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class MetronomeCmd
extends AbstractSubcommand
implements IOptionSource {
    private static final PositionalOptionDefinition OPT_PORT = new PositionalOptionDefinition("port", 1, 1);

    public Options getOptions() throws ConflictingOptionException {
        Options opts = new Options(false);
        opts.addOption((IPositionalOptionDefinition)OPT_PORT, "Port of the daemon to query");
        return opts;
    }

    public void run() throws FileSystemException {
        MetronomeRootDTO stats;
        IFSDaemon daemon = (IFSDaemon)this.config.getContext().getRemoteObject();
        if (daemon != null) {
            throw StatusHelper.internalError((String)"You shouldn't be able to run this in a lightweight client.");
        }
        ICommandLine subcli = this.config.getSubcommandCommandLine();
        String portString = subcli.getOption((IOptionKey)OPT_PORT).trim();
        int port = Integer.parseInt(portString);
        if (port < 1) {
            throw StatusHelper.argSyntax((String)"Port must be a positive integer");
        }
        DaemonRegistry registry = new DaemonRegistry(this.config.getConfigDirectory());
        Discovery2.DiscoveryParams discoverParams = new Discovery2.DiscoveryParams().setDaemonRegistry(registry).setInterface(IDebugRestClient.class).setRunInProcess(false).setAllowStart(false).setPort(port);
        IDebugRestClient client = (IDebugRestClient)Discovery2.RESOLVER.resolve(discoverParams, null);
        try {
            stats = client.getMetronomeStatistics();
        }
        catch (IllegalStateException e) {
            throw StatusHelper.disallowed((String)("Target daemon must be running with " + MetronomeEventModel.ENV_VAR + " set"));
        }
        OutputStreamWriter writer = new OutputStreamWriter(this.config.getContext().stdout());
        try {
            stats.tabulate((Writer)writer);
            writer.flush();
        }
        catch (IOException e) {
            throw StatusHelper.internalError((String)"Couldn't tabulate result", (Exception)e);
        }
    }
}

