/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.tools.verify;

import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.cli.tools.CliFilesystemToolsException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IFileContentManager;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileOptions;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.IFileOptions;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IShareableVisitor;
import com.ibm.team.filesystem.client.internal.LinkInfo;
import com.ibm.team.filesystem.client.internal.LinkType;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class FileSystemComparator {
    private final IShareable startingPoint;
    private final IFileStorage anchorRoot;
    private ILocation copyFileAreaRoot;

    public FileSystemComparator(Shareable startingPoint) {
        this.startingPoint = startingPoint;
        this.anchorRoot = startingPoint.getFileStorage();
        this.copyFileAreaRoot = startingPoint.getCopyFileAreaRoot();
    }

    public static void fail(String message) throws CliFilesystemToolsException {
        throw new CliFilesystemToolsException(message);
    }

    public static void assertTrue(String message, boolean condition) throws CliFilesystemToolsException {
        if (!condition) {
            FileSystemComparator.fail(message);
        }
    }

    public static void assertFalse(String message, boolean condition) throws CliFilesystemToolsException {
        FileSystemComparator.assertTrue(message, !condition);
    }

    public static void assertNotNull(String message, Object obj) throws CliFilesystemToolsException {
        if (obj == null) {
            FileSystemComparator.fail(message);
        }
    }

    public static void assertEquals(String message, Object expected, Object actual) throws CliFilesystemToolsException {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        FileSystemComparator.fail(message);
    }

    public void assertEquals(IConnection connection, IComponentHandle component, IVersionableHandle remoteHandle, Set excludedItems) throws TeamRepositoryException, FileNotFoundException, IOException, CoreException, CliFilesystemToolsException {
        IVersionable remote = null;
        try {
            remote = FileSystemComparator.fetch(connection, component, remoteHandle);
        }
        catch (TeamRepositoryException e) {
            FileSystemComparator.fail("Could not find remote file system item for " + this.startingPoint.getLocalPath());
        }
        IRelativeLocation remoteName = this.locate(connection, component, remoteHandle);
        this.validateSharingDescriptor(connection, component, remoteName);
        Shareable shareable = new Shareable(this.copyFileAreaRoot, this.startingPoint.getLocalPath().append(remoteName), ResourceType.getResourceType((IVersionableHandle)remoteHandle));
        LocalChangeManager.getInstance().computeChanges((IShareable)shareable, null);
        LocalChangeManager.getInstance().syncPendingChanges(connection.getContextHandle(), component, shareable.getSandbox(), null);
        HashSet itemsSeen = new HashSet();
        this.walkRemoteRepo(connection, component, remote, remoteName, excludedItems, itemsSeen, true);
        FileSystemComparator.assertTrue("Local root resource does not exist", this.rootExists());
        this.walkFileSystem(new FileSystemValidator(excludedItems, itemsSeen));
        for (String name : excludedItems) {
            ILocation path = this.startingPoint.getFullPath().append(name);
            FileSystemComparator.assertTrue("Excluded item missing" + name, SubcommandUtil.exists((ILocation)path, (IProgressMonitor)TempHelper.MONITOR));
        }
        Shareable localShareable = this.anchorRoot.getShareable();
        FileSystemComparator.assertNotNull("Missing Shareable information", localShareable);
        localShareable.accept((IShareableVisitor)new ShareableVisitor(itemsSeen), Integer.MAX_VALUE, true, false, null);
    }

    private void validateSharingDescriptor(IConnection connection, IComponentHandle component, IRelativeLocation remoteName) throws TeamRepositoryException, FileSystemException, CliFilesystemToolsException {
        Shareable shareable = new Shareable(this.copyFileAreaRoot, this.startingPoint.getLocalPath().append(remoteName), ResourceType.FOLDER);
        FileSystemComparator.assertTrue("Can't validate share", shareable.exists(null));
        IShare share = shareable.getShare(null);
        FileSystemComparator.assertNotNull("Item is not shared with copy file area " + remoteName, share);
        SharingDescriptor sharingDescriptor = (SharingDescriptor)share.getSharingDescriptor();
        FileSystemComparator.assertNotNull("Item is not shared with copy file area " + remoteName, sharingDescriptor);
        FileSystemComparator.assertEquals("mis-matched share component", component.getItemId(), sharingDescriptor.getComponent().getItemId());
        ISyncTime expected = null;
        FileSystemServiceProxy fss = ((FileSystemManager)FileSystemCore.getFileSystemManager((ITeamRepository)connection.teamRepository())).getFileSystemService();
        List summaries = fss.getComponentStateSummaries(connection, null);
        for (IComponentStateSummary summary : summaries) {
            if (!summary.getComponent().sameItemId((IItemHandle)component)) continue;
            expected = summary.getConfigurationTime();
            break;
        }
        FileSystemComparator.assertEquals("Configuration state mismatch", expected, sharingDescriptor.getConfigurationState());
    }

    protected boolean rootExists() throws FileSystemException {
        return this.startingPoint.exists(null);
    }

    public void assertEquals(IConnection connection, IComponentHandle component, IVersionableHandle remoteHandle) throws TeamRepositoryException, IOException, CoreException, CliFilesystemToolsException {
        this.assertEquals(connection, component, remoteHandle, Collections.EMPTY_SET);
    }

    public void assertEquals(ISharingDescriptor descriptor, Set<String> excludedItems, String repositoryUri) throws TeamRepositoryException, FileNotFoundException, IOException, CoreException, CliFilesystemToolsException {
        ITeamRepository repo = this.getRepo(repositoryUri);
        repo.login((IProgressMonitor)new NullProgressMonitor());
        IWorkspaceConnection connection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)descriptor.getConnectionHandle(), null);
        this.assertEquals((IConnection)connection, descriptor.getComponent(), descriptor.getRootVersionable(), excludedItems);
        repo.logout(null);
    }

    public void assertEquals(ISharingDescriptor descriptor, String repositoryUri) throws TeamRepositoryException, IOException, CoreException, CliFilesystemToolsException {
        this.assertEquals(descriptor, Collections.EMPTY_SET, repositoryUri);
    }

    private ITeamRepository getRepo(String uri) {
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getUnmanagedRepository(uri);
        repo.registerLoginHandler(new ITeamRepository.ILoginHandler(){

            public ITeamRepository.ILoginHandler.ILoginInfo challenge(ITeamRepository repo) {
                return new ITeamRepository.ILoginHandler.ILoginInfo(){

                    public String getUserId() {
                        return "ADMIN";
                    }

                    public String getPassword() {
                        return "ADMIN";
                    }
                };
            }
        });
        return repo;
    }

    private void walkRemoteRepo(IConnection connection, IComponentHandle component, IVersionable remote, IRelativeLocation remoteName, Set excludedItems, Set itemsSeen, boolean verifyMetaData) throws FileNotFoundException, TeamRepositoryException, IOException, CoreException, CliFilesystemToolsException {
        Shareable shareable = new Shareable(this.copyFileAreaRoot, remoteName, ResourceType.getResourceType((IVersionableHandle)remote));
        IFileStorage fileStorage = shareable.getFileStorage();
        FileSystemComparator.assertNotNull("Remote resource missing in copy file area " + remoteName, fileStorage);
        if (verifyMetaData) {
            this.verifyMetaData(remote, fileStorage);
        }
        FileSystemComparator.assertEquals(connection, remote, shareable);
        boolean isFolder = remote instanceof IFolder;
        String stdName = FileSystemComparator.ResourceTestUtils_standardizePath(remoteName.toString(), isFolder);
        FileSystemComparator.assertFalse("Excluded item in repo " + remoteName, excludedItems.contains(stdName));
        itemsSeen.add(stdName);
        if (isFolder) {
            Map children = connection instanceof IWorkspaceConnection ? ((IWorkspaceConnection)connection).configuration(component).childEntries((IFolderHandle)remote, null) : ((IBaselineConnection)connection).configuration().childEntries((IFolderHandle)remote, null);
            for (Map.Entry entry : children.entrySet()) {
                IVersionable child = null;
                try {
                    child = FileSystemComparator.fetch(connection, component, (IVersionableHandle)entry.getValue());
                }
                catch (TeamRepositoryException e) {
                    FileSystemComparator.fail("Could not find remote file system item for " + remoteName);
                }
                this.walkRemoteRepo(connection, component, child, remoteName.append((String)entry.getKey()), excludedItems, itemsSeen, verifyMetaData);
            }
        }
    }

    private static String ResourceTestUtils_standardizePath(String path, boolean isFolder) {
        if (path.equals("")) {
            return "/";
        }
        if (path.charAt(0) != '/') {
            path = "/" + path;
        }
        if (isFolder && path.charAt(path.length() - 1) != '/') {
            path = String.valueOf(path) + "/";
        }
        return path;
    }

    private static IVersionable fetch(IConnection connection, IComponentHandle component, IVersionableHandle handle) throws TeamRepositoryException {
        IConfiguration config = connection instanceof IWorkspaceConnection ? ((IWorkspaceConnection)connection).configuration(component) : ((IBaselineConnection)connection).configuration();
        IVersionable child = config.fetchCompleteItem(handle, null);
        return child;
    }

    private void verifyMetaData(IVersionable remote, IFileStorage fileStorage) throws FileSystemException, CliFilesystemToolsException {
        String name = fileStorage.getShareable().getLocalPath().toString();
        FileItemInfo itemInfo = ICopyFileAreaManager.instance.createCopyFileArea(this.copyFileAreaRoot, null).getItemInfo(fileStorage.getShareable().getLocalPath());
        FileSystemComparator.assertNotNull("Missing FileItemInfo for " + name, itemInfo);
        FileSystemComparator.assertEquals("FileItemInfo " + name, remote.getItemId(), itemInfo.getVersionableHandle().getItemId());
        FileSystemComparator.assertEquals("FileItemInfo " + name, remote instanceof IFolder, itemInfo.isFolder());
        if (remote instanceof IFileItem || remote instanceof ISymbolicLink) {
            FileSystemComparator.assertEquals("FileItemInfo " + name, remote.getStateId(), itemInfo.getVersionableHandle().getStateId());
        }
        Shareable shareable = fileStorage.getShareable();
        FileSystemComparator.assertNotNull("Missing ISharable for " + name, shareable);
        FileSystemComparator.assertFalse("IShareable " + name + " is dirty", this.isDirty((IShareable)shareable));
        ResourceType remoteType = ResourceType.getResourceType((IVersionableHandle)remote);
        FileSystemComparator.assertEquals("FileItemInfo " + name, remoteType, ResourceType.getResourceType((IVersionableHandle)itemInfo.getVersionableHandle()));
    }

    private boolean isDirty(IShareable shareable) throws FileSystemException {
        return LocalChangeManager.getInstance().isContentDirty(shareable, null);
    }

    private static void assertEquals(IConnection connection, IVersionable remote, Shareable shareable) throws FileNotFoundException, TeamRepositoryException, IOException, CoreException, CliFilesystemToolsException {
        IFileStorage fileStorage = shareable.getFileStorage();
        String name = shareable.getLocalPath().toString();
        ResourceType remoteType = ResourceType.getResourceType((IVersionableHandle)remote);
        ResourceType localType = shareable.getResourceType(null);
        FileSystemComparator.assertEquals("Not same type " + name, remoteType, localType);
        if (remoteType == ResourceType.FILE) {
            IFileContentManager contentManager = FileSystemCore.getContentManager((ITeamRepository)connection.teamRepository());
            IFileContent remoteContents = ((IFileItem)remote).getContent();
            ByteArrayOutputStream remoteBytes = new ByteArrayOutputStream((int)remoteContents.getEstimatedConvertedLength());
            contentManager.retrieveContent((IFileItemHandle)remote, remoteContents, (OutputStream)remoteBytes, null);
            ByteArrayOutputStream localBytes = new ByteArrayOutputStream();
            InputStream fis = fileStorage.getContents((IFileOptions)new FileOptions(false, (IFileItem)remote));
            FileSystemComparator.ResourceTestUtils_transferStreams(fis, localBytes);
            FileSystemComparator.assertEquals(name, remoteBytes.toByteArray(), localBytes.toByteArray());
        } else if (remoteType == ResourceType.SYMBOLIC_LINK) {
            ISymbolicLink remoteLink = (ISymbolicLink)remote;
            String remoteTarget = remoteLink.getTarget();
            remoteTarget = shareable.getFileStorage().convertTargetIntoLocalForm(remoteTarget);
            boolean remoteIsDirectoryLink = remoteLink.isDirectoryLink();
            LinkInfo info = shareable.getFileStorage().getLinkInfo(null);
            String localTarget = info.getTarget();
            boolean localIsDirectoryLink = info.getType() == LinkType.NONE ? shareable.getFileItemInfo(null).isDirectoryLink() : info.getType() == LinkType.DIRECTORY;
            FileSystemComparator.assertTrue("Symbolic link targets don't match", remoteTarget.equals(localTarget) && remoteIsDirectoryLink == localIsDirectoryLink);
        }
    }

    private static void ResourceTestUtils_transferStreams(InputStream source, OutputStream destination) throws IOException {
        byte[] buffer = new byte[8192];
        try {
            while (true) {
                int bytesRead = -1;
                bytesRead = source.read(buffer);
                if (bytesRead == -1) {
                    break;
                }
                destination.write(buffer, 0, bytesRead);
            }
        }
        finally {
            block27: {
                try {
                    try {
                        source.close();
                    }
                    catch (IOException iOException) {
                        try {
                            destination.close();
                        }
                        catch (IOException iOException2) {}
                        break block27;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        destination.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    destination.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void assertEquals(String path, byte[] expected, byte[] actual) throws CliFilesystemToolsException {
        FileSystemComparator.assertEquals("content lengths do not match for " + path, expected.length, actual.length);
        int i = 0;
        while (i < actual.length) {
            FileSystemComparator.assertEquals("content does not match (" + i + "/" + actual.length + ") for " + path, expected[i], actual[i]);
            ++i;
        }
    }

    public void assertEquals(ISharingDescriptor descriptor, IVersionableHandle remoteHandle, String repositoryUri) throws TeamRepositoryException, IOException, CoreException, CliFilesystemToolsException {
        ITeamRepository repo = this.getRepo(repositoryUri);
        repo.login((IProgressMonitor)new NullProgressMonitor());
        Object connection = descriptor.associatedWithWorkspace() ? SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)descriptor.getConnectionHandle(), null) : SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getBaselineConnection((IBaselineHandle)descriptor.getConnectionHandle(), null);
        this.assertEquals((IConnection)connection, descriptor.getComponent(), remoteHandle, new HashSet());
        repo.logout(null);
    }

    protected final ILocation getCopyFileAreaRoot() {
        return this.copyFileAreaRoot;
    }

    public void assertLoaded(IWorkspaceConnection connection, IComponentHandle component, IVersionableHandle remoteHandle, HashSet excludes) throws TeamRepositoryException, FileNotFoundException, IOException, CoreException, CliFilesystemToolsException {
        IVersionable remote = null;
        try {
            remote = FileSystemComparator.fetch((IConnection)connection, component, remoteHandle);
        }
        catch (TeamRepositoryException e) {
            FileSystemComparator.fail("Could not find remote file system item for " + this.startingPoint.getLocalPath());
        }
        IRelativeLocation remoteName = this.locate((IConnection)connection, component, remoteHandle);
        Shareable shareable = new Shareable(this.copyFileAreaRoot, remoteName, ResourceType.getResourceType((IVersionableHandle)remote));
        LocalChangeManager.getInstance().computeChanges((IShareable)shareable, null);
        LocalChangeManager.getInstance().syncPendingChanges(connection.getContextHandle(), component, shareable.getSandbox(), null);
        HashSet itemsSeen = new HashSet();
        this.walkRemoteRepo((IConnection)connection, component, remote, remoteName, excludes, itemsSeen, false);
        FileSystemComparator.assertTrue("Local root resource does not exist", this.rootExists());
        this.walkFileSystem(new FileSystemValidator(excludes, itemsSeen));
        for (String name : excludes) {
            ILocation path = this.startingPoint.getFullPath().append(name);
            FileSystemComparator.assertTrue("Excluded item missing" + name, SubcommandUtil.exists((ILocation)path, (IProgressMonitor)TempHelper.MONITOR));
        }
        FileSystemComparator.assertFalse(null, ICopyFileAreaManager.instance.copyFileAreaExists(this.startingPoint.getFullPath(), 0));
    }

    private IRelativeLocation locate(IConnection connection, IComponentHandle component, IVersionableHandle handle) throws TeamRepositoryException {
        IConfiguration configuration = connection instanceof IWorkspaceConnection ? ((IWorkspaceConnection)connection).configuration(component) : ((IBaselineConnection)connection).configuration();
        List ancestors = configuration.locateAncestors(Collections.singletonList(handle), null);
        RelativeLocation relativeLocation = RelativeLocation.EMPTY_LOCATION;
        Iterator iAncestors = ((IAncestorReport)ancestors.get(0)).getNameItemPairs().iterator();
        iAncestors.next();
        while (iAncestors.hasNext()) {
            INameItemPair pair = (INameItemPair)iAncestors.next();
            relativeLocation = relativeLocation.append(pair.getName());
        }
        return relativeLocation;
    }

    protected void walkFileSystem(FileSystemValidator validator) throws IOException, CoreException, CliFilesystemToolsException {
        this.traverse((File)this.startingPoint.getFullPath().getAdapter(File.class), validator);
    }

    private void traverse(File localFile, FileSystemValidator validator) throws IOException, CoreException, CliFilesystemToolsException {
        ResourceType type = null;
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(localFile.getAbsolutePath()));
        IFileInfo info = fileStore.fetchInfo(0, null);
        if (info.getAttribute(32)) {
            type = ResourceType.SYMBOLIC_LINK;
        } else if (localFile.isDirectory()) {
            type = ResourceType.FOLDER;
        } else if (info.exists()) {
            type = ResourceType.FILE;
        } else {
            FileSystemComparator.fail("Unexpected resource " + localFile.getCanonicalPath());
        }
        PathLocation local = new PathLocation(localFile.getAbsolutePath());
        IRelativeLocation path = local.getLocationRelativeTo(this.copyFileAreaRoot);
        validator.validate(path.toString(), type);
        if (type == ResourceType.FOLDER) {
            File[] members = localFile.listFiles();
            int i = 0;
            while (i < members.length) {
                this.traverse(members[i], validator);
                ++i;
            }
        }
    }

    protected static class FileSystemValidator {
        private Set excludedItems;
        private Set itemsSeen;

        public FileSystemValidator(Set excludedItems, Set itemsSeen) {
            this.excludedItems = excludedItems;
            this.itemsSeen = itemsSeen;
        }

        public void validate(String relativePath, ResourceType type) throws CliFilesystemToolsException {
            String stdName = FileSystemComparator.ResourceTestUtils_standardizePath(relativePath, type == ResourceType.FOLDER);
            FileSystemComparator.assertTrue("Not seen nor excluded " + stdName, this.excludedItems.contains(stdName) || this.itemsSeen.contains(stdName));
        }
    }

    private static class ShareableVisitor
    implements IShareableVisitor {
        private final Set itemsSeen;

        public ShareableVisitor(Set itemsSeen) {
            this.itemsSeen = itemsSeen;
        }

        public boolean visit(IShareable shareable, IProgressMonitor monitor) {
            try {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                if ((shareable.getState((IProgressMonitor)progress.newChild(50)) & 2) != 0) {
                    String stdName = FileSystemComparator.ResourceTestUtils_standardizePath(shareable.getLocalPath().toString(), shareable.getRemote((IProgressMonitor)progress.newChild(50)) instanceof IFolderHandle);
                    return false;
                }
            }
            catch (FileSystemException e) {
                throw new RuntimeException(e);
            }
            return true;
        }

        public IComponentHandle getComponent() {
            return null;
        }
    }
}

