/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.tools.verify;

import com.ibm.team.filesystem.cli.core.AbstractSubcommand;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.tools.verify.EclipseWorkspaceCompareCmdOptions;
import com.ibm.team.filesystem.cli.tools.verify.FileSystemComparator;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.Shareable;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class EclipseWorkspaceCompareCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        HashSet<String> excludes = new HashSet<String>();
        List toExclude = this.config.getSubcommandCommandLine().getOptions(EclipseWorkspaceCompareCmdOptions.OPT_EXCLUDES);
        excludes.addAll(toExclude);
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
        }
        catch (CoreException e) {
            throw StatusHelper.failure((String)"Refresh failed", (Throwable)e);
        }
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            Shareable shareable = (Shareable)project.getAdapter(IShareable.class);
            ISharingDescriptor desc = shareable.getShare(null).getSharingDescriptor();
            try {
                new FileSystemComparator(shareable).assertEquals(desc, excludes, this.config.getRepositoryURI(desc.getRepositoryId(), null));
            }
            catch (Exception e) {
                throw StatusHelper.failure((String)"Compare failed", (Throwable)e);
            }
            ++n2;
        }
    }
}

