/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.tools.dump.blocks;

import com.ibm.team.filesystem.cli.tools.dump.MetadataDumpParser;
import com.ibm.team.filesystem.cli.tools.dump.blocks.IScopedByComponentMetadataBlock;
import com.ibm.team.repository.common.UUID;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class InverseMetadataBlock
extends MetadataDumpParser.MetadataBlock
implements IScopedByComponentMetadataBlock {
    public static Comparator<InverseMetadataBlock> COMPARATOR = new Comparator<InverseMetadataBlock>(){

        @Override
        public int compare(InverseMetadataBlock b1, InverseMetadataBlock b2) {
            int r = IScopedByComponentMetadataBlock.COMPARATOR.compare(b1, b2);
            if (r == 0) {
                r = b1.getItemId().compareTo((Object)b2.getItemId());
            }
            return r;
        }
    };
    private List<RemoteChild> logicalChildren;
    private final UUID itemId;
    private final UUID componentId;
    private final UUID connectionId;
    private Map<String, String> originalProps;
    private Map<String, String> changedProps;

    public InverseMetadataBlock(String self, Map<String, String> originalProps, Map<String, String> changedProps, List<RemoteChild> children, UUID itemId, UUID componentId, UUID connectionId) {
        super(self);
        this.originalProps = originalProps;
        this.changedProps = changedProps;
        this.itemId = itemId;
        this.componentId = componentId;
        this.connectionId = connectionId;
        this.originalProps = originalProps;
        this.changedProps = changedProps;
        this.logicalChildren = children;
    }

    public List<RemoteChild> getChildren() {
        return this.logicalChildren;
    }

    public void rewriteChildren(List<RemoteChild> newValue) {
        this.logicalChildren = newValue;
    }

    public UUID getItemId() {
        return this.itemId;
    }

    @Override
    protected void dumpContent(PrintWriter w) {
        super.dumpContent(w);
        this.writeProps(w, "----- original properties -----", this.originalProps);
        this.writeProps(w, "----- changed properties ------", this.changedProps);
        if (this.logicalChildren != null && this.logicalChildren.size() > 0) {
            w.println("----- remote children ---------");
            for (RemoteChild rc : this.logicalChildren) {
                w.println(rc.self);
            }
        }
    }

    private void writeProps(PrintWriter w, String heading, Map<String, String> props) {
        if (props != null && props.size() > 0) {
            w.println(heading);
            for (Map.Entry<String, String> entry : props.entrySet()) {
                w.println("   " + entry.getKey() + " : " + entry.getValue());
            }
        }
    }

    public Map<String, String> getOriginalProps() {
        return this.originalProps;
    }

    public void rewriteOriginalProps(Map<String, String> rewritten) {
        this.originalProps = rewritten;
    }

    public Map<String, String> getChangedProps() {
        return this.changedProps;
    }

    public void rewriteChangedProps(Map<String, String> rewritten) {
        this.changedProps = rewritten;
    }

    @Override
    protected void dumpHeading(PrintWriter w) {
        w.println("================= Inverse Info =====================");
    }

    @Override
    public UUID getConnectionId() {
        return this.connectionId;
    }

    @Override
    public UUID getComponentId() {
        return this.componentId;
    }

    public static class RemoteChild {
        final String self;
        private final UUID id;
        private final String type;

        public RemoteChild(String line, UUID id, String type) {
            this.self = line;
            this.id = id;
            this.type = type;
        }

        public void dump(PrintWriter w) {
            w.println(this.self);
        }

        public UUID getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }
    }
}

