/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.tools.dump.blockparsers;

import com.ibm.team.filesystem.cli.tools.dump.MetadataDumpVisitor;
import com.ibm.team.filesystem.cli.tools.dump.SectioningLineNumberReader;
import com.ibm.team.filesystem.cli.tools.dump.blockparsers.BlockParser;
import com.ibm.team.filesystem.cli.tools.dump.blocks.InverseMetadataBlock;
import com.ibm.team.repository.common.UUID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class InverseMetadataDumpParser
extends BlockParser {
    @Override
    public void parse(SectioningLineNumberReader reader, MetadataDumpVisitor c) throws IOException {
        String line;
        ParseState state = ParseState.BODY;
        HashMap<String, String> bodyValues = new HashMap<String, String>();
        StringBuffer buf = new StringBuffer();
        StringBuffer changedProps = null;
        StringBuffer originalProps = null;
        StringBuffer remoteChildrenBuf = null;
        HashMap<String, String> changedPropsMap = null;
        HashMap<String, String> originalPropsMap = null;
        ArrayList<InverseMetadataBlock.RemoteChild> remoteChildren = null;
        StringBuffer curBuf = buf;
        HashMap<String, String> curMap = bodyValues;
        while ((line = reader.readLine()) != null) {
            if ("----------------------------------------------------".equals(line)) {
                InverseMetadataBlock block = new InverseMetadataBlock(buf.toString(), originalPropsMap, changedPropsMap, remoteChildren, UUID.valueOf((String)((String)bodyValues.get("item ID"))), UUID.valueOf((String)((String)bodyValues.get("component ID"))), UUID.valueOf((String)((String)bodyValues.get("connection ID"))));
                c.consumeInverseMetadataBlock(block);
                continue;
            }
            if ("----- original properties -----".equals(line)) {
                curBuf = originalProps = new StringBuffer();
                originalPropsMap = new HashMap<String, String>();
                curMap = originalPropsMap;
                state = ParseState.ORIGINAL_PROPS;
                continue;
            }
            if ("----- changed properties ------".equals(line)) {
                curBuf = changedProps = new StringBuffer();
                changedPropsMap = new HashMap<String, String>();
                curMap = changedPropsMap;
                state = ParseState.CHANGED_PROPS;
                continue;
            }
            if ("----- remote children ---------".equals(line)) {
                remoteChildren = new ArrayList<InverseMetadataBlock.RemoteChild>();
                curBuf = remoteChildrenBuf = new StringBuffer();
                state = ParseState.REMOTE_CHILDREN;
                continue;
            }
            if (state == ParseState.REMOTE_CHILDREN) {
                String[] rc = line.split("/", 2);
                InverseMetadataBlock.RemoteChild remoteChild = new InverseMetadataBlock.RemoteChild(line, UUID.valueOf((String)rc[1].trim()), rc[0].trim());
                remoteChildren.add(remoteChild);
            } else {
                String[] pair = line.split(":", 2);
                curMap.put(pair[0].trim(), pair[1].trim());
            }
            curBuf.append(line);
            curBuf.append("\n");
        }
    }

    @Override
    public String getSectionHeading() {
        return "================= Inverse Info =====================";
    }

    @Override
    protected void visit(MetadataDumpVisitor c, StringBuffer buf, Map<String, String> values) {
        throw new IllegalStateException("parse() should be redefined and shouldn't call this.");
    }

    static enum ParseState {
        BODY,
        ORIGINAL_PROPS,
        CHANGED_PROPS,
        REMOTE_CHILDREN;

    }
}

