/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.tools.dump;

import com.ibm.team.filesystem.cli.tools.dump.MetadataDumpVisitor;
import com.ibm.team.filesystem.cli.tools.dump.SectioningLineNumberReader;
import com.ibm.team.filesystem.cli.tools.dump.blockparsers.BlockParser;
import com.ibm.team.filesystem.cli.tools.dump.blockparsers.ComponentMetadataDumpParser;
import com.ibm.team.filesystem.cli.tools.dump.blockparsers.ForwardMetadataDumpParser;
import com.ibm.team.filesystem.cli.tools.dump.blockparsers.ForwardSharingMetadataDumpParser;
import com.ibm.team.filesystem.cli.tools.dump.blockparsers.InverseMetadataDumpParser;
import com.ibm.team.filesystem.cli.tools.dump.blockparsers.InverseSharingMetadataDumpParser;
import com.ibm.team.filesystem.cli.tools.dump.blockparsers.MetametaDumpParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class MetadataDumpParser {
    public static void parse(InputStream in, MetadataDumpVisitor c) throws IOException {
        String line;
        LineNumberReader lnr = new LineNumberReader(new InputStreamReader(in));
        HashMap<String, BlockParser> parsers = new HashMap<String, BlockParser>();
        MetadataDumpParser.addParser(parsers, new ComponentMetadataDumpParser());
        MetadataDumpParser.addParser(parsers, new ForwardMetadataDumpParser());
        MetadataDumpParser.addParser(parsers, new ForwardSharingMetadataDumpParser());
        MetadataDumpParser.addParser(parsers, new InverseSharingMetadataDumpParser());
        MetadataDumpParser.addParser(parsers, new InverseMetadataDumpParser());
        MetadataDumpParser.addParser(parsers, new MetametaDumpParser());
        while ((line = lnr.readLine()) != null) {
            SectioningLineNumberReader reader = new SectioningLineNumberReader(lnr);
            BlockParser parser = (BlockParser)parsers.get(line);
            if (parser == null) {
                throw new RuntimeException("No parser for \"" + line + "\" on line " + lnr.getLineNumber());
            }
            parser.parse(reader, c);
            if (reader.foundSectionTerminator()) continue;
            throw new IllegalStateException("Failed to terminate on line " + lnr.getLineNumber());
        }
    }

    private static void addParser(Map<String, BlockParser> parsers, BlockParser blockParser) {
        parsers.put(blockParser.getSectionHeading(), blockParser);
    }

    public static abstract class MetadataBlock {
        protected String self;

        public MetadataBlock(String self) {
            this.self = self;
        }

        protected void dumpContent(PrintWriter w) {
            w.print(this.self);
        }

        protected abstract void dumpHeading(PrintWriter var1);

        public void dump(PrintWriter w) {
            this.dumpHeading(w);
            this.dumpContent(w);
            w.println("----------------------------------------------------");
            w.println();
        }
    }
}

