/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.tools;

import com.ibm.team.filesystem.cli.core.AbstractSubcommand;
import com.ibm.team.filesystem.cli.tools.dump.MetadataDumpParser;
import com.ibm.team.filesystem.cli.tools.dump.MetadataDumpVisitor;
import com.ibm.team.filesystem.cli.tools.dump.blocks.ComponentMetadataBlock;
import com.ibm.team.filesystem.cli.tools.dump.blocks.ForwardMetadataBlock;
import com.ibm.team.filesystem.cli.tools.dump.blocks.ForwardSharingMetadataBlock;
import com.ibm.team.filesystem.cli.tools.dump.blocks.IScopedByComponentMetadataBlock;
import com.ibm.team.filesystem.cli.tools.dump.blocks.InverseMetadataBlock;
import com.ibm.team.filesystem.cli.tools.dump.blocks.InverseSharingMetadataBlock;
import com.ibm.team.filesystem.cli.tools.dump.blocks.MetametaMetadataBlock;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class MetadataDumpPostProcessCmd
extends AbstractSubcommand
implements IOptionSource {
    public static PositionalOptionDefinition OPT_METADATA = new PositionalOptionDefinition("metadata", 1, 1);
    private static final Comparator<InverseMetadataBlock.RemoteChild> COMPARATOR_REMOTE_CHILD = new Comparator<InverseMetadataBlock.RemoteChild>(){

        @Override
        public int compare(InverseMetadataBlock.RemoteChild r1, InverseMetadataBlock.RemoteChild r2) {
            return r1.getId().compareTo((Object)r2.getId());
        }
    };

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        options.setLongHelp("Sort metadata sections generated with 'validate'. ");
        options.addOption((IPositionalOptionDefinition)OPT_METADATA, "Path to the metadata to sort. MAY ONLY INCLUDE INVERSE METADATA SECTION. ");
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        String metadataFile = cli.getOption((IOptionKey)OPT_METADATA);
        SortingInverseMetadataDumpParserConsumer c = new SortingInverseMetadataDumpParserConsumer();
        try (FileInputStream inputStream = new FileInputStream(metadataFile);){
            MetadataDumpParser.parse(inputStream, c);
        }
        catch (IOException e) {
            throw new FileSystemException((Throwable)e);
        }
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter(this.config.getContext().stdout()));){
            for (ComponentMetadataBlock cmb : c.componentMetadataBlocks) {
                cmb.dump(out);
            }
            for (ForwardSharingMetadataBlock fsmb : c.forwardSharingMetadataBlocks) {
                fsmb.dump(out);
            }
            for (InverseSharingMetadataBlock ismb : c.inverseSharingMetadataBlocks) {
                ismb.dump(out);
            }
            for (ForwardMetadataBlock fmb : c.fowardMetadataBlocks) {
                fmb.dump(out);
            }
            for (InverseMetadataBlock imb : c.inverseMetadataBlocks) {
                imb.dump(out);
            }
            for (MetametaMetadataBlock mmb : c.metametaMetadataBlocks) {
                mmb.dump(out);
            }
        }
    }

    public static class SortingInverseMetadataDumpParserConsumer
    extends MetadataDumpVisitor {
        SortedSet<ForwardSharingMetadataBlock> forwardSharingMetadataBlocks = new TreeSet<ForwardSharingMetadataBlock>(ForwardSharingMetadataBlock.COMPARATOR);
        SortedSet<InverseSharingMetadataBlock> inverseSharingMetadataBlocks = new TreeSet<InverseSharingMetadataBlock>(InverseSharingMetadataBlock.COMPARATOR);
        SortedSet<ComponentMetadataBlock> componentMetadataBlocks = new TreeSet<IScopedByComponentMetadataBlock>(IScopedByComponentMetadataBlock.COMPARATOR);
        SortedSet<ForwardMetadataBlock> fowardMetadataBlocks = new TreeSet<ForwardMetadataBlock>(ForwardMetadataBlock.COMPARATOR);
        SortedSet<InverseMetadataBlock> inverseMetadataBlocks = new TreeSet<InverseMetadataBlock>(InverseMetadataBlock.COMPARATOR);
        SortedSet<MetametaMetadataBlock> metametaMetadataBlocks = new TreeSet<MetametaMetadataBlock>(MetametaMetadataBlock.COMPARATOR);

        @Override
        public void consumeInverseMetadataBlock(InverseMetadataBlock block) {
            Map<String, String> changed;
            Map<String, String> original;
            List<InverseMetadataBlock.RemoteChild> children = block.getChildren();
            if (children != null) {
                TreeSet<InverseMetadataBlock.RemoteChild> kids = new TreeSet<InverseMetadataBlock.RemoteChild>(COMPARATOR_REMOTE_CHILD);
                kids.addAll(children);
                block.rewriteChildren(new ArrayList<InverseMetadataBlock.RemoteChild>(kids));
            }
            if ((original = block.getOriginalProps()) != null && original.size() > 0) {
                block.rewriteOriginalProps(this.sort(original));
            }
            if ((changed = block.getChangedProps()) != null && changed.size() > 0) {
                block.rewriteChangedProps(this.sort(changed));
            }
            this.inverseMetadataBlocks.add(block);
        }

        @Override
        public void consumeComponentMetadataBlock(ComponentMetadataBlock cmb) {
            this.componentMetadataBlocks.add(cmb);
        }

        @Override
        public void consumeForwardMetadataBlock(ForwardMetadataBlock forwardMetadataBlock) {
            this.fowardMetadataBlocks.add(forwardMetadataBlock);
        }

        @Override
        public void consumeForwardSharingMetadataBlock(ForwardSharingMetadataBlock forwardMetadataBlock) {
            this.forwardSharingMetadataBlocks.add(forwardMetadataBlock);
        }

        @Override
        public void consumeInverseSharingMetadataBlock(InverseSharingMetadataBlock inverseSharingMetadataBlock) {
            this.inverseSharingMetadataBlocks.add(inverseSharingMetadataBlock);
        }

        @Override
        public void consumeMetametaMetadataBlock(MetametaMetadataBlock metametaMetadataBlock) {
            this.metametaMetadataBlocks.add(metametaMetadataBlock);
        }

        private Map<String, String> sort(Map<String, String> original) {
            TreeMap<String, String> sorted = new TreeMap<String, String>();
            sorted.putAll(original);
            return sorted;
        }
    }
}

